<?php
/*
 * Simple Product Functionality
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSFunctionforSimpleProduct' ) ) {

    class RSFunctionforSimpleProduct {

        public static function init() {
            add_action( 'woocommerce_before_shop_loop' , array ( __CLASS__ , 'rs_msg_in_shop_page' ) ) ;
            add_filter( 'woocommerce_get_price_html' , array ( __CLASS__ , 'display_reward_point_msg_for_product' ) , 999 , 2 ) ;
            add_filter( 'woocommerce_get_price_html' , array ( __CLASS__ , 'display_buying_point_msg_for_product' ) , 9999 , 2 ) ;

            add_shortcode( 'rewardpoints' , array ( __CLASS__ , 'add_shortcode_function_for_rewardpoints_of_simple' ) ) ;
            add_shortcode( 'rsrefferalpoints' , array ( __CLASS__ , 'add_shortcode_function_for_rewardpoints_of_simple_referral' ) ) ;
            add_shortcode( 'buypoints' , array ( __CLASS__ , 'add_shortcode_function_for_buypoints_of_simple' ) ) ;

            if ( get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                add_action( 'woocommerce_before_single_product' , array ( __CLASS__ , 'display_purchase_message_for_simple_in_single_product_page' ) ) ;
                add_shortcode( 'equalamount' , array ( __CLASS__ , 'get_redeem_conversion_value' ) ) ;
            }
            add_shortcode( 'referralequalamount' , array ( __CLASS__ , 'get_redeem_conversion_value_referral' ) ) ;
            add_filter( 'woocommerce_variation_sale_price_html' , array ( __CLASS__ , 'display_point_price_in_variable_product' ) , 99 , 2 ) ;
            add_filter( 'woocommerce_variation_price_html' , array ( __CLASS__ , 'display_point_price_in_variable_product' ) , 99 , 2 ) ;
        }

        public static function rs_msg_in_shop_page() {
            if ( get_option( 'rs_product_purchase_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'yes' )
                return ;

            if ( get_option( 'rs_award_points_for_cart_or_product_total' ) == '1' )
                return ;

            if ( get_option( 'rs_enable_cart_total_reward_points' ) == '2' )
                return ;

            if ( get_option( 'rs_reward_type_for_cart_total' ) == '1' ) {
                if ( get_option( 'rs_enable_msg_for_fixed_cart_total_based_product_purchase_in_shop' ) == '2' )
                    return ;

                $ShopPageMsg               = get_option( 'rs_msg_for_fixed_cart_total_based_product_purchase_in_shop' ) ;
                $FixedCartTotalBasedPoints = get_option( 'rs_reward_points_for_cart_total_in_fixed' ) ;
                $FixedCartTotalBasedPoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $FixedCartTotalBasedPoints ) ;
                if ( $FixedCartTotalBasedPoints == 0 )
                    return ;
            }else {
                if ( get_option( 'rs_enable_msg_for_percent_cart_total_based_product_purchase_in_shop' ) == '2' )
                    return ;

                $ShopPageMsg                 = get_option( 'rs_msg_for_percent_cart_total_based_product_purchase_in_shop' ) ;
                $PercentCartTotalBasedPoints = get_option( 'rs_reward_points_for_cart_total_in_percent' ) ;
                $PercentCartTotalBasedPoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $PercentCartTotalBasedPoints ) ;
                if ( $PercentCartTotalBasedPoints == 0 )
                    return ;
            }
            ?>
            <div class="woocommerce-info"><?php echo $ShopPageMsg ; ?></div>
            <?php
        }

        public static function add_shortcode_function_for_buypoints_of_simple() {
            global $post ;
            $buying_points = get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) ;
            return round_off_type( $buying_points ) ;
        }

        public static function display_buying_point_msg_for_product( $price , $product ) {
            global $post ;
            if ( is_object( $post ) ) {
                global $woocommerce_loop ;
                $related_product  = false ;
                $userid           = get_current_user_id() ;
                $banning_type     = FPRewardSystem::check_banning_type( $userid ) ;
                $checkproducttype = rs_get_product_object( $post->ID ) ;
                $id               = rs_get_id( $product ) ;
                $bool             = self::rs_check_for_stock_in_products( $product ) ;
                if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                    if ( is_object( $checkproducttype ) && ($checkproducttype->is_type( 'simple' ) || ($checkproducttype->is_type( 'subscription' ))) ) {
                        $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                        if ( ! $sumo_bookings_check ) {
                            if ( is_product() ) {
                                if ( is_user_logged_in() ) {
                                    if ( get_option( 'rs_show_hide_buy_points_message_for_simple_in_product' ) == '1' && $bool == true ) {
                                        if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                            $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_product_page_for_simple' ) ) ;
                                            return $price . '<br>' . '<div class = rs_buypoints_message_simple >' . $shop_msg . '</div>' ;
                                        }
                                    }
                                } else {
                                    if ( get_option( 'rs_show_hide_buy_point_message_for_simple_in_product_guest' ) == '1' && $bool == true ) {
                                        if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                            $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_product_page_for_simple' ) ) ;
                                            return $price . '<br>' . '<div class = rs_buypoints_message_simple >' . $shop_msg . '</div>' ;
                                        }
                                    }
                                }
                            }
                        }
                        if ( is_page() ) {
                            if ( is_user_logged_in() ) {
                                if ( get_option( 'rs_show_hide_buy_points_message_for_simple_in_custom' ) == '1' ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_custom_shop_page_for_simple' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_buy_point_message_for_simple_in_custom_shop_guest' ) == '1' ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_custom_shop_page_for_simple' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            }
                        }
                        if ( is_shop() || is_product_category() ) {
                            $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                            if ( ! $sumo_bookings_check ) {
                                if ( is_user_logged_in() ) {
                                    if ( get_option( 'rs_show_hide_buy_points_message_for_simple_in_shop' ) == '1' && $bool == true ) {
                                        if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                            $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_shop_page_for_simple' ) ) ;
                                            return $price . '<br>' . $shop_msg ;
                                        }
                                    }
                                } else {
                                    if ( get_option( 'rs_show_hide_buy_pont_message_for_simple_in_shop_guest' ) == '1' && $bool == true ) {
                                        if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                            $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_shop_page_for_simple' ) ) ;
                                            return $price . '<br>' . $shop_msg ;
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        if ( is_product() ) {
                            if ( is_user_logged_in() ) {
                                if ( get_option( 'rs_show_hide_buy_points_message_for_variable_in_product' ) == '1' && $bool == true ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_product_page_for_variable' ) ) ;
                                        return $price . '<br>' . '<div class = rs_buypoints_message_variable >' . $shop_msg . '</div>' ;
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_buy_pont_message_for_variable_in_product_guest' ) == '1' && $bool == true ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_product_page_for_variable' ) ) ;
                                        return $price . '<br>' . '<div class = rs_buypoints_message_variable >' . $shop_msg . '</div>' ;
                                    }
                                }
                            }
                        }
                        if ( is_page() ) {
                            if ( is_user_logged_in() ) {
                                if ( get_option( 'rs_show_hide_buy_points_message_for_variable_in_custom_shop' ) == '1' ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_custom_shop_page_for_variable' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_buy_point_message_for_variable_in_custom_shop_guest' ) == '1' ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_custom_shop_page_for_variable' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            }
                        }
                        if ( is_shop() || is_product_category() ) {
                            if ( is_user_logged_in() ) {
                                if ( get_option( 'rs_show_hide_buy_points_message_for_variable_in_shop' ) == '1' && $bool == true ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_shop_page_for_variable' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_buy_pont_message_for_variable_in_shop_guest' ) == '1' && $bool == true ) {
                                    if ( get_post_meta( $post->ID , '_rewardsystem_buying_reward_points' , true ) == 'yes' && get_post_meta( $post->ID , '_rewardsystem_assign_buying_points' , true ) != '' ) {
                                        $shop_msg = do_shortcode( get_option( 'rs_buy_point_message_in_shop_page_for_variable' ) ) ;
                                        return $price . '<br>' . $shop_msg ;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return $price ;
        }

        public static function display_reward_point_msg_for_product( $price , $product ) {
            global $post ;
            global $woocommerce ;
            global $woocommerce_loop ;
            $related_product     = false ;
            $userid              = get_current_user_id() ;
            $point_price_info    = get_option( 'rs_label_for_point_value' ) ;
            $labelposition       = get_option( 'rs_sufix_prefix_point_price_label' ) ;
            $pixel               = get_option( 'rs_pixel_val' ) ;
            $roundofftype        = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
            $displaymax          = '' ;
            $point_price_display = '' ;
            $banning_type        = FPRewardSystem::check_banning_type( $userid ) ;
            $id                  = rs_get_id( $product ) ;
            $pdt_type            = rs_get_product_type( $product ) ;
            $bool                = self::rs_check_for_stock_in_products( $product ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                $gettheproducts = rs_get_product_object( $id ) ;
                if ( ( float ) $woocommerce->version >= ( float ) '3.3.0' ) {
                    if ( (isset( $woocommerce_loop[ 'name' ] ) && $woocommerce_loop[ 'name' ] == 'related' || $woocommerce_loop[ 'name' ] == 'up-sells' ) ) {
                        $related_product = true ;
                    }
                }
                if ( is_object( $gettheproducts ) && rs_check_variable_product_type( $gettheproducts ) ) {
                    $pointmin          = self::get_point_price( $id ) ;
                    $point_price_label = str_replace( "/" , "" , $point_price_info ) ;
                    if ( ! empty( $pointmin ) && $bool == true ) {
                        $displaymin = min( $pointmin ) ;
                        $displaymax = max( $pointmin ) ;
                        if ( $price != '' ) {
                            $display = '/' ;
                        } else {
                            $display = '' ;
                        }
                        if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                            $point_price_display = '' ;
                        } else {
                            if ( $displaymin == $displaymax ) {
                                if ( $labelposition == '1' ) {
                                    $point_price_display = $display . "{$point_price_label}<span style='margin-left:{$pixel}px;'>{$displaymin}</span>" ;
                                } else {
                                    $point_price_display = $display . "{$displaymin}<span style='margin-left:{$pixel}px;'>{$point_price_label}</span>" ;
                                }
                            } else {
                                if ( $labelposition == '1' ) {
                                    $point_price_display = $display . "{$point_price_label}<span style='margin-left:{$pixel}px;'>{$displaymin}</span>" . '-' . "{$point_price_label}<span style='margin-left:{$pixel}px;'>{$displaymax}</span>" ;
                                } else {
                                    $point_price_display = $display . "{$displaymin}<span style='margin-left:{$pixel}px;'>{$point_price_label}</span>" . '-' . "{$displaymax}<span style='margin-left:{$pixel}px;'>{$point_price_label}</span>" ;
                                }
                            }
                        }
                    }
                    if ( is_page() ) {                                                                        //Shop and Category Page Message for Variable Product                            
                        if ( get_option( 'rs_enable_display_earn_message_for_variation_custom_shop' ) == 'yes' ) {
                            $variation_id = self::get_variation_id( $id ) ;
                            if ( is_array( $variation_id ) && ! empty( $variation_id ) ) {
                                $varpointss = self::rewardpoints_of_variation( $variation_id[ 0 ] , $id ) ;
                            } else {
                                $varpointss = '' ;
                            }
                            if ( $varpointss != '' ) {
                                $redeemingrspoints      = $varpointss / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                $point_amount           = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                $updatedredeemingpoints = $redeemingrspoints * $point_amount ;
                                $currency               = round_off_type( $varpointss ) ;
                                $message                = get_option( "rs_message_for_custom_shop_variation" ) ;
                                if ( get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                                    $earnmessage = str_replace( '[variationrewardpoints]' , $currency , $message ) ;
                                } else {
                                    $earnmessage = '' ;
                                }
                                // Shop Page Message for Variable Product with Gift Icon
                                return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage , $price , $point_price_display ) ;
                            }
                        } else {
                            return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage = '' , $price , $point_price_display ) ;
                        }
                    }
                    if ( is_shop() || is_product_category() ) {                                                                        //Shop and Category Page Message for Variable Product                            
                        if ( get_option( 'rs_enable_display_earn_message_for_variation' ) == 'yes' && $bool == true ) {
                            $variation_id = self::get_variation_id( $id ) ;
                            if ( is_array( $variation_id ) && ! empty( $variation_id ) ) {
                                $varpointss = self::rewardpoints_of_variation( $variation_id[ 0 ] , $id ) ;
                            } else {
                                $varpointss = '' ;
                            }
                            if ( $varpointss != '' ) {
                                $redeemingrspoints      = $varpointss / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                $point_amount           = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                $updatedredeemingpoints = $redeemingrspoints * $point_amount ;
                                $currency               = round_off_type( $varpointss ) ;
                                $message                = get_option( "rs_message_for_single_product_variation" ) ;
                                if ( get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                                    $earnmessage = str_replace( '[variationrewardpoints]' , $currency , $message ) ;
                                } else {
                                    $earnmessage = '' ;
                                }
                                // Shop Page Message for Variable Product with Gift Icon
                                return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage , $price , $point_price_display ) ;
                            }
                        } else {
                            return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage = '' , $price , $point_price_display ) ;
                        }
                    }

                    if ( is_product() ) {
                        //Single Product and Custom Page Message for Variable Product
                        if ( $related_product == true && get_option( 'rs_show_hide_message_for_shop_archive_variable_related_products' ) == '1' && $bool == true ) {
                            global $post ;
                            $variation_id = self::get_variation_id( $post->ID ) ;
                            if ( is_array( $variation_id ) && ! empty( $variation_id ) ) {
                                $varpointss = RSFunctionforSimpleProduct::rewardpoints_of_variation( $variation_id[ 0 ] , $post->ID ) ;
                            } else {
                                $varpointss = '' ;
                            }
                            if ( $varpointss != '' ) {
                                $message     = get_option( 'rs_message_in_variable_related_products' ) ;
                                $find        = '[variationrewardpoints]' ;
                                $replace     = $varpointss ;
                                $earnmessage = str_replace( $find , $replace , $message ) ;
                                return $earnmessage . '<br>' . $price . $point_price_display ;
                            }
                        }
                        if ( $related_product == false && $bool == true ) {
                            if ( get_option( 'rs_show_hide_message_for_variable_in_single_product_page' ) == '1' ) {
                                // Shop Page Message for Variable Product with Gift Icon
                                if ( get_option( 'rs_enable_display_earn_message_for_variation_single_product' ) == 'yes' ) {
                                    $variation_id = self::get_variation_id( $id ) ;
                                    if ( is_array( $variation_id ) && ! empty( $variation_id ) ) {
                                        $varpointss = self::rewardpoints_of_variation( $variation_id[ 0 ] , $id ) ;
                                    } else {
                                        $varpointss = '' ;
                                    }
                                    if ( $varpointss != '' ) {
                                        if ( $pdt_type === 'variable' ) {
                                            return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage = '' , $price , $point_price_display ) ;
                                        }
                                    }
                                } else {
                                    if ( $pdt_type === 'variable' ) {
                                        return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage = '' , $price , $point_price_display ) ;
                                    }
                                }
                            }
                            if ( $pdt_type === 'variable' ) {
                                if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                                    return self::rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage = '' , $price , $point_price_display ) ;
                                }
                            }
                            if ( $pdt_type === 'variation' ) {
                                if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                                    return self :: display_point_price_in_variable_product( $price , $product ) ;
                                }
                            }
                        }
                    }
                } else {
                    $getshortcodevalues   = rs_function_for_rewardpoints_of_simple() ;
                    $enabledpoints        = calculate_point_price_for_products( $id ) ;
                    $point_price          = $enabledpoints[ $id ] ;
                    $point_price          = round_off_type( $point_price ) ;
                    $point_price_type     = check_display_price_type( $id ) ;
                    $enable_reward_points = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $id , '_rewardsystemcheckboxvalue' ) ;
                    $replace              = str_replace( "/" , "" , $point_price_info ) ;
                    if ( $point_price != 0 && $bool == true ) {
                        if ( $labelposition == '1' ) {
                            $point_price_info = "{$point_price_info}<span style='margin-left:{$pixel}px;'>{$point_price}</span>" ;
                        } else {
                            $point_price_info = '/' . "{$point_price}<span style='margin-left:{$pixel}px;'>{$replace}</span>" ;
                        }
                    } else {
                        $point_price_info = $price ;
                    }
                    if ( $getshortcodevalues > 0 ) {
                        if ( is_shop() || is_product_category() ) {//Shop and Category Page Message for Simple Product
                            global $post ;
                            $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                            if ( ! $sumo_bookings_check ) {
                                $earnmessage           = do_shortcode( get_option( "rs_message_in_shop_page_for_simple" ) ) ;
                                // Shop Page Message for Simple Product with Gift Icon
                                $earnpoint_msg_in_shop = self::rs_function_to_get_msg_with_gift_icon( $earnmessage ) ;
                                $msg_position          = get_option( 'rs_message_position_for_simple_products_in_shop_page' ) ;
                                //Shop Page Message for Simple Product for User                            
                                if ( is_user_logged_in() ) {
                                    if ( get_option( 'rs_show_hide_message_for_simple_in_shop' ) == '1' && $bool == true ) {

                                        //Function to Return Shop Page Message
                                        return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) ;
                                    }
                                } else {
                                    //Shop Page Message for Simple Product for Guest
                                    if ( get_option( 'rs_show_hide_message_for_simple_in_shop_guest' ) == '1' && $bool == true ) {

                                        //Function to Return Shop Page Message
                                        return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) ;
                                    }
                                }
                            }
                        }
                        if ( is_page() ) {
                            $earnmessage = do_shortcode( get_option( "rs_message_in_custom_shop_page_for_simple" ) ) ;

                            // Shop Page Message for Simple Product with Gift Icon
                            $earnpoint_msg_in_shop = self::rs_function_to_get_msg_with_gift_icon( $earnmessage ) ;
                            $msg_position          = get_option( 'rs_message_position_for_simple_products_in_custom_shop_page' ) ;
                            //Shop Page Message for Simple Product for User                            
                            if ( is_user_logged_in() ) {
                                if ( get_option( 'rs_show_hide_message_for_simple_in_custom_shop' ) == '1' ) {

                                    //Function to Return Shop Page Message
                                    return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) ;
                                }
                            } else {
                                //Shop Page Message for Simple Product for Guest
                                if ( get_option( 'rs_show_hide_message_for_simple_in_custom_shop_guest' ) == '1' ) {

                                    //Function to Return Shop Page Message
                                    return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) ;
                                }
                            }
                        }
                        if ( is_product() ) {                              //Single Product and Custom Page Message for Simple Product
                            global $post ;
                            $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;

                            if ( $related_product == true && get_option( 'rs_show_hide_message_for_shop_archive_single_related_products' ) == '1' && $bool == true ) {
                                $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                                if ( ! $sumo_bookings_check ) {
                                    $earnmessage  = do_shortcode( get_option( "rs_message_in_single_product_page_related_products" ) ) ;
                                    $msg_position = '1' ;
                                    return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnmessage , $msg_position ) ;
                                }
                            }
                            if ( $related_product == false && $bool == true ) {
                                if ( ! $sumo_bookings_check ) {
                                    if ( get_option( 'rs_show_hide_message_for_shop_archive_single' ) == '1' ) {
                                        $earnmessage           = do_shortcode( get_option( "rs_message_in_single_product_page" ) ) ;
                                        // Single Product and Custom Page Message for Simple Product with Gift Icon
                                        $earnpoint_msg_in_shop = self::rs_function_to_get_msg_with_gift_icon( $earnmessage ) ;
                                        $msg_position          = get_option( 'rs_message_position_in_single_product_page_for_simple_products' ) ;
                                        //Function to Return Single Product and Custom Page Message
                                        return self::rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) ;
                                    }
                                }
                            }
                        }
                    }

                    if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' && $bool == true ) {
                        global $post ;
                        $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                        if ( ! $sumo_bookings_check ) {
                            if ( $point_price_type == '2' ) {
                                if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                                    return $price ;
                                } else {
                                    $point_price_info = str_replace( "/" , "" , $point_price_info ) ;
                                    return $point_price_info ;
                                }
                            } else {
                                if ( $point_price != '' ) {
                                    if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                                        return $price ;
                                    } else {
                                        return $price . '<span class="point_price_label">' . $point_price_info ;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return $price ;
        }

        public static function rs_function_to_get_earnpoint_msg( $point_price_type , $point_price , $price , $point_price_info , $earnpoint_msg_in_shop , $msg_position ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {                          //Shop Page Message for Simple Product when Points Price is Enabled                
                if ( $point_price_type == '2' ) {
                    $point_price_info = str_replace( "/" , "" , $point_price_info ) ;
                    if ( $msg_position == '1' ) {    //Position of Shop Page Message for Simple Product - Before
                        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                            return $point_price_info ;
                        } else {
                            return "<small>" . $earnpoint_msg_in_shop . "</small> <br>" . $point_price_info ;
                        }
                    } else {                                                                            //Position of Shop Page Message for Simple Product - After
                        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                            return "<small>" . $point_price_info . "</small><br>" ;
                        } else {
                            return "<small>" . $point_price_info . "<br>" . $earnpoint_msg_in_shop . "</small><br>" ;
                        }
                    }
                } else {
                    if ( $point_price != '' ) {
                        if ( $msg_position == '1' ) {    //Position of Shop Page Message for Simple Product - Before
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price . '<span class="point_price_label">' . $point_price_info . "</span>" ;
                            } else {
                                return $earnpoint_msg_in_shop . "<br>" . $price . '<span class="point_price_label">' . $point_price_info . "</span>" ;
                            }
                        } else {                                                                              //Position of Shop Page Message for Simple Product - After
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price . '<span class="point_price_label">' . $point_price_info . "</span>" ;
                            } else {
                                return $price . '<span class="point_price_label">' . $point_price_info . "</span><br><small>" . $earnpoint_msg_in_shop . "</small>" ;
                            }
                        }
                    } else {
                        if ( $msg_position == '1' ) {    //Position of Shop Page Message for Simple Product - Before
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price ;
                            } else {
                                return $earnpoint_msg_in_shop . "<br>" . $price ;
                            }
                        } else {                                                                              //Position of Shop Page Message for Simple Product - After
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price ;
                            } else {
                                return $price . "<br>" . $earnpoint_msg_in_shop ;
                            }
                        }
                    }
                }
            } else {                                                                              //Shop Page Message for Simple Product when Points Price is Disabled
                if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                    return $price ;

                if ( $msg_position == '1' ) {    //Position of Shop Page Message for Simple Product - Before
                    return $earnpoint_msg_in_shop . "<br>" . $price ;
                } else {                                                                              //Position of Shop Page Message for Simple Product - After
                    return $price . "<br>" . $earnpoint_msg_in_shop ;
                }
            }
            return $price ;
        }

        public static function rs_function_to_get_msg_with_gift_icon( $earnmessage ) {
            if ( get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                if ( get_option( '_rs_enable_disable_gift_icon' ) == '1' ) {
                    if ( get_option( 'rs_image_url_upload' ) != '' ) {
                        $earnpoint_msg_in_shop = "<span class='simpleshopmessage'><img src=" . get_option( 'rs_image_url_upload' ) . " style='width:16px;height:16px;display:inline;' />&nbsp; " . $earnmessage . "</span>" ;
                    } else {
                        $earnpoint_msg_in_shop = "<span class='simpleshopmessage'>" . $earnmessage . "</span>" ;
                    }
                } else {
                    $earnpoint_msg_in_shop = "<span class='simpleshopmessage'>" . $earnmessage . "</span>" ;
                }
            } else {
                $earnpoint_msg_in_shop = '' ;
            }
            return $earnpoint_msg_in_shop ;
        }

        public static function rs_function_to_get_msg_with_gift_icon_for_variable( $earnmessage , $price , $point_price_display ) {
            $image = "<img class='gift_icon' src=" . get_option( 'rs_image_url_upload' ) . " style='width:16px;height:16px;display:inline;' />&nbsp;" ;
            if ( $earnmessage != '' ) {
                $break = '<br>' ;
            } else {
                $break = '' ;
                if ( is_shop() || is_product_category() ) {
                    $image = '' ;
                }
                if ( is_product() || is_page() ) {
                    $break = '<br>' ;
                }
            }
            if ( get_option( '_rs_enable_disable_gift_icon' ) == '1' ) {
                if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                    if ( get_option( 'rs_image_url_upload' ) != '' ) {
                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $image . $break . $price . $point_price_display ;
                            } else {
                                return $image . "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price . $point_price_display ;
                            }
                        } else {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price . $point_price_display . '<br>' . $image ;
                            } else {
                                return $price . $point_price_display . '<br>' . $image . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                            }
                        }
                    } else {
                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $break . $price . $point_price_display ;
                            } else {
                                return "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price . $point_price_display ;
                            }
                        } else {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price . $point_price_display . $break ;
                            } else {
                                return $price . $point_price_display . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                            }
                        }
                    }
                } else {
                    if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                        return $price ;

                    if ( get_option( 'rs_image_url_upload' ) != '' ) {
                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            return $image . "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price ;
                        } else {
                            return $price . '<br>' . $image . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                        }
                    } else {
                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            return "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price ;
                        } else {
                            return $price . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                        }
                    }
                }
            } else {
                if ( is_product() ) {
                    if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $break . $price . $point_price_display ;
                            } else {
                                return "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price . $point_price_display ;
                            }
                        } else {
                            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                                return $price . $point_price_display . $break ;
                            } else {
                                return $price . $point_price_display . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                            }
                        }
                    } else {
                        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                            return $price ;

                        if ( get_option( 'rs_message_position_in_single_product_page_for_variable_products' ) == '1' ) {
                            return "<span class='variableshopmessage'>" . $earnmessage . "</span>" . $break . $price ;
                        } else {
                            return $price . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                        }
                    }
                } else if ( is_shop() || is_product_category() || is_page() ) {
                    if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' ) {
                            return $price . $point_price_display . $break ;
                        } else {
                            return $price . $point_price_display . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                        }
                    } else {
                        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                            return $price ;

                        return $price . $break . "<span class='variableshopmessage'>" . $earnmessage . "</span>" ;
                    }
                }
            }
            return $price ;
        }

        public static function get_point_price( $post_id ) {
            $enabledpoints1 = array () ;
            $args           = array (
                'post_parent' => $post_id ,
                'post_type'   => 'product_variation' ,
                'orderby'     => 'menu_order' ,
                'order'       => 'ASC' ,
                'fields'      => 'ids' ,
                'post_status' => 'publish' ,
                'numberposts' => -1
                    ) ;
            $variation_id   = get_posts( $args ) ;
            foreach ( $variation_id as $key ) {
                $enabledpoints = calculate_point_price_for_products( $key ) ;
                if ( $enabledpoints[ $key ] != '' ) {
                    $enabledpoints1[ $key ] = $enabledpoints[ $key ] ;
                }
            }
            return $enabledpoints1 ;
        }

        public static function add_shortcode_function_for_rewardpoints_of_simple() {
            $reward_points = rs_function_for_rewardpoints_of_simple() ;
            $reward_points = round_off_type( $reward_points ) ;
            return $reward_points ;
        }

        public static function add_shortcode_function_for_rewardpoints_of_simple_referral() {
            $reward_points = rs_function_for_rewardpoints_of_simple_referral() ;
            $reward_points = round_off_type( $reward_points ) ;
            return $reward_points ;
        }

        public static function display_purchase_msg_in_single_product_page() {
            if ( ! is_user_logged_in() )
                return ;

            if ( ! class_exists( 'FPWaitList' ) )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_show_hide_message_for_waitlist' ) == '2' )
                return ;

            $points = round_off_type( get_option( 'rs_reward_for_waitlist_subscribing' ) ) ;
            if ( $points == 0 )
                return ;

            global $post ;
            $checkproducttype = rs_get_product_object( $post->ID ) ;

            if ( $checkproducttype->is_in_stock() )
                return ;

            if ( get_option( 'wl_show_form_member' ) != 'yes' )
                return ;

            $message = get_option( 'rs_message_for_subscribing_product' ) ;
            $replace = str_replace( '[subscribingpoints]' , RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $points ) , $message ) ;
            ?>
            <div class="woocommerce-info rs_message_for_single_product"><?php echo $replace ; ?></div>
            <?php
        }

        public static function display_cart_total_based_product_purchase_msg_in_single_product_page() {
            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_product_purchase_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'yes' )
                return ;

            if ( get_option( 'rs_award_points_for_cart_or_product_total' ) == '1' )
                return ;

            if ( get_option( 'rs_enable_cart_total_reward_points' ) == '2' )
                return ;

            if ( get_option( 'rs_reward_type_for_cart_total' ) == '1' ) {
                if ( get_option( 'rs_enable_msg_for_fixed_cart_total_based_product_purchase' ) == '2' )
                    return ;

                $ProductPageMsg            = get_option( 'rs_msg_for_fixed_cart_total_based_product_purchase' ) ;
                $FixedCartTotalBasedPoints = get_option( 'rs_reward_points_for_cart_total_in_fixed' ) ;
                $FixedCartTotalBasedPoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $FixedCartTotalBasedPoints ) ;
                if ( $FixedCartTotalBasedPoints == 0 )
                    return ;
            }else {
                if ( get_option( 'rs_enable_msg_for_percent_cart_total_based_product_purchase' ) == '2' )
                    return ;

                $ProductPageMsg              = get_option( 'rs_msg_for_percent_cart_total_based_product_purchase' ) ;
                $PercentCartTotalBasedPoints = get_option( 'rs_reward_points_for_cart_total_in_percent' ) ;
                $PercentCartTotalBasedPoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $PercentCartTotalBasedPoints ) ;
                if ( $PercentCartTotalBasedPoints == 0 )
                    return ;
            }
            ?>
            <div class="woocommerce-info"><?php echo $ProductPageMsg ; ?></div>
            <?php
        }

        public static function display_product_review_msg_in_single_product_page() {
            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_product_review_points' ) != 'yes' )
                return ;

            if ( get_option( 'rs_show_hide_message_for_product_review' ) == '2' )
                return ;

            $ProductReviewMsg              = get_option( 'rs_message_for_product_review' ) ;
            $ProductReviewPoints           = round_off_type( get_option( 'rs_reward_product_review' ) ) ;
            $ProductReviewPoints           = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $ProductReviewPoints ) ;
            $ProductReviewMsginProductPage = str_replace( '[productreviewpoint]' , $ProductReviewPoints , $ProductReviewMsg ) ;
            if ( $ProductReviewPoints == 0 )
                return ;
            ?>
            <div class="woocommerce-info rs_message_for_single_product"><?php echo $ProductReviewMsginProductPage ; ?></div>
            <?php
        }

        public static function display_product_total_based_product_purchase_msg_in_single_product_page() {
            $userid       = get_current_user_id() ;
            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
            if ( ! ($banning_type != 'earningonly' && $banning_type != 'both') )
                return ;

            global $post ;
            if ( is_user_logged_in() ) {
                $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                $checkproducttype    = rs_get_product_object( $post->ID ) ;
                if ( get_option( 'rs_show_hide_message_for_single_product' ) == '1' ) {
                    if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                        return ;

                    if ( is_object( $checkproducttype ) && ($checkproducttype->is_type( 'simple' ) || $checkproducttype->is_type( 'subscription' ) || $checkproducttype->is_type( 'bundle' )) ) {
                        if ( RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $post->ID , '_rewardsystem_options' ) == '1' ) {
                            $rewardpoints = rs_function_for_rewardpoints_of_simple() ;
                            if ( $rewardpoints > 0 && ! $sumo_bookings_check ) {
                                ?>
                                <div class="woocommerce-info rs_message_for_single_product"><?php echo do_shortcode( get_option( 'rs_message_for_single_product_point_rule' ) ) ; ?></div>
                            <?php } elseif ( $rewardpoints > 0 && $sumo_bookings_check ) {
                                ?>
                                <div class="woocommerce-info rs_message_for_single_product"><?php echo get_option( 'rs_message_for_booking_product' ) ; ?></div>

                                <?php
                            }
                        } else {
                            $rewardpoints = rs_function_for_rewardpoints_of_simple() ;
                            if ( $rewardpoints > 0 && ! $sumo_bookings_check ) {
                                ?>
                                <div class="woocommerce-info rs_message_for_single_product"><?php echo do_shortcode( get_option( 'rs_message_for_single_product_point_rule' ) ) ; ?></div>
                            <?php } elseif ( $rewardpoints > 0 && $sumo_bookings_check ) {
                                ?>
                                <div class="woocommerce-info rs_message_for_single_product"><?php echo get_option( 'rs_message_for_booking_product' ) ; ?></div>

                                <?php
                            }
                        }
                    }
                }
                if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                    if ( get_option( 'rs_show_hide_message_for_single_product_referral' ) == '1' && get_option( 'rs_referral_activated' ) == 'yes' ) {
                        $rewardpoints = rs_function_for_rewardpoints_of_simple_referral() ;
                        if ( $rewardpoints > 0 ) {
                            ?>
                            <div class="woocommerce-info rs_message_for_single_product">
                                <?php
                                $msg     = get_option( 'rs_message_for_single_product_point_rule_referral' ) ;
                                $strrplc = str_replace( '[rsreferredusername]' , $_COOKIE[ 'rsreferredusername' ] , $msg ) ;
                                echo do_shortcode( $strrplc ) ;
                                ?></div>
                            <?php
                        }
                    }
                }
            } else {
                $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                $earnmessage         = do_shortcode( get_option( "rs_message_for_single_product_point_rule" ) ) ;
                if ( get_option( 'rs_show_hide_message_for_single_product_guest' ) == '1' ) {
                    if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                        return ;

                    $checkproducttype = rs_get_product_object( $post->ID ) ;
                    if ( is_object( $checkproducttype ) && ($checkproducttype->is_type( 'simple' ) || ($checkproducttype->is_type( 'subscription' )) || $checkproducttype->is_type( 'bundle' )) ) {
                        if ( RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $post->ID , '_rewardsystem_options' ) == '1' ) {
                            $rewardpoints = rs_function_for_rewardpoints_of_simple() ;
                            if ( $rewardpoints > 0 && ! $sumo_bookings_check ) {
                                if ( $earnmessage != '' ) {
                                    ?>
                                    <div class="woocommerce-info rs_message_for_single_product"><?php echo do_shortcode( get_option( 'rs_message_for_single_product_point_rule' ) ) ; ?></div>
                                    <?php
                                }
                            } elseif ( $rewardpoints > 0 && $sumo_bookings_check ) {
                                ?>
                                <div class="woocommerce-info rs_message_for_single_product"><?php echo get_option( 'rs_message_for_booking_product' ) ; ?></div>

                                <?php
                            }
                        } else {
                            $rewardpoints = rs_function_for_rewardpoints_of_simple() ;
                            if ( $earnmessage != '' ) {
                                if ( $rewardpoints > 0 && ! $sumo_bookings_check ) {
                                    ?>
                                    <div class="woocommerce-info rs_message_for_single_product"><?php echo do_shortcode( get_option( 'rs_message_for_single_product_point_rule' ) ) ; ?></div>
                                <?php } elseif ( $rewardpoints > 0 && $sumo_bookings_check ) {
                                    ?>
                                    <div class="woocommerce-info rs_message_for_single_product"><?php echo get_option( 'rs_message_for_booking_product' ) ; ?></div>

                                    <?php
                                }
                            }
                        }
                    }
                }
                if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                    if ( get_option( 'rs_show_hide_message_for_single_product_guest_referral' ) == '1' ) {
                        $rewardpoints = rs_function_for_rewardpoints_of_simple_referral() ;
                        if ( $rewardpoints > 0 ) {
                            ?>
                            <div class="woocommerce-info rs_message_for_single_product"><?php echo do_shortcode( get_option( 'rs_message_for_single_product_point_rule_referral' ) ) ; ?></div>
                            <?php
                        }
                    }
                }
            }
        }

        public static function display_purchase_message_for_simple_in_single_product_page() {
            global $post ;
            $product = rs_get_product_object( $post->ID ) ;
            $bool    = self::rs_check_for_stock_in_products( $product ) ;
            if ( $bool == false )
                return ;

            if ( did_action( 'woocommerce_before_single_product' ) === 1 ) {

                /* To Display Product Review Message */
                self::display_product_review_msg_in_single_product_page() ;

                /* To Display Subscribing Product Message */
                self::display_purchase_msg_in_single_product_page() ;

                /* To Display Product Purchase Message Based on Cart Total */
                self::display_cart_total_based_product_purchase_msg_in_single_product_page() ;

                /* To Display Product Purchase Message Based on Product Total */
                self::display_product_total_based_product_purchase_msg_in_single_product_page() ;
            }
        }

        public static function get_redeem_conversion_value_referral() {
            $singleproductvalue = rs_function_for_rewardpoints_of_simple_referral() ;
            $newvalue           = ( float ) $singleproductvalue / ( float ) wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
            $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
            $updatedvalue       = $newvalue * $point_amount ;
            return get_woocommerce_formatted_price( round_off_type_for_currency( $updatedvalue ) ) ;
        }

        public static function get_redeem_conversion_value() {
            $singleproductvalue = rs_function_for_rewardpoints_of_simple() ;
            $newvalue           = ( float ) $singleproductvalue / ( float ) wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
            $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
            $updatedvalue       = $newvalue * $point_amount ;
            return get_woocommerce_formatted_price( round_off_type_for_currency( $updatedvalue ) ) ;
        }

        public static function display_point_price_in_variable_product( $price , $object ) {
            global $post ;
            if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                return $price ;
            } else {
                if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                    $pixel                  = get_option( 'rs_pixel_val' ) ;
                    $enabledpoints          = calculate_point_price_for_products( rs_get_id( $object ) ) ;
                    $point_price            = $enabledpoints[ rs_get_id( $object ) ] ;
                    $point_price_info       = get_option( 'rs_label_for_point_value' ) ;
                    $typeofprice            = check_display_price_type( rs_get_id( $object ) ) ;
                    $labelposition          = get_option( 'rs_sufix_prefix_point_price_label' ) ;
                    $point_price_visibility = get_option( 'rs_point_price_visibility' ) ;
                    if ( $typeofprice == '2' ) {
                        $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                        $point_price  = round_off_type( $point_price ) ;
                        $replace      = str_replace( "/" , "" , $point_price_info ) ;

                        if ( $labelposition == '1' ) {
                            $totalamount = "{$replace}<span style='margin-left:{$pixel}px;'>{$point_price}</span>" ;
                        } else {
                            $totalamount = "{$point_price}<span style='margin-left:{$pixel}px;'>{$replace}</span>" ;
                        }
                        return $totalamount ;
                    } else {
                        if ( $point_price != '' ) {
                            $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                            $point_price  = round_off_type( $point_price ) ;

                            if ( $labelposition == '1' ) {
                                $totalamount = "{$point_price_info}<span style='margin-left:{$pixel}px;'>{$point_price}</span>" ;
                            } else {
                                $replace     = str_replace( "/" , "" , $point_price_info ) ;
                                $totalamount = '/' . "{$point_price}<span style='margin-left:{$pixel}px;'>{$replace}</span>" ;
                            }
                            return $price . '<span class="point_price_label">' . $totalamount ;
                        } else {
                            return $price ;
                        }
                    }
                }
            }
        }

        public static function get_variation_id( $post_id ) {
            $args                  = array (
                'post_parent' => $post_id ,
                'post_type'   => 'product_variation' ,
                'orderby'     => 'menu_order' ,
                'order'       => 'ASC' ,
                'fields'      => 'ids' ,
                'post_status' => 'publish' ,
                'numberposts' => -1
                    ) ;
            $variation_ids         = get_posts( $args ) ;
            $in_stock_variation_id = array () ;
            foreach ( $variation_ids as $variation_idss ) {
                $variation_id = new WC_Product_Variation( $variation_idss ) ;
                if ( $variation_id->is_in_stock() ) {
                    $in_stock_variation_id[] = $variation_id->get_id() ;
                }
            }
            return $in_stock_variation_id ;
        }

        public static function rewardpoints_of_variation( $variation_id , $newparentid ) {
            $varpoints        = '' ;
            $item             = array ( 'qty' => '1' ) ;
            $rewardpoints     = check_level_of_enable_reward_point( $newparentid , $variation_id , $item , $checklevel       = 'no' , $referred_user    = '' , $getting_referrer = 'no' , $socialreward     = 'no' , $rewardfor        = '' , $payment_price    = 0 ) ;
            if ( is_user_logged_in() ) {
                $getpoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $rewardpoints ) ;
            } else {
                $getpoints = $rewardpoints ;
            }
            $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
            $varpoints    = $getpoints ;
            return $varpoints ;
        }

        public static function rs_check_for_stock_in_products( $product ) {
            $bool = $product->is_in_stock() ;
            if ( is_shop() ) {
                if ( $bool == false && get_option( 'rs_show_or_hide_message_for_outofstock' ) == '1' ) {
                    $bool = true ;
                }
            }
            if ( is_product() ) {
                if ( $bool == false && get_option( 'rs_message_outofstockproducts_product_page' ) == '1' ) {
                    $bool = true ;
                }
            }
            return $bool ;
        }

    }

    RSFunctionforSimpleProduct::init() ;
}