<?php
if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' ) ;
}

class FPRewardSystemSendpointTabList extends WP_List_Table {

    function __construct() {
        global $status , $page ;
        parent::__construct( array(
            'singular' => 'send_application' ,
            'plural'   => 'send_applications' ,
            'ajax'     => true
        ) ) ;
    }

    function column_default( $item , $column_name ) {
        return $item[ $column_name ] ;
    }

    function column_userloginname( $item ) {


        if ( $item[ 'status' ] == 'Paid' ) {
            //Build row actions
            $actions = array(
                'delete' => sprintf( '<a href="?page=%s&tab=%s&section=%s&action=%s&id=%s">Delete</a>' , $_REQUEST[ 'page' ] , $_REQUEST[ 'tab' ] , $_REQUEST[ 'section' ] , 'send_application_delete' , $item[ 'id' ] ) ,
                    ) ;

            //Return the title contents
            return sprintf( '%1$s %3$s' ,
                    /* $1%s */ $item[ 'userloginname' ] ,
                    /* $2%s */ $item[ 'id' ] ,
                    /* $3%s */ $this->row_actions( $actions )
                    ) ;
        } elseif ( $item[ 'status' ] == 'Rejected' ) {
            //Build row actions
            $actions = array(
                'delete' => sprintf( '<a href="?page=%s&tab=%s&action=%s&id=%s&section=%s">Delete</a>' , $_REQUEST[ 'page' ] , $_REQUEST[ 'tab' ] , $_REQUEST[ 'section' ] , 'delete' , $item[ 'id' ] ) ,
                    ) ;
            return sprintf( '%1$s %3$s' ,
                    /* $1%s */ $item[ 'userloginname' ] ,
                    /* $2%s */ $item[ 'id' ] ,
                    /* $3%s */ $this->row_actions( $actions )
                    ) ;
        } else {
            $actions = array(
                'accept' => sprintf( '<a href="?page=%s&tab=%s&section=%s&action=%s&id=%s">Approve</a>' , $_REQUEST[ 'page' ] , $_REQUEST[ 'tab' ] , $_REQUEST[ 'section' ] , 'accept' , $item[ 'id' ] ) ,
                'reject' => sprintf( '<a href="?page=%s&tab=%s&section=%s&action=%s&id=%s">Reject</a>' , $_REQUEST[ 'page' ] , $_REQUEST[ 'tab' ] , $_REQUEST[ 'section' ] , 'reject' , $item[ 'id' ] ) ,
                    ) ;
            //Return the title contents
            return sprintf( '%1$s %3$s' ,
                    /* $1%s */ $item[ 'userloginname' ] ,
                    /* $2%s */ $item[ 'id' ] ,
                    /* $3%s */ $this->row_actions( $actions )
                    ) ;
        }
    }

    function column_cb( $item ) {
        return sprintf(
                '<input type="checkbox" name="id[]" value="%s" />' , $item[ 'id' ]
                ) ;
    }

    function get_columns() {
        $columns = array(
            'cb'                  => '<input type="checkbox" />' , //Render a checkbox instead of text            
            'userloginname'       => __( 'Sent by' , 'rewardsystem' ) ,
            'selecteduser'        => __( 'Received by' , 'rewardsystem' ) ,
            'pointstosend'        => __( 'Points' , 'rewardsystem' ) ,
            'sendercurrentpoints' => __( 'Current user Points' , 'rewardsystem' ) ,
            'status'              => __( 'Request Status' , 'rewardsystem' ) ,
            'date'                => __( 'Requested date' , 'rewardsystem' )
                ) ;
        return $columns ;
    }

    function get_sortable_columns() {
        $sortable_columns = array(
            'userloginname'       => array( 'userloginname' , false ) , //true means it's already sorted            
            'selecteduser'        => array( 'selecteduser' , false ) ,
            'pointstosend'        => array( 'pointstosend' , false ) ,
            'sendercurrentpoints' => array( 'sendercurrentpoints' , false ) ,
            'status'              => array( 'status' , false ) ,
            'date'                => array( 'date' , false )
                ) ;
        return $sortable_columns ;
    }

    function get_bulk_actions() {
        $actions = array(
            'delete' => __( 'Delete' , 'rewardsystem' ) ,
            'rspaid' => __( 'Mark as Paid' , 'rewardsystem' ) ,
            'rsdue'  => __( 'Mark as Due' , 'rewardsystem' ) ,
                ) ;
        return $actions ;
    }

    function process_bulk_action() {
        global $wpdb ;
        $table_name  = $wpdb->prefix . 'sumo_reward_send_point_submitted_data' ; // do not forget about tables prefix
        $table_name1 = $wpdb->prefix . "rspointexpiry" ;
        $table_name2 = $wpdb->prefix . "rsrecordpoints" ;
        $table_name3 = $wpdb->prefix . "users" ;
        $date        = rs_function_to_get_expiry_date_in_unixtimestamp() ;
        if ( 'send_application_delete' === $this->current_action() ) {
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) ) {
                $ids = implode( ',' , $ids ) ;
            } else {
                $ids = $ids ;
            }

            if ( ! empty( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                foreach ( $ids as $eachid ) {
                    $user_id = $wpdb->get_results( "SELECT selecteduser,id,userid,pointstosend FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                    if ( is_array( $user_id ) && ! empty( $user_id ) ) {
                        foreach ( $user_id as $value ) {
                            $user_idss          = $value[ 'userid' ] ;
                            $returnedpointsss   = $value[ 'pointstosend' ] ;
                            $updatoption        = $value[ 'id' ] . 'sendpointupadate' ;
                            $sender_user_info   = get_userdata( $user_idss ) ;
                            $receiver_user_info = get_userdata( $value[ 'selecteduser' ] ) ;
                            $status             = 'Deleted' ;
                            $this->rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointsss ) ;
                            $get_user           = get_user_meta( $user_idss , $updatoption , true ) ;
                            if ( $get_user != '1' ) {
                                $equearnamt  = RSPointExpiry::earning_conversion_settings( $returnedpointsss ) ;
                                RSPointExpiry::insert_earning_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , $returnedpointsss , '0' ) ;
                                $totalpoints = RSPointExpiry::total_available_points_in_site( $user_idss ) ;
                                RSPointExpiry::record_the_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , '' , '0' ) ;
                                update_user_meta( $user_idss , $updatoption , '1' ) ;
                            }
                        }
                    }
                }
            }
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) ) {
                $ids = implode( ',' , $ids ) ;
            } else {
                $ids = $ids ;
            }
            $wpdb->query( "DELETE FROM $table_name WHERE id IN($ids)" ) ;
            $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
            wp_safe_redirect( $redirect ) ;
        } elseif ( 'rspaid' === $this->current_action() ) {
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) ) {
                $ids = implode( ',' , $ids ) ;
            } else {
                $ids = $ids ;
            }
            if ( ! is_array( $ids ) && ! empty( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                foreach ( $ids as $eachid ) {
                    $wpdb->update( $table_name , array( 'status' => 'Paid' ) , array( 'id' => $eachid ) ) ;
                    $message        = __( $countids . ' Status Changed to Paid' , 'rewardsystem' ) ;
                    $selecteduserid = $wpdb->get_results( "SELECT selecteduser,userid FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                    if ( is_array( $selecteduserid ) && ! empty( $selecteduserid ) ) {
                        foreach ( $selecteduserid as $value ) {
                            $useridsss  = $value[ 'selecteduser' ] ;
                            $senduser   = $value[ 'userid' ] ;
                            $sendpoints = $wpdb->get_results( "SELECT pointstosend FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                            foreach ( $sendpoints as $value ) {
                                $returnedpointssss = $value[ 'pointstosend' ] ;
                            }
                            $sender_user_info   = get_userdata( $senduser ) ;
                            $receiver_user_info = get_userdata( $useridsss ) ;
                            $status             = 'Accepted' ;
                            $this->rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointssss ) ;
                            $equearnamt         = RSPointExpiry::earning_conversion_settings( $returnedpointssss ) ;
                            RSPointExpiry::insert_earning_points( $useridsss , $returnedpointssss , '0' , $date , 'SP' , '0' , $returnedpointssss , '0' , '' ) ;
                            $totalpoints        = RSPointExpiry::total_available_points_in_site( $useridsss ) ;
                            RSPointExpiry::record_the_points( $useridsss , $returnedpointssss , '0' , $date , 'SP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , $senduser , '0' ) ;

                            // Log to be record for Sender after Admin Approval
                            $totalpoints = RSPointExpiry::total_available_points_in_site( $senduser ) ;
                            RSPointExpiry::record_the_points( $senduser , '0' , $returnedpointssss , $date , 'SPA' , '0' , '0' , '0' , '0' , '0' , '0' , '' , $totalpoints , $useridsss , '0' ) ;
                        }
                    }
                }

                if ( ! empty( $message ) ):
                    ?>
                    <div id="message" class="updated"><p><?php echo $message ?></p></div>
                    <?php
                endif ;
                $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
                wp_safe_redirect( $redirect ) ;
                exit ;
            }
        }elseif ( 'accept' === $this->current_action() ) {
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( ! is_array( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                foreach ( $ids as $eachid ) {
                    $wpdb->update( $table_name , array( 'status' => 'Paid' ) , array( 'id' => $eachid ) ) ;
                    $message        = __( $countids . ' Status Changed to Paid' , 'rewardsystem' ) ;
                    $selecteduserid = $wpdb->get_results( "SELECT selecteduser,userid,pointstosend FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                    if ( is_array( $selecteduserid ) && ! empty( $selecteduserid ) ) {
                        foreach ( $selecteduserid as $value ) {
                            $useridsss          = $value[ 'selecteduser' ] ;
                            $returnedpointssss  = $value[ 'pointstosend' ] ;
                            $senduser           = $value[ 'userid' ] ;
                            $sender_user_info   = get_userdata( $senduser ) ;
                            $receiver_user_info = get_userdata( $useridsss ) ;
                            $status             = 'Accepted' ;
                            $this->rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointssss ) ;
                            $equearnamt         = RSPointExpiry::earning_conversion_settings( $returnedpointssss ) ;
                            RSPointExpiry::insert_earning_points( $useridsss , $returnedpointssss , '0' , $date , 'SP' , '0' , $returnedpointssss , '0' , '' ) ;
                            $totalpoints        = RSPointExpiry::total_available_points_in_site( $useridsss ) ;
                            RSPointExpiry::record_the_points( $useridsss , $returnedpointssss , '0' , $date , 'SP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , $senduser , '0' ) ;

//Log to be record for Sender after Admin Approval
                            $totalpoints = RSPointExpiry::total_available_points_in_site( $senduser ) ;
                            RSPointExpiry::record_the_points( $senduser , '0' , $returnedpointssss , $date , 'SPA' , '0' , '0' , '0' , '0' , '0' , '0' , '' , $totalpoints , $useridsss , '0' ) ;
                        }
                    }
                }
                if ( ! empty( $message ) ):
                    ?>
                    <div id="message" class="updated"><p><?php echo $message ?></p></div>
                    <?php
                endif ;
                $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
                wp_safe_redirect( $redirect ) ;
                exit ;
            }
        }elseif ( 'reject' === $this->current_action() ) {
            $user_idss        = '' ;
            $returnedpointsss = '' ;
            $ids              = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( ! is_array( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                foreach ( $ids as $eachid ) {
                    $wpdb->update( $table_name , array( 'status' => 'Rejected' ) , array( 'id' => $eachid ) ) ;
                    $message = __( $countids . ' Status Changed to Rejected' , 'rewardsystem' ) ;
                    $user_id = $wpdb->get_results( "SELECT selecteduser,id,userid,pointstosend FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                    if ( is_array( $user_id ) && ! empty( $user_id ) ) {
                        foreach ( $user_id as $value ) {
                            $user_idss          = $value[ 'userid' ] ;
                            $returnedpointsss   = $value[ 'pointstosend' ] ;
                            $updatoption        = $value[ 'id' ] . 'sendpointupadate' ;
                            $sender_user_info   = get_userdata( $user_idss ) ;
                            $receiver_user_info = get_userdata( $value[ 'selecteduser' ] ) ;
                            $status             = 'Rejected' ;
                            $this->rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointsss ) ;
                            $get_user           = get_user_meta( $user_idss , $updatoption , true ) ;
                            if ( $get_user != '1' ) {
                                $equearnamt  = RSPointExpiry::earning_conversion_settings( $returnedpointsss ) ;
                                RSPointExpiry::insert_earning_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , $returnedpointsss , '0' ) ;
                                $totalpoints = RSPointExpiry::total_available_points_in_site( $user_idss ) ;
                                RSPointExpiry::record_the_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , '' , '0' ) ;
                                update_user_meta( $user_idss , $updatoption , '1' ) ;
                            }
                        }
                    }
                }
                if ( ! empty( $message ) ):
                    ?>
                    <div id="message" class="updated"><p><?php echo $message ?></p></div>
                    <?php
                endif ;
                $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
                wp_safe_redirect( $redirect ) ;
                exit ;
            }
        }elseif ( 'delete' === $this->current_action() ) {
            $user_idss        = '' ;
            $returnedpointsss = '' ;
            $ids              = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) ) {
                $ids = implode( ',' , $ids ) ;
            } else {
                $ids = $ids ;
            }

            if ( ! empty( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                $value    = array( 'action' => 'delete' ) ;
                foreach ( $ids as $eachid ) {
                    $user_id = $wpdb->get_results( "SELECT selecteduser,id,userid,pointstosend FROM $table_name WHERE id = $eachid" , ARRAY_A ) ;
                    if ( is_array( $user_id ) && ! empty( $user_id ) ) {
                        foreach ( $user_id as $value ) {
                            $user_idss          = $value[ 'userid' ] ;
                            $sender_user_info   = get_userdata( $user_idss ) ;
                            $receiver_user_info = get_userdata( $value[ 'selecteduser' ] ) ;
                            $returnedpointsss   = $value[ 'pointstosend' ] ;
                            $status             = 'Deleted' ;
                            $this->rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointsss ) ;
                            $updatoption        = $value[ 'id' ] . 'sendpointupadate' ;
                            $get_user           = get_user_meta( $user_idss , $updatoption , true ) ;
                            if ( $get_user != '1' ) {
                                $equearnamt  = RSPointExpiry::earning_conversion_settings( $returnedpointsss ) ;
                                RSPointExpiry::insert_earning_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , $returnedpointsss , '0' ) ;
                                $totalpoints = RSPointExpiry::total_available_points_in_site( $user_idss ) ;
                                RSPointExpiry::record_the_points( $user_idss , $returnedpointsss , '0' , $date , 'SEP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , '' , '0' ) ;
                                update_user_meta( $user_idss , $updatoption , '1' ) ;
                            }
                        }
                    }
                }
            }
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) ) {
                $ids = implode( ',' , $ids ) ;
            } else {
                $ids = $ids ;
            }
            $wpdb->query( "DELETE FROM $table_name WHERE id IN($ids)" ) ;
            if ( ! empty( $message ) ):
                ?>
                <div id="message" class="updated"><p><?php echo $message ?></p></div>
                <?php
            endif ;
            $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
            wp_safe_redirect( $redirect ) ;
            exit ;
        }else {
            $ids = isset( $_REQUEST[ 'id' ] ) ? $_REQUEST[ 'id' ] : array() ;
            if ( is_array( $ids ) )
                $ids = implode( ',' , $ids ) ;
            if ( ! empty( $ids ) ) {
                $ids      = explode( ',' , $ids ) ;
                $countids = count( $ids ) ;
                foreach ( $ids as $eachid ) {
                    $wpdb->update( $table_name , array( 'status' => 'Due' ) , array( 'id' => $eachid ) ) ;
                    $message = __( $countids . ' Status Changed to Due' , 'rewardsystem' ) ;
                }
                if ( ! empty( $message ) ):
                    ?>
                    <div id="message" class="updated"><p><?php echo $message ?></p></div>
                    <?php
                endif ;
                $redirect = remove_query_arg( array( 'action' , 'id' ) , get_permalink() ) ;
                wp_safe_redirect( $redirect ) ;
                exit ;
            }
        }
    }

    private function table_data( $startpoint , $perPage ) {
        global $wpdb ;
        $table_name = $wpdb->prefix . 'sumo_reward_send_point_submitted_data' ; // do not forget about tables prefix
        $data       = array() ;
        $query_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name  LIMIT %d OFFSET %d" , $perPage , $startpoint ) , ARRAY_A ) ;
        $i          = 1 ;
        foreach ( $query_data as $user ) {
            $sender      = $user[ 'userid' ] ;
            $sender_info = get_user_by( 'id' , $sender ) ;
            if ( ! empty( $sender_info ) && is_object( $sender_info ) ) {
                $customer_info    = $sender_info->display_name . ' (#' . $sender_info->ID . ' - ' . sanitize_email( $sender_info->user_email ) . ')' ;
                $receiver_user_id = $user[ 'selecteduser' ] ;
                $customer         = get_user_by( 'id' , $receiver_user_id ) ;
                if ( is_object( $customer ) ) {
                    $reciver_info = $customer->display_name . ' (#' . $customer->ID . ' - ' . sanitize_email( $customer->user_email ) . ')' ;
                    $data[]       = array(
                        'id'                  => $user[ 'id' ] ,
                        'userloginname'       => $customer_info ,
                        'selecteduser'        => $reciver_info ,
                        'pointstosend'        => $user[ 'pointstosend' ] ,
                        'sendercurrentpoints' => $user[ 'sendercurrentpoints' ] ,
                        'status'              => $user[ 'status' ] ,
                        'date'                => $user[ 'date' ] ,
                            ) ;
                    $i ++ ;
                }
            }
        }
        return $data ;
    }

    function prepare_items() {
        global $wpdb ;
        $table_name            = $wpdb->prefix . 'sumo_reward_send_point_submitted_data' ; // do not forget about tables prefix
        $columns               = $this->get_columns() ;
        $hidden                = array() ;
        $sortable              = $this->get_sortable_columns() ;
        // here we configure table headers, defined in our methods
        $this->_column_headers = array( $columns , $hidden , $sortable ) ;
        $this->process_bulk_action() ;
        // will be used in pagination settings
        $total_items           = $wpdb->get_var( "SELECT COUNT(id) FROM $table_name" ) ;
        // prepare query params, as usual current page, order by and order direction
        $paged                 = isset( $_REQUEST[ 'paged' ] ) ? max( 0 , intval( $_REQUEST[ 'paged' ] ) - 1 ) : 0 ;
        $orderby               = (isset( $_REQUEST[ 'orderby' ] ) && in_array( $_REQUEST[ 'orderby' ] , array_keys( $this->get_sortable_columns() ) )) ? $_REQUEST[ 'orderby' ] : 'id' ;
        $order                 = (isset( $_REQUEST[ 'order' ] ) && in_array( $_REQUEST[ 'order' ] , array( 'asc' , 'desc' ) )) ? $_REQUEST[ 'order' ] : 'asc' ;
        // [REQUIRED] define $items array
        // notice that last argument is ARRAY_A, so we will retrieve array
        $user                  = get_current_user_id() ;
        $screen                = get_current_screen() ;
        $per_page              = RSTabManagement::rs_get_value_for_no_of_item_perpage( $user , $screen ) ;
        $currentPage           = $this->get_pagenum() ;
        $startpoint            = ($currentPage - 1) * $per_page ;
        $data                  = $this->table_data( $startpoint , $per_page ) ;
        $this->items           = $data ;
        // [REQUIRED] configure pagination
        $this->set_pagination_args( array(
            'total_items' => $total_items , // total items defined above
            'per_page'    => $per_page , // per page constant defined at top of method
            'total_pages' => ceil( $total_items / $per_page ) // calculate pages count
        ) ) ;
    }

    function rs_confirmation_mail_and_admin_mail_for_Sendpoints( $status , $sender_user_info , $receiver_user_info , $returnedpointssss ) {
        $approval_type = get_option( 'rs_request_approval_type' ) ;
        $headers       = '' ;
        global $woocommerce ;
        if ( $approval_type == '1' ) {
            $sender_name    = is_object( $sender_user_info ) ? $sender_user_info->user_login : '' ;
            $receiver_name  = is_object( $receiver_user_info ) ? $receiver_user_info->user_login : '' ;
            $receiver_mail  = is_object( $receiver_user_info ) ? $receiver_user_info->user_email : '' ;
            $sender_mail_id = is_object( $sender_user_info ) ? $sender_user_info->user_email : '' ;
            $admin_email_id = get_option( 'admin_email' ) ;
            $admin_name     = get_bloginfo( 'name' , 'display' ) ;
            if ( get_option( 'rs_mail_for_send_points_confirmation_mail_for_user' ) == 'yes' ) {
                if ( $status != '' && $sender_name != '' && $sender_mail_id != '' && $admin_name != '' && $admin_email_id != '' ) {
                    $confirmation_email_subject                = get_option( 'rs_email_subject_for_send_points_confirmation' ) ;
                    $email_confirmation_message                = get_option( 'rs_email_message_for_send_points_confirmation' ) ;
                    $confirmation_email_message_for_sendpoints = str_replace( '[request]' , $status , str_replace( '[user_name] ' , $sender_name , str_replace( '[points]' , $returnedpointssss , str_replace( '[receiver_name]' , $receiver_name , $email_confirmation_message ) ) ) ) ;
                    add_filter( 'woocommerce_email_footer_text' , 'footer_link' ) ;
                    ob_start() ;
                    wc_get_template( 'emails/email-header.php' , array( 'email_heading' => $confirmation_email_subject ) ) ;
                    echo $confirmation_email_message_for_sendpoints ;
                    wc_get_template( 'emails/email-footer.php' ) ;
                    $woo_temp_msg                              = ob_get_clean() ;
                    $message_headers                           = "MIME-Version: 1.0\r\n" ;
                    // $message_headers .= "Content-Type: text/html; charset=UTF-8\r\n" ;
                    $message_headers                           .= "From: \"{$admin_name}\" <{$admin_email_id}>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n" ;
                    $message_headers                           .= "Reply-To: " . $sender_name . " <" . $sender_name . ">\r\n" ;
                    FPRewardSystem::$rs_from_name              = $admin_name ;
                    add_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 2 ) ;
                    if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                        if ( wp_mail( $sender_mail_id , $confirmation_email_subject , $confirmation_email_message_for_sendpoints , $message_headers ) ) {
                            
                        }
                    } else {
                        $mailer = WC()->mailer() ;
                        $mailer->send( $sender_mail_id , $confirmation_email_subject , $woo_temp_msg , $message_headers ) ;
                    }
                    remove_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 2 ) ;
                }
            }
            if ( get_option( 'rs_mail_for_send_points_for_user' ) == 'yes' ) {
                $Reason = get_option( 'rs_reason_for_send_points_mail' ) ;
                if ( $sender_name != '' && $returnedpointssss != '' && $status != '' ) {
                    $email_subject = get_option( 'rs_email_subject_for_send_points' ) ;
                    $email_message = get_option( 'rs_email_message_for_send_points' ) ;
                    $message       = str_replace( '[_rs_sendpoints]' , $returnedpointssss , str_replace( '[specific_user]' , $sender_name , str_replace( '[user_name]' , $receiver_name , $email_message ) ) ) ;
                    $Email_message = str_replace( '[status]' , $status , str_replace( '[reason_message]' , $Reason , $message ) ) ;
                    $Email_message = do_shortcode( $Email_message ) ;
                    add_filter( 'woocommerce_email_footer_text' , 'footer_link' ) ;

                    ob_start() ;
                    wc_get_template( 'emails/email-header.php' , array( 'email_heading' => $email_subject ) ) ;
                    echo $Email_message ;
                    wc_get_template( 'emails/email-footer.php' ) ;
                    $woo_temp_msg                 = ob_get_clean() ;
                    $message_headers              = "MIME-Version: 1.0\r\n" ;
                    // $message_headers .= "Content-Type: text/html; charset=UTF-8\r\n" ;
                    $message_headers              .= "From: \"{$sender_name}\" <{$sender_mail_id}>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n" ;
                    $message_headers              .= "Reply-To: " . $receiver_name . " <" . $receiver_mail . ">\r\n" ;
                    FPRewardSystem::$rs_from_name = $sender_name ;
                    add_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 2 ) ;
                    if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                        if ( wp_mail( $receiver_mail , $email_subject , $Email_message , $message_headers ) ) {
                            
                        }
                    } else {
                        $mailer = WC()->mailer() ;
                        $mailer->send( $receiver_mail , $email_subject , $woo_temp_msg , $message_headers ) ;
                    }
                    remove_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 1 ) ;
                }
            }
        }
    }

}
