<?php

/*
 * SMS Tab Setting
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSSms' ) ) {

    class RSSms {

        public static function init() {

            add_filter( 'woocommerce_rs_settings_tabs_array' , array( __CLASS__ , 'reward_system_tab_setting' ) ) ; // Register a New Tab in a WooCommerce Reward System Settings        

            add_action( 'woocommerce_rs_settings_tabs_rewardsystem_sms' , array( __CLASS__ , 'reward_system_register_admin_settings' ) ) ; // Call to register the admin settings in the Reward System Submenu with general Settings tab        

            add_action( 'woocommerce_update_options_rewardsystem_modules_rewardsystem_sms' , array( __CLASS__ , 'reward_system_update_settings' ) ) ; // call the woocommerce_update_options_{slugname} to update the reward system                               

            add_action( 'admin_init' , array( __CLASS__ , 'reward_system_default_settings' ) ) ; // call the init function to update the default settings on page load

            add_action( 'fp_action_to_reset_module_settings_rewardsystem_sms' , array( __CLASS__ , 'rs_function_to_reset_sms_tab' ) ) ;

            add_action( 'woocommerce_admin_field_rs_enable_disable_sms_module' , array( __CLASS__ , 'rs_function_to_enable_disable_sms_module' ) ) ;
        }

        /*
         * Function to Define Name of the Tab
         */

        public static function reward_system_tab_setting( $setting_tabs ) {
            if ( ! is_array( $setting_tabs ) )
                $setting_tabs                       = ( array ) $setting_tabs ;
            $setting_tabs[ 'rewardsystem_sms' ] = __( 'SMS Module' , 'rewardsystem' ) ;
            return $setting_tabs ;
        }

        /*
         * Function label settings to Member Level Tab
         */

        public static function reward_system_admin_fields() {
            global $woocommerce ;

            return apply_filters( 'woocommerce_rewardsystem_sms_settings' , array(
                array(
                    'type' => 'rs_modulecheck_start' ,
                ) ,
                array(
                    'name' => __( 'SMS Module' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_activate_sms_module'
                ) ,
                array(
                    'type' => 'rs_enable_disable_sms_module' ,
                ) ,
                array( 'type' => 'sectionend' , 'id' => '_rs_activate_sms_module' ) ,
                array(
                    'type' => 'rs_modulecheck_end' ,
                ) ,
                array(
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array(
                    'name' => __( 'SMS Notification Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_sms_setting'
                ) ,
                array(
                    'title'   => __( 'Notification through SMS' , 'woocommerce' ) ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'id'      => 'rs_enable_send_sms_to_user' ,
                    'newids'  => 'rs_enable_send_sms_to_user' ,
                ) ,
                array(
                    'name'     => __( 'SMS API' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can choose the sms sending APi' , 'rewardsystem' ) ,
                    'id'       => 'rs_sms_sending_api_option' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'select' ,
                    'options'  => array(
                        '1' => 'Twilio' ,
                        '2' => 'Nexmo' , ) ,
                    'newids'   => 'rs_sms_sending_api_option' ,
                    'class'    => 'rs_sms_sending_api_option' ,
                    'desc_tip' => true ,
                ) ,
                array(
                    'title'   => __( 'Send SMS on Earning Points' , 'woocommerce' ) ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'id'      => 'rs_send_sms_earning_points' ,
                    'class'   => 'rs_send_sms_earning_points' ,
                    'newids'  => 'rs_send_sms_earning_points' ,
                ) ,
                array(
                    'name'    => __( 'SMS Content' , 'rewardsystem' ) ,
                    'id'      => 'rs_points_sms_content_for_earning' ,
                    'std'     => 'Hi {username}, you have earned {points} on this order{orderid}. Currently, you have {rewardpoints} points in your account. You can make use of it to get discount on future purchases in {sitelink}.' ,
                    'default' => 'Hi {username}, you have earned {points} on this order{orderid}. Currently, you have {rewardpoints} points in your account. You can make use of it to get discount on future purchases in {sitelink}.' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_points_sms_content_for_earning' ,
                    'class'   => 'rs_points_sms_content_for_earning' ,
                ) ,
                array(
                    'title'   => __( 'Send SMS on Redeeming Points' , 'woocommerce' ) ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'id'      => 'rs_send_sms_redeeming_points' ,
                    'class'   => 'rs_send_sms_redeeming_points' ,
                    'newids'  => 'rs_send_sms_redeeming_points' ,
                ) ,
                array(
                    'name'    => __( 'SMS Content' , 'rewardsystem' ) ,
                    'id'      => 'rs_points_sms_content_for_redeeming' ,
                    'std'     => 'Hi {username}, you have redeemed {points} on this order {orderid}. Currently, you have {rewardpoints} points in your account. You can make use of it to get discount on future purchases in {sitelink}' ,
                    'default' => 'Hi {username}, you have redeemed {points} on this order {orderid}. Currently, you have {rewardpoints} points in your account. You can make use of it to get discount on future purchases in {sitelink}' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_points_sms_content_for_redeeming' ,
                    'class'   => 'rs_points_sms_content_for_redeeming' ,
                ) ,
                array(
                    'name'    => __( 'Twilio Account SID' , 'rewardsystem' ) ,
                    'id'      => 'rs_twilio_secret_account_id' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'text' ,
                    'newids'  => 'rs_twilio_secret_account_id' ,
                ) ,
                array(
                    'name'    => __( 'Twilio Account Auth Token' , 'rewardsystem' ) ,
                    'id'      => 'rs_twilio_auth_token_id' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'text' ,
                    'newids'  => 'rs_twilio_auth_token_id' ,
                ) ,
                array(
                    'name'    => __( 'Twilio From Number' , 'rewardsystem' ) ,
                    'id'      => 'rs_twilio_from_number' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'text' ,
                    'newids'  => 'rs_twilio_from_number' ,
                ) ,
                array(
                    'name'    => __( 'Nexmo Key' , 'rewardsystem' ) ,
                    'id'      => 'rs_nexmo_key' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'text' ,
                    'newids'  => 'rs_nexmo_key' ,
                ) ,
                array(
                    'name'    => __( 'Nexmo Secret' , 'rewardsystem' ) ,
                    'id'      => 'rs_nexmo_secret' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'text' ,
                    'newids'  => 'rs_nexmo_secret' ,
                ) ,
                array( 'type' => 'sectionend' , 'id' => '_rs_sms_setting' ) ,
                array(
                    'type' => 'rs_wrapper_end' ,
                ) ,
                    ) ) ;
        }

        /**
         * Registering Custom Field Admin Settings of SUMO Reward Points in woocommerce admin fields funtion
         */
        public static function reward_system_register_admin_settings() {

            woocommerce_admin_fields( RSSms::reward_system_admin_fields() ) ;
        }

        /**
         * Update the Settings on Save Changes may happen in SUMO Reward Points
         */
        public static function reward_system_update_settings() {
            woocommerce_update_options( RSSms::reward_system_admin_fields() ) ;
            if ( isset( $_POST[ 'rs_sms_module_checkbox' ] ) ) {
                update_option( 'rs_sms_activated' , $_POST[ 'rs_sms_module_checkbox' ] ) ;
            } else {
                update_option( 'rs_sms_activated' , 'no' ) ;
            }
        }

        /**
         * Initialize the Default Settings by looping this function
         */
        public static function reward_system_default_settings() {
            global $woocommerce ;
            foreach ( RSSms::reward_system_admin_fields() as $setting )
                if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                    add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                }
        }

        public static function rs_function_to_reset_sms_tab() {
            $settings = RSSms::reward_system_admin_fields() ;
            RSTabManagement::rs_function_to_reset_setting( $settings ) ;
        }

        public static function rs_function_to_enable_disable_sms_module() {
            $get_option_value = get_option( 'rs_sms_activated' ) ;
            $name_of_checkbox = 'rs_sms_module_checkbox' ;
            RSModulesTab::rs_common_function_to_get_checkbox( $get_option_value , $name_of_checkbox ) ;
        }

    }

    RSSms::init() ;
}