<?php
/*
 * Reset Tab Setting
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSReset' ) ) {

    class RSReset {

        public static function init() {

            add_filter( 'woocommerce_rs_settings_tabs_array' , array ( __CLASS__ , 'reward_system_tab_setting' ) ) ; // Register a New Tab in a WooCommerce Reward System Settings        

            add_action( 'woocommerce_rs_settings_tabs_rewardsystem_reset' , array ( __CLASS__ , 'reward_system_register_admin_settings' ) ) ; // Call to register the admin settings in the Reward System Submenu with general Settings tab        

            add_action( 'woocommerce_update_options_rewardsystem_modules_rewardsystem_reset' , array ( __CLASS__ , 'reward_system_update_settings' ) ) ; // call the woocommerce_update_options_{slugname} to update the reward system                               

            add_action( 'woocommerce_admin_field_reset_field' , array ( __CLASS__ , 'add_admin_field_to_reward_system' ) ) ;

            add_action( 'wp_ajax_nopriv_rsresetuserdata' , array ( __CLASS__ , 'process_reset_data_users' ) ) ;

            add_action( 'wp_ajax_rsresetuserdata' , array ( __CLASS__ , 'process_reset_data_users' ) ) ;

            add_action( 'wp_ajax_rssplitajaxpreviousorder' , array ( __CLASS__ , 'process_reset_previous_order' ) ) ;

            add_action( 'woocommerce_admin_field_reset_tab_settings' , array ( __CLASS__ , 'rs_field_to_reset_tab' ) ) ;

            add_action( 'wp_ajax_rsresettabsettings' , array ( __CLASS__ , 'reset_reward_system_admin_settings' ) ) ;

            add_action( 'woocommerce_admin_field_rs_enable_disable_reset_module' , array ( __CLASS__ , 'rs_function_to_enable_disable_reset_module' ) ) ;

            add_action( 'woocommerce_admin_field_rs_select_user_to_reset_data' , array ( __CLASS__ , 'rs_select_user_to_reset_data' ) ) ;
        }

        /*
         * Function to Define Name of the Tab
         */

        public static function reward_system_tab_setting( $setting_tabs ) {
            if ( ! is_array( $setting_tabs ) )
                $setting_tabs                         = ( array ) $setting_tabs ;
            $setting_tabs[ 'rewardsystem_reset' ] = __( 'Reset Module' , 'rewardsystem' ) ;
            return $setting_tabs ;
        }

        /*
         * Function label settings to Member Level Tab
         */

        public static function reward_system_admin_fields() {
            global $woocommerce ;

            return apply_filters( 'woocommerce_rewardsystem_reset_settings' , array (
                array (
                    'type' => 'rs_modulecheck_start' ,
                ) ,
                array (
                    'name' => __( 'Reset Module' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_activate_reset_module'
                ) ,
                array (
                    'type' => 'rs_enable_disable_reset_module' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_activate_reset_module' ) ,
                array (
                    'type' => 'rs_modulecheck_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Reset Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_reset_setting'
                ) ,
                array (
                    'name'    => __( 'Reset Data for' , 'rewardsystem' ) ,
                    'type'    => 'radio' ,
                    'id'      => 'rs_reset_data_all_users' ,
                    'newids'  => 'rs_reset_data_all_users' ,
                    'class'   => 'rs_reset_data_for_users' ,
                    'options' => array (
                        '1' => __( 'All Users' , 'rewardsystem' ) ,
                        '2' => __( 'Selected Users' , 'rewardsystem' ) ,
                    ) ,
                    'std'     => '1' ,
                    'default' => '1' ,
                ) ,
                array (
                    'type' => 'rs_select_user_to_reset_data' ,
                ) ,
                array (
                    'name'    => __( 'Reset User Reward Points' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_user_reward_points' ,
                    'newids'  => 'rs_reset_user_reward_points' ,
                    'class'   => 'rs_reset_user_reward_points' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'name'    => __( 'Reset User Logs' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_user_log' ,
                    'newids'  => 'rs_reset_user_log' ,
                    'class'   => 'rs_reset_user_log' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'name'    => __( 'Reset Master Logs' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_master_log' ,
                    'newids'  => 'rs_reset_master_log' ,
                    'class'   => 'rs_reset_master_log' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'name'    => __( 'Reset Meta for Previous Order(s)' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_previous_order' ,
                    'newids'  => 'rs_reset_previous_order' ,
                    'class'   => 'rs_reset_previous_order' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'name'    => __( 'Reset Referral Reward Table' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_referral_log_table' ,
                    'newids'  => 'rs_reset_referral_log_table' ,
                    'class'   => 'rs_reset_referral_log_table' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'name'    => __( 'Reset Manual Referral Link Settings' , 'rewardsystem' ) ,
                    'type'    => 'checkbox' ,
                    'id'      => 'rs_reset_manual_referral_link' ,
                    'newids'  => 'rs_reset_manual_referral_link' ,
                    'class'   => 'rs_reset_manual_referral_link' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                ) ,
                array (
                    'type' => 'reset_field' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_reset_setting' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Setting to Reset Plugin Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_reset_tab_setting'
                ) ,
                array (
                    'type' => 'reset_tab_settings' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_reset_tab_setting' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                    ) ) ;
        }

        /**
         * Registering Custom Field Admin Settings of SUMO Reward Points in woocommerce admin fields funtion
         */
        public static function reward_system_register_admin_settings() {

            woocommerce_admin_fields( RSReset::reward_system_admin_fields() ) ;
        }

        /**
         * Update the Settings on Save Changes may happen in SUMO Reward Points
         */
        public static function reward_system_update_settings() {
            woocommerce_update_options( RSReset::reward_system_admin_fields() ) ;
            if ( isset( $_POST[ 'rs_reset_module_checkbox' ] ) ) {
                update_option( 'rs_reset_activated' , $_POST[ 'rs_reset_module_checkbox' ] ) ;
            } else {
                update_option( 'rs_reset_activated' , 'no' ) ;
            }
        }

        public static function rs_function_to_enable_disable_reset_module() {
            $get_option_value = get_option( 'rs_reset_activated' ) ;
            $name_of_checkbox = 'rs_reset_module_checkbox' ;
            RSModulesTab::rs_common_function_to_get_checkbox( $get_option_value , $name_of_checkbox ) ;
        }

        public static function rs_select_user_to_reset_data() {
            $field_id    = "rs_reset_selected_user_data" ;
            $field_label = "Select Users to Reset Data" ;
            $getuser     = get_option( 'rs_reset_selected_user_data' ) ;
            echo rs_function_to_add_field_for_user_select( $field_id , $field_label , $getuser ) ;
        }

        public static function add_admin_field_to_reward_system() {
            global $woocommerce ;
            ?>
            <style type="text/css">
                p.sumo_reward_points {
                    display:none;
                }
                #mainforms {
                    display:none;
                }
            </style>
            <tr valign="top">
                <td>
                </td>
                <td>
                    <input type="button" class="button-primary" name="rs_reset_data_submit" id="rs_reset_data_submit" value="Reset Data" />
                    <img class="gif_rs_sumo_reward_button_for_reset" src="<?php echo WP_PLUGIN_URL ; ?>/rewardsystem/admin/images/update.gif" style="width:32px;height:32px;position:absolute"/><br>
                    <div class="rs_reset_success_data"></div>
                </td>
            </tr>
            </table>
            <?php
            if ( isset( $_GET[ 'page' ] ) == 'rewardsystem_callback' ) {
                if ( isset( $_GET[ 'tab' ] ) && isset( $_GET[ 'section' ] ) ) {
                    if ( $_GET[ 'section' ] == 'rewardsystem_reset' ) {
                        if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                            echo rs_common_chosen_function( '#rs_reset_selected_user_data' ) ;
                        } else {
                            if ( ( float ) $woocommerce->version > ( float ) ('2.2.0') && ( float ) $woocommerce->version < ( float ) ('3.0.0') ) {
                                echo rs_common_select_function( '#rs_reset_selected_user_data' ) ;
                            }
                        }
                    }
                }
            }
            echo rs_common_ajax_function_to_select_user( 'rs_reset_selected_user_data' ) ;
        }

        public static function process_reset_previous_order() {
            check_ajax_referer( 'reset-previous-order-meta' , 'sumo_security' ) ;

            if ( ! isset( $_POST ) || ! isset( $_POST[ 'ids' ] ) )
                throw new exception( __( 'Invalid Request' , 'rewardsystem' ) ) ;

            try {
                if ( $_POST[ 'ids' ] == 'done' )
                    wp_send_json_success( array ( 'content' => 'success' ) ) ;

                $order = $_POST[ 'ids' ] ;
                foreach ( $order as $order_id ) {
                    delete_post_meta( $order_id , 'reward_points_awarded' ) ;
                    delete_post_meta( $order_id , 'earning_point_once' ) ;
                }
            } catch ( Exception $e ) {
                wp_send_json_error( array ( 'error' => $e->getMessage() ) ) ;
            }
        }

        public static function process_reset_data_users() {
            check_ajax_referer( 'reset-data-for-user' , 'sumo_security' ) ;

            if ( ! isset( $_POST ) || ! isset( $_POST[ 'resetdatafor' ] ) )
                throw new exception( __( 'Invalid Request' , 'rewardsystem' ) ) ;

            try {
                global $wpdb ;
                $table_name  = $wpdb->prefix . 'rspointexpiry' ;
                $table_name2 = $wpdb->prefix . 'rsrecordpoints' ;
                $order_id    = array () ;

                if ( isset( $_POST[ 'resetpreviousorder' ] ) ) {
                    $resetpreviousorder = $_POST[ 'resetpreviousorder' ] ;
                    if ( $resetpreviousorder == '1' ) {
                        $args     = array ( 'post_type' => 'shop_order' , 'numberposts' => '-1' , 'meta_query' => array ( 'relation' => 'AND' , array ( 'key' => 'reward_points_awarded' , 'compare' => 'EXISTS' ) , array ( 'key' => 'earning_point_once' , 'compare' => 'EXISTS' ) ) , 'post_status' => 'published' , 'fields' => 'ids' , 'cache_results' => false ) ;
                        $order_id = get_posts( $args ) ;
                    }
                }

                if ( isset( $_POST[ 'rsresetuserpoints' ] ) ) {
                    $proceeduserrewardpoints = $_POST[ 'rsresetuserpoints' ] ;
                } else {
                    $proceeduserrewardpoints = '' ;
                }
                if ( isset( $_POST[ 'rsresetuserlogs' ] ) ) {
                    $proceeduserlogs = $_POST[ 'rsresetuserlogs' ] ;
                } else {
                    $proceeduserlogs = '' ;
                }
                if ( isset( $_POST[ 'rsresetmasterlogs' ] ) ) {
                    $proceedmasterlogs = $_POST[ 'rsresetmasterlogs' ] ;
                } else {
                    $proceedmasterlogs = "" ;
                }
                if ( isset( $_POST[ 'resetreferrallog' ] ) ) {
                    $proceedreferrallog = $_POST[ 'resetreferrallog' ] ;
                } else {
                    $proceedreferrallog = '' ;
                }
                if ( isset( $_POST[ 'resetmanualreferral' ] ) ) {
                    $Reset_manual_referral = $_POST[ 'resetmanualreferral' ] ;
                } else {
                    $Reset_manual_referral = '' ;
                }
                if ( $_POST[ 'resetdatafor' ] == '2' ) {   //Selected User                    
                    if ( isset( $_POST[ 'rsselectedusers' ] ) ) {
                        $newarray = $_POST[ 'rsselectedusers' ] ;
                        if ( ! is_array( $_POST[ 'rsselectedusers' ] ) ) {
                            $newarray = explode( ',' , $_POST[ 'rsselectedusers' ] ) ;
                        }
                        if ( is_array( $newarray ) && ! empty( $newarray ) ) {
                            foreach ( $newarray as $selecteduserid ) {
                                if ( $proceeduserrewardpoints == '1' ) {
                                    delete_user_meta( $selecteduserid , 'rs_earned_points_before_delete' ) ;
                                    delete_user_meta( $selecteduserid , 'rs_user_total_earned_points' ) ;
                                    delete_user_meta( $selecteduserid , 'rs_expired_points_before_delete' ) ;
                                    delete_user_meta( $selecteduserid , 'rs_redeem_points_before_delete' ) ;
                                    delete_user_meta( $selecteduserid , '_my_reward_points' ) ;
                                    $wpdb->query( "DELETE FROM $table_name WHERE userid = $selecteduserid" ) ;
                                }

                                if ( $proceeduserlogs == '1' ) {
                                    $wpdb->query( "UPDATE $table_name2 SET showuserlog = true WHERE userid = $selecteduserid" ) ;
                                    delete_user_meta( $selecteduserid , '_my_points_log' ) ;
                                }

                                if ( $proceedmasterlogs == '1' ) {
                                    $wpdb->query( "UPDATE $table_name2 SET showmasterlog = true WHERE userid  = $selecteduserid" ) ;
                                }

                                if ( $proceedreferrallog == '1' ) {
                                    $getdatas = get_option( 'rs_referral_log' ) ;

                                    if ( isset( $getdatas[ $selecteduserid ] ) ) {
                                        unset( $getdatas[ $selecteduserid ] ) ;
                                        update_option( 'rs_referral_log' , $getdatas ) ;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    //If not then All Users
                    $data_base_prefix = $wpdb->prefix ;
                    $users            = $data_base_prefix . 'users' ;
                    $get_var          = $wpdb->get_col( "SELECT ID FROM $users" ) ;
                    $user_ids         = implode( ',' , $get_var ) ;
                    $table_usermeta   = $data_base_prefix . 'usermeta' ;
                    if ( $proceeduserrewardpoints == '1' ) {
                        $wpdb->query( "DELETE FROM $table_name WHERE userid IN ($user_ids)" ) ;
                        $wpdb->query( "DELETE FROM $table_usermeta WHERE meta_key IN ('_my_reward_points','rs_earned_points_before_delete','rs_user_total_earned_points','rs_expired_points_before_delete','rs_redeem_points_before_delete') AND user_id IN ($user_ids)" ) ;
                    }
                    if ( $proceeduserlogs == '1' ) {
                        $wpdb->query( "UPDATE $table_name2 SET showuserlog = true WHERE userid IN ($user_ids)" ) ;
                        $wpdb->query( "DELETE FROM $table_usermeta WHERE meta_key IN ('_my_points_log') AND user_id IN ($user_ids)" ) ;
                    }
                    if ( $proceedmasterlogs == '1' ) {
                        $wpdb->query( "UPDATE $table_name2 SET showmasterlog = true WHERE userid IN ($user_ids)" ) ;
                        delete_option( 'rsoveralllog' ) ;
                    }
                    if ( $proceedreferrallog == '1' ) {
                        delete_option( 'rs_referral_log' , true ) ;
                    }
                    if ( $Reset_manual_referral == '1' ) {
                        delete_option( 'rewards_dynamic_rule_manual' , true ) ;
                    }
                }
                wp_send_json_success( array ( 'content' => $order_id ) ) ;
            } catch ( Exception $e ) {
                wp_send_json_error( array ( 'error' => $e->getMessage() ) ) ;
            }
        }

        public static function rs_field_to_reset_tab() {
            ?>
            <tr valign="top">
                <th class="titledesc" scope="row">                    
                    <label for="rs_reset_tab_label"><?php _e( 'Click the Button to Reset the Entire Plugin settings (Excluding Plugin Data)' , 'rewardsystem' ) ; ?></label>
                </th>
                <td>
                    <input type="submit" class="button-primary" name="rs_reset_tab" id="rs_reset_tab" value="Reset" />
                    <img class="gif_rs_reset_tab_settings" src="<?php echo WP_PLUGIN_URL ; ?>/rewardsystem/admin/images/update.gif" style="width:32px;height:32px;position:absolute"/><br>
                    <div class="rs_reset_tab_setting_success">
                    </div>
                </td>
            </tr>
            <?php
        }

        public static function reset_reward_system_admin_settings() {
            check_ajax_referer( 'rs-reset-tab' , 'sumo_security' ) ;

            if ( ! isset( $_POST ) || ! isset( $_POST[ 'dataclicked' ] ) )
                throw new exception( __( 'Invalid Request' , 'rewardsystem' ) ) ;

            try {
                foreach ( RSGeneralTabSetting::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                        update_option( 'rs_earn_point' , '1' ) ;
                        update_option( 'rs_earn_point_value' , '1' ) ;
                        update_option( 'rs_redeem_point' , '1' ) ;
                        update_option( 'rs_redeem_point_value' , '1' ) ;
                        update_option( 'rs_redeem_point_for_cash_back' , '1' ) ;
                        update_option( 'rs_redeem_point_value_for_cash_back' , '1' ) ;
                    }
                }

                foreach ( RSAddorRemovePoints::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSProductPurchaseModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSReferralSystemModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSRewardPointsForAction::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSPointExpiryModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSRedeemingModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSPointPriceModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSEmailModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSOfflineOnlineRewards::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSMessage::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSSocialReward::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSSms::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSCashbackModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSPointURL::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSGatewayModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSSendPointsModule::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSLocalization::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                foreach ( RSAdvancedSetting::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                delete_option( 'rewards_dynamic_rule_couponpoints' ) ;

                foreach ( RSNominee::reward_system_admin_fields() as $setting ) {
                    if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                        delete_option( $setting[ 'newids' ] ) ;
                        add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                    }
                }

                delete_option( 'rewards_dynamic_rule_manual' ) ;

                delete_transient( 'woocommerce_cache_excluded_uris' ) ;

                wp_send_json_success() ;
            } catch ( Exception $ex ) {
                wp_send_json_error( array ( 'error' => $e->getMessage() ) ) ;
            }
        }

    }

    RSReset::init() ;
}