<?php
/*
 * Gift Voucher Tab Setting
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
if (!class_exists('RSOfflineOnlineRewards')) {

    class RSOfflineOnlineRewards {

        public static function init() {

            add_filter('woocommerce_rs_settings_tabs_array', array(__CLASS__, 'reward_system_tab_settings')); // Register a New Tab in a WooCommerce Reward System Settings        

            add_action('woocommerce_rs_settings_tabs_rewardsystem_offline_online_rewards', array(__CLASS__, 'reward_system_register_admin_settings')); // Call to register the admin settings in the Reward System Submenu with general Settings tab        

            add_action('woocommerce_update_options_rewardsystem_modules_rewardsystem_offline_online_rewards', array(__CLASS__, 'reward_system_update_settings')); // call the woocommerce_update_options_{slugname} to update the reward system                               

            add_action('admin_init', array(__CLASS__, 'reward_system_default_settings'));

            add_action('woocommerce_admin_field_rs_offline_online_rewards_voucher_settings', array(__CLASS__, 'settings_for_voucher_code_offline_online_rewards'));

            add_action('woocommerce_admin_field_rs_offline_online_rewards_display_table_settings', array(__CLASS__, 'table_to_display_created_voucher_codes'));

            add_action('admin_head', array(__CLASS__, 'import_giftvoucher'));

            add_action('wp_ajax_rs_create_voucher_code', array(__CLASS__, 'process_ajax_to_create_voucher_code'));

            add_action('wp_ajax_rssplitvouchercode', array(__CLASS__, 'process_to_split_voucher_codes'));

            add_action('fp_action_to_reset_module_settings_rewardsystem_offline_online_rewards', array(__CLASS__, 'rs_function_to_reset_gift_voucher_tab'));

            add_action('woocommerce_admin_field_rs_enable_disable_gift_voucher_module', array(__CLASS__, 'rs_function_to_enable_disable_gift_voucher_module'));
        }

        /*
         * Function to Define Name of the Tab
         */

        public static function reward_system_tab_settings($setting_tabs) {
            if (!is_array($setting_tabs))
                $setting_tabs = (array) $setting_tabs;
            $setting_tabs['rewardsystem_offline_online_rewards'] = __('Gift Voucher Module', 'rewardsystem');
            return array_filter($setting_tabs);
        }

        /*
         * Function for Admin Settings
         * 
         */

        public static function reward_system_admin_fields() {

            return apply_filters('woocommerce_rewardsystem_offline_online_rewards_settings', array(
                array(
                    'type' => 'rs_modulecheck_start',
                ),
                array(
                    'name' => __('Gift Voucher Module', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_activate_gift_voucher_module'
                ),
                array(
                    'type' => 'rs_enable_disable_gift_voucher_module',
                ),
                array('type' => 'sectionend', 'id' => '_rs_activate_gift_voucher_module'),
                array(
                    'type' => 'rs_modulecheck_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Voucher Code Settings', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_voucher_code_settings'
                ),
                array(
                    'name' => __('Enable Voucher Code Settings', 'rewardsystem'),
                    'id' => 'rs_enable_voucher_code',
                    'std' => 'Enable',
                    'default' => 'Enable',
                    'newids' => 'rs_enable_voucher_code',
                    'type' => 'select',
                    'options' => array(
                        'Enable' => __('Enable', 'rewardsystem'),
                        'Disable' => __('Disable', 'rewardsystem'),
                    ),
                ),
                array(
                    'type' => 'rs_offline_online_rewards_voucher_settings',
                ),
                array('type' => 'sectionend', 'id' => '_rs_voucher_code_settings'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Gift Voucher Redeem Field Settings', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_my_account_voucher_table_settings'
                ),
                array(
                    'name' => __('Gift Voucher Field', 'rewardsystem'),
                    'id' => 'rs_show_hide_redeem_voucher',
                    'std' => '1',
                    'default' => '1',
                    'newids' => 'rs_show_hide_redeem_voucher',
                    'type' => 'select',
                    'options' => array(
                        '1' => __('Show', 'rewardsystem'),
                        '2' => __('Hide', 'rewardsystem'),
                    ),
                ),
                array(
                    'name' => __('Redeem your Gift Voucher Label', 'rewardsystem'),
                    'id' => 'rs_redeem_your_gift_voucher_label',
                    'std' => 'Redeem your Gift Voucher',
                    'default' => 'Redeem your Gift Voucher',
                    'newids' => 'rs_redeem_your_gift_voucher_label',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Redeem your Gift Voucher Field Placeholder', 'rewardsystem'),
                    'id' => 'rs_redeem_your_gift_voucher_placeholder',
                    'std' => 'Please enter your Reward Code',
                    'default' => 'Please enter your Reward Code',
                    'newids' => 'rs_redeem_your_gift_voucher_placeholder',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Redeem Gift Voucher Button Label', 'rewardsystem'),
                    'id' => 'rs_redeem_gift_voucher_button_label',
                    'std' => 'Redeem Gift Voucher',
                    'default' => 'Redeem Gift Voucher',
                    'newids' => 'rs_redeem_gift_voucher_button_label',
                    'type' => 'text',
                ),
                array(
                    'name' => __('Voucher Field Position', 'rewardsystem'),
                    'id' => 'rs_redeem_voucher_position',
                    'std' => '1',
                    'default' => '1',
                    'newids' => 'rs_redeem_voucher_position',
                    'type' => 'select',
                    'options' => array(
                        '1' => __('Before My Account', 'rewardsystem'),
                        '2' => __('After My Account', 'rewardsystem'),
                    ),
                ),
                array('type' => 'sectionend', 'id' => '_rs_my_account_voucher_table_settings'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Gift Voucher List', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_table'
                ),
                array(
                    'type' => 'rs_offline_online_rewards_display_table_settings',
                ),
                array('type' => 'sectionend', 'id' => '_rs_table'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Email Settings', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_voucher_email_settings'
                ),
                array(
                    'name' => __('Enable To Send Mail For Gift Voucher Reward Points', 'rewardsystem'),
                    'desc' => __('Enabling this option will send Gift Voucher Points through Mail', 'rewardsystem'),
                    'id' => 'rs_send_mail_gift_voucher',
                    'type' => 'checkbox',
                    'std' => 'no',
                    'default' => 'no',
                    'newids' => 'rs_send_mail_gift_voucher',
                ),
                array(
                    'name' => __('Email Subject For Gift Voucher Points', 'rewardsystem'),
                    'id' => 'rs_email_subject_gift_voucher',
                    'std' => 'Gift Voucher - Notification',
                    'default' => 'Gift Voucher - Notification',
                    'type' => 'textarea',
                    'newids' => 'rs_email_subject_gift_voucher',
                ),
                array(
                    'name' => __('Email Message For Gift Voucher Points', 'rewardsystem'),
                    'id' => 'rs_email_message_gift_voucher',
                    'std' => 'You have earned [rs_earned_points] points and currently you have [rs_available_points] in your account',
                    'default' => 'You have earned [rs_earned_points] points and currently you have [rs_available_points] in your account',
                    'type' => 'textarea',
                    'newids' => 'rs_email_message_gift_voucher',
                ),
                array('type' => 'sectionend', 'id' => '_rs_voucher_email_settings'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Gift Voucher Message Settings', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_gift_voucher_message_settings',
                ),
                array(
                    'name' => __('Error Message displayed when a Gift Voucher field is left empty', 'rewardsystem'),
                    'desc' => __('Enter the Message which will be displayed when Redeem Voucher Button is clicked without entering the voucher code ', 'rewardsystem'),
                    'id' => 'rs_voucher_redeem_empty_error',
                    'std' => 'Please Enter your Voucher Code',
                    'default' => 'Please Enter your Voucher Code',
                    'type' => 'text',
                    'newids' => 'rs_voucher_redeem_empty_error',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Success Message displayed when a Gift Voucher is Redeemed', 'rewardsystem'),
                    'desc' => __('Enter the Message which will be displayed when the Gift Voucher has been Successfully Redeemed', 'rewardsystem'),
                    'id' => 'rs_voucher_redeem_success_message',
                    'std' => '[giftvoucherpoints] Reward points has been added to your Account',
                    'default' => '[giftvoucherpoints] Reward points has been added to your Account',
                    'type' => 'text',
                    'newids' => 'rs_voucher_redeem_success_message',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Error Message displayed when a User tries to Redeem Expired Voucher Code', 'rewardsystem'),
                    'desc' => __('Enter the Message which will be displayed when the Gift Voucher has been Successfully Redeemed', 'rewardsystem'),
                    'id' => 'rs_voucher_code_expired_error_message',
                    'std' => 'Voucher has been Expired',
                    'default' => 'Voucher has been Expired',
                    'type' => 'text',
                    'newids' => 'rs_voucher_code_expired_error_message',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Error Message displayed when a User tries to Redeem an Invalid Voucher Code', 'rewardsystem'),
                    'desc' => __('Enter the Message which will be displayed when a Invalid Voucher is used for Redeeming', 'rewardsystem'),
                    'id' => 'rs_invalid_voucher_code_error_message',
                    'std' => 'Sorry, Voucher not found in list',
                    'default' => 'Sorry, Voucher not found in list',
                    'type' => 'text',
                    'newids' => 'rs_invalid_voucher_code_error_message',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Login Link Label for Guests', 'rewardsystem'),
                    'desc' => __('Please Enter Login link for Guest Label', 'rewardsystem'),
                    'id' => 'rs_redeem_voucher_login_link_label',
                    'css' => 'min-width:200px;',
                    'std' => 'Login',
                    'default' => 'Login',
                    'type' => 'text',
                    'newids' => 'rs_redeem_voucher_login_link_label',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Message displayed for Guests', 'rewardsystem'),
                    'desc' => __('Enter the Message which will be displayed for Guest when Gift Voucher Shortcode is used', 'rewardsystem'),
                    'id' => 'rs_voucher_redeem_guest_error_message',
                    'std' => 'Please [rs_login_link] to View this Page',
                    'default' => 'Please [rs_login_link] to View this Page',
                    'type' => 'text',
                    'newids' => 'rs_voucher_redeem_guest_error_message',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Error Message displayed when a User tries to Redeem a used Voucher Code', 'rewardsystem'),
                    'desc' => __('Enter the Message that will be displayed when User tries to Redeem a Voucher code that has already been Used', 'rewardsystem'),
                    'id' => 'rs_voucher_code_used_error_message',
                    'css' => 'min-width:200px;',
                    'std' => 'Voucher has been used',
                    'default' => 'Voucher has been used',
                    'type' => 'text',
                    'newids' => 'rs_voucher_code_used_error_message',
                    'desc_tip' => true,
                ),
                array(
                    'name' => __('Message displayed for Banned Users', 'rewardsystem'),
                    'desc' => __('Enter the Message that will be displayed when a Banned User tries to Redeem the Gift Voucher', 'rewardsystem'),
                    'id' => 'rs_banned_user_redeem_voucher_error',
                    'std' => 'You have Earned 0 Points',
                    'default' => 'You have Earned 0 Points',
                    'type' => 'textarea',
                    'newids' => 'rs_banned_user_redeem_voucher_error',
                    'desc_tip' => true,
                ),
                array('type' => 'sectionend', 'id' => '_rs_gift_voucher_message_settings'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Voucher Code Form Customization', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_offline_to_online_form_customize_settings'
                ),
                array(
                    'name' => __('Voucher Code field Label', 'rewardsystem'),
                    'id' => 'rs_reward_code_field_caption',
                    'std' => 'Enter your Voucher Code below to Claim',
                    'default' => 'Enter your Voucher Code below to Claim',
                    'type' => 'text',
                    'newids' => 'rs_reward_code_field_caption',
                ),
                array(
                    'name' => __('Placeholder for Voucher Code Field', 'rewardsystem'),
                    'id' => 'rs_reward_code_field_placeholder',
                    'std' => 'Voucher Code',
                    'default' => 'Voucher Code',
                    'type' => 'text',
                    'newids' => 'rs_reward_code_field_placeholder',
                ),
                array(
                    'name' => __('Submit Button Field Caption', 'rewardsystem'),
                    'id' => 'rs_reward_code_submit_field_caption',
                    'std' => 'Submit',
                    'type' => 'text',
                    'newids' => 'rs_reward_code_submit_field_caption',
                ),
                array('type' => 'sectionend', 'id' => '_rs_offline_to_online_form_customize_settings'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Current Balance Message Customization', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_current_balance_shortcode_customization'
                ),
                array(
                    'name' => __('Current Available Points Label', 'rewardsystem'),
                    'id' => 'rs_current_available_balance_caption',
                    'std' => 'Current Balance:',
                    'default' => 'Current Balance:',
                    'type' => 'text',
                    'newids' => 'rs_current_available_balance_caption',
                ),
                array('type' => 'sectionend', 'id' => '_rs_current_balance_shortcode_customization'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Extra Class Name for Button', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_myaccount_custom_class_name',
                ),
                array(
                    'name' => __('Extra Class Name for Redeem Gift Voucher Button', 'rewardsystem'),
                    'desc' => __('Add Extra Class Name to the My Account Redeem Gift Voucher Button, Don\'t Enter dot(.) before Class Name', 'rewardsystem'),
                    'id' => 'rs_extra_class_name_redeem_gift_voucher_button',
                    'std' => '',
                    'default' => '',
                    'type' => 'text',
                    'newids' => 'rs_extra_class_name_redeem_gift_voucher_button',
                    'desc_tip' => true,
                ),
                array('type' => 'sectionend', 'id' => '_rs_myaccount_custom_class_name'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
                array(
                    'type' => 'rs_wrapper_start',
                ),
                array(
                    'name' => __('Shortcode used in Gift Vocuher', 'rewardsystem'),
                    'type' => 'title',
                    'id' => 'rs_shortcode_for_gift_voucher'
                ),
                array(
                    'type' => 'title',
                    'desc' => '<b>[giftvoucherpoints]</b> - To display points earned for using voucher code<br><br>'
                    . '<b>[rs_login_link]</b> - To display login link for guests',
                ),
                array('type' => 'sectionend', 'id' => 'rs_shortcode_for_gift_voucher'),
                array(
                    'type' => 'rs_wrapper_end',
                ),
            ));
        }

        /*
         * Register  the Admin Field Settings
         * 
         */

        public static function reward_system_register_admin_settings() {

            woocommerce_admin_fields(RSOfflineOnlineRewards::reward_system_admin_fields());
        }

        /*
         * Update Settings for Offline Online Rewards tab    
         * 
         */

        public static function reward_system_update_settings() {
            woocommerce_update_options(RSOfflineOnlineRewards::reward_system_admin_fields());
            if (isset($_POST['rs_gift_voucher_module_checkbox'])) {
                update_option('rs_gift_voucher_activated', $_POST['rs_gift_voucher_module_checkbox']);
            } else {
                update_option('rs_gift_voucher_activated', 'no');
            }
            if (isset($_POST['rs_reward_code_type'])) {
                update_option('rs_reward_code_type', $_POST['rs_reward_code_type']);
            } else {
                update_option('rs_reward_code_type', '');
            }

            if (isset($_POST['rs_enable_voucher_code'])) {
                update_option('rs_enable_voucher_code', $_POST['rs_enable_voucher_code']);
            } else {
                update_option('rs_enable_voucher_code', '');
            }
        }

        /**
         * Initialize the Default Settings by looping this function
         */
        public static function reward_system_default_settings() {
            global $woocommerce;
            foreach (RSOfflineOnlineRewards::reward_system_admin_fields() as $setting)
                if (isset($setting['newids']) && isset($setting['std'])) {
                    add_option($setting['newids'], $setting['std']);
                }
        }

        public static function rs_function_to_enable_disable_gift_voucher_module() {
            $get_option_value = get_option('rs_gift_voucher_activated');
            $name_of_checkbox = 'rs_gift_voucher_module_checkbox';
            RSModulesTab::rs_common_function_to_get_checkbox($get_option_value, $name_of_checkbox);
        }

        public static function settings_for_voucher_code_offline_online_rewards() {
            $security = rs_function_to_create_security();
            $isadmin = is_admin() ? 'yes' : 'no';
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Prefix/Suffix', 'rewardsystem'); ?></label>
                    </th>
                    <td class="forminp forminp-select">
                        <input type="checkbox" id="rs_enable_prefix" name="rs_enable_prefix_offline_online_rewards" class="rs_enable_prefix_offline_online_rewards"><span><?php _e('Prefix', 'rewardsystem'); ?></span>
                        <input type="text" name="rs_voucher_prefix_offline_online" class="rs_voucher_prefix_offline_online" />
                        <span class="rs_voucher_code_creation_error_for_prefix"></span><br><br>
                        <input type="checkbox" name="rs_enable_suffix_offline_online_rewards" class="rs_enable_suffix_offline_online_rewards"><span><?php _e('Suffix', 'rewardsystem'); ?></span>
                        <input type="text" name="rs_voucher_suffix_offline_online" class="rs_voucher_suffix_offline_online" />
                        <span class="rs_voucher_code_creation_error_for_suffix"></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Voucher Code Type', 'rewardsystem'); ?></label><br/><br/>
                    </th>
                    <td class="forminp forminp-select">
                        <select name="rs_reward_code_type" id="rs_reward_code_type">
                            <option value="numeric"><?php _e('Numeric', 'rewardsystem'); ?></option>
                            <option value="alphanumeric"><?php _e('Alphanumeric', 'rewardsystem'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label class="rs_exclude_characters_code_generation_label"><?php _e('Excluded Alphabets from Voucher Code creation', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="text" id="rs_alphabets_from_voucher_code_creation" name="rs_exclude_characters_code_generation" class="rs_exclude_characters_code_generation" />
                        <label class="exclude_caption">Alphabets are comma separated(For eg: i,l,o)</label>
                    </td>
                </tr>            
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Voucher Code Length', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="number" id="rs_voucher_code_length" step="1" min="0" name="rs_voucher_code_length_offline_online" class="rs_voucher_code_length_offline_online" />
                        <span class="rs_voucher_code_creation_error_for_character"></span>
                    </td>
                </tr>            
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Reward Points per Voucher Code', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="number" id="rs_per_voucher_code" step="any" min="0" name="rs_voucher_code_points_value_offline_online" class="rs_voucher_code_points_value_offline_online" />
                        <span class="rs_voucher_code_creation_error_for_rpv"></span>
                    </td>
                </tr>            
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Number of Voucher Codes to generate', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="number" id="rs_voucher_code_to_generate"step="any" min="0" name="rs_voucher_code_count_offline_online" class="rs_voucher_code_count_offline_online" />
                        <span class="rs_voucher_code_creation_error_for_noofrc"></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Voucher Code Used by', 'rewardsystem'); ?></label><br/><br/>
                    </th>
                    <td class="forminp forminp-select">
                        <select name="rs_voucher_code_user_for" id="rs_voucher_code_user_for">
                            <option value="1"><?php _e('Single User', 'rewardsystem'); ?></option>
                            <option value="2"><?php _e('Multiple Users', 'rewardsystem'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Voucher Code Usage Limit', 'rewardsystem'); ?></label><br/><br/>
                    </th>
                    <td class="forminp forminp-select">
                        <select name="rs_voucher_code_usage_limit" id="rs_voucher_code_usage_limit">
                            <option value="1"><?php _e('Limited', 'rewardsystem'); ?></option>
                            <option value="2"><?php _e('Unlimited', 'rewardsystem'); ?></option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Number of Users to restrict the usage of Voucher Code', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="number" step="1" min="0" name="rs_voucher_code_usage_limit_value" id="rs_voucher_code_usage_limit_value" class="rs_voucher_code_usage_limit_value" />
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label><?php _e('Expiry Date of Voucher Code(s)', 'rewardsystem'); ?></label>                    
                    </th>
                    <td class="forminp forminp-select">
                        <input type="text" class="rs_gift_voucher_expiry" value="" name="rs_gift_voucher_expiry" id="rs_gift_voucher_expiry" />
                        <span class="rs_voucher_code_creation_error_for_expdate"></span>
                    </td>
                </tr>
                <tr valign="top">
                    <td class="forminp forminp-select">
                        <div id="dialog1" hidden="hidden" ></div>
                        <button id="rs_create_Voucher_Codes"class="button-primary rs_create_voucher_codes_offline_online rs_voucher_codes_btn" ><?php _e('Create Voucher Codes', 'rewardsystem'); ?></button>            
                        <span class="preloader_image_online_offline_rewards"><img src="<?php echo WP_PLUGIN_URL; ?>/rewardsystem/admin/images/update.gif" style="width:32px;height:32px; position: absolute;"/></span>
                    </td>
                </tr>
            </table>            
            <style type="text/css">
                .rs_voucher_code_creation_error_for_character{
                    font-size: 16px;
                    color: red;
                }
                .rs_voucher_code_creation_error_for_rpv{
                    font-size: 16px;
                    color: red;
                }

                .rs_voucher_code_creation_error_for_noofrc{
                    font-size: 16px;
                    color: red;
                }

                .rs_voucher_code_creation_error_for_expdate{
                    font-size: 16px;
                    color: red;
                }

                .rs_voucher_code_creation_error_for_prefix{
                    font-size: 16px;
                    color: red;
                }

                .rs_voucher_code_creation_error_for_suffix{
                    font-size: 16px;
                    color: red;
                }
            </style>    
            <link rel="stylesheet" href="//code.jquery.com/ui/1.12.0/themes/base/jquery-ui.css">
            <script src="https://code.jquery.com/ui/1.12.0/jquery-ui.js"></script>
            <script type="text/javascript">
                jQuery(document).ready(function () {
                    jQuery('#rs_gift_voucher_expiry').datepicker({dateFormat: 'yy-mm-dd', minDate: 0});
                    jQuery('.preloader_image_online_offline_rewards').css("display", "none");
                    jQuery('.rs_create_voucher_codes_offline_online').click(function () {
                        var prefix_enabled_value = jQuery('.rs_enable_prefix_offline_online_rewards').is(":checked") ? 'yes' : 'no';
                        var prefix_content = jQuery('.rs_voucher_prefix_offline_online').val();
                        var suffix_enabled_value = jQuery('.rs_enable_suffix_offline_online_rewards').is(":checked") ? 'yes' : 'no';
                        var sufffix_content = jQuery('.rs_voucher_suffix_offline_online').val();
                        var reward_code_type = jQuery('#rs_reward_code_type').val();
                        var exclude_content_code = jQuery('.rs_exclude_characters_code_generation').val();
                        var length_of_voucher_code = jQuery('.rs_voucher_code_length_offline_online').val();
                        var points_value_of_voucher_code = jQuery('.rs_voucher_code_points_value_offline_online').val();
                        var number_of_vouchers_to_be_created = jQuery('.rs_voucher_code_count_offline_online').val();
                        var gift_expired_date = jQuery('#rs_gift_voucher_expiry').val();
                        var voucher_code_for = jQuery('#rs_voucher_code_user_for').val();
                        var voucher_code_usage_limit = jQuery('#rs_voucher_code_usage_limit').val();
                        var voucher_code_usage_limit_value = jQuery('#rs_voucher_code_usage_limit_value').val();
                        jQuery(this).attr('data-clicked', '1');
                        var dataclicked = jQuery(this).attr('data-clicked');
                        var dataparam = ({
                            action: 'rs_create_voucher_code',
                            proceedanyway: dataclicked,
                            prefix_enabled_value: prefix_enabled_value,
                            prefix_content: prefix_content,
                            suffix_enabled_value: suffix_enabled_value,
                            number_of_vouchers_to_be_created: number_of_vouchers_to_be_created,
                            sufffix_content: sufffix_content,
                            reward_code_type: reward_code_type,
                            length_of_voucher_code: length_of_voucher_code,
                            points_value_of_voucher_code: points_value_of_voucher_code,
                            exclude_content_code: exclude_content_code,
                            vouchercreated: '<?php echo date('Y-m-d'); ?>',
                            gift_expired_date: gift_expired_date,
                            security: "<?php echo $security; ?>",
                            state: "<?php echo $isadmin; ?>"
                        });
                        if (prefix_enabled_value === 'yes' && suffix_enabled_value === 'yes') {
                            if (prefix_content === '') {
                                jQuery('.rs_voucher_code_creation_error_for_prefix').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_prefix').html('<?php _e('Prefix value Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_prefix').fadeOut(5000);
                                return false;
                            }

                            if (sufffix_content === '') {
                                jQuery('.rs_voucher_code_creation_error_for_suffix').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_suffix').html('<?php _e('Suffix value Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_suffix').fadeOut(5000);
                                return false;
                            }
                            if (length_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_character').html('<?php _e('Number of Characters for Voucher Code Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeOut(5000);
                                return false;
                            }
                            if (points_value_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_rpv').html('<?php _e('Reward Points Value per Voucher Code Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeOut(5000);
                                return false;
                            }
                            if (number_of_vouchers_to_be_created === '') {
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').html('<?php _e('Number of Voucher Codes to be Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeOut(5000);
                                return false;
                            }
                        } else if (prefix_enabled_value != 'yes' && suffix_enabled_value != 'yes') {
                            if (length_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_character').html('<?php _e('Number of Characters for Voucher Code Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeOut(5000);
                                return false;
                            }
                            if (points_value_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_rpv').html('<?php _e('Reward Points Value per Voucher Code Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeOut(5000);
                                return false;
                            }
                            if (number_of_vouchers_to_be_created === '') {
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').html('<?php _e('Number of Voucher Codes to be Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeOut(5000);
                                return false;
                            }
                        } else if (prefix_enabled_value == 'yes' && suffix_enabled_value != 'yes') {
                            if (prefix_content == '') {
                                jQuery('.rs_voucher_code_creation_error_for_prefix').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_prefix').html('<?php _e('Prefix value Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_prefix').fadeOut(5000);
                                return false;
                            }
                            if (length_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_character').html('<?php _e('Number of Characters for Voucher Code Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeOut(5000);
                                return false;
                            }
                            if (points_value_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_rpv').html('<?php _e('Reward Points Value per Voucher Code Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeOut(5000);
                                return false;
                            }
                            if (number_of_vouchers_to_be_created === '') {
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').html('<?php _e('Number of Voucher Codes to be Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeOut(5000);
                                return false;
                            }
                        } else if (prefix_enabled_value != 'yes' && suffix_enabled_value == 'yes') {
                            if (sufffix_content == '') {
                                jQuery('.rs_voucher_code_creation_error_for_suffix').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_suffix').html('<?php _e('Suffix value Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_suffix').fadeOut(5000);
                                return false;
                            }
                            if (length_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_character').html('<?php _e('Number of Characters for Voucher Code Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_character').fadeOut(5000);
                                return false;
                            }
                            if (points_value_of_voucher_code === '') {
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_rpv').html('<?php _e('Reward Points Value per Voucher Code Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_rpv').fadeOut(5000);
                                return false;
                            }
                            if (number_of_vouchers_to_be_created === '') {
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeIn();
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').html('<?php _e('Number of Voucher Codes to be Generated Should not be Empty', 'rewardsystem'); ?>');
                                jQuery('.rs_voucher_code_creation_error_for_noofrc').fadeOut(5000);
                                return false;
                            }
                        }
                        jQuery('.preloader_image_online_offline_rewards').css("display", "inline");
                        function getvouchercountofflinerewards(id) {
                            return jQuery.ajax({
                                type: 'POST',
                                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                                data: ({
                                    action: 'rssplitvouchercode',
                                    ids: id,
                                    prefix_enabled_value: prefix_enabled_value,
                                    prefix_content: prefix_content,
                                    suffix_enabled_value: suffix_enabled_value,
                                    number_of_vouchers_to_be_created: number_of_vouchers_to_be_created,
                                    sufffix_content: sufffix_content,
                                    reward_code_type: reward_code_type,
                                    length_of_voucher_code: length_of_voucher_code,
                                    points_value_of_voucher_code: points_value_of_voucher_code,
                                    exclude_content_code: exclude_content_code,
                                    vouchercreated: '<?php echo date('Y-m-d'); ?>',
                                    gift_expired_date: gift_expired_date,
                                    security: "<?php echo $security; ?>",
                                    voucher_code_for: voucher_code_for,
                                    voucher_code_usage_limit: voucher_code_usage_limit,
                                    voucher_code_usage_limit_value: voucher_code_usage_limit_value,
                                    state: "<?php echo $isadmin; ?>"
                                }),
                                success: function (response) {
                                    console.log(response);
                                },
                                dataType: 'json',
                                async: false
                            });

                        }
                        jQuery.post("<?php echo admin_url('admin-ajax.php'); ?>", dataparam,
                                function (response) {
                                    console.log(response);
                                    if (response != 'sucess') {
                                        var j = 1;
                                        var i, j, temparray, chunk = 10;
                                        for (i = 0, j = response.length; i < j; i += chunk) {
                                            temparray = response.slice(i, i + chunk);
                                            getvouchercountofflinerewards(temparray);
                                        }
                                        jQuery.when(getvouchercountofflinerewards()).done(function (a1) {
                                            var uniquekey = [];
                                            jQuery.each(response, function (i, el) {
                                                if (jQuery.inArray(el, uniquekey) === -1) {
                                                    uniquekey.push(el);
                                                }
                                            });
                                            if (number_of_vouchers_to_be_created > uniquekey.length + 1) {
                                                jQuery("#dialog1").dialog({
                                                    buttons: [
                                                        {
                                                            text: "Ok",
                                                            icons: {
                                                                primary: "ui-icon-heart"
                                                            },
                                                            click: function () {
                                                                jQuery(this).dialog("close");
                                                                location.reload();
                                                            }

                                                        }
                                                    ]

                                                });
                                                jQuery('div#dialog1').on('dialogclose', function () {
                                                    location.reload();
                                                });
                                                jQuery("#dialog1").html(+uniquekey.length + 'Unique code is Generated Please Increase number of Character to Create More Voucher');
                                            } else {
                                                location.reload();
                                            }
                                            jQuery('.rs_voucher_prefix_offline_online').val('');
                                            jQuery('.rs_voucher_suffix_offline_online').val('');
                                            jQuery('#rs_reward_code_type').val('');
                                            jQuery('.rs_exclude_characters_code_generation').val('');
                                            jQuery('.rs_voucher_code_length_offline_online').val('');
                                            jQuery('.rs_voucher_code_points_value_offline_online').val('');
                                            jQuery('.rs_voucher_code_count_offline_online').val('');
                                            jQuery('#rs_gift_voucher_expiry').val('');
                                            console.log('Ajax Done Successfully');
                                            jQuery('.preloader_image_online_offline_rewards').css("display", "none");
                                        });
                                    }
                                }, 'json');
                        return false;
                    });
                });
            </script>    
            <?php
        }

        public static function table_to_display_created_voucher_codes() {
            ?>
            <style type="text/css">
                .rs_reward_code_vouchers_click {
                    border: 2px solid #a1a1a1;
                    padding: 3px 9px;
                    background: #dddddd;
                    width: 5px;
                    border-radius: 25px;
                }

                .rs_reward_code_vouchers_click:hover {
                    cursor: pointer;
                    background:red;
                    color:#fff;
                    border: 2px solid #fff;
                }
            </style>
            <table class="form-table">
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="rs_import_gift_voucher_csv"><?php _e('Export Voucher Codes as CSV', 'rewardsystem'); ?></label>
                    </th>
                    <td class="forminp forminp-select">
                        <input type="submit" id="rs_export_reward_codes_csv" class="rs_export_button" name="rs_export_reward_codes_csv" value="Export Voucher Codes"/>
                    </td>

                </tr>

                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="rs_import_gift_voucher_csv"><?php _e('Import Gift Voucher to CSV', 'rewardsystem'); ?></label>
                    </th>
                    <td class="forminp forminp-select">
                        <input type="file" id="rs_import_gift_voucher_csv" name="file" />
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="rs_voucher_code_import_type"><?php _e('If Voucher Code already exists', 'rewardsystem'); ?></label>
                    </th>
                    <td class="forminp forminp-select">                
                        <select id ="rs_voucher_code_import_type" class="rs_voucher_code_import_type" name="rs_voucher_code_import_type">
                            <option value="1"><?php _e('Ignore Voucher Code', 'rewardsystem'); ?>  </option>
                            <option value="2"><?php _e('Replace Voucher Code', 'rewardsystem'); ?>  </option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <td class="forminp forminp-select">
                        <input type="submit" id="rs_import_reward_codes_csv_from_old" class="rs_export_button" name="rs_import_reward_codes_csv_from_old" value="Import Voucher Codes as CSV "/>
                    </td>

                </tr>            
            </table>
            <?php
            if (isset($_POST['rs_export_reward_codes_csv'])) {
                global $wpdb;
                $table_name = $wpdb->prefix . 'rsgiftvoucher';
                $each_reward_code = $wpdb->get_results("SELECT * FROM $table_name ", ARRAY_A);
                foreach ($each_reward_code as $code_info) {
                    $voucher_code = $code_info['vouchercode'];
                    $voucher_amount = $code_info['points'];
                    $voucher_created_date = $code_info['vouchercreated'];
                    if ($code_info['memberused'] != '') {
                        $memberused = unserialize($code_info['memberused']);
                        $array = array();
                        foreach ($memberused as $userid) {
                            $userinfo = get_userdata($userid);
                            $usernames = $userinfo->user_login;
                            $array[] = $usernames;
                        }
                        $voucher_used_count = implode(',', $array);
                    } else {
                        $voucher_used_count = '';
                    }
                    if ($code_info['voucherexpiry'] != '') {
                        $voucher_expired_date = $code_info['voucherexpiry'];
                    } else {
                        $voucher_expired_date = 'Never';
                    }
                    $voucher_info_array[] = array($voucher_code, $voucher_amount, $voucher_created_date, $voucher_expired_date, $voucher_used_count);
                }
                ob_end_clean();
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=list_of_reward_codes" . date("Y-m-d") . ".csv");
                header("Pragma: no-cache");
                header("Expires: 0");
                RSMasterLog::outputCSV($voucher_info_array);
                exit();
            }
            if (isset($_GET['vouchercode'])) {
                $newwp_list_table_for_users = new WP_List_Table_for_View_Gift_Voucher();
                $newwp_list_table_for_users->prepare_items();
                $newwp_list_table_for_users->search_box('Search', 'search_id');
                $newwp_list_table_for_users->display();
            } else {
                $newwp_list_table_for_users = new WP_List_Table_for_NewGiftVoucher();
                $newwp_list_table_for_users->prepare_items();
                $newwp_list_table_for_users->search_box('Search', 'search_id');
                $newwp_list_table_for_users->display();
            }
        }

        public static function import_giftvoucher() {
            global $wpdb;
            $table_name = $wpdb->prefix . 'rsgiftvoucher';
            $get_gift_voucher = '';
            $get_option = get_option('once_create_gift');
            if ($get_option != '2') {
                $get_gift_voucher = get_option('rsvoucherlists');
                if (is_array($get_gift_voucher)) {
                    if (!empty($get_gift_voucher)) {
                        foreach ($get_gift_voucher as $array) {
                            foreach ($array as $variable1) {
                                if ($variable1['voucherexpiry'] != '') {
                                    $voucherexpiry = $variable1['voucherexpiry'];
                                } else {
                                    $voucherexpiry = '';
                                }
                                if ($variable1['memberused'] != '') {
                                    $username = $variable1['memberused'];
                                } else {
                                    $username = '';
                                }
                                $newupdates[$variable1['vouchercode']] = array(
                                    $variable1['vouchercode'] => array('points' => $variable1['points'], 'vouchercode' => $variable1['vouchercode'], 'vouchercreated' => $variable1['vouchercreated'], 'voucherexpiry' => $voucherexpiry, 'memberused' => $username)
                                );
                            }
                        }
                        $array3 = array_merge((array) get_option('rs_list_of_gift_vouchers_created'), $newupdates);
                        $array3 = array_map("unserialize", array_unique(array_map("serialize", $array3)));
                        update_option('rs_list_of_gift_vouchers_created', array_filter($array3));
                        update_option('once_create_gift', '2');
                    }
                }
            }
            $get_gift_voucher = get_option('rs_list_of_gift_vouchers_created');
            if (is_array($get_gift_voucher)) {
                foreach ($get_gift_voucher as $array) {
                    foreach ($array as $variable1) {
                        if ($variable1['voucherexpiry'] != '') {
                            $voucherexpiry = $variable1['voucherexpiry'];
                        } else {
                            $voucherexpiry = '';
                        }
                        if ($variable1['memberused'] != '') {
                            $username = $variable1['memberused'];
                        } else {
                            $username = '';
                        }
                        $wpdb->insert(
                                $table_name, array(
                            'points' => $variable1['points'],
                            'vouchercode' => $variable1['vouchercode'],
                            'vouchercreated' => $variable1['vouchercreated'],
                            'voucherexpiry' => $voucherexpiry,
                            'memberused' => $username)
                        );
                    }
                }
            }
            delete_option('rs_list_of_gift_vouchers_created');
            if (isset($_POST['rs_import_reward_codes_csv_from_old'])) {
                if (isset($_POST['rs_voucher_code_import_type'])) {
                    if ($_POST['rs_voucher_code_import_type'] == '1') {
                        if ($_FILES["file"]["error"] > 0) {
                            echo "Error: " . $_FILES["file"]["error"] . "<br>";
                        } else {
                            $mimes = array('text/csv',
                                'text/plain',
                                'application/csv',
                                'text/comma-separated-values',
                                'application/excel',
                                'application/vnd.ms-excel',
                                'application/vnd.msexcel',
                                'text/anytext',
                                'application/octet-stream',
                                'application/txt');
                            if (in_array($_FILES['file']['type'], $mimes)) {
                                self::inputCSVforIgnore($_FILES["file"]["tmp_name"]);
                            } else {
                                ?>
                                <style type="text/css">
                                    div.error {
                                        display:block;
                                    }
                                </style>
                                <?php
                            }
                        }
                        $myurl = get_permalink();
                    } else {
                        if ($_POST['rs_voucher_code_import_type'] == '2') {
                            if ($_FILES["file"]["error"] > 0) {
                                echo "Error: " . $_FILES["file"]["error"] . "<br>";
                            } else {
                                $mimes = array('text/csv',
                                    'text/plain',
                                    'application/csv',
                                    'text/comma-separated-values',
                                    'application/excel',
                                    'application/vnd.ms-excel',
                                    'application/vnd.msexcel',
                                    'text/anytext',
                                    'application/octet-stream',
                                    'application/txt');
                                if (in_array($_FILES['file']['type'], $mimes)) {
                                    self::inputCSVforReplace($_FILES["file"]["tmp_name"]);
                                } else {
                                    ?>
                                    <style type="text/css">
                                        div.error {
                                            display:block;
                                        }
                                    </style>
                                    <?php
                                }
                            }
                            $myurl = get_permalink();
                        }
                    }
                }
            }
        }

        public static function inputCSVforReplace($data_path) {
            global $wpdb;
            $row = 1;
            if (($handle = fopen($data_path, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $row++;
                    $datas = strtotime($data[2]);
                    $datass = isset($data[2]) ? $datas : 999999999999;
                    if ($data[3] != 'Never') {
                        if ($data[3] != '') {
                            $datasss = strtotime($data[3]);
                        } else {
                            $datasss = '';
                        }
                    } else {
                        $datasss = '';
                    }
                    $expired = $datasss;
                    $usedby = isset($data[4]) ? $data[4] : '';

                    $collection[] = array($data[0], $data[1], $datass, $expired, $usedby);
                }
                $table_name = $wpdb->prefix . "rsgiftvoucher";
                foreach ($collection as $variable1) {
                    if ($variable1[0] != '') {
                        $create_date = date_i18n('Y-m-d', $variable1[2]);
                        if (isset($variable1[3])) {
                            if ($variable1[3] != '') {
                                $expired_date = date_i18n('Y-m-d', $variable1[3]);
                            } else {
                                $expired_date = '';
                            }
                        } else {
                            $expired_date = '';
                        }
                        if ($variable1[4] != 'Notyet') {
                            if ($variable1[4] != '') {
                                $array = array();
                                $memberused = explode(',', $variable1[4]);
                                foreach ($memberused as $userid) {
                                    $userinfo = get_user_by('login', $userid);
                                    $usernames = $userinfo->ID;
                                    $array[] = $usernames;
                                }
                                $user = serialize($array);
                            } else {
                                $user = '';
                            }
                        } else {
                            $user = '';
                        }
                        $voucher_codes = $wpdb->get_col("SELECT vouchercode FROM $table_name");
                        if (!in_array($variable1[0], $voucher_codes)) {
                            $wpdb->insert(
                                    $table_name, array(
                                'points' => $variable1[1],
                                'vouchercode' => $variable1[0],
                                'vouchercreated' => $create_date,
                                'voucherexpiry' => $expired_date,
                                'memberused' => $user)
                            );
                        } else {
                            $query = $wpdb->get_row("SELECT * FROM $table_name WHERE vouchercode = '$variable1[0]'", ARRAY_A);
                            $id = $query['id'];
                            $wpdb->update($table_name, array('points' => $variable1[1], 'vouchercreated' => $create_date, 'voucherexpiry' => $expired_date, 'memberused' => $user), array('id' => $id)
                            );
                        }
                    }
                }
            }
        }

        public static function inputCSVforIgnore($data_path) {
            global $wpdb;
            $table_name = $wpdb->prefix . "rsgiftvoucher";
            $row = 1;
            if (($handle = fopen($data_path, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    $row++;
                    $datas = strtotime($data[2]);
                    $datass = isset($data[2]) ? $datas : 999999999999;
                    if ($data[3] != 'Never') {
                        if ($data[3] != '') {
                            $datasss = strtotime($data[3]);
                        } else {
                            $datasss = '';
                        }
                    } else {
                        $datasss = '';
                    }
                    $expired = $datasss;
                    $usedby = isset($data[4]) ? $data[4] : '';
                    $collection[] = array($data[0], $data[1], $datass, $expired, $usedby);
                }

                $newupdates = array();
                foreach ($collection as $variable1) {
                    $get_voucher_codes = $wpdb->get_col("SELECT vouchercode FROM $table_name");
                    if (!in_array($variable1[0], $get_voucher_codes)) {
                        $create_date = date_i18n('Y-m-d', $variable1[2]);
                        if (isset($variable1[3])) {
                            if ($variable1[3] != '') {
                                $expired_date = date_i18n('Y-m-d', $variable1[3]);
                            } else {
                                $expired_date = '';
                            }
                        } else {
                            $expired_date = '';
                        }
                        if ($variable1[4] != 'Notyet') {
                            if ($variable1[4] != '') {
                                $array = array();
                                $memberused = explode(',', $variable1[4]);
                                foreach ($memberused as $userid) {
                                    $userinfo = get_user_by('login', $userid);
                                    $usernames = $userinfo->ID;
                                    $array[] = $usernames;
                                }
                                $user = serialize($array);
                            } else {
                                $user = '';
                            }
                        } else {
                            $user = '';
                        }
                        $wpdb->insert(
                                $table_name, array(
                            'points' => $variable1[1],
                            'vouchercode' => $variable1[0],
                            'vouchercreated' => $create_date,
                            'voucherexpiry' => $expired_date,
                            'memberused' => $user)
                        );
                    }
                }
                fclose($handle);
            }
        }

        public static function rs_function_to_reset_gift_voucher_tab() {
            $settings = RSOfflineOnlineRewards::reward_system_admin_fields();
            RSTabManagement::rs_function_to_reset_setting($settings);
        }

        public static function function_to_generate_random_code($array) {
            $reward_code_type = $array['reward_code_type'];
            $number_of_charaters_for_voucher_code = $array['characters_for_code'];
            $number_of_points_for_voucher_code = $array['point_for_code'];
            $number_of_vouchers_to_be_generated = $array['no_of_vouchercodes'];
            $gift_expired_date = $array['expiry_date'];
            $prefix_coupon_value = isset($array['prefix_coupon_value']) ? $array['prefix_coupon_value'] : '';
            $suffix_coupon_value = isset($array['suffix_coupon_value']) ? $array['suffix_coupon_value'] : '';
            $exclude_content_code = $array['exclude_content'];
            if ($reward_code_type == 'numeric') {
                if ($number_of_charaters_for_voucher_code != "" && $number_of_points_for_voucher_code != '' && $number_of_vouchers_to_be_generated != '') {
                    $number_of_times = (int) $number_of_vouchers_to_be_generated;
                    for ($k = 0; $k < $number_of_times; $k++) {
                        $random_code = '';
                        $check_duplicate_random_codes = array();
                        for ($j = 1; $j <= $number_of_charaters_for_voucher_code; $j++) {
                            $random_code .= rand(0, 9);
                        }
                        $random_codes[] = $prefix_coupon_value . $random_code . $suffix_coupon_value;
                    }
                }
            } else {
                if ($number_of_charaters_for_voucher_code != "" && $number_of_points_for_voucher_code != '' && $number_of_vouchers_to_be_generated != '') {
                    $list_of_characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    $character_length = strlen($list_of_characters);
                    $number_of_times = (int) $number_of_vouchers_to_be_generated;
                    for ($k = 0; $k < $number_of_times; $k++) {
                        $randomstring = '';
                        for ($j = 1; $j <= $number_of_charaters_for_voucher_code; $j++) {
                            $randomstring .= $list_of_characters[rand(0, $character_length - 1)];
                        }
                        if ($exclude_content_code != "") {
                            $exclude_string = explode(",", $exclude_content_code);
                            $new_array = array();
                            foreach ($exclude_string as $value) {
                                $new_array[$value] = rand(0, 9);
                            }

                            $randomstring = strtr($randomstring, $new_array);
                            $random_codes[] = $prefix_coupon_value . $randomstring . $suffix_coupon_value;
                        } else {
                            $random_codes[] = $prefix_coupon_value . $randomstring . $suffix_coupon_value;
                        }
                    }
                }
            }
            return $random_codes;
        }

        public static function process_ajax_to_create_voucher_code() {
            $verify_security = isset($_POST['security']) ? rs_function_to_verify_secure($_POST['security']) : false;
            if (isset($_POST['proceedanyway']) && $verify_security && isset($_POST['state']) && $_POST['state'] == 'yes') {
                if ($_POST['proceedanyway'] == '1') {

                    $updated_voucher_code_new = array();

                    $prefix_enabled_for_voucher = $_POST['prefix_enabled_value'];

                    $prefix_coupon_value = $_POST['prefix_content'];

                    $suffix_enabled_for_voucher = $_POST['suffix_enabled_value'];

                    $suffix_coupon_value = $_POST['sufffix_content'];

                    $reward_code_type = $_POST['reward_code_type'];

                    $exclude_content_code = $_POST['exclude_content_code'];

                    $number_of_charaters_for_voucher_code = $_POST['length_of_voucher_code'];

                    $number_of_points_for_voucher_code = $_POST['points_value_of_voucher_code'];

                    $number_of_vouchers_to_be_generated = $_POST['number_of_vouchers_to_be_created'] ? $_POST['number_of_vouchers_to_be_created'] : '';

                    $gift_expired_date = $_POST['gift_expired_date'];

                    $voucher_created_date = $_POST['vouchercreated'];

                    if ($prefix_enabled_for_voucher == 'yes' && $suffix_enabled_for_voucher == 'yes') {
                        if ($prefix_coupon_value != '' && $suffix_coupon_value != '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                                'prefix_coupon_value' => $prefix_coupon_value,
                                'suffix_coupon_value' => $suffix_coupon_value,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        } elseif ($prefix_coupon_value == '' && $suffix_coupon_value == '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        } elseif ($prefix_coupon_value != '' && $suffix_coupon_value == '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                                'prefix_coupon_value' => $prefix_coupon_value,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        } elseif ($prefix_coupon_value == '' && $suffix_coupon_value != '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                                'suffix_coupon_value' => $suffix_coupon_value,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        }
                    } elseif ($prefix_enabled_for_voucher != 'yes' && $suffix_enabled_for_voucher != 'yes') {
                        $value_to_generate_randomcode = array(
                            'reward_code_type' => $reward_code_type,
                            'characters_for_code' => $number_of_charaters_for_voucher_code,
                            'point_for_code' => $number_of_points_for_voucher_code,
                            'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                            'expiry_date' => $gift_expired_date,
                            'exclude_content' => $exclude_content_code,
                        );
                        $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                    } elseif ($prefix_enabled_for_voucher == 'yes' && $suffix_enabled_for_voucher != 'yes') {
                        if ($prefix_coupon_value != '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                                'prefix_coupon_value' => $prefix_coupon_value,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        } else {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        }
                    } elseif ($prefix_enabled_for_voucher != 'yes' && $suffix_enabled_for_voucher == 'yes') {
                        if ($suffix_coupon_value != '') {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                                'suffix_coupon_value' => $suffix_coupon_value,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        } else {
                            $value_to_generate_randomcode = array(
                                'reward_code_type' => $reward_code_type,
                                'characters_for_code' => $number_of_charaters_for_voucher_code,
                                'point_for_code' => $number_of_points_for_voucher_code,
                                'no_of_vouchercodes' => $number_of_vouchers_to_be_generated,
                                'expiry_date' => $gift_expired_date,
                                'exclude_content' => $exclude_content_code,
                            );
                            $random_codes = self::function_to_generate_random_code($value_to_generate_randomcode);
                        }
                    }
                    echo json_encode($random_codes);
                }
                exit();
            }
        }

        public static function process_to_split_voucher_codes() {
            global $wpdb;
            $table_name = $wpdb->prefix . "rsgiftvoucher";
            $verify_security = isset($_POST['security']) ? rs_function_to_verify_secure($_POST['security']) : false;
            if (isset($_POST['ids']) && !empty($_POST['ids']) && $verify_security && isset($_POST['state']) && $_POST['state'] == 'yes') {
                $voucher_code = $_POST['ids'];
                $gift_expired_date = $_POST['gift_expired_date'];
                $voucher_created_date = $_POST['vouchercreated'];
                $number_of_points_for_voucher_code = $_POST['points_value_of_voucher_code'];
                $voucher_code_for = $_POST['voucher_code_for'];
                $voucher_code_usage_limit = $_POST['voucher_code_usage_limit'];
                $voucher_code_usage_limit_value = $_POST['voucher_code_usage_limit_value'];
                foreach ($voucher_code as $each_code) {
                    $wpdb->insert(
                            $table_name, array(
                        'points' => $number_of_points_for_voucher_code,
                        'vouchercode' => $each_code,
                        'vouchercreated' => $voucher_created_date,
                        'voucherexpiry' => $gift_expired_date,
                        'memberused' => '',
                        'voucher_code_usage' => $voucher_code_for,
                        'voucher_code_usage_limit' => $voucher_code_usage_limit,
                        'voucher_code_usage_limit_val' => $voucher_code_usage_limit_value)
                    );
                }
                echo json_encode('sucess');
            }
            exit();
        }

    }

    RSOfflineOnlineRewards::init();
}