<?php
/*
 * Email Template Tab
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
if (!class_exists('RSEmailExpiredPointsTemplate')) {

    class RSEmailExpiredPointsTemplate {

        public static function init() {

            add_filter('woocommerce_rs_settings_tabs_array', array(__CLASS__, 'reward_system_tab_setting')); // Register a New Tab in a WooCommerce Reward System Settings        

            add_action('woocommerce_rs_settings_tabs_rewardsystem_email_expired_point_template', array(__CLASS__, 'reward_system_register_admin_settings')); // Call to register the admin settings in the Reward System Submenu with general Settings tab        

            add_action('woocommerce_update_options_rewardsystem_modules_rewardsystem_email_expired_point_template', array(__CLASS__, 'reward_system_update_settings')); // call the woocommerce_update_options_{slugname} to update the reward system                               

            add_action('woocommerce_admin_field_list_table_expired_point', array(__CLASS__, 'add_sumo_rewards_table_list_email_expired_templates'));

            add_action('wp_ajax_rs_new_expired_template', array(__CLASS__, 'create_template'));

            add_action('wp_ajax_nopriv_rs_new_expired_template', array(__CLASS__, 'create_template'));

            add_action('wp_ajax_rs_edit_template_expired', array(__CLASS__, 'edit_template'));

            add_action('wp_ajax_nopriv_rs_edit_template_expired', array(__CLASS__, 'edit_template'));

            add_action('wp_ajax_rs_delete_expired_email_template', array(__CLASS__, 'delete_template'));

            add_action('wp_ajax_nopriv_rs_delete_expired_email_template', array(__CLASS__, 'delete_template'));

            add_action('wp_ajax_rs_email_template_status', array(__CLASS__, 'email_template_status'));

            add_action('wp_ajax_nopriv_rs_email_template_status', array(__CLASS__, 'email_template_status'));

            add_action('fp_action_to_reset_settings_rewardsystem_emailtemplate', array(__CLASS__, 'rs_function_to_reset_email_template_tab'));

            add_action('woocommerce_admin_field_rs_enable_disable_emial_template_expire', array(__CLASS__, 'rs_function_to_enable_disable_product_purchase_module'));
        }

        public static function rs_function_to_enable_disable_product_purchase_module() {
            $get_option_value = get_option('rs_email_template_expire_activated');
            $name_of_checkbox = 'rs_email_template_expire_checkbox';
            RSModulesTab::rs_common_function_to_get_checkbox($get_option_value, $name_of_checkbox);
        }

        public static function email_template_status() {
            if (isset($_POST['row_id'])) {
                global $wpdb;
                $table_name_email = $wpdb->prefix . 'rs_expiredpoints_email';
                $requesting_state = $_POST['status'] == 'ACTIVE' ? 'NOTACTIVE' : 'ACTIVE';
                $wpdb->update($table_name_email, array('rs_status' => $requesting_state), array('id' => $_POST['row_id']));
                echo $requesting_state;
            }
            exit();
        }

        /*
         * Function to Define Name of the Tab
         */

        public static function reward_system_tab_setting($setting_tabs) {
            if (!is_array($setting_tabs))
                $setting_tabs = (array) $setting_tabs;
            $setting_tabs['rewardsystem_email_expired_point_template'] = __('Email Templates', 'rewardsystem');
            return $setting_tabs;
        }

        /*
         * Function label settings to Member Level Tab
         */

        public static function reward_system_admin_fields() {
            global $woocommerce;
            global $wpdb;
            $emailtemplate_table_name = $wpdb->prefix . 'rs_expiredpoints_email';
            $email_templates = $wpdb->get_results("SELECT template_name FROM $emailtemplate_table_name WHERE rs_status='ACTIVE'", ARRAY_A);
            $array = array();
            foreach ($email_templates as $key) {
                $array[$key['template_name']] = $key['template_name'];
            }
            return apply_filters('woocommerce_rewardsystem_email_expired_point_template_settings', array(
                array(
                    'type' => 'rs_modulecheck_start',
                ),
                array(
                    'name' => __('Email Template for Expire', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_activate_email_template_expire_module',
                ),
                array(
                    'type' => 'rs_enable_disable_emial_template_expire',
                ),
                array('type' => 'sectionend', 'id' => '_rs_activate_email_template_expire_module'),
                array(
                    'type' => 'rs_modulecheck_end',
                ),                
                array(
                    'type' => 'rs_modulecheck_start',
                ),
                array(
                    'name' => __('Email Templates Settings for Expire', 'rewardsystem'),
                    'type' => 'title',
                    'id' => '_rs_email_expired_point_template_setting'
                ),
                array(
                    'name' => __('Select Template ', 'rewardsystem'),
                    'desc' => __('Select Template', 'rewardsystem'),
                    'id' => 'rs_select_template',
                    'class' => 'rs_select_template',
                    'std' => '',
                    'default' => '',
                    'type' => 'select',
                    'newids' => 'rs_select_template',
                    'options' => $array,
                    'desc_tip' => true,
                ),
                array('type' => 'sectionend', 'id' => 'rs_general_tab_'),
                array(
                    'type' => 'list_table_expired_point',
                ),
                array('type' => 'sectionend', 'id' => '_rs_email_expired_point_template_setting'),
                array(
                    'type' => 'rs_modulecheck_end',
                ),
            ));
        }

        /**
         * Registering Custom Field Admin Settings of SUMO Reward Points in woocommerce admin fields funtion
         */
        public static function reward_system_register_admin_settings() {

            woocommerce_admin_fields(RSEmailExpiredPointsTemplate::reward_system_admin_fields());
        }

        /**
         * Update the Settings on Save Changes may happen in SUMO Reward Points
         */
        public static function reward_system_update_settings() {
            woocommerce_update_options(RSEmailExpiredPointsTemplate::reward_system_admin_fields());
            if (isset($_POST['rs_email_template_expire_checkbox'])) {
                update_option('rs_email_template_expire_activated', $_POST['rs_email_template_expire_checkbox']);
            } else {
                update_option('rs_email_template_expire_activated', 'no');
            }
            wp_safe_redirect(esc_url_raw(add_query_arg('rs_saved', '1', $_SERVER['REQUEST_URI'])));
            exit();
        }

        public static function add_sumo_rewards_table_list_email_expired_templates() {
            global $woocommerce;
            ?>
            <style type="text/css">                
                .chosen-container .chosen-results {
                    clear: both;
                }
                .chosen-container {
                    position:absolute !important;
                }
            </style>
            <script type='text/javascript'>
                jQuery(document).ready(function () {
                    jQuery('#rs_pagination').change(function (e) {
                        e.preventDefault();
                        var pageSize = jQuery(this).val();
                        jQuery('.rs_email_template_table').data('page-size', pageSize);
                        jQuery('.rs_email_template_table').trigger('footable_initialized');
                    });
                    jQuery('#rs_email_templates_table_expired').footable().on('click', '.rs_delete_expired', function (e) {
                        e.preventDefault();
                        var row_id = jQuery(this).data('id');
                        console.log(row_id);
                        var footable = jQuery('#rs_email_templates_table_expired').data('footable');
                        var row = jQuery(this).parents('tr:first');
                        footable.removeRow(row);
                        var data = {
                            row_id: row_id,
                            action: "rs_delete_expired_email_template"
                        }
                        jQuery.ajax({type: "POST",
                            url: ajaxurl,
                            data: data}).done(function (res) {

                        });
                    });
                    jQuery('#rs_email_templates_table_expired').on('click', '.rs_expired_mail_active', function (e) {
                        e.preventDefault();
                        var row_id = jQuery(this).data('rsmailid');
                        var obj = jQuery(this);
                        jQuery(obj).attr('disabled', true);
                        var status = jQuery(this).data('currentstate');
                        var data = {
                            row_id: row_id,
                            status: status,
                            action: "rs_email_template_status"
                        }
                        jQuery.ajax({type: "POST",
                            url: ajaxurl,
                            data: data}).done(function (res) {
                            obj.data('currentstate', res);
                            if (res == "ACTIVE") {
                                obj.text("Deactivate");
                            } else {
                                obj.text("Activate");
                            }
                            jQuery(obj).attr('disabled', false);

                        });
                    });

                });
            </script>
            <?php
            global $wpdb;
            $table_name = $wpdb->prefix . 'rs_expiredpoints_email';
            $templates = $wpdb->get_results("SELECT * FROM $table_name", OBJECT);            
            if (isset($_GET['rs_new_email_expired']) && (isset($_GET['rs_saved']))) {
                $email_templates = $wpdb->get_results("SELECT template_name FROM $table_name WHERE rs_status='ACTIVE'", ARRAY_A);
                $new_template_id = get_option('rs_new_template_id_for_expiry');
                $edit_templates = $wpdb->get_results("SELECT * FROM $table_name WHERE id = $new_template_id", OBJECT);
                $edit_templates = $edit_templates[0];
                if (empty($email_templates)) {
                    ?>
                    <script type='text/javascript'>
                        jQuery(document).ready(function () {
                            jQuery('#rs_select_template').parent().parent().hide();
                        });
                    </script>
                    <?php
                }
                $editor_id = "rs_email_new_expired";
                $settings = array('textarea_name' => 'rs_email_new_expired');
                $admin_url = admin_url('admin.php');
                $template_list_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template',), $admin_url);
                $content = "Hi {rsfirstname} {rslastname}, <br><br> You have Earned Reward Points: {rspoints} on {rssitelink}  <br><br> You can use this Reward Points to make discounted purchases on {rssitelink} <br><br> Thanks";                
                $getuser = array(0);
                $template_name = $edit_templates->template_name;
                $woo_selected = checked($edit_templates->sender_opt, 'woo', false);
                $local_selected = checked($edit_templates->sender_opt, 'local', false);
                $template_active = selected($edit_templates->rs_status, 'ACTIVE', false);
                $template_not_active = selected($edit_templates->rs_status, 'NOTACTIVE', false);
                ?>
                <table class="widefat"><tr><td>
                    <tr><td><span><strong>{rssitelink}</strong> - Use this Shortcode to insert the Cart Link in the mail</span></td></tr>
                    <tr><td><span><strong>{rsfirstname}</strong> - Use this Shortcode to insert Receiver First Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rslastname}</strong> - Use this Shortcode to insert Receiver Last Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rsdate}</strong> - Use this Shortcode to insert Expired Date in the Mail</span></td></tr>
                    <tr><td><span><strong>{rspoints}</strong> - Use this Shortcode to insert Expired Points in the Mail</span></td></tr>

                    <tr><td><?php _e('Template Name', 'rewardsystem') ?>: </td><td><input type="text" name="rs_email_expired_name" id="rs_email_expired_name" value="<?php echo $template_name ?>"></td></tr>
                    <tr><td><?php _e('Template Status', 'rewardsystem') ?>: </td><td><select name="rs_expired_template_status" id="rs_expired_template_status">                       
                                <option value="NOTACTIVE" <?php echo $template_not_active ?> >Deactivated</option>
                                <option value="ACTIVE" <?php echo $template_active ?> >Activated</option>
                            </select>
                    <tr><td><?php _e('Email Sender Option', 'rewardsystem') ?>: </td><td><input type="radio" name="rs_sender_opt_expired" id="rs_sender_woo_expired" value="woo" <?php echo $woo_selected ?> class="rs_sender_opt_expired">woocommerce
                            <input type="radio" name="rs_sender_opt_expired" id="rs_sender_local" value="local" <?php echo $local_selected ?> class="rs_sender_opt_expired">local</td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Name', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_expired_from_name" id="rs_expired_from_name" value="<?php echo $edit_templates->from_name ?>"></td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Email', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_expired_from_email" id="rs_expired_from_email" value="<?php echo $edit_templates->from_email ?>"></td></tr>

                    <!-- Change the Logic to Optimize Get Users -->               
                    <tr><td><?php _e('Email Subject', 'rewardsystem') ?>:</td><td> <input type="text" name="rs_subject_expired" id="rs_subject_expired"></td></tr>
                    <tr><td><?php _e('No of Days', 'rewardsystem') ?>:</td><td> <input type="text" name="rs_no_of_days" id="rs_no_of_days"></td></tr>

                    <tr><td> <?php _e('Email Message', 'rewardsystem') ?>:</td>
                        <td>
                            <?php
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </td></tr>
                    <tr><td>
                            <input type="button" name="rs_save_new_expired_template" class="button button-primary button-large" id="rs_save_new_expired_template" value="Save">&nbsp;

                            <a href="<?php echo $template_list_url ?>"><input type="button" class="button" name="returntolist" value="Return to Mail Templates"></a>&nbsp;
                        </td></tr>
                </table>
                <script>
                    function get_tinymce_content() {
                        if (jQuery("#wp-rs_email_new_expired-wrap").hasClass("tmce-active")) {
                            return tinyMCE.activeEditor.getContent();
                        } else {
                            return jQuery("#rs_email_new_expired").val();
                        }
                    }
                    jQuery(document).ready(function () {
                        // jQuery("#rs_email_expired_name").val("Default");
                        jQuery("#rs_expired_from_name").val("Admin");
                        if (jQuery("#rs_sender_woo_expired").is(":checked")) {
                            jQuery(".rs_local_senders_expired").css("display", "none");
                        } else {
                            jQuery(".rs_local_senders_expired").css("display", "table-row");
                        }
                        //jQuery("#rs_sender_woo_expired").attr("checked", "checked");
                        jQuery(".rs_sender_opt_expired").change(function () {
                            if (jQuery("#rs_sender_woo_expired").is(":checked")) {
                                jQuery(".rs_local_senders_expired").css("display", "none");
                            } else {
                                jQuery(".rs_local_senders_expired").css("display", "table-row");
                            }
                        });


                        jQuery("#rs_subject_expired").val("SUMO Reward Points");
                        jQuery("#rs_expired_from_email").val("<?php echo get_option('admin_email') ?>");
                        jQuery("#rs_duration_type").val("days");
                        jQuery("#rs_duration").val("1");

                        jQuery("#rs_email_new_expired").val("Hi {rsfirstname} {rslastname}, <br><br> Your {rspoints} Points is Expire on : {rsdate}   <br><br> You can use this Reward Points to make discounted purchases on {rssitelink} <br><br> Thanks");
                        jQuery("#rs_duration_type").change(function () {
                            jQuery("span#rs_duration").html(jQuery("#rs_duration_type").val());
                        });
                        jQuery("#rs_save_new_expired_template").click(function () {
                            jQuery(this).prop("disabled", true);
                            var rs_email_expired_name = jQuery("#rs_email_expired_name").val();
                            var rs_sender_option = jQuery("input:radio[name=rs_sender_opt_expired]:checked").val();
                            var rs_expired_from_name = jQuery("#rs_expired_from_name").val();
                            var rs_expired_from_email = jQuery("#rs_expired_from_email").val();
                            var rs_subject_expired = jQuery("#rs_subject_expired").val();
                            var rs_no_of_days = jQuery("#rs_no_of_days").val();
                            var rs_message_expired = get_tinymce_content();
                            var rs_expired_template_status = jQuery("#rs_expired_template_status").val();
                            var data = {
                                action: "rs_new_expired_template",
                                rs_sender_option: rs_sender_option,
                                rs_email_expired_name: rs_email_expired_name,
                                rs_expired_from_name: rs_expired_from_name,
                                rs_expired_from_email: rs_expired_from_email,
                                rs_subject_expired: rs_subject_expired,
                                rs_no_of_days: rs_no_of_days,
                                rs_message_expired: rs_message_expired,
                                rs_expired_template_status: rs_expired_template_status,
                            };

                            jQuery.ajax({
                                type: "POST",
                                url: ajaxurl,
                                data: data
                            }).done(function (response) {

                                alert("Settings Saved");
                                jQuery("#rs_save_new_expired_template").prop("disabled", false);
                            });
                            console.log(data);
                        });
                    });</script>
                <style>
                    .rs_local_senders_expired{
                        display:none;
                    }
                </style>
                <?php
            } else if (isset($_GET['rs_new_email_expired']) && (!isset($_GET['rs_saved']))) {
                $editor_id = "rs_email_new_expired";
                $settings = array('textarea_name' => 'rs_email_new_expired');
                $admin_url = admin_url('admin.php');
                $template_list_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template',), $admin_url);
                $content = "Hi {rsfirstname} {rslastname}, <br><br> You have Earned Reward Points: {rspoints} on {rssitelink}  <br><br> You can use this Reward Points to make discounted purchases on {rssitelink} <br><br> Thanks";
                ?>
                <table class="widefat"><tr><td>
                    <tr><td><span><strong>{rssitelink}</strong> - Use this Shortcode to insert the Cart Link in the mail</span></td></tr>
                    <tr><td><span><strong>{rsfirstname}</strong> - Use this Shortcode to insert Receiver First Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rslastname}</strong> - Use this Shortcode to insert Receiver Last Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rsdate}</strong> - Use this Shortcode to insert Expired Date in the Mail</span></td></tr>
                    <tr><td><span><strong>{rspoints}</strong> - Use this Shortcode to insert Expired Points in the Mail</span></td></tr>
                    <tr><td><?php _e('Template Name', 'rewardsystem') ?>: </td><td><input type="text" name="rs_email_expired_name" id="rs_email_expired_name"></td></tr>
                    <tr><td><?php _e('Template Status', 'rewardsystem') ?>: </td><td><select name="rs_expired_template_status" id="rs_expired_template_status"> 
                                <option value="NOTACTIVE">Deactivated</option>
                                <option value="ACTIVE">Activated</option>
                            </select></td></tr>

                    <tr><td><?php _e('Email Sender Option', 'rewardsystem') ?>: </td><td><input type="radio" name="rs_sender_opt_expired" id="rs_sender_woo_expired" value="woo" class="rs_sender_opt_expired">woocommerce <input type="radio" name="rs_sender_opt_expired" id="rs_sender_local" value="local" class="rs_sender_opt_expired">local</td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Name', 'rewardsystem') ?>: </td><td><input type="text" name="rs_expired_from_name"  id="rs_expired_from_name"></td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Email', 'rewardsystem') ?>: </td><td><input type="text" name="rs_expired_from_email"  id="rs_expired_from_email"></td></tr>
                    <tr><td><?php _e('Email Subject', 'rewardsystem') ?>:</td><td> <input type="text" name="rs_subject_expired" id="rs_subject_expired"></td></tr>
                    <tr><td><?php _e('No of Days', 'rewardsystem') ?>:</td><td> <input type="text" name="rs_no_of_days" id="rs_no_of_days"></td></tr>
                    <tr><td> <?php _e('Email Message', 'rewardsystem') ?>:</td>
                        <td>
                            <?php                            
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </td></tr>
                    <tr><td>
                            <input type="button" name="rs_save_new_expired_template" class="button button-primary button-large" id="rs_save_new_expired_template" value="Save">&nbsp;
                            <a href="<?php echo $template_list_url ?>"><input type="button" class="button" name="returntolist" value="Return to Mail Templates"></a>&nbsp;
                        </td></tr>
                </table>
                <script>
                    function get_tinymce_content() {
                        if (jQuery("#wp-rs_email_new_expired-wrap").hasClass("tmce-active")) {
                            return tinyMCE.activeEditor.getContent();
                        } else {
                            return jQuery("#rs_email_new_expired").val();
                        }
                    }
                    jQuery(document).ready(function () {
                        jQuery("#rs_email_expired_name").val("Default");
                        jQuery("#rs_expired_from_name").val("Admin");
                        jQuery("#rs_sender_woo_expired").attr("checked", "checked");
                        jQuery(".rs_sender_opt_expired").change(function () {
                            if (jQuery("#rs_sender_woo_expired").is(":checked")) {
                                jQuery(".rs_local_senders_expired").css("display", "none");
                            } else {
                                jQuery(".rs_local_senders_expired").css("display", "table-row");
                            }
                        });

                        jQuery("#rs_subject_expired").val("SUMO Reward Points");
                        jQuery("#rs_expired_from_email").val("<?php echo get_option('admin_email') ?>");
                        jQuery("#rs_duration_type").val("days");
                        jQuery("#rs_duration").val("1");

                        jQuery("#rs_email_new_expired").val("Hi {rsfirstname} {rslastname}, <br><br> Your {rspoints} Points is Expire on : {rsdate}   <br><br> You can use this Reward Points to make discounted purchases on {rssitelink} <br><br> Thanks");
                        jQuery("#rs_duration_type").change(function () {
                            jQuery("span#rs_duration").html(jQuery("#rs_duration_type").val());
                        });
                        jQuery("#rs_save_new_expired_template").click(function () {
                            jQuery(this).prop("disabled", true);
                            var rs_email_expired_name = jQuery("#rs_email_expired_name").val();
                            var rs_sender_option = jQuery("input:radio[name=rs_sender_opt_expired]:checked").val();
                            var rs_expired_from_name = jQuery("#rs_expired_from_name").val();
                            var rs_expired_from_email = jQuery("#rs_expired_from_email").val();
                            var rs_subject_expired = jQuery("#rs_subject_expired").val();
                            var rs_no_of_days = jQuery("#rs_no_of_days").val();
                            var rs_message_expired = get_tinymce_content();                            
                            var rs_expired_template_status = jQuery("#rs_expired_template_status").val();
                            var data = {
                                action: "rs_new_expired_template",
                                rs_sender_option: rs_sender_option,
                                rs_email_expired_name: rs_email_expired_name,
                                rs_expired_from_name: rs_expired_from_name,
                                rs_expired_from_email: rs_expired_from_email,
                                rs_subject_expired: rs_subject_expired,
                                rs_no_of_days: rs_no_of_days,
                                rs_message_expired: rs_message_expired,
                                rs_expired_template_status: rs_expired_template_status,
                            };

                            jQuery.ajax({
                                type: "POST",
                                url: ajaxurl,
                                data: data
                            }).done(function (response) {
                                alert("Settings Saved");
                                jQuery("#rs_save_new_expired_template").prop("disabled", false);
                            });
                            console.log(data);
                        });
                    });</script>
                <style>
                    .rs_local_senders_expired{
                        display:none;
                    }
                </style>
                <?php
            } else if (isset($_GET['rs_edit_email_expired'])) {
                $rs_mailsend_implode = '';
                $template_id = $_GET['rs_edit_email_expired'];
                $edit_templates = $wpdb->get_results("SELECT * FROM $table_name WHERE id=$template_id", OBJECT);
                $edit_templates = $edit_templates[0];

                $admin_url = admin_url('admin.php');
                $template_list_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template',), $admin_url);
                $editor_id = "rs_email_expired_template_edit";
                $content = $edit_templates->message;

                if (!empty($rs_mailsend_selected_users)) {
                    $rs_mailsend_implode = implode(',', $rs_mailsend_selected_users);
                }
                $settings = array('textarea_name' => 'rs_email_expired_template_edit');
                ?>
                <script type="text/javascript">

                </script>
                <table class="widefat"><tr><td>
                    <tr><td><span><strong>{rssitelink}</strong> - Use this Shortcode to insert the Cart Link in the mail</span></td></tr>
                    <tr><td><span><strong>{rsfirstname}</strong> - Use this Shortcode to insert Receiver First Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rslastname}</strong> - Use this Shortcode to insert Receiver Last Name in the mail</span></td></tr>
                    <tr><td><span><strong>{rsdate}</strong> - Use this Shortcode to insert Expire Date in the Mail</span></td></tr>
                    <tr><td><span><strong>{rspoints}</strong> - Use this Shortcode to insert Expire Points in the Mail</span></td></tr>
                    <tr>
                        <td> <?php _e('Template Name', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_email_expired_name" id="rs_email_expired_name" value="<?php echo $edit_templates->template_name ?>"></td></tr>
                    <?php
                    $getuser = array(0);
                    $woo_selected = checked($edit_templates->sender_opt, 'woo', false);
                    $local_selected = checked($edit_templates->sender_opt, 'local', false);
                    $template_active = selected($edit_templates->rs_status, 'ACTIVE', false);
                    $template_not_active = selected($edit_templates->rs_status, 'NOTACTIVE', false);
                    ?>
                    <tr><td><?php _e('Template Status', 'rewardsystem') ?>: </td><td><select name="rs_expired_template_status" id="rs_expired_template_status">                       
                                <option value="NOTACTIVE" <?php echo $template_not_active ?> >Deactivated</option>
                                <option value="ACTIVE" <?php echo $template_active ?> >Activated</option>
                            </select>
                    <tr><td><?php _e('Email Sender Option', 'rewardsystem') ?>: </td><td><input type="radio" name="rs_sender_opt_expired" id="rs_sender_woo_expired" value="woo" <?php echo $woo_selected ?> class="rs_sender_opt_expired">woocommerce
                            <input type="radio" name="rs_sender_opt_expired" id="rs_sender_local" value="local" <?php echo $local_selected ?> class="rs_sender_opt_expired">local</td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Name', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_expired_from_name" id="rs_expired_from_name" value="<?php echo $edit_templates->from_name ?>"></td></tr>
                    <tr class="rs_local_senders_expired"><td><?php _e('From Email', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_expired_from_email" id="rs_expired_from_email" value="<?php echo $edit_templates->from_email ?>"></td></tr>

                    <!-- Send Mail Options -->

                    <!-- Change the Logic to Optimize Get Users -->

                    <tr><td><?php _e('Email Subject', 'rewardsystem') ?>:</td>

                        <td><input type="text" name="rs_subject_expired" id="rs_subject_expired" value="<?php echo $edit_templates->subject ?>"></td></tr>
                    <tr><td><?php _e('No of Days', 'rewardsystem') ?>:</td>
                        <td><input type="text" name="rs_no_of_days" id="rs_no_of_days" value="<?php echo $edit_templates->noofdays ?>"></td></tr>

                    <tr><td> <?php _e('Email Message', 'rewardsystem') ?>:</td>
                        <td>
                            <?php
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </td></tr>
                    <tr><td>
                            <input type="button" class="button button-primary button-large" name="rs_save_new_expired_template" id="rs_save_new_expired_template" value="<?php _e('Save Changes', 'rewardsystem') ?>">&nbsp;
                            <a href="<?php echo $template_list_url ?>"><input type="button" class="button" name="returntolist" value="<?php _e('Return to Mail Templates', 'rewardsystem') ?>"></a>&nbsp;
                        </td></tr>
                </table>
                <script>
                    function get_tinymce_content_edit() {
                        if (jQuery("#wp-rs_email_expired_template_edit-wrap").hasClass("tmce-active")) {
                            return tinyMCE.activeEditor.getContent();
                        } else {
                            return jQuery("#rs_email_expired_template_edit").val();
                        }
                    }
                    jQuery(document).ready(function () {
                        jQuery("#rs_duration_type").change(function () {
                            jQuery("span#rs_duration").html(jQuery("#rs_duration_type").val());
                        });


                        //normal ready event
                        if (jQuery("#rs_sender_woo_expired").is(":checked")) {
                            jQuery(".rs_local_senders_expired").css("display", "none");
                        } else {
                            jQuery(".rs_local_senders_expired").css("display", "table-row");
                        }

                        jQuery(".rs_sender_opt_expired").change(function () {
                            if (jQuery("#rs_sender_woo_expired").is(":checked")) {
                                jQuery(".rs_local_senders_expired").css("display", "none");
                            } else {
                                jQuery(".rs_local_senders_expired").css("display", "table-row");
                            }
                        });
                        jQuery("#rs_save_new_expired_template").click(function () {
                            jQuery(this).prop("disabled", true);
                            var rs_email_expired_name = jQuery("#rs_email_expired_name").val();
                            var rs_sender_option = jQuery("input:radio[name=rs_sender_opt_expired]:checked").val();
                            var rs_expired_from_name = jQuery("#rs_expired_from_name").val();
                            var rs_expired_from_email = jQuery("#rs_expired_from_email").val();
                            var rs_subject_expired = jQuery("#rs_subject_expired").val();
                            var rs_no_of_days = jQuery("#rs_no_of_days").val();
                            var rs_expired_template_status = jQuery("#rs_expired_template_status").val();
                            var rs_message_expired = get_tinymce_content_edit();
                            var rs_duration_type = jQuery("#rs_duration_type").val();
                            var rs_mail_duration = jQuery("span #rs_duration").val();
                            var rs_template_id = '<?php echo $template_id ?>';
                            console.log(jQuery("#rs_email_expired_template_edit").val());
                            var data = {
                                action: "rs_edit_template_expired",
                                rs_sender_option: rs_sender_option,
                                rs_email_expired_name: rs_email_expired_name,
                                rs_expired_from_name: rs_expired_from_name,
                                rs_expired_from_email: rs_expired_from_email,
                                rs_subject_expired: rs_subject_expired,
                                rs_no_of_days: rs_no_of_days,
                                rs_message_expired: rs_message_expired,
                                rs_expired_template_status: rs_expired_template_status,
                                rs_duration_type: rs_duration_type,
                                rs_mail_duration: rs_mail_duration,
                                rs_template_id: rs_template_id
                            };

                            jQuery.ajax({
                                type: "POST",
                                url: ajaxurl,
                                data: data
                            }).done(function (response) {
                                var newresponse = response.replace(/\s/g, '');
                                if (newresponse === '1') {
                                    alert("Settings Updated");
                                }
                                jQuery("#rs_save_new_expired_template").prop("disabled", false);
                            });
                            console.log(data);
                        });
                    });</script>
                <?php
            } else {
                $admin_url = admin_url('admin.php');
                $new_template_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template', 'rs_new_email_expired' => 'template'), $admin_url);
                $edit_template_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template', 'rs_edit_email_expired' => 'template'), $admin_url);
                ?>
                <a href='<?php echo $new_template_url ?>'>
                    <input type="button" name="rs_new_email_expired_template" id="rs_new_email_expired_template" class="button rs_email_button" value="New Template">
                </a>
                <?php
                echo '<p> ' . __('Search:', 'rewardsystem') . '<input id="rs_email_expired_templates" type="text"/>  ' . __('Page Size:', 'rewardsystem') . '
                <select id="changepagesizertemplates">
                <option value="1">1</option>
		<option value="5">5</option>
		<option value="10">10</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                </p>';
                ?>
                <table class="wp-list-table widefat fixed posts" data-filter = "#rs_email_templates_expired" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next" id="rs_email_templates_table_expired" cellspacing="0">
                    <thead>
                        <tr>
                            <th scope='col' data-toggle="true" class='manage-column column-serial_number'  style="">
                                <a href="#"><span><?php _e('S.No', 'rewardsystem'); ?></span>
                            </th>
                            <th scope='col' id='rs_user_names' class='manage-column column-rs_user_name'  style=""><?php _e('Template Name', 'rewardsystem'); ?></th>
                            <th scope='col' id='rs_expired_from_name' class='manage-column column-rs_expired_from_name'  style=""><?php _e('From Name', 'rewardsystem'); ?></th>
                            <th scope='col' id='rs_expired_from_email' class='manage-column column-rs_expired_from_email'  style=""><?php _e('From Email', 'rewardsystem'); ?></th>
                            <th scope="col" id="rs_subject_expired" class="manage-column column-rs_subject_expired" style=""><?php _e('Email Subject', 'rewardsystem'); ?></th>
                            <th scope='col' id='rs_message_expired' class='manage-column column-rs_message_expired' style=''><?php _e('Email Message', 'rewardsystem'); ?></th>
                            <th scope='col' id='rs_no_of_days' class='manage-column column-rs_no_of_days' style=''><?php _e('No of days', 'rewardsystem'); ?></th>
                            <th scope="col" id="rs_email_status" class="manage-column column-rs_email_status" style=""><?php _e('Status', 'rewardsystem'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php                        
                        foreach ($templates as $each_template) {
                            echo '<tr><td>';
                            echo $each_template->id;
                            $edit_template_url = add_query_arg(array('page' => 'rewardsystem_callback', 'tab' => 'rewardsystem_modules', 'section' => 'rewardsystem_email_expired_point_template', 'rs_edit_email_expired' => $each_template->id), $admin_url);
                            echo '&nbsp;<span><a href="' . $edit_template_url . '">' . __('Edit', 'rewardsystem') . ' </a></span>&nbsp; <span><a href="" class="rs_delete_expired" data-id="' . $each_template->id . '">' . __('Delete', 'rewardsystem') . '</a></span>';
                            echo '</td><td>';
                            echo $each_template->template_name;
                            echo '</td><td>';
                            if ("local" == $each_template->sender_opt) {
                                echo $each_template->from_name;
                                echo '</td><td>';
                                echo $each_template->from_email;
                            } else {
                                echo get_option('woocommerce_email_from_name');
                                echo '</td><td>';
                                echo get_option('woocommerce_email_from_address');
                            }
                            echo '</td><td>';
                            echo $each_template->subject;
                            echo '</td><td>';
                            $message = strip_tags($each_template->message);
                            if (strlen($message) > 80) {
                                echo substr($message, 0, 80);
                                echo '...';
                            } else {
                                echo $message;
                            }
                            echo '</td><td>';
                            echo $each_template->noofdays;
                            echo '</td><td>';
                            $status = $each_template->rs_status;
                            $mail_id = $each_template->id;
                            if ($status == 'ACTIVE') {
                                echo ' <a href="#" class="button rs_expired_mail_active" data-rsmailid="' . $mail_id . '" data-currentstate="ACTIVE">Deactivate</a>';
                                echo '</td></tr>';
                            } else {
                                echo ' <a href="#" class="button rs_expired_mail_active" data-rsmailid="' . $mail_id . '" data-currentstate="NOTACTIVE">Activate</a>';
                                echo '</td></tr>';
                            }
                        }
                        ?>
                    </tbody>
                </table>
                <div style="clear:both;">
                    <div class="pagination pagination-centered"></div>
                </div>
                <?php
            }
        }

        public static function create_template() {
            global $wpdb;
            if (isset($_POST['rs_email_expired_name'])) {
                $table_name_email = $wpdb->prefix . 'rs_expiredpoints_email';
                $wpdb->insert($table_name_email, array('template_name' => stripslashes($_POST['rs_email_expired_name']),
                    'sender_opt' => stripslashes($_POST['rs_sender_option']),
                    'from_name' => stripslashes($_POST['rs_expired_from_name']),
                    'from_email' => stripslashes($_POST['rs_expired_from_email']),
                    'subject' => stripslashes($_POST['rs_subject_expired']),
                    'message' => stripslashes($_POST['rs_message_expired']),
                    'noofdays' => stripslashes($_POST['rs_no_of_days']),
                    'rs_status' => stripslashes($_POST['rs_expired_template_status']),
                ));
            }
            echo $wpdb->insert_id;
            update_option('rs_new_template_id_for_expiry', $wpdb->insert_id);
            exit();
        }

        public static function edit_template() {
            if (isset($_POST['rs_template_id'])) {
                $template_id = $_POST['rs_template_id'];
                global $wpdb;
                $table_name_email = $wpdb->prefix . 'rs_expiredpoints_email';
                $wpdb->update($table_name_email, array('template_name' => stripslashes($_POST['rs_email_expired_name']),
                    'sender_opt' => stripslashes($_POST['rs_sender_option']),
                    'from_name' => stripslashes($_POST['rs_expired_from_name']),
                    'from_email' => stripslashes($_POST['rs_expired_from_email']),
                    'subject' => stripslashes($_POST['rs_subject_expired']),
                    'message' => stripslashes($_POST['rs_message_expired']),
                    'noofdays' => stripslashes($_POST['rs_no_of_days']),
                    'rs_status' => stripslashes($_POST['rs_expired_template_status']),
                        ), array('id' => $template_id));
            }
            echo "1";
            exit();
        }

        public static function delete_template() {
            if (isset($_POST['row_id'])) {
                global $wpdb;
                $row_id = $_POST['row_id'];
                $table_name_email = $wpdb->prefix . 'rs_expiredpoints_email';
                $wpdb->delete($table_name_email, array('id' => $row_id));
            }
            exit();
        }

        public static function rs_function_to_reset_email_template_tab() {
            $settings = RSEmailTemplate::reward_system_admin_fields();
            RSTabManagement::rs_function_to_reset_setting($settings);
        }

    }

    RSEmailExpiredPointsTemplate::init();
}