<?php
/*
 * Advanced Tab
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSAdvancedSetting' ) ) {

    class RSAdvancedSetting {

        public static function init() {
            add_filter( 'woocommerce_rs_settings_tabs_array' , array ( __CLASS__ , 'reward_system_tab_setting' ) ) ; // Register a New Tab in a WooCommerce Reward System Settings        

            add_action( 'woocommerce_rs_settings_tabs_rewardsystem_advanced' , array ( __CLASS__ , 'reward_system_register_admin_settings' ) ) ; // Call to register the admin settings in the Reward System Submenu with general Settings tab        

            add_action( 'woocommerce_update_options_rewardsystem_advanced' , array ( __CLASS__ , 'reward_system_update_settings' ) ) ; // call the woocommerce_update_options_{slugname} to update the reward system                               

            add_action( 'admin_init' , array ( __CLASS__ , 'reward_system_default_settings' ) ) ; // call the init function to update the default settings on page load

            add_action( 'fp_action_to_reset_settings_rewardsystem_advanced' , array ( __CLASS__ , 'rs_function_to_reset_advanced_tab' ) ) ;

            add_action( 'woocommerce_admin_field_rs_add_old_version_points' , array ( __CLASS__ , 'add_old_points_for_all_user' ) ) ;

            add_action( 'woocommerce_admin_field_previous_order_button_range' , array ( __CLASS__ , 'rs_add_date_picker' ) ) ;

            add_action( 'woocommerce_admin_field_previous_order_button' , array ( __CLASS__ , 'rs_apply_points_for_previous_order_button' ) ) ;

            add_action( 'admin_head' , array ( __CLASS__ , 'rs_send_ajax_points_to_previous_orders' ) ) ;

            add_action( 'wp_ajax_nopriv_previousorderpoints' , array ( __CLASS__ , 'rs_process_ajax_points_to_previous_order' ) ) ;

            add_action( 'wp_ajax_previousorderpoints' , array ( __CLASS__ , 'rs_process_ajax_points_to_previous_order' ) ) ;

            add_action( 'wp_ajax_rssplitajaxoptimizationforpreviousorder' , array ( __CLASS__ , 'process_chunk_ajax_request_for_previous_orders' ) ) ;

            add_filter( "woocommerce_rewardsystem_advanced_settings" , array ( __CLASS__ , 'reward_system_add_settings_based_on_user_role' ) ) ;

            add_action( 'woocommerce_admin_field_rs_administrator_wrapper_start' , array ( __CLASS__ , 'rs_wrapper_administrator_start' ) ) ;

            add_action( 'woocommerce_admin_field_rs_administrator_wrapper_end' , array ( __CLASS__ , 'rs_wrapper_administrator_close' ) ) ;
        }

        /*
         * Function to Define Name of the Tab
         */

        public static function reward_system_tab_setting( $setting_tabs ) {
            if ( ! is_array( $setting_tabs ) )
                $setting_tabs                            = ( array ) $setting_tabs ;
            $setting_tabs[ 'rewardsystem_advanced' ] = __( 'Advanced' , 'rewardsystem' ) ;
            return $setting_tabs ;
        }

        public static function reward_system_admin_fields() {
            return apply_filters( 'woocommerce_rewardsystem_advanced_settings' , array (
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Advanced Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => 'rs_advanced_setting' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Program' , 'rewardsystem' ) ,
                    'id'      => 'rs_enable_reward_program' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'type'    => 'checkbox' ,
                    'newids'  => 'rs_enable_reward_program' ,
                    'desc'    => __( 'By enabling this checkbox, new users can have the option to involve in the Reward Points Program on the site during registration. For old users, they will have the checkbox to exit from the reward points program on the account page. By default, it will be enabled for old users' , 'rewardsystem' ) ,
                ) ,
                array (
                    'name'    => __( 'Notification on My Account Page - Registration' , 'rewardsystem' ) ,
                    'id'      => 'rs_msg_in_reg_page' ,
                    'std'     => __( 'By selecting this checkbox, you will be involved in Reward Points Program where you can earn points for the actions such as Account Sign up, Product Purchase, Product Review, etc on the site and points earned can be used on future purchases' , 'rewardsystem' ) ,
                    'default' => __( 'By selecting this checkbox, you will be involved in Reward Points Program where you can earn points for the actions such as Account Sign up, Product Purchase, Product Review, etc on the site and points earned can be used on future purchases' , 'rewardsystem' ) ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_msg_in_reg_page' ,
                ) ,
                array (
                    'name'    => __( 'Notification on My Account Page - Checked' , 'rewardsystem' ) ,
                    'id'      => 'rs_msg_in_acc_page_when_checked' ,
                    'std'     => __( 'By unchecking this checkbox, you will not be in part of Reward Points Program' , 'rewardsystem' ) ,
                    'default' => __( 'By unchecking this checkbox, you will not be in part of Reward Points Program' , 'rewardsystem' ) ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_msg_in_acc_page_when_checked' ,
                ) ,
                array (
                    'name'    => __( 'Notification on My Account Page - Unchecked' , 'rewardsystem' ) ,
                    'id'      => 'rs_msg_in_acc_page_when_unchecked' ,
                    'std'     => __( 'By selecting this checkbox, you will be in part of Reward Points Program' , 'rewardsystem' ) ,
                    'default' => __( 'By selecting this checkbox, you will be in part of Reward Points Program' , 'rewardsystem' ) ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_msg_in_acc_page_when_unchecked' ,
                ) ,
                array (
                    'name'    => __( 'Tab section' , 'rewardsystem' ) ,
                    'id'      => 'rs_expand_collapse' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'select' ,
                    'newids'  => 'rs_expand_collapse' ,
                    'options' => array (
                        '1' => __( 'Collapse all' , 'rewardsystem' ) ,
                        '2' => __( 'Expand all' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Show/Hide Reset Button in Tabs' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_reset_all' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'select' ,
                    'newids'  => 'rs_show_hide_reset_all' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Admin Color Scheme' , 'rewardsystem' ) ,
                    'id'      => 'rs_color_scheme' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'select' ,
                    'newids'  => 'rs_color_scheme' ,
                    'options' => array (
                        '1' => __( 'Dark' , 'rewardsystem' ) ,
                        '2' => __( 'Light' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => 'rs_advanced_setting' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Product Purchase Reward Points for Previous Orders' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_apply_reward_points' ,
                ) ,
                array (
                    'name'     => __( 'Award Product Purchase Reward Points for' , 'rewardsystem' ) ,
                    'id'       => 'rs_sumo_select_order_range' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'select' ,
                    'options'  => array (
                        '1' => 'Any Old Orders' ,
                        '2' => 'Orders Placed Between Specific Date Range'
                    ) ,
                    'newids'   => 'rs_sumo_select_order_range' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'type' => 'previous_order_button_range' ,
                ) ,
                array (
                    'name'     => __( 'Previous Order(s) Points for' , 'rewardsystem' ) ,
                    'id'       => 'rs_award_previous_order_points' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'select' ,
                    'options'  => array (
                        '1' => 'Order(s) in which points are not awarded for already purchased products' ,
                        '2' => 'Based on Conversion Settings'
                    ) ,
                    'newids'   => 'rs_award_previous_order_points' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'type' => 'previous_order_button' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_apply_reward_points' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'My Account Page Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_my_acccount_page_settings' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Fields in My Account Page' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enable this option to show the Reward Points Fields in My Account Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_reward_content' ,
                    'type'    => 'checkbox' ,
                    'std'     => 'yes' ,
                    'default' => 'yes' ,
                    'newids'  => 'rs_reward_content' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Fields in Shortcode' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enable this option to show the Reward Points Fields in Shortcode' , 'rewardsystem' ) ,
                    'id'      => 'rs_reward_content_shortcode' ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'newids'  => 'rs_reward_content_shortcode' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_my_acccount_page_settings' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'My Account Menu Page Show/Hide Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_my_acccount_menu_page_show_hide_settings' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Fields in My Account Menu' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enable this option to show the Reward Points Fields in My Account Menu' , 'rewardsystem' ) ,
                    'id'      => 'rs_reward_content_menu_page' ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'newids'  => 'rs_reward_content_menu_page' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Fields display Name on My Account Page' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enter the Title for My Reward Content on My Account Menu Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_my_reward_content_title' ,
                    'type'    => 'text' ,
                    'std'     => 'My Reward' ,
                    'default' => 'My Reward' ,
                    'newids'  => 'rs_my_reward_content_title' ,
                ) ,
                array (
                    'name'    => __( 'Reward Points Fields URL Name on My Account Page' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enter the URL for Reward Points Fields in My Account Menu Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_my_reward_url_title' ,
                    'type'    => 'text' ,
                    'std'     => 'sumo-reward-points' ,
                    'default' => 'sumo-reward-points' ,
                    'newids'  => 'rs_my_reward_url_title' ,
                ) ,
                array (
                    'name'    => __( 'My Rewards Table' , 'rewardsystem' ) ,
                    'id'      => 'rs_my_reward_table_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'newids'  => 'rs_my_reward_table_menu_page' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Generate Referral Link' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_generate_referral_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'newids'  => 'rs_show_hide_generate_referral_menu_page' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Referral Table ' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_referal_table_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'newids'  => 'rs_show_hide_referal_table_menu_page' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'     => __( 'My Cashback Table' , 'rewardsystem' ) ,
                    'id'       => 'rs_my_cashback_table_menu_page' ,
                    'std'      => '1' ,
                    'desc_tip' => true ,
                    'default'  => '1' ,
                    'newids'   => 'rs_my_cashback_table_menu_page' ,
                    'type'     => 'select' ,
                    'options'  => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Nominee Field' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_nominee_field_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'newids'  => 'rs_show_hide_nominee_field_menu_page' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Gift Voucher Field' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_redeem_voucher_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'newids'  => 'rs_show_hide_redeem_voucher_menu_page' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Email - Subscribe Link' , 'rewardsystem' ) ,
                    'id'      => 'rs_show_hide_your_subscribe_link_menu_page' ,
                    'newids'  => 'rs_show_hide_your_subscribe_link_menu_page' ,
                    'class'   => 'rs_show_hide_your_subscribe_link_menu_page' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'select' ,
                    'options' => array (
                        '1' => __( 'Show' , 'rewardsystem' ) ,
                        '2' => __( 'Hide' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_my_acccount_menu_page_show_hide_settings' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_administrator_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Reward Points Menu Restriction based on User Role' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_user_role_menu_restriction_reward_points' ,
                ) ,
                array (
                    'name'    => __( 'User Role based Menu Restriction' , 'rewardsystem' ) ,
                    'desc'    => __( 'Enable this option to restrict the menu based on user role' , 'rewardsystem' ) ,
                    'id'      => 'rs_menu_restriction_based_on_user_role' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'type'    => 'checkbox' ,
                    'newids'  => 'rs_menu_restriction_based_on_user_role' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_user_role_menu_restriction_reward_points' ) ,
                array (
                    'type' => 'rs_administrator_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Coupon Deletion based on Cron Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_delete_coupon_cron_time' ,
                ) ,
                array (
                    'name'    => __( 'Coupon Deletion' , 'rewardsystem' ) ,
                    'id'      => '_rs_enable_coupon_restriction' ,
                    'newids'  => '_rs_enable_coupon_restriction' ,
                    'type'    => 'checkbox' ,
                    'std'     => 'no' ,
                    'default' => 'no' ,
                    'desc'    => 'By Enabling this checkbox, the coupons created on WooCommerce coupon section when points have been applied will be deleted based on cron time.' ,
                ) ,
                array (
                    'name'    => __( 'Delete Coupons ' , 'rewardsystem' ) ,
                    'id'      => '_rs_restrict_coupon' ,
                    'newids'  => '_rs_restrict_coupon' ,
                    'type'    => 'select' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'options' => array (
                        '1' => __( 'After the order has been placed' , 'rewardsystem' ) ,
                        '2' => __( 'Based on cron time' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'    => __( 'Coupon Deletion Cron Time Type' , 'rewardsystem' ) ,
                    'id'      => 'rs_delete_coupon_by_cron_time' ,
                    'newids'  => 'rs_delete_coupon_by_cron_time' ,
                    'type'    => 'select' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'options' => array (
                        '1' => __( 'Days' , 'rewardsystem' ) ,
                        '2' => __( 'Hours' , 'rewardsystem' ) ,
                        '3' => __( 'Minutes' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'              => __( 'Coupon Deletion Cron Time' , 'rewardsystem' ) ,
                    'id'                => 'rs_delete_coupon_specific_time' ,
                    'newids'            => 'rs_delete_coupon_specific_time' ,
                    'type'              => 'number' ,
                    'custom_attributes' => array (
                        'min' => 0
                    ) ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_delete_coupon_specific_settings' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Rank based Reward Points Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_short_code_settings_rank' ,
                ) ,
                array (
                    'name'    => __( 'Rank Table for Total Earned Points to be displayed ' , 'rewardsystem' ) ,
                    'id'      => 'rs_select_pagination_for_total_earned_points' ,
                    'newids'  => 'rs_select_pagination_for_total_earned_points' ,
                    'type'    => 'select' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'options' => array (
                        '1' => __( 'With Pagination' , 'rewardsystem' ) ,
                        '2' => __( 'Without Pagination' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'              => __( 'Enter the number of entries to be displayed' , 'rewardsystem' ) ,
                    'id'                => 'rs_value_without_pagination_for_total_earned_points' ,
                    'newids'            => 'rs_value_without_pagination_for_total_earned_points' ,
                    'type'              => 'number' ,
                    'custom_attributes' => array (
                        'min' => '0'
                    ) ,
                    'std'               => '' ,
                    'default'           => '' ,
                ) ,
                array (
                    'name'    => __( 'Rank Table for Available Points to be displayed ' , 'rewardsystem' ) ,
                    'id'      => 'rs_select_pagination_for_available_points' ,
                    'newids'  => 'rs_select_pagination_for_available_points' ,
                    'type'    => 'select' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'options' => array (
                        '1' => __( 'With Pagination' , 'rewardsystem' ) ,
                        '2' => __( 'Without Pagination' , 'rewardsystem' ) ,
                    ) ,
                ) ,
                array (
                    'name'              => __( 'Enter the number of entries to be displayed' , 'rewardsystem' ) ,
                    'id'                => 'rs_value_without_pagination_for_available_points' ,
                    'newids'            => 'rs_value_without_pagination_for_available_points' ,
                    'type'              => 'number' ,
                    'custom_attributes' => array (
                        'min' => '0'
                    ) ,
                    'std'               => '' ,
                    'default'           => '' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_short_code_settings_rank' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Custom CSS Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'desc' => 'Try !important if styles doesn\'t apply ' ,
                    'id'   => '_rs_general_custom_css_settings' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS' , 'rewardsystem' ) ,
                    'id'      => 'rs_general_custom_css' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_general_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Shop Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_shop_page_custom_css' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_shop_page_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Category Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_category_page_custom_css' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_category_page_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Single Product Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_single_product_page_custom_css' ,
                    'std'     => '.rs_message_for_single_product{ }' ,
                    'default' => '.rs_message_for_single_product{ }' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_single_product_page_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Cart Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_cart_page_custom_css' ,
                    'std'     => '#rs_apply_coupon_code_field { } #mainsubmi { } .fp_apply_reward{ } .rs_cart_message{ }' ,
                    'default' => '#rs_apply_coupon_code_field { } #mainsubmi { } .fp_apply_reward{ } .rs_cart_message{ }' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_cart_page_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Checkout Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_checkout_page_custom_css' ,
                    'std'     => '#rs_apply_coupon_code_field { } #mainsubmi { } .fp_apply_reward{ } .rs_checkout_message{ }' ,
                    'default' => '#rs_apply_coupon_code_field { } #mainsubmi { } .fp_apply_reward{ } .rs_checkout_message{ }' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_checkout_page_custom_css' ,
                ) ,
                array (
                    'name'   => __( 'Custom CSS for My Account Page' , 'rewardsystem' ) ,
                    'id'     => 'rs_myaccount_custom_css' ,
                    'std'    => '#generate_referral_field { }  '
                    . '#rs_redeem_voucher_code { }  '
                    . '#ref_generate_now { } '
                    . ' #rs_submit_redeem_voucher { }'
                    . '.rs_subscriptionoption h3 { }' ,
                    'type'   => 'textarea' ,
                    'newids' => 'rs_myaccount_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Social Button' , 'rewardsystem' ) ,
                    'id'      => 'rs_social_custom_css' ,
                    'std'     => '.rs_social_sharing_buttons{};'
                    . '.rs_social_sharing_success_message' ,
                    'default' => '.rs_social_sharing_buttons{};'
                    . '.rs_social_sharing_success_message' ,
                    'newids'  => 'rs_social_custom_css' ,
                    'type'    => 'textarea' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Refer a Friend Form' , 'rewardsystem' ) ,
                    'id'      => 'rs_refer_a_friend_custom_css' ,
                    'std'     => '#rs_refer_a_friend_form { } #rs_friend_name { } #rs_friend_email { } #rs_friend_subject { } #rs_your_message { } #rs_refer_submit { }' ,
                    'default' => '#rs_refer_a_friend_form { } #rs_friend_name { } #rs_friend_email { } #rs_friend_subject { } #rs_your_message { } #rs_refer_submit { }' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_refer_a_friend_custom_css' ,
                ) ,
                array (
                    'name'    => __( 'Inbuilt Design for Cashback Form' , 'rewardsystem' ) ,
                    'id'      => 'rs_encash_form_inbuilt_design' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'radio' ,
                    'options' => array ( '1' => 'Inbuilt Design' ) ,
                    'newids'  => 'rs_encash_form_inbuilt_design' ,
                ) ,
                array (
                    'name'              => __( 'Inbuilt CSS (Non Editable) for Cashback Form' , 'rewardsystem' ) ,
                    'id'                => 'rs_encash_form_default_css' ,
                    'std'               => '#encashing_form{}
.rs_encash_points_value{}
.error{color:#ED0514;}
.rs_encash_points_reason{}
.rs_encash_payment_method{}
.rs_encash_paypal_address{}
.rs_encash_custom_payment_option_value{}
.rs_encash_submit{}
#rs_encash_submit_button{}
.success_info{}
#encash_form_success_info{}' ,
                    'default'           => '#encashing_form{}
.rs_encash_points_value{}
.error{color:#ED0514;}
.rs_encash_points_reason{}
.rs_encash_payment_method{}
.rs_encash_paypal_address{}
.rs_encash_custom_payment_option_value{}
.rs_encash_submit{}
#rs_encash_submit_button{}
.success_info{}
#encash_form_success_info{}' ,
                    'type'              => 'textarea' ,
                    'custom_attributes' => array (
                        'readonly' => 'readonly'
                    ) ,
                    'newids'            => 'rs_encash_form_default_css' ,
                ) ,
                array (
                    'name'    => __( 'Custom Design for Cashback Form' , 'rewardsystem' ) ,
                    'id'      => 'rs_encash_form_inbuilt_design' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'radio' ,
                    'options' => array ( '2' => 'Custom Design' ) ,
                    'newids'  => 'rs_encash_form_inbuilt_design' ,
                ) ,
                array (
                    'name'    => __( 'Custom CSS for Cashback Form' , 'rewardsystem' ) ,
                    'id'      => 'rs_encash_form_custom_css' ,
                    'std'     => '' ,
                    'default' => '' ,
                    'type'    => 'textarea' ,
                    'newids'  => 'rs_encash_form_custom_css' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_reward_point_general_settings' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Troubleshoot Settings' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_reward_point_troubleshoot_cart_page'
                ) ,
                array (
                    'name'     => __( 'Troubleshoot Before Cart Hook' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can select the different hooks in Cart Page' , 'rewardsystem' ) ,
                    'id'       => 'rs_reward_point_troubleshoot_before_cart' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'radio' ,
                    'options'  => array ( '1' => 'woocommerce_before_cart' , '2' => 'woocommerce_before_cart_table' ) ,
                    'newids'   => 'rs_reward_point_troubleshoot_before_cart' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'name'    => __( 'Redeeming Field display Position in Cart Page' , 'rewardsystem' ) ,
                    'id'      => 'rs_reward_point_troubleshoot_after_cart' ,
                    'std'     => '1' ,
                    'default' => '1' ,
                    'type'    => 'radio' ,
                    'options' => array ( '1' => 'woocommerce_after_cart_table' , '2' => 'woocommerce_cart_coupon' ) ,
                    'newids'  => 'rs_reward_point_troubleshoot_after_cart' ,
                ) ,
                array (
                    'name'     => __( 'Enqueue Tipsy jQuery Library in SUMO Reward Points' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can select to change the load tipsy option if some jQuery conflict occurs' , 'rewardsystem' ) ,
                    'id'       => 'rs_reward_point_enable_tipsy_social_rewards' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'radio' ,
                    'options'  => array ( '1' => 'Enable ' , '2' => 'Disable' ) ,
                    'newids'   => 'rs_reward_point_enable_tipsy_social_rewards' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'name'     => __( 'Enqueue jQuery UI Library in SUMO Reward Points' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can select whether to enqueue the jQuery UI library available within SUMO Reward Points' , 'rewardsystem' ) ,
                    'id'       => 'rs_reward_point_enable_jquery' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'radio' ,
                    'options'  => array ( '1' => 'Enqueue ' , '2' => 'Do not Enqueue' ) ,
                    'newids'   => 'rs_reward_point_enable_jquery' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'name'     => __( 'Enqueue Ajax based Redeeming Library in SUMO Reward Points' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can select whether to enqueue the Ajax based Redeeming library available within SUMO Reward Points' , 'rewardsystem' ) ,
                    'id'       => 'rs_reward_point_enable_ajax_based_redeeming' ,
                    'std'      => '1' ,
                    'default'  => '1' ,
                    'type'     => 'radio' ,
                    'options'  => array ( '1' => 'Enqueue ' , '2' => 'Do not Enqueue' ) ,
                    'newids'   => 'rs_reward_point_enable_ajax_based_redeeming' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'name'     => __( 'Dequeue Select2 Library Version 3.x in SUMO Reward Points' , 'rewardsystem' ) ,
                    'desc'     => __( 'Here you can dequeue the select2 V3.x library in the Front End within SUMO Reward Points' , 'rewardsystem' ) ,
                    'id'       => 'rs_reward_point_dequeue_select2' ,
                    'std'      => 'no' ,
                    'default'  => 'no' ,
                    'type'     => 'checkbox' ,
                    'newids'   => 'rs_reward_point_dequeue_select2' ,
                    'desc_tip' => true ,
                ) ,
                array (
                    'name'     => __( 'Load SUMO Reward Points Script/Styles in' , 'rewardsystem' ) ,
                    'desc'     => __( 'For Footer of the Site Option is experimental why because if your theme doesn\'t contain wp_footer hook then it won\'t work' , 'rewardsystem' ) ,
                    'id'       => 'rs_load_script_styles' ,
                    'newids'   => 'rs_load_script_styles' ,
                    'type'     => 'select' ,
                    'desc_tip' => false ,
                    'options'  => array (
                        'wp_head'   => 'Header of the Site' ,
                        'wp_footer' => 'Footer of the Site (Experimental)'
                    ) ,
                    'std'      => 'wp_head' ,
                    'default'  => 'wp_head' ,
                ) ,
                array (
                    'name'     => __( 'Memory Exhaust Issues' , 'rewardsystem' ) ,
                    'desc'     => __( 'Enable or Disable Memory Exhaust Troubleshoot' , 'rewardsystem' ) ,
                    'id'       => 'rs_load_memory_unit' ,
                    'newids'   => 'rs_load_memory_unit' ,
                    'type'     => 'select' ,
                    'desc_tip' => false ,
                    'options'  => array (
                        '1' => 'Enable' ,
                        '2' => 'Disable'
                    ) ,
                    'std'      => '2' ,
                    'default'  => '2' ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_reward_point_troubleshoot_cart_page' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                array (
                    'type' => 'rs_wrapper_start' ,
                ) ,
                array (
                    'name' => __( 'Experimental Features' , 'rewardsystem' ) ,
                    'type' => 'title' ,
                    'id'   => '_rs_reward_point_table'
                ) ,
                array (
                    'type' => 'rs_add_old_version_points' ,
                ) ,
                array (
                    'name'     => __( 'SUMO Reward Points Payment Gateway for Manual Order' , 'rewardsystem' ) ,
                    'desc'     => __( 'Enable or Disable SUMO Reward Points Payment Gateway for Manual Order' , 'rewardsystem' ) ,
                    'id'       => 'rs_gateway_for_manual_order' ,
                    'newids'   => 'rs_gateway_for_manual_order' ,
                    'std'      => '2' ,
                    'default'  => '2' ,
                    'type'     => 'select' ,
                    'desc_tip' => false ,
                    'options'  => array (
                        '1' => 'Enable' ,
                        '2' => 'Disable'
                    ) ,
                ) ,
                array ( 'type' => 'sectionend' , 'id' => '_rs_reward_point_table' ) ,
                array (
                    'type' => 'rs_wrapper_end' ,
                ) ,
                    )
                    ) ;
        }

        public static function rs_wrapper_administrator_start() {
            ?>
            <div class="rs_adminstrator_wrapper">
                <?php
            }

            public static function rs_wrapper_administrator_close() {
                ?>
            </div>
            <?php
            $user_roles = rs_get_current_user_role() ;
            if ( ! in_array( 'administrator' , $user_roles ) ) {
                ?>
                <style type="text/css">
                    .rs_adminstrator_wrapper{
                        display:none;
                    }
                </style>
                <?php
            }
        }

        public static function reward_system_register_admin_settings() {

            woocommerce_admin_fields( RSAdvancedSetting::reward_system_admin_fields() ) ;
        }

        public static function reward_system_update_settings() {
            woocommerce_update_options( RSAdvancedSetting::reward_system_admin_fields() ) ;
        }

        public static function reward_system_default_settings() {
            foreach ( RSAdvancedSetting::reward_system_admin_fields() as $setting )
                if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
                    add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
                }
        }

        public static function rs_function_to_reset_advanced_tab() {
            $settings = RSAdvancedSetting::reward_system_admin_fields() ;
            RSTabManagement::rs_function_to_reset_setting( $settings ) ;
        }

        public static function add_old_points_for_all_user() {
            ?>
            <tr valign="top">
                <th>
                    <label for="rs_add_old_points_label" style="font-size:14px;font-weight:600;"><?php _e( 'Add the Old Available Points to User(s)' , 'rewardsystem' ) ; ?></label>
                </th>
                <td>
                    <input type="button" value="<?php _e( 'Add Old Points' , 'rewardsystem' ) ; ?>"  id="rs_add_old_points" class="rs_oldpoints_button" name="rs_add_old_points" /><b><span style="font-size: 18px;">(Experimental)</span></b>
                    <img class="gif_rs_sumo_reward_button" src="<?php echo WP_PLUGIN_URL ; ?>/rewardsystem/admin/images/update.gif" style="width:32px;height:32px;position:absolute"/>                         
                </td>
            </tr>
            <?php
        }

        public static function rs_add_date_picker() {
            ?>
            <script type="text/javascript">
                jQuery( function () {
                    jQuery( "#rs_from_date" ).datepicker( {
                        defaultDate : "+1w" ,
                        changeMonth : true ,
                        dateFormat : 'yy-mm-dd' ,
                        numberOfMonths : 1 ,
                        onClose : function ( selectedDate ) {
                            jQuery( "#to" ).datepicker( "option" , "minDate" , selectedDate ) ;
                        }
                    } ) ;
                    jQuery( '#rs_from_date' ).datepicker( 'setDate' , '-1' ) ;
                    jQuery( "#rs_to_date" ).datepicker( {
                        defaultDate : "+1w" ,
                        changeMonth : true ,
                        dateFormat : 'yy-mm-dd' ,
                        numberOfMonths : 1 ,
                        onClose : function ( selectedDate ) {
                            jQuery( "#from" ).datepicker( "option" , "maxDate" , selectedDate ) ;
                        }

                    } ) ;
                    jQuery( "#rs_to_date" ).datepicker( 'setDate' , new Date() ) ;
                } ) ;
            </script>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="rs_sumo_rewards_for_selecting_particular_date"><?php _e( 'Select from Specific Date' , 'rewardsystem' ) ; ?></label>
                </th>
                <td class="forminp forminp-select">
                    From <input type="text" id="rs_from_date" value=""/> To <input type="text" id="rs_to_date" value=""/>
                </td>
            </tr>
            <?php
        }

        public static function rs_process_ajax_points_to_previous_order() {
            if ( isset( $_POST[ 'proceedanyway' ] ) ) {
                if ( $_POST[ 'proceedanyway' ] == '1' ) {
                    $type            = $_POST[ 'typeofpreviousorderpoints' ] ;
                    $replace_points  = $_POST[ 'replace_points' ] ;
                    $orderstatuslist = get_option( 'rs_order_status_control' ) ;
                    $new_order       = array ( 'wc-completed' ) ;
                    foreach ( $orderstatuslist as $each_order ) {
                        $new_order[] = 'wc-' . $each_order ;
                    }
                    if ( $type == '1' ) {
                        $args     = array ( 'post_type' => 'shop_order' , 'numberposts' => '-1' , 'meta_query' => array ( array ( 'key' => 'reward_points_awarded' , 'compare' => 'NOT EXISTS' ) ) , 'post_status' => $new_order , 'fields' => 'ids' , 'cache_results' => false ) ;
                        $order_id = get_posts( $args ) ;
                        echo json_encode( $order_id ) ;
                    } else {
                        $args     = array ( 'post_type' => 'shop_order' , 'numberposts' => '-1' , 'meta_query' => array ( array ( 'key' => 'reward_points_awarded' , 'compare' => 'EXISTS' ) ) , 'post_status' => $new_order , 'fields' => 'ids' , 'cache_results' => false ) ;
                        $order_id = get_posts( $args ) ;
                        echo json_encode( $order_id ) ;
                    }
                }
            }
            exit() ;
        }

        public static function rs_apply_points_for_previous_order_button() {
            ?>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="rs_sumo_rewards_for_previous_order_label"><?php _e( 'Apply Product Purchase Reward Points to Previous Orders' , 'rewardsystem' ) ; ?></label>
                </th>
                <td class="forminp forminp-select">
                    <input type="submit" class="rs_sumo_rewards_for_previous_order button-primary rs_button" value="Apply Points for Previous Orders"/>
                    <img class="gif_rs_sumo_reward_button_for_previous_order" src="<?php echo WP_PLUGIN_URL ; ?>/rewardsystem/admin/images/update.gif" style="width:32px;height:32px;position:absolute"/>
                    <div class="rs_sumo_rewards_previous_order" style="margin-bottom:10px;margin-top:10px; color:green;"></div>
                </td>
            </tr>
            <?php
        }

        public static function rs_send_ajax_points_to_previous_orders() {
            ?>
            <script type="text/javascript">
                jQuery( document ).ready( function () {
                    jQuery( '.gif_rs_sumo_reward_button_for_previous_order' ).css( 'display' , 'none' ) ;
                    jQuery( '.rs_sumo_rewards_for_previous_order' ).click( function () {
                        jQuery( '.gif_rs_sumo_reward_button_for_previous_order' ).css( 'display' , 'inline-block' ) ;
                        jQuery( this ).attr( 'data-clicked' , '1' ) ;
                        var dataclicked = jQuery( this ).attr( 'data-clicked' ) ;
                        var fromdate = jQuery( '#rs_from_date' ).val() ;
                        var todate = jQuery( '#rs_to_date' ).val() ;
                        var typeofpreviousorderpoints = jQuery( '#rs_award_previous_order_points' ).val() ;
                        var orderrange = jQuery( '#rs_sumo_select_order_range' ).val() ;
                        if ( jQuery( '#rs_sumo_select_order_range' ).val() === '1' ) {
                            var dataparam = ( {
                                action : 'previousorderpoints' ,
                                proceedanyway : dataclicked ,
                                typeofpreviousorderpoints : typeofpreviousorderpoints ,
                            } ) ;
                            function getData( id ) {
                                return jQuery.ajax( {
                                    type : 'POST' ,
                                    url : "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" ,
                                    data : ( {
                                        action : 'rssplitajaxoptimizationforpreviousorder' ,
                                        ids : id ,
                                        proceedanyway : dataclicked ,
                                        typeofpreviousorderpoints : typeofpreviousorderpoints ,
                                        orderrange : orderrange
                                    } ) ,
                                    success : function ( response ) {
                                        console.log( response ) ;
                                    } ,
                                    dataType : 'json' ,
                                    async : false
                                } ) ;
                            }
                            jQuery.post( "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" , dataparam ,
                                    function ( response ) {
                                        console.log( response ) ;
                                        if ( response != 'success' ) {
                                            var j = 1 ;
                                            var i , j , temparray , chunk = 10 ;
                                            for ( i = 0 , j = response.length ; i < j ; i += chunk ) {
                                                temparray = response.slice( i , i + chunk ) ;
                                                getData( temparray ) ;
                                            }
                                            jQuery.when( getData() ).done( function ( a1 ) {
                                                console.log( 'Ajax Done Successfully' ) ;
                                                location.reload() ;
                                                jQuery( '.rs_sumo_rewards_previous_order' ).fadeIn() ;
                                                if ( response != '' ) {
                                                    jQuery( '.rs_sumo_rewards_previous_order' ).html( 'Points Successfully Added to Previous Order' ) ;
                                                } else {
                                                    jQuery( '.rs_sumo_rewards_previous_order' ).html( 'There is no order to give points' ) ;
                                                }
                                                jQuery( '.rs_sumo_rewards_previous_order' ).fadeOut( 5000 ) ;
                                            } ) ;
                                        }
                                    } , 'json' ) ;
                        } else {
                            var dataparam = ( {
                                action : 'previousorderpoints' ,
                                proceedanyway : dataclicked ,
                                fromdate : fromdate ,
                                todate : todate ,
                                typeofpreviousorderpoints : typeofpreviousorderpoints ,
                            } ) ;
                            function getDataforDate( id ) {
                                return jQuery.ajax( {
                                    type : 'POST' ,
                                    url : "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" ,
                                    data : ( {
                                        action : 'rssplitajaxoptimizationforpreviousorder' ,
                                        ids : id ,
                                        proceedanyway : dataclicked ,
                                        typeofpreviousorderpoints : typeofpreviousorderpoints ,
                                        orderrange : orderrange ,
                                        fromdate : fromdate ,
                                        todate : todate ,
                                    } ) ,
                                    success : function ( response ) {
                                        console.log( response ) ;
                                    } ,
                                    dataType : 'json' ,
                                    async : false
                                } ) ;
                            }
                            jQuery.post( "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" , dataparam ,
                                    function ( response ) {
                                        console.log( response ) ;
                                        // alert(response);
                                        if ( response != 'success' ) {
                                            var j = 1 ;
                                            var i , j , temparray , chunk = 10 ;
                                            for ( i = 0 , j = response.length ; i < j ; i += chunk ) {
                                                temparray = response.slice( i , i + chunk ) ;
                                                getDataforDate( temparray ) ;
                                            }
                                            jQuery.when( getDataforDate() ).done( function ( a1 ) {
                                                console.log( 'Ajax Done Successfully' ) ;
                                                location.reload() ;
                                                jQuery( '.rs_sumo_rewards_previous_order' ).fadeIn() ;
                                                if ( response != '' ) {
                                                    jQuery( '.rs_sumo_rewards_previous_order' ).html( 'Points Successfully Added to Previous Order' ) ;
                                                } else {
                                                    jQuery( '.rs_sumo_rewards_previous_order' ).html( 'There is no order to give points' ) ;
                                                }
                                                jQuery( '.rs_sumo_rewards_previous_order' ).fadeOut( 5000 ) ;
                                            } ) ;
                                        }
                                    } , 'json' ) ;
                        }
                        return false ;
                    } ) ;
                } ) ;</script>
            <?php
        }

        public static function reward_system_add_settings_based_on_user_role( $settings ) {
            global $wp_roles ;
            $updated_settings = array () ;
            $mainvariable     = array () ;
            global $woocommerce ;
            $newcombinedarray = rs_get_the_menus() ;
            foreach ( $settings as $section ) {
                if ( isset( $section[ 'id' ] ) && '_rs_user_role_menu_restriction_reward_points' == $section[ 'id' ] &&
                        isset( $section[ 'type' ] ) && 'sectionend' == $section[ 'type' ] ) {
                    foreach ( $wp_roles->role_names as $value => $key ) {
                        if ( $key != 'Administrator' && $key != 'Customer' ) {
                            $updated_settings[] = array (
                                'name'     => __( 'Reward Points Menu Restriction For ' . $key . ' User Role' , 'rewardsystem' ) ,
                                'desc'     => __( 'Restrict the Reward Points Menus For ' . $key . ' User role' , 'rewardsystem' ) ,
                                'class'    => 'rewardpoints_userrole_menu_restriction' ,
                                'id'       => 'rewardpoints_userrole_menu_restriction' . $value ,
                                'type'     => 'multiselect' ,
                                'options'  => $newcombinedarray ,
                                'default'  => '' ,
                                'std'      => '' ,
                                'newids'   => 'rewardpoints_userrole_menu_restriction' . $value ,
                                'desc_tip' => true ,
                                    ) ;
                        }
                    }

                    $updated_settings[] = array (
                        'type' => 'sectionend' , 'id'   => '_rs_user_role_menu_restriction_reward_points' ,
                            ) ;
                }

                $updated_settings[] = $section ;
            }

            return $updated_settings ;
        }

        public static function process_chunk_ajax_request_for_previous_orders() {
            if ( isset( $_POST[ 'ids' ] ) ) {
                $products = $_POST[ 'ids' ] ;
                foreach ( $products as $product ) {
                    $order            = new WC_Order( $product ) ;
                    $order_user_id    = rs_get_order_obj( $order ) ;
                    $order_id         = $order_user_id[ 'order_id' ] ;
                    $order_user_id    = $order_user_id[ 'order_userid' ] ;
                    $modified_date    = get_the_time( 'Y-m-d' , $product ) ;
                    $typeofprevious   = $_POST[ 'typeofpreviousorderpoints' ] ;
                    $order_range_type = $_POST[ 'orderrange' ] ;
                    if ( $order_range_type == '1' ) {
                        if ( $typeofprevious == '1' ) {
                            $points_awarded_for_this_order = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product , 'reward_points_awarded' ) ;
                            if ( $points_awarded_for_this_order != 'yes' ) {
                                $new_obj                     = new RewardPointsOrder( $product , $apply_previous_order_points = 'yes' ) ;
                                $new_obj->update_earning_points_for_user() ;
                            }
                        } else {
                            $pointstodelete[]            = self::get_already_earned_points( $order_id , $order_user_id ) ;
                            $totalpoints                 = array_sum( $pointstodelete ) ;
                            self::replace_the_points_already_earned_in_order( $order_id , $order_user_id , $totalpoints ) ;
                            delete_post_meta( $product , 'reward_points_awarded' ) ;
                            delete_post_meta( $product , 'earning_point_once' ) ;
                            $new_obj                     = new RewardPointsOrder( $product , $apply_previous_order_points = 'yes' ) ;
                            $new_obj->update_earning_points_for_user( 'Replaced' ) ;
                        }
                    } else {
                        if ( isset( $_POST[ 'fromdate' ] ) || isset( $_POST[ 'todate' ] ) ) {
                            $FromDate      = strtotime( $_POST[ 'fromdate' ] ) ;
                            $ToDate        = strtotime( $_POST[ 'todate' ] ) ;
                            $DateToCompare = strtotime( $modified_date ) ;
                            if ( ($FromDate <= $DateToCompare) && ($DateToCompare <= $ToDate) ) {
                                if ( $typeofprevious == '1' ) {
                                    $points_awarded_for_this_order = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product , 'reward_points_awarded' ) ;
                                    if ( $points_awarded_for_this_order != 'yes' ) {
                                        $new_obj                     = new RewardPointsOrder( $product , $apply_previous_order_points = 'yes' ) ;
                                        $new_obj->update_earning_points_for_user() ;
                                    }
                                } else {
                                    $pointstodelete[]            = self::get_already_earned_points( $order_id , $order_user_id ) ;
                                    $totalpoints                 = array_sum( $pointstodelete ) ;
                                    self::replace_the_points_already_earned_in_order( $order_id , $order_user_id , $totalpoints ) ;
                                    delete_post_meta( $product , 'reward_points_awarded' ) ;
                                    delete_post_meta( $product , 'earning_point_once' ) ;
                                    $new_obj                     = new RewardPointsOrder( $product , $apply_previous_order_points = 'yes' ) ;
                                    $new_obj->update_earning_points_for_user( 'Replaced' ) ;
                                }
                            }
                        }
                    }
                }
            }
            exit() ;
        }

        public static function replace_the_points_already_earned_in_order( $order_id , $user_id , $totalpoints ) {
            global $wpdb ;
            $table_name  = $wpdb->prefix . 'rspointexpiry' ;
            $table_name1 = $wpdb->prefix . 'rsrecordpoints' ;
            $query       = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE userid = %d AND expirydate = 999999999999" , $user_id ) , ARRAY_A ) ;
            if ( ! empty( $query ) ) {
                $id              = $query[ 'id' ] ;
                $AvailablePoints = $query[ 'earnedpoints' ] - $query[ 'usedpoints' ] ;
                if ( $totalpoints >= $AvailablePoints ) {
                    $PointsToUpdate = $query[ 'usedpoints' ] + $AvailablePoints ;
                } else {
                    $PointsToUpdate = $query[ 'usedpoints' ] + $totalpoints ;
                }
                $wpdb->update( $table_name , array ( 'usedpoints' => $PointsToUpdate ) , array ( 'id' => $id ) ) ;
            }
            $query2 = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE checkpoints = 'PPRP' AND orderid = %d AND userid = %d AND expirydate != 999999999999" , $order_id , $user_id ) , ARRAY_A ) ;
            if ( ! empty( $query2 ) ) {
                $id              = $query2[ 'id' ] ;
                $AvailablePoints = $query2[ 'earnedpoints' ] - $query2[ 'usedpoints' ] ;
                if ( $totalpoints >= $AvailablePoints ) {
                    $PointsToUpdate = $query2[ 'usedpoints' ] + $AvailablePoints ;
                } else {
                    $PointsToUpdate = $query2[ 'usedpoints' ] + $totalpoints ;
                }
                $wpdb->update( $table_name , array ( 'usedpoints' => $PointsToUpdate ) , array ( 'id' => $id ) ) ;
            }
        }

        public static function get_already_earned_points( $order_id , $user_id ) {
            global $wpdb ;
            $earned_points        = 0 ;
            $table_name           = $wpdb->prefix . 'rsrecordpoints' ;
            $rsrecordpoints_table = $wpdb->get_results( $wpdb->prepare( "SELECT earnedpoints,userid FROM $table_name WHERE checkpoints = 'PPRP' AND orderid = %d AND userid = %d" , $order_id , $user_id ) , ARRAY_A ) ;
            foreach ( $rsrecordpoints_table as $earnedpoints ) {
                if ( $earnedpoints[ 'userid' ] == $user_id ) {
                    $earned_points = $earnedpoints[ 'earnedpoints' ] ;
                }
            }
            return $earned_points ;
        }

    }

    RSAdvancedSetting::init() ;
}