/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

jQuery( function ( $ ) {
    var is_blocked = function ( $node ) {
        return $node.is( '.processing' ) ;
    } ;

    var block = function ( $node ) {
        $node.addClass( 'processing' ).block( {
            message : null ,
            overlayCSS : {
                background : '#fff' ,
                opacity : 0.6
            }
        } ) ;
    } ;
    var unblock = function ( $node ) {
        $node.removeClass( 'processing' ).unblock() ;
    } ;

    var another_common_syntax = function ( $node ) {
        var $html = $.parseHTML( $node ) ;
        var $sumomessage = $( 'div.sumo_reward_points_info_message' , $html ) ;
        var $complete_message = $( 'div.sumo_reward_points_complete_message' , $html ) ;
        var $current_point_message = $( 'div.sumo_reward_points_current_points_message' , $html ) ;
        var $autoredeem_message = $( 'div.sumo_reward_points_auto_redeem_message' , $html ) ;
        var $autoredeem_error_message = $( 'div.sumo_reward_points_auto_redeem_error_message' , $html ) ;
        var $manualredeem_message = $( 'div.sumo_reward_points_manual_redeem_message' , $html ) ;
        var $manualredeem_error_message = $( 'div.sumo_reward_points_manual_redeem_error_message' , $html ) ;
        var $load_script = $( 'div.sumo_reward_point_hide_field_script' , $html ) ;
        var $apply_discount = $( 'div.sumo_reward_points_cart_apply_discount' , $html ).closest( 'form' ) ;
        var $apply_discou = $( 'div.sumo_reward_points_coupon_error_message' , $html ).closest( 'form' ) ;

        show_notice( $sumomessage , false ) ;
        show_notice( $complete_message , false ) ;
        show_notice( $current_point_message , false ) ;
        show_notice( $autoredeem_message , false ) ;
        show_notice( $autoredeem_error_message , false ) ;
        show_notice( $manualredeem_message , false ) ;
        show_notice( $manualredeem_error_message , false ) ;
        show_notice( $load_script , false ) ;
        show_notice( $apply_discou , false ) ;

        $( 'div.woocommerce' ).prepend( $apply_discount ) ;
    } ;

    var common_syntax = function ( $node ) {
        var $html = $.parseHTML( $node , true ) ;
        var $html_data = $( $.parseHTML( $node ) ).filter( ".cart_totals" ) ;
        var $sumomessage = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_info_message' ) ;
        var $complete_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_complete_message' ) ;
        var $current_point_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_current_points_message' ) ;
        var $autoredeem_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_auto_redeem_message' ) ;
        var $autoredeem_error_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_auto_redeem_error_message' ) ;
        var $manualredeem_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_manual_redeem_message' ) ;
        var $manualredeem_error_message = $( $.parseHTML( $node ) ).filter( '.sumo_reward_points_manual_redeem_error_message' ) ;
        var $load_script = $( $html ).filter( 'div.sumo_reward_point_hide_field_script' ) ;
        var $apply_discount = $( 'div.sumo_reward_points_cart_apply_discount' , $html ).closest( 'form' ) ;
        if ( $load_script.length > 0 ) {
            $( 'div.sumo_reward_points_cart_apply_discount' , $html ).closest( 'form' ).hide() ;
        } else {
            $( 'div.woocommerce' ).prepend( $apply_discount ) ;
        }

        show_notice( $sumomessage , false ) ;
        show_notice( $complete_message , false ) ;
        show_notice( $current_point_message , false ) ;
        show_notice( $autoredeem_message , false ) ;
        show_notice( $autoredeem_error_message , false ) ;
        show_notice( $manualredeem_message , false ) ;
        show_notice( $manualredeem_error_message , false ) ;
        show_notice( $load_script , false ) ;
        //show_notice($apply_discount, false);

        $( 'div.cart_totals' ).replaceWith( $html_data ) ;


    } ;

    var update_wc_div = function ( html_str ) {
        var $html = $.parseHTML( html_str ) ;
        var $new_form = $( 'table.shop_table.cart' , $html ).closest( 'form' ) ;
        var $new_totals = $( '.cart_totals' , $html ) ;

        // Error message collection
        var $error = $( '.woocommerce-error' , $html ) ;

        var $message = $( '.woocommerce-message' , $html ) ;
        if ( $new_form.length === 0 ) {
            // No items to display now! Replace all cart content.
            var $cart_html = $( '.cart-empty' , $html ).closest( '.woocommerce' ) ;
            $( 'table.shop_table.cart' ).closest( '.woocommerce' ).replaceWith( $cart_html ) ;

            if ( $error.length > 0 ) {
            } else if ( $message.length > 0 ) {
                show_notice( $message , $( '.cart-empty' ).closest( '.woocommerce' ) ) ;
            }
        } else {
            $( 'table.shop_table.cart' ).closest( 'form' ).replaceWith( $new_form ) ;
            $( 'table.shop_table.cart' ).closest( 'form' ).find( 'input[name="update_cart"]' ).prop( 'disabled' , true ) ;

            if ( $error.length > 0 ) {
            } else if ( $message.length > 0 ) {
                show_notice( $message ) ;
            }

            update_cart_totals_div( $new_totals ) ;
        }

        $( document.body ).trigger( 'updated_wc_div' ) ;
    } ;

    var update_cart_totals_div = function ( html_str ) {
        $( '.cart_totals' ).replaceWith( html_str ) ;
        $( document.body ).trigger( 'updated_cart_totals' ) ;
    } ;

    var show_notice = function ( html_element , $target ) {
        $target = $( 'table.shop_table.cart' ).closest( 'form' ) ;

        $target.before( html_element ) ;
    } ;

    var cart = {
        /**
         * Initialize cart UI events.
         */
        init : function () {

            this.cart_apply_redeeming = this.cart_apply_redeeming.bind( this ) ;
            this.submit_click = this.submit_click.bind( this ) ;
            this.apply_sumo_reward_points = this.apply_sumo_reward_points.bind( this ) ;
            this.quantity_update_cart = this.quantity_update_cart.bind( this ) ;
            this.apply_coupon = this.apply_coupon.bind( this ) ;
            this.quantity_update = this.quantity_update.bind( this ) ;
            this.item_remove_clicked = this.item_remove_clicked.bind( this ) ;
//            this.apply_redeeming_button = this.apply_redeeming_button.bind( this ) ;
            this.remove_coupon_clicked = this.remove_coupon_clicked.bind( this ) ;
            this.update_cart = this.update_cart.bind( this ) ;
            this.add_free_product = this.add_free_product.bind( this ) ;
            this.cart_submit = this.cart_submit.bind( this ) ;

            $( document ).on(
                    'updated_wc_div' ,
                    this.display_notice ) ;

            $( document ).on(
                    'submit' ,
                    'div.woocommerce > form' ,
                    this.quantity_update_cart ) ;


            $( document ).on(
                    'submit' ,
                    'div.woocommerce > form' ,
                    this.cart_apply_redeeming ) ;


//            $( document ).on(
//                    'submit' ,
//                    'div.woocommerce > form' ,
//                    this.apply_redeeming_button ) ;

            $( document ).on(
                    'click' ,
                    '.rs_button_redeem_cart input[type=submit]' ,
                    this.submit_click ) ;

            $( document ).on(
                    'click' ,
                    '.rs_button_redeem_checkout input[type=submit]' ,
                    this.submit_click ) ;

            $( document ).on(
                    'click' ,
                    'td.product-remove > a' ,
                    this.item_remove_clicked ) ;

            $( document ).on(
                    'click' ,
                    'a.woocommerce-remove-coupon' ,
                    this.remove_coupon_clicked ) ;

            $( document ).on(
                    'click' ,
                    'a.add_removed_free_product_to_cart' ,
                    this.add_free_product ) ;
            $( document ).on(
                    'submit' ,
                    'div.woocommerce:not(.widget_product_search) > form' ,
                    this.cart_submit ) ;

        } ,
        display_notice : function () {
            var $clicked = $( 'input[type=submit][clicked=true]' ) ;
            if ( $clicked.is( 'input[name="rs_apply_coupon_code2"]' ) && jQuery( "#mainsubmi" ).closest( 'form' ).is( ':visible' ) && $( 'a.woocommerce-remove-coupon' ).length ) {
                jQuery( "#mainsubmi" ).closest( 'form' ).hide() ;
            }
        } ,
        cart_submit : function ( evt ) {
            var $form = $( evt.currentTarget ) ;
            var $submit = $( document.activeElement ) ;
            var $clicked = $( 'input[type=submit][clicked=true]' ) ;
            if ( $clicked.is( '[name="apply_coupon"]' ) || $submit.is( '#coupon_code' ) ) {
                evt.preventDefault() ;
                this.apply_coupon( $form ) ;
            }
        } ,
        apply_coupon : function ( $form ) {
            block( $form ) ;
            $( '.sumo_reward_points_info_message,.sumo_reward_points_current_points_message, .sumo_reward_points_auto_redeem_message, .sumo_reward_points_auto_redeem_error_message, .sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount' ).remove() ;
            var data = {
                action : 'sumo_apply_coupon' ,
            } ;
            $.ajax( {
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                type : 'post' ,
                //dataType: 'html',
                success : function ( response ) {
                    another_common_syntax( response ) ;
//                    location.reload();

                }
            } ) ;

        } ,
        add_free_product : function ( evt ) {
            var data = {
                action : 'delete_meta_current_key' ,
                current_user_id : sumo_global_variable_js.user_id ,
                key_to_remove : $( evt.target ).data( 'cartkey' ) ,
            } ;
            $.ajax( {
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                type : 'post' ,
                //dataType: 'html',
                success : function ( response ) {
                    var newresponse = response.replace( /\s/g , '' ) ;
                    if ( newresponse === '1' ) {
                        location.reload( true ) ;
                    }
                }
            } ) ;


        } ,
        item_remove_clicked : function ( evt ) {
            evt.preventDefault() ;
            var $a = $( evt.target ) ;
            var $form = $a.parents( 'form' ) ;
            block( $form ) ;
            block( $( 'div.cart_totals' ) ) ;
            $( '.sumo_reward_points_info_message,.sumo_reward_points_current_points_message, .sumo_reward_points_auto_redeem_message, .sumo_reward_points_auto_redeem_error_message, .sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount' ).remove() ;
            $.ajax( {
                type : 'GET' ,
                url : $a.attr( 'href' ) ,
                dataType : 'html' ,
//Commented because messages in Cart and Checkout display twice                success: another_common_syntax,
                complete : function () {
                    unblock( $form ) ;
                    unblock( $( 'div.cart_totals' ) ) ;
//Commented Because Undo option in Cart not displayed when product is removed                    location.reload();
                }
            } ) ;
        } ,
        remove_coupon_clicked : function ( evt ) {
            evt.preventDefault() ;
            $form = $( 'table.shop_table.cart' ).closest( 'form' ) ;
            var $datacoupon = $( evt.target ).data( 'coupon' ) ;
            var data = {
                action : 'sumo_remove_coupon' ,
                coupon : $datacoupon ,
            } ;
            $.ajax( {
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                dataType : 'html' ,
                type : 'post' ,
                success : function ( response ) {
                    $( '.sumo_reward_points_auto_redeem_message,.sumo_reward_points_auto_redeem_error_message,.sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount,sumo_reward_points_coupon_error_message' ).remove() ;
                    another_common_syntax( response ) ;
                    console.log( response ) ;
                }
            } ) ;
        } ,
        quantity_update_cart : function ( evt ) {
            var $clicked = $( 'input[type=submit][clicked=true]' ) ;
            if ( $clicked.is( '[name="update_cart"]' ) ) {
                this.update_cart() ;

            }
        } ,
        quantity_update : function () {
            var $form = $( 'table.shop_table.cart' ).closest( 'form' ) ;
            block( $( 'div.cart_totals' ) ) ;
            var data = {
                action : 'sumo_updated_cart_total' ,
            } ;
            $.ajax( {
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                dataType : 'html' ,
                //async:false,
                success : function ( response ) {
                    $( '.sumo_reward_points_complete_message,.sumo_reward_points_info_message, .sumo_reward_points_current_points_message, .sumo_reward_points_auto_redeem_message, .sumo_reward_points_auto_redeem_error_message, .sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount' ).remove() ;
                    common_syntax( response ) ;
                    $( document.body ).trigger( 'updated_cart_totals' ) ;
                } ,
                complete : function () {
                    unblock( $form ) ;
                    unblock( $( 'div.cart_totals' ) ) ;
                    location.reload() ;
                }
            } ) ;


        } ,
        /**
         * Update entire cart via ajax.
         */
        update_cart : function () {
            var $form = $( 'table.shop_table.cart' ).closest( 'form' ) ;

            block( $form ) ;
            block( $( 'div.cart_totals' ) ) ;

            // Make call to actual form post URL.
            $.ajax( {
                type : $form.attr( 'method' ) ,
                url : $form.attr( 'action' ) ,
                data : $form.serialize() ,
                dataType : 'html' ,
                success : function ( response ) {
                    update_wc_div( response ) ;
                } ,
                complete : function () {
                    unblock( $form ) ;
                    unblock( $( 'div.cart_totals' ) ) ;
                    cart.quantity_update() ;
                }
            } ) ;
        } ,
        /**
         * Update the cart after something has changed.
         */
        update_cart_totals_sumo : function () {
            block( $( 'div.cart_totals' ) ) ;
            var data = {
                action : 'sumo_updated_cart_total' ,
            } ;
            $.ajax( {
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                dataType : 'html' ,
                success : function ( response ) {

                    $( '.sumo_reward_points_info_message,.sumo_reward_points_current_points_message, .sumo_reward_points_auto_redeem_message, .sumo_reward_points_auto_redeem_error_message, .sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount' ).remove() ;
                    common_syntax( response ) ;
                    $( document.body ).trigger( 'updated_cart_totals' ) ;
                }
            } ) ;
        } ,
        cart_apply_redeeming : function ( evt ) {
            var $form = $( evt.target ) ;
            var $submit = $( document.activeElement ) ;
            var $clicked = $( 'input[type=submit][clicked=true]' ) ;
            if ( $clicked.is( '[name="rs_apply_coupon_code"]' ) || $submit.is( '#rs_apply_coupon_code_field' ) || $clicked.is( 'input[name="rs_apply_coupon_code1"]' ) || $clicked.is( 'input[name="rs_apply_coupon_code2"]' ) ) {
                var $text_field = $( '#rs_apply_coupon_code_field' ) ;
                var coupon_code = $text_field.val() ;
                var minimum_points = sumo_global_variable_js.minimum_points ;
                var maximum_points = sumo_global_variable_js.maximum_points ;
                console.log( minimum_points ) ;
                console.log( maximum_points ) ;
                if ( maximum_points != '' && minimum_points != '' ) {
                    if ( parseInt( maximum_points ) >= coupon_code && parseInt( minimum_points ) <= coupon_code ) {
                        cart.apply_sumo_reward_points( $form , '1' ) ;
                    } else {
                        $( '.rs_warning_message' ).html( sumo_global_variable_js.min_max_error ).css( 'color' , 'red' ) ;
                        return false ;
                    }
                } else if ( minimum_points != '' ) {
                    if ( parseInt( minimum_points ) <= coupon_code ) {
                        cart.apply_sumo_reward_points( $form , '1' ) ;
                    } else {
                        $( '.rs_warning_message' ).html( sumo_global_variable_js.min_error ).css( 'color' , 'red' ) ;
                        return false ;
                    }
                } else if ( maximum_points != '' ) {
                    if ( parseInt( maximum_points ) >= coupon_code ) {
                        cart.apply_sumo_reward_points( $form , '1' ) ;
                    } else {
                        $( '.rs_warning_message' ).html( sumo_global_variable_js.max_error ).css( 'color' , 'red' ) ;
                        return false ;
                    }

                } else if ( maximum_points == '' && minimum_points == '' ) {
                    cart.apply_sumo_reward_points( $form , '1' ) ;
                }

            }
        } ,
        /*Commented for Creating Multiple Coupon*/
//        apply_redeeming_button : function ( evt ) {
//            var $form = $( evt.target ) ;
//            $( $( evt.target ).attr( 'disabled' , 'disabled' ) ) ;
//            var $submit = $( document.activeElement ) ;
//            var $clicked = $( 'input[type=submit][clicked=true]' ) ;
//            if ( 1 === $form.find( 'table.shop_table.cart' ).length ) {
//                return false ;
//            }
//            if ( $clicked.is( 'input[name="rs_apply_coupon_code1"]' ) || $submit.is( "#mainsubmi" ) || $clicked.is( 'input[name="rs_apply_coupon_code2"]' ) || $clicked.is( 'input[name="rs_apply_coupon_code"]' ) ) {		//Changed to due to IOS Problem where button type not working
//                var $text_field = $( '#rs_apply_coupon_code_field' ) ;
//                var coupon_code = $text_field.val() ;
//                var minimum_points = sumo_global_variable_js.minimum_points ;
//                var maximum_points = sumo_global_variable_js.maximum_points ;
//                console.log( minimum_points ) ;
//                console.log( maximum_points ) ;
//                if ( maximum_points != '' && minimum_points != '' ) {
//                    if ( parseInt( maximum_points ) >= coupon_code && parseInt( minimum_points ) <= coupon_code ) {
//                        cart.apply_sumo_reward_points( $form , '1' ) ;
//                    } else {
//                        $( '.rs_warning_message' ).html( sumo_global_variable_js.min_max_error ).css( 'color' , 'red' ) ;
//                        return false ;
//                    }
//                } else if ( minimum_points != '' ) {
//                    if ( parseInt( minimum_points ) <= coupon_code ) {
//                        cart.apply_sumo_reward_points( $form , '1' ) ;
//                    } else {
//                        $( '.rs_warning_message' ).html( sumo_global_variable_js.min_error ).css( 'color' , 'red' ) ;
//                        return false ;
//                    }
//                } else if ( maximum_points != '' ) {
//                    if ( parseInt( maximum_points ) >= coupon_code ) {
//                        cart.apply_sumo_reward_points( $form , '1' ) ;
//                    } else {
//                        $( '.rs_warning_message' ).html( sumo_global_variable_js.max_error ).css( 'color' , 'red' ) ;
//                        return false ;
//                    }
//                } else if ( maximum_points == '' && minimum_points == '' ) {
//                    cart.apply_sumo_reward_points( $form , '1' ) ;
//                }
//
//            }
//
//        } ,
        /**
         * Special handling to identify which submit button was clicked.
         *
         * @param {Object} evt The JQuery event
         */
        submit_click : function ( evt ) {
            $( 'input[type=submit]' , $( evt.target ).parents( 'form' ) ).removeAttr( 'clicked' ) ;
            $( evt.target ).attr( 'clicked' , 'true' ) ;
        } ,
        /**
         * Apply Coupon code
         *
         * @param {JQuery Object} $form The cart form.
         */
        apply_sumo_reward_points : function ( $form , $data_variation ) {
            $form = $( 'table.shop_table.cart' ).closest( 'form' ) ;
            block( $form ) ;
            var cart = this ;
            var $text_field = $( '#rs_apply_coupon_code_field' ) ;
            var coupon_code = $text_field.val() ;
            var data = {
                rs_apply_coupon_code : "yes" ,
                rs_apply_coupon_code_field : coupon_code ,
                action : 'rs_apply_sumo_reward_points_redeeming' ,
            } ;

            $.ajax( {
                type : 'POST' ,
                url : sumo_global_variable_js.wp_ajax_url ,
                data : data ,
                dataType : 'html' ,
                success : function ( response ) {
                    $( '.woocommerce-error,.sumo_reward_points_info_message,.sumo_reward_points_current_points_message, .sumo_reward_points_auto_redeem_message, .sumo_reward_points_auto_redeem_error_message, .sumo_reward_points_manual_redeem_message, .sumo_reward_points_manual_redeem_error_message, .sumo_reward_point_hide_field_script, .sumo_reward_points_cart_apply_discount' ).remove() ;
                    show_notice( response ) ;
                    $( document.body ).trigger( 'applied_coupon' ) ;
                } ,
                complete : function () {
                    unblock( $form ) ;
                    unblock( $( 'div.cart_totals' ) ) ;
                    $( 'div.rs_warning_message' ).hide() ;
                    cart.update_cart_totals_sumo() ;
                    cart.update_cart() ;
                    $( 'input[name="rs_apply_coupon_code1"]' ).removeAttr( 'disabled' ) ;
                }
            } ) ;

        } ,
    } ;
    cart.init() ;

} ) ;