
jQuery(function ($) {

    var FPRewardAction = {
        init: function () {
            $(document).on('click', '#rs_enable_earn_points_for_user', this.allow_user_to_earn_points);
        },
        allow_user_to_earn_points: function (event) {
            event.preventDefault();
            var checkbox_value = jQuery('#rs_enable_earn_points_for_user').is(':checked') == true ? 'yes' : 'no';
            var con = checkbox_value == 'yes' ? confirm('Are you sure do you want to be in part of Reward Points Program?') : confirm('Are you sure do you want to exit the Reward Points Program?');
            if (con) {
                FPRewardAction.block('.enable_reward_points');
                var data = {
                    action: 'allow_user_to_earn_points',
                    user_id: enablerewardpoints_params.user_id,
                    enable_reward_points: checkbox_value,
                    sumo_security: enablerewardpoints_params.enable_option_nonce
                };
                $.post(enablerewardpoints_params.ajaxurl, data, function (response) {
                    if (true === response.success) {
                        FPRewardAction.unblock('.enable_reward_points');
                        window.location.reload(true);
                    } else {
                        window.alert(response.data.error);
                        FPRewardAction.unblock('.enable_reward_points');
                    }
                });
            }
            return false;
        },
        block: function (id) {
            $(id).block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });
        },
        unblock: function (id) {
            $(id).unblock();
        },
    };
    FPRewardAction.init();
});
