
jQuery( function ( $ ) {

    var FPAdminScripts = {
        init : function () {
            jQuery( '.gif_rs_sumo_reward_button_for_unsubscribe' ).css( 'display' , 'none' ) ;
            $( document ).on( 'click' , '.rs_add_rule_for_custom_reg_field' , this.append_rule_for_cus_reg_field ) ;
            $( document ).on( 'click' , '.rs_remove_rule_for_custom_reg_field' , this.remove_rule_for_cus_reg_field ) ;
            $( document ).on( 'change' , '.rs_search_custom_field' , this.get_selected_field_type ) ;
            $( document ).on( 'click' , '#rs_enable_reward_program' , this.save_reward_program_disable_option ) ;
            $( document ).on( 'click' , '.rs_sumo_point_price_button' , this.bulk_update_points_for_point_price_product ) ;
            $( document ).on( 'click' , '.rs_sumo_reward_button' , this.bulk_update_points_for_product_purchase ) ;
            $( document ).on( 'click' , '.rs_unsubscribe_user' , this.unsubscribe_selected_user ) ;
            $( document ).on( 'click' , '.rs_bulk_update_button_for_buying_points' , this.bulk_update_points_for_buying_reward ) ;
            $( document ).on( 'click' , '.rs_sumo_reward_button_social' , this.bulk_update_points_for_social_reward ) ;
            $( 'body' ).on( 'blur' , adminscripts_params.field_ids , this.validation_in_product_settings_on_blur ) ;
            $( 'body' ).on( 'keyup change' , adminscripts_params.field_ids , this.validation_in_product_settings_on_keyup ) ;
            $( 'body' ).on( 'click' , 'body' , this.validation_in_product_settings_on_body_click ) ;
        } ,
        unsubscribe_selected_user : function () {
            jQuery( '.gif_rs_sumo_reward_button_for_unsubscribe' ).css( 'display' , 'inline-block' ) ;
            var unsubscribe = jQuery( '#rs_select_user_to_unsubscribe' ).val() ;
            var emailsubject = jQuery( '#rs_subject_for_user_unsubscribe' ).val() ;
            var emailmessage = jQuery( '#rs_message_for_user_unsubscribe' ).val() ;
            var data = ( {
                action : 'rs_unsubscribe_user_by_admin' ,
                unsubscribe : unsubscribe ,
                emailsubject : emailsubject ,
                emailmessage : emailmessage ,
                sumo_security : adminscripts_params.rs_unsubscribe_email
            } ) ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    console.log( 'Ajax Done Successfully' ) ;
                    jQuery( '.button-primary' ).trigger( 'click' ) ;
                    jQuery( '.gif_rs_sumo_reward_button_for_unsubscribe' ).css( 'display' , 'none' ) ;
                } else {
                    window.alert( response.data.error ) ;
                }
            } ) ;
        } ,
        validation_in_product_settings_on_blur : function () {
            $( '.wc_error_tip' ).fadeOut( '100' , function () {
                $( this ).remove() ;
            } ) ;
            return this ;
        } ,
        validation_in_product_settings_on_keyup : function () {
            var value = $( this ).val() ;
            var regex = new RegExp( "[^\+0-9\%.\\" + woocommerce_admin.mon_decimal_point + "]+" , "gi" ) ;
            var newvalue = value.replace( regex , '' ) ;

            if ( value !== newvalue ) {
                $( this ).val( newvalue ) ;
                if ( $( this ).parent().find( '.wc_error_tip' ).size() == 0 ) {
                    $( this ).after( '<div class="wc_error_tip">' + woocommerce_admin.i18n_mon_decimal_error + " Negative Values are not allowed" + '</div>' ) ;
                    $( '.wc_error_tip' )
                            .css( 'left' , offset.left + $( this ).width() - ( $( this ).width() / 2 ) - ( $( '.wc_error_tip' ).width() / 2 ) )
                            .css( 'top' , offset.top + $( this ).height() )
                            .fadeIn( '100' ) ;
                }
            }
            return this ;
        } ,
        validation_in_product_settings_on_body_click : function () {
            $( '.wc_error_tip' ).fadeOut( '100' , function () {
                $( this ).remove() ;
            } ) ;
            return this ;
        } ,
        save_reward_program_disable_option : function () {
            if ( jQuery( '#rs_enable_reward_program' ).is( ':checked' ) == false ) {
                if ( confirm( 'Are you sure do you want to turn off this option? Please note, If You Turn Off this option ,then all the users on your site will be in part of SUMO Reward Points)' ) ) {
                    return true ;
                }
                return false ;
            }
        } ,
        append_rule_for_cus_reg_field : function ( event ) {
            event.preventDefault() ;
            FPAdminScripts.block( '.rs_rule_for_custom_reg_field' ) ;
            var count = parseInt( $( 'input#rs_rule_id_for_custom_reg_field:last' ).val() ) ;
            count = count + 1 || 0 ;
            var data = {
                action : 'rs_add_rule_for_cus_reg_fields' ,
                count : count ,
                sumo_security : adminscripts_params.rs_rule_for_cus_reg_fields
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    $( '#rs_append_rule_for_custom_reg_field' ).append( response.data.content ) ;
                    FPAdminScripts.unblock( '.rs_rule_for_custom_reg_field' ) ;
                    jQuery( 'body' ).trigger( 'wc-enhanced-select-init' ) ;
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_rule_for_custom_reg_field' ) ;
                }
            } ) ;
        } ,
        get_selected_field_type : function ( event ) {
            event.preventDefault() ;
            var $this = $( event.currentTarget ) ;
            var count = $( $this ).closest( 'tr' ).find( '#rs_rule_id_for_custom_reg_field' ).val() ;
            var key = count + 1 || 0 ;
            var data = {
                action : 'rs_get_cus_field_type' ,
                field_id : $( $this ).val() ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    $( $this ).closest( 'tr' ).find( '.rs_label_for_cus_field_type' ).html( response.data.content ) ;
                    $( $this ).closest( 'tr' ).find( '.rs_label_for_cus_field_type_hidden' ).val( response.data.content ) ;
                    if ( response.data.content == 'DATEPICKER' ) {
                        $( $this ).closest( 'tr' ).find( '.rs_label_for_datepicker_type' ).html( '<select style="width:50% !important;" name="rs_rule_for_custom_reg_field[' + key + '][repeat_points]"><option value="no">No</option><option value="yes">Yes</option></select>' ) ;
                        $( $this ).closest( 'tr' ).find( '.rs_label_award_points_for_filling_datepicker' ).html( '<input type="checkbox" name="rs_rule_for_custom_reg_field[' + key + '][award_points_for_filling]"/>' ) ;
                    } else {
                        $( $this ).closest( 'tr' ).find( '.rs_label_for_datepicker_type' ).html( 'N/A' ) ;
                        $( $this ).closest( 'tr' ).find( '.rs_label_award_points_for_filling_datepicker' ).html( 'N/A' ) ;
                    }
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_rule_for_custom_reg_field' ) ;
                }
            } ) ;
        } ,
        remove_rule_for_cus_reg_field : function ( event ) {
            event.preventDefault() ;
            var $this = $( event.currentTarget ) ;
            $( $this ).parent().parent().remove() ;
        } ,
        bulk_update_points_for_point_price_product : function ( event ) {
            event.preventDefault() ;
            FPAdminScripts.block( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
            jQuery( '.gif_rs_sumo_point_price_button' ).css( 'display' , 'inline-block' ) ;
            var whichproduct = jQuery( '#rs_which_point_precing_product_selection' ).val() ;
            var enabledisablepoints = jQuery( '#rs_local_enable_disable_point_price' ).val() ;
            var pointpricetype = jQuery( '#rs_local_point_price_type' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_products_for_point_price' ).val() ;
            var pricepoints = jQuery( '#rs_local_price_points' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_categories_for_point_price' ).val() ;
            var pointpricingtype = jQuery( '#rs_local_point_pricing_type' ).val() ;
            var pricing_category_types = jQuery( '#rs_local_point_pricing_type' ).val() ;
            jQuery( this ).attr( 'data-clicked' , '1' ) ;
            var dataclicked = jQuery( this ).attr( 'data-clicked' ) ;
            var data = {
                action : 'previousproductpointpricevalue' ,
                sumo_security : adminscripts_params.point_price_bulk_update ,
                proceedanyway : dataclicked ,
                whichproduct : whichproduct ,
                enabledisablepoints : enabledisablepoints ,
                pointpricetype : pointpricetype ,
                selectedproducts : selectparticularproducts ,
                pricepoints : pricepoints ,
                selectedcategories : selectedcategories ,
                pointpricingtype : pointpricingtype ,
                pricing_category_types : pricing_category_types
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    if ( response.data.content !== 'success' ) {
                        var j = 1 ;
                        var i , j , temparray , chunk = 10 ;
                        for ( i = 0 , j = response.data.content.length ; i < j ; i += chunk ) {
                            temparray = response.data.content.slice( i , i + chunk ) ;
                            FPAdminScripts.chunk_and_update_points_for_point_price_product( temparray ) ;
                        }
                        jQuery.when( FPAdminScripts.chunk_and_update_points_for_point_price_product( 'done' ) ).done( function ( a1 ) {
                            console.log( 'Ajax Done Successfully' ) ;
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        } ) ;
                    } else {
                        var newresponse = response.data.content.replace( /\s/g , '' ) ;
                        if ( newresponse === 'success' ) {
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        }
                    }
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                }
            } ) ;
        } ,
        chunk_and_update_points_for_point_price_product : function ( id ) {
            jQuery( '.gif_rs_sumo_point_price_button' ).css( 'display' , 'inline-block' ) ;
            var enabledisablepoints = jQuery( '#rs_local_enable_disable_point_price' ).val() ;
            var pointpricetype = jQuery( '#rs_local_point_price_type' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_products_for_point_price' ).val() ;
            var pricepoints = jQuery( '#rs_local_price_points' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_categories_for_point_price' ).val() ;
            var pointpricingtype = jQuery( '#rs_local_point_pricing_type' ).val() ;
            var pricing_category_types = jQuery( '#rs_local_point_pricing_type' ).val() ;
            var data = {
                action : 'rssplitajaxoptimizationforpointprice' ,
                sumo_security : adminscripts_params.point_price_bulk_update ,
                ids : id ,
                enabledisablepoints : enabledisablepoints ,
                selectedproducts : selectparticularproducts ,
                pointpricetype : pointpricetype ,
                pricepoints : pricepoints ,
                pointpricetype : pointpricetype ,
                selectedcategories : selectedcategories ,
                pointpricingtype : pointpricingtype ,
                pricing_category_types : pricing_category_types
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    console.log( 'Ajax Done Successfully' ) ;
                } else {
                    window.alert( response.data.error ) ;
                }
            } ) ;
        } ,
        bulk_update_points_for_product_purchase : function ( event ) {
            event.preventDefault() ;
            FPAdminScripts.block( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
            jQuery( '.gif_rs_sumo_reward_button' ).css( 'display' , 'inline-block' ) ;
            var whichproduct = jQuery( '#rs_which_product_selection' ).val() ;
            var enabledisablereward = jQuery( '#rs_local_enable_disable_reward' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_products' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_categories' ).val() ;
            var rewardtype = jQuery( '#rs_local_reward_type' ).val() ;
            var rewardpoints = jQuery( '#rs_local_reward_points' ).val() ;
            var rewardpercent = jQuery( '#rs_local_reward_percent' ).val() ;
            var enabledisablereferralreward = jQuery( '#rs_local_enable_disable_referral_reward' ).val() ;
            var referralrewardtype = jQuery( '#rs_local_referral_reward_type' ).val() ;
            var referralrewardpoint = jQuery( '#rs_local_referral_reward_point' ).val() ;
            var referralrewardpercent = jQuery( '#rs_local_referral_reward_percent' ).val() ;
            var referralrewardtyperefer = jQuery( '#rs_local_referral_reward_type_get_refer' ).val() ;
            var referralpointforgettingrefer = jQuery( '#rs_local_referral_reward_point_for_getting_referred' ).val() ;
            var referralrewardpercentgettingrefer = jQuery( '#rs_local_referral_reward_percent_for_getting_referred' ).val() ;
            jQuery( this ).attr( 'data-clicked' , '1' ) ;
            var dataclicked = jQuery( this ).attr( 'data-clicked' ) ;
            var data = {
                action : 'previousproductvalue' ,
                sumo_security : adminscripts_params.product_purchase_bulk_update ,
                proceedanyway : dataclicked ,
                whichproduct : whichproduct ,
                enabledisablereward : enabledisablereward ,
                selectedproducts : selectparticularproducts ,
                selectedcategories : selectedcategories ,
                rewardtype : rewardtype ,
                rewardpoints : rewardpoints ,
                rewardpercent : rewardpercent ,
                enabledisablereferralreward : enabledisablereferralreward ,
                referralrewardtype : referralrewardtype ,
                referralrewardpoint : referralrewardpoint ,
                referralrewardpercent : referralrewardpercent ,
                referralrewardtyperefer : referralrewardtyperefer ,
                referralpointforgettingrefer : referralpointforgettingrefer ,
                referralrewardpercentgettingrefer : referralrewardpercentgettingrefer ,

            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    if ( response.data.content !== 'success' ) {
                        var j = 1 ;
                        var i , j , temparray , chunk = 10 ;
                        for ( i = 0 , j = response.data.content.length ; i < j ; i += chunk ) {
                            temparray = response.data.content.slice( i , i + chunk ) ;
                            FPAdminScripts.chunk_and_update_points_for_product_purchase( temparray ) ;
                        }
                        jQuery.when( FPAdminScripts.chunk_and_update_points_for_product_purchase( 'done' ) ).done( function ( a1 ) {
                            console.log( 'Ajax Done Successfully' ) ;
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        } ) ;
                    } else {
                        var newresponse = response.data.content.replace( /\s/g , '' ) ;
                        if ( newresponse === 'success' ) {
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        }
                    }
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                }
            } ) ;
        } ,
        chunk_and_update_points_for_product_purchase : function ( id ) {
            jQuery( '.gif_rs_sumo_reward_button' ).css( 'display' , 'inline-block' ) ;
            var enabledisablereward = jQuery( '#rs_local_enable_disable_reward' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_products' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_categories' ).val() ;
            var rewardtype = jQuery( '#rs_local_reward_type' ).val() ;
            var rewardpoints = jQuery( '#rs_local_reward_points' ).val() ;
            var rewardpercent = jQuery( '#rs_local_reward_percent' ).val() ;
            var enabledisablereferralreward = jQuery( '#rs_local_enable_disable_referral_reward' ).val() ;
            var referralrewardtype = jQuery( '#rs_local_referral_reward_type' ).val() ;
            var referralrewardpoint = jQuery( '#rs_local_referral_reward_point' ).val() ;
            var referralrewardpercent = jQuery( '#rs_local_referral_reward_percent' ).val() ;
            var referralrewardtyperefer = jQuery( '#rs_local_referral_reward_type_get_refer' ).val() ;
            var referralpointforgettingrefer = jQuery( '#rs_local_referral_reward_point_for_getting_referred' ).val() ;
            var referralrewardpercentgettingrefer = jQuery( '#rs_local_referral_reward_percent_for_getting_referred' ).val() ;
            var data = {
                action : 'rssplitajaxoptimization' ,
                sumo_security : adminscripts_params.product_purchase_bulk_update ,
                ids : id ,
                enabledisablereward : enabledisablereward ,
                selectedproducts : selectparticularproducts ,
                selectedcategories : selectedcategories ,
                rewardtype : rewardtype ,
                rewardpoints : rewardpoints ,
                rewardpercent : rewardpercent ,
                enabledisablereferralreward : enabledisablereferralreward ,
                referralrewardtype : referralrewardtype ,
                referralrewardpoint : referralrewardpoint ,
                referralrewardpercent : referralrewardpercent ,
                referralrewardtyperefer : referralrewardtyperefer ,
                referralpointforgettingrefer : referralpointforgettingrefer ,
                referralrewardpercentgettingrefer : referralrewardpercentgettingrefer ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    console.log( 'Ajax Done Successfully' ) ;
                } else {
                    window.alert( response.data.error ) ;
                }
            } ) ;
        } ,
        bulk_update_points_for_buying_reward : function ( event ) {
            event.preventDefault() ;
            FPAdminScripts.block( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
            jQuery( '.gif_rs_bulk_update_button_for_buying_points' ).css( 'display' , 'inline-block' ) ;
            jQuery( this ).attr( 'data-clicked' , '1' ) ;
            var dataclicked = jQuery( this ).attr( 'data-clicked' ) ;
            var data = {
                action : 'rsapplybuyingpoint' ,
                sumo_security : adminscripts_params.buying_reward_bulk_update ,
                proceedanyway : dataclicked ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    if ( response.data.content !== 'success' ) {
                        var j = 1 ;
                        var i , j , temparray , chunk = 10 ;
                        for ( i = 0 , j = response.data.content.length ; i < j ; i += chunk ) {
                            temparray = response.data.content.slice( i , i + chunk ) ;
                            FPAdminScripts.chunk_and_update_points_for_buying_reward( temparray ) ;
                        }
                        jQuery.when( FPAdminScripts.chunk_and_update_points_for_buying_reward( 'done' ) ).done( function ( a1 ) {
                            console.log( 'Ajax Done Successfully' ) ;
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        } ) ;
                    } else {
                        var newresponse = response.data.content.replace( /\s/g , '' ) ;
                        if ( newresponse === 'success' ) {
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        }
                    }
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                }
            } ) ;
        } ,
        chunk_and_update_points_for_buying_reward : function ( id ) {
            jQuery( '.gif_rs_bulk_update_button_for_buying_points' ).css( 'display' , 'inline-block' ) ;
            var applicableproduct = jQuery( '#rs_buying_points_is_applicable' ).val() ;
            var enablebuyingpoint = jQuery( '#rs_enable_buying_points' ).val() ;
            var buyingpoint = jQuery( '#rs_points_for_buying_points' ).val() ;
            var excludeproducts = jQuery( '#rs_exclude_products_for_buying_points' ).val() ;
            var includeproducts = jQuery( '#rs_include_products_for_buying_points' ).val() ;
            var data = {
                action : 'rsapplybuyingpointforallproducts' ,
                sumo_security : adminscripts_params.buying_reward_bulk_update ,
                ids : id ,
                applicableproduct : applicableproduct ,
                enablebuyingpoint : enablebuyingpoint ,
                buyingpoint : buyingpoint ,
                includeproducts : includeproducts ,
                excludeproducts : excludeproducts ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    console.log( 'Ajax Done Successfully' ) ;
                } else {
                    window.alert( response.data.error ) ;
                }
            } ) ;
        } ,
        bulk_update_points_for_social_reward : function ( event ) {
            event.preventDefault() ;
            FPAdminScripts.block( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
            jQuery( '.gif_rs_sumo_reward_button_social' ).css( 'display' , 'inline-block' ) ;
            var whichproduct = jQuery( '#rs_which_social_product_selection' ).val() ;
            var enabledisablereward = jQuery( '#rs_local_enable_disable_social_reward' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_social_products' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_social_categories' ).val() ;
            var rewardtypefacebook = jQuery( '#rs_local_reward_type_for_facebook' ).val() ;
            var facebookrewardpoints = jQuery( '#rs_local_reward_points_facebook' ).val() ;
            var facebookrewardpercent = jQuery( '#rs_local_reward_percent_facebook' ).val() ;
            var rewardtypefacebook_share = jQuery( '#rs_local_reward_type_for_facebook_share' ).val() ;
            var facebookrewardpoints_share = jQuery( '#rs_local_reward_points_facebook_share' ).val() ;
            var facebookrewardpercent_share = jQuery( '#rs_local_reward_percent_facebook_share' ).val() ;
            var rewardtypetwitter = jQuery( '#rs_local_reward_type_for_twitter' ).val() ;
            var twitterrewardpoints = jQuery( '#rs_local_reward_points_twitter' ).val() ;
            var twitterrewardpercent = jQuery( '#rs_local_reward_percent_twitter' ).val() ;
            var rewardtypegoogle = jQuery( '#rs_local_reward_type_for_google' ).val() ;
            var googlerewardpoints = jQuery( '#rs_local_reward_points_google' ).val() ;
            var googlerewardpercent = jQuery( '#rs_local_reward_percent_google' ).val() ;
            var rewardtypevk = jQuery( '#rs_local_reward_type_for_vk' ).val() ;
            var vkrewardpoints = jQuery( '#rs_local_reward_points_vk' ).val() ;
            var vkrewardpercent = jQuery( '#rs_local_reward_percent_vk' ).val() ;
            var rewardtypetwitter_follow = jQuery( '#rs_local_reward_type_for_twitter_follow' ).val() ;
            var twitterrewardpoints_follow = jQuery( '#rs_local_reward_points_twitter_follow' ).val() ;
            var twitterrewardpercent_follow = jQuery( '#rs_local_reward_percent_twitter_follow' ).val() ;
            var rewardtypeinstagram = jQuery( '#rs_local_reward_type_for_instagram' ).val() ;
            var instagramrewardpoints = jQuery( '#rs_local_reward_points_instagram' ).val() ;
            var instagramrewardpercent = jQuery( '#rs_local_reward_percent_instagram' ).val() ;
            var rewardtypeok_follow = jQuery( '#rs_local_reward_type_for_ok_follow' ).val() ;
            var okrewardpoints_follow = jQuery( '#rs_local_reward_points_ok_follow' ).val() ;
            var okrewardpercent_follow = jQuery( '#rs_local_reward_percent_ok_follow' ).val() ;
            jQuery( this ).attr( 'data-clicked' , '1' ) ;
            var dataclicked = jQuery( this ).attr( 'data-clicked' ) ;
            var data = {
                action : 'previoussocialproductvalue' ,
                sumo_security : adminscripts_params.social_reward_bulk_update ,
                proceedanyway : dataclicked ,
                whichproduct : whichproduct ,
                enabledisablereward : enabledisablereward ,
                selectedproducts : selectparticularproducts ,
                selectedcategories : selectedcategories ,
                rewardtypefacebook : rewardtypefacebook ,
                facebookrewardpoints : facebookrewardpoints ,
                facebookrewardpercent : facebookrewardpercent ,
                rewardtypefacebook_share : rewardtypefacebook_share ,
                facebookrewardpoints_share : facebookrewardpoints_share ,
                facebookrewardpercent_share : facebookrewardpercent_share ,
                rewardtypetwitter : rewardtypetwitter ,
                twitterrewardpoints : twitterrewardpoints ,
                twitterrewardpercent : twitterrewardpercent ,
                rewardtypegoogle : rewardtypegoogle ,
                googlerewardpoints : googlerewardpoints ,
                googlerewardpercent : googlerewardpercent ,
                rewardtypevk : rewardtypevk ,
                vkrewardpoints : vkrewardpoints ,
                vkrewardpercent : vkrewardpercent ,
                rewardtypetwitter_follow : rewardtypetwitter_follow ,
                twitterrewardpoints_follow : twitterrewardpoints_follow ,
                twitterrewardpercent_follow : twitterrewardpercent_follow ,
                rewardtypeinstagram : rewardtypeinstagram ,
                instagramrewardpoints : instagramrewardpoints ,
                instagramrewardpercent : instagramrewardpercent ,
                rewardtypeok_follow : rewardtypeok_follow ,
                okrewardpoints_follow : okrewardpoints_follow ,
                okrewardpercent_follow : okrewardpercent_follow ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    if ( response.data.content !== 'success' ) {
                        var j = 1 ;
                        var i , j , temparray , chunk = 10 ;
                        for ( i = 0 , j = response.data.content.length ; i < j ; i += chunk ) {
                            temparray = response.data.content.slice( i , i + chunk ) ;
                            FPAdminScripts.chunk_and_update_points_for_social_reward( temparray ) ;
                        }
                        jQuery.when( FPAdminScripts.chunk_and_update_points_for_social_reward( 'done' ) ).done( function ( a1 ) {
                            console.log( 'Ajax Done Successfully' ) ;
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        } ) ;
                    } else {
                        var newresponse = response.data.content.replace( /\s/g , '' ) ;
                        if ( newresponse === 'success' ) {
                            jQuery( '.submit .button-primary' ).trigger( 'click' ) ;
                        }
                    }
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                } else {
                    window.alert( response.data.error ) ;
                    FPAdminScripts.unblock( '.rs_hide_bulk_update_for_product_purchase_start' ) ;
                }
            } ) ;
        } ,
        chunk_and_update_points_for_social_reward : function ( id ) {
            jQuery( '.gif_rs_bulk_update_button_for_buying_points' ).css( 'display' , 'inline-block' ) ;
            var enabledisablereward = jQuery( '#rs_local_enable_disable_social_reward' ).val() ;
            var selectparticularproducts = jQuery( '#rs_select_particular_social_products' ).val() ;
            var selectedcategories = jQuery( '#rs_select_particular_social_categories' ).val() ;
            var rewardtypefacebook = jQuery( '#rs_local_reward_type_for_facebook' ).val() ;
            var facebookrewardpoints = jQuery( '#rs_local_reward_points_facebook' ).val() ;
            var facebookrewardpercent = jQuery( '#rs_local_reward_percent_facebook' ).val() ;
            var rewardtypefacebook_share = jQuery( '#rs_local_reward_type_for_facebook_share' ).val() ;
            var facebookrewardpoints_share = jQuery( '#rs_local_reward_points_facebook_share' ).val() ;
            var facebookrewardpercent_share = jQuery( '#rs_local_reward_percent_facebook_share' ).val() ;
            var rewardtypetwitter = jQuery( '#rs_local_reward_type_for_twitter' ).val() ;
            var twitterrewardpoints = jQuery( '#rs_local_reward_points_twitter' ).val() ;
            var twitterrewardpercent = jQuery( '#rs_local_reward_percent_twitter' ).val() ;
            var rewardtypegoogle = jQuery( '#rs_local_reward_type_for_google' ).val() ;
            var googlerewardpoints = jQuery( '#rs_local_reward_points_google' ).val() ;
            var googlerewardpercent = jQuery( '#rs_local_reward_percent_google' ).val() ;
            var rewardtypevk = jQuery( '#rs_local_reward_type_for_vk' ).val() ;
            var vkrewardpoints = jQuery( '#rs_local_reward_points_vk' ).val() ;
            var vkrewardpercent = jQuery( '#rs_local_reward_percent_vk' ).val() ;
            var rewardtypetwitter_follow = jQuery( '#rs_local_reward_type_for_twitter_follow' ).val() ;
            var twitterrewardpoints_follow = jQuery( '#rs_local_reward_points_twitter_follow' ).val() ;
            var twitterrewardpercent_follow = jQuery( '#rs_local_reward_percent_twitter_follow' ).val() ;
            var rewardtypeinstagram = jQuery( '#rs_local_reward_type_for_instagram' ).val() ;
            var instagramrewardpoints = jQuery( '#rs_local_reward_points_instagram' ).val() ;
            var instagramrewardpercent = jQuery( '#rs_local_reward_percent_instagram' ).val() ;
            var rewardtypeok_follow = jQuery( '#rs_local_reward_type_for_ok_follow' ).val() ;
            var okrewardpoints_follow = jQuery( '#rs_local_reward_points_ok_follow' ).val() ;
            var okrewardpercent_follow = jQuery( '#rs_local_reward_percent_ok_follow' ).val() ;
            var data = {
                action : 'rssplitajaxoptimizationsocial' ,
                sumo_security : adminscripts_params.social_reward_bulk_update ,
                ids : id ,
                enabledisablereward : enabledisablereward ,
                selectedproducts : selectparticularproducts ,
                selectedcategories : selectedcategories ,
                rewardtypefacebook : rewardtypefacebook ,
                facebookrewardpoints : facebookrewardpoints ,
                facebookrewardpercent : facebookrewardpercent ,
                rewardtypefacebook_share : rewardtypefacebook_share ,
                facebookrewardpoints_share : facebookrewardpoints_share ,
                facebookrewardpercent_share : facebookrewardpercent_share ,
                rewardtypetwitter : rewardtypetwitter ,
                twitterrewardpoints : twitterrewardpoints ,
                twitterrewardpercent : twitterrewardpercent ,
                rewardtypegoogle : rewardtypegoogle ,
                googlerewardpoints : googlerewardpoints ,
                googlerewardpercent : googlerewardpercent ,
                rewardtypevk : rewardtypevk ,
                vkrewardpoints : vkrewardpoints ,
                vkrewardpercent : vkrewardpercent ,
                rewardtypetwitter_follow : rewardtypetwitter_follow ,
                twitterrewardpoints_follow : twitterrewardpoints_follow ,
                twitterrewardpercent_follow : twitterrewardpercent_follow ,
                rewardtypeinstagram : rewardtypeinstagram ,
                instagramrewardpoints : instagramrewardpoints ,
                instagramrewardpercent : instagramrewardpercent ,
                rewardtypeok_follow : rewardtypeok_follow ,
                okrewardpoints_follow : okrewardpoints_follow ,
                okrewardpercent_follow : okrewardpercent_follow ,
            } ;
            $.post( ajaxurl , data , function ( response ) {
                if ( true === response.success ) {
                    console.log( 'Ajax Done Successfully' ) ;
                } else {
                    window.alert( response.data.error ) ;
                }
            } ) ;
        } ,
        block : function ( id ) {
            $( id ).block( {
                message : null ,
                overlayCSS : {
                    background : '#fff' ,
                    opacity : 0.6
                }
            } ) ;
        } ,
        unblock : function ( id ) {
            $( id ).unblock() ;
        } ,
    } ;
    FPAdminScripts.init() ;
} ) ;