<?php
/*
 * Admin Side Enqueues
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSAdminEnqueues' ) ) {

    class RSAdminEnqueues {

        public static function init() {
            add_action( 'admin_enqueue_scripts' , array( __CLASS__ , 'admin_enqueue_script' ) ) ;

            add_action( 'admin_head' , array( __CLASS__ , 'import_user_points_to_reward_system' ) ) ;

            add_action( 'wp_ajax_get_user_list_of_ids' , array( __CLASS__ , 'perform_ajax_scenario_getting_list_of_user_ids' ) ) ;

            add_action( 'wp_ajax_user_points_split_option' , array( __CLASS__ , 'perform_ajax_splitted_ids_for_user_ids' ) ) ;
        }

        public static function admin_enqueue_script() {
            $deps          = array() ;
            $verison       = '1' ;
            $plugin_folder = get_plugins( '/' . 'rewardsystem' ) ;
            $plugin_file   = 'rewardsystem.php' ;
            if ( isset( $plugin_folder[ $plugin_file ][ 'Version' ] ) ) {
                $verison = $plugin_folder[ $plugin_file ][ 'Version' ] ;
            }
            wp_register_script( 'rewardsystem_admin' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/admin.js" , $deps , $verison ) ;
            wp_register_script( 'wp_reward_footable' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.js" ) ;
            wp_register_script( 'wp_reward_footable_sort' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.sort.js" ) ;
            wp_register_script( 'wp_reward_footable_paging' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.paginate.js" ) ;
            wp_register_script( 'wp_reward_footable_filter' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.filter.js" ) ;
            
            wp_enqueue_script( 'fp_edit_product_page' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/fp-edit-product-page.js" , $deps , $verison ) ;
            
            wp_enqueue_script( 'fp_general_tab' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/fp-general-tab.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_addremovepoints_tab' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/fp-addremovepoints-tab.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_msg_tab' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/fp-msg-tab.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_advance_tab' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/fp-advance-tab.js" , $deps , $verison ) ;
            
            wp_enqueue_script( 'fp_product_purchase_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-productpurchase-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_referral_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-referral-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_social_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-social-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_action_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-action-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_redeem_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-redeem-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_pointprice_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-pointprice-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_email_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-email-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_giftvoucher_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-giftvoucher-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_sms_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-sms-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_cashback_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-cashback-module.js" , $deps , $verison ) ;
            wp_enqueue_script( 'fp_reset_module' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/tab/modules/fp-reset-module.js" , $deps , $verison ) ;
            
            wp_register_style( 'wp_reward_footable_css' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/footable.core.css" ) ;
            wp_register_style( 'wp_reward_bootstrap_css' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/bootstrap.css" ) ;
            wp_register_style( 'wp_reward_facebook' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/style.css" ) ;
            wp_enqueue_script( 'jquery' ) ;
            wp_enqueue_script( 'wp_reward_facebook' ) ;
            wp_enqueue_script( 'wp_reward_footable' ) ;
            wp_enqueue_script( 'wp_reward_footable_sort' ) ;
            wp_enqueue_script( 'wp_reward_footable_paging' ) ;
            wp_enqueue_script( 'wp_reward_footable_filter' ) ;
            wp_enqueue_style( 'wp_reward_footable_css' ) ;
            wp_enqueue_style( 'wp_reward_bootstrap_css' ) ;
            wp_enqueue_script( 'jquery-ui-datepicker' ) ;
            wp_enqueue_script( 'rewardsystem_admin' ) ;
            if ( function_exists( 'wp_enqueue_media' ) ) {
                wp_enqueue_media() ;
            } else {
                wp_enqueue_style( 'thickbox' ) ;
                wp_enqueue_script( 'media-upload' ) ;
                wp_enqueue_script( 'thickbox' ) ;
            }
            if ( isset( $_GET[ 'page' ] ) && $_GET[ 'page' ] == 'rewardsystem_callback' && isset( $_GET[ 'tab' ] ) && $_GET[ 'tab' ] == 'rewardsystem_modules' ) {
                wp_register_script( 'wp_jscolor_rewards' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/jscolor/jscolor.js" , array( 'jquery' ) ) ;
                wp_enqueue_script( 'wp_jscolor_rewards' ) ;
            }
        }

        // Import User Reward Points from Old Version to Latest Version
        public static function import_user_points_to_reward_system() {
            wp_enqueue_script( 'jquery' ) ;
            $security = rs_function_to_create_security() ;
            $isadmin  = is_admin() ? 'yes' : 'no' ;
            ?>
            <script type="text/javascript">
                jQuery( function () {
                    jQuery( '.gif_rs_sumo_reward_button' ).css( 'display' , 'none' ) ;
                } ) ;
                jQuery( document ).ready( function () {
                    jQuery( '#rs_add_old_points' ).click( function () {
                        if ( confirm( "Are you sure you want to Add the Existing points?" ) ) {
                            jQuery( '.gif_rs_sumo_reward_button' ).css( 'display' , 'inline-block' ) ;
                            var dataparam = ( {
                                action : 'get_user_list_of_ids'
                            } ) ;
                            function getData( id ) {
                                console.log( id ) ;
                                return jQuery.ajax( {
                                    type : 'POST' ,
                                    url : "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" ,
                                    data : ( {
                                        action : 'user_points_split_option' ,
                                        ids : id ,
                                        secure : "<?php echo $security ; ?>" ,
                                        state : "<?php echo $isadmin ; ?>"
                                    } ) ,
                                    success : function ( response ) {
                                        console.log( response ) ;
                                    } ,
                                    dataType : 'json' ,
                                    async : false
                                } ) ;
                            }
                            jQuery.post( "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" , dataparam ,
                                    function ( response ) {
                                        console.log( response ) ;
                                        if ( response !== 'success' ) {
                                            var j = 1 ;
                                            var i , j , temparray , chunk = 10 ;
                                            for ( i = 0 , j = response.length ; i < j ; i += chunk ) {
                                                temparray = response.slice( i , i + chunk ) ;
                                                getData( temparray ) ;
                                            }
                                            jQuery.when( getData() ).done( function ( a1 ) {
                                                console.log( 'Ajax Done Successfully' ) ;
                                                location.reload() ;
                                            } ) ;
                                        } else {
                                            var newresponse = response.replace( /\s/g , '' ) ;
                                            if ( newresponse === 'success' ) {
                                                //jQuery('.submit .button-primary').trigger('click');
                                            }
                                        }
                                    } , 'json' ) ;
                            return false ;
                        }
                    } ) ;
                } ) ;

            </script>
            <?php
        }

        //Perform Ajax Scenario for Updating User Points
        public static function perform_ajax_scenario_getting_list_of_user_ids() {
            $args      = array(
                'fields'       => 'ID' ,
                'meta_key'     => '_my_reward_points' ,
                'meta_value'   => '' ,
                'meta_compare' => '!='
            ) ;
            $get_users = get_users( $args ) ;

            echo json_encode( $get_users ) ;

            exit() ;
        }

        // Perform Splitted User IDs in Reward System Function
        public static function perform_ajax_splitted_ids_for_user_ids() {
            $verify_security = isset( $_POST[ 'secure' ] ) ? rs_function_to_verify_secure( $_POST[ 'secure' ] ) : false ;
            if ( isset( $_POST[ 'ids' ] ) && $verify_security && isset( $_POST[ 'state' ] ) && $_POST[ 'state' ] == 'yes' ) {
                foreach ( $_POST[ 'ids' ] as $eachid ) {
                    self::insert_user_points_in_database( $eachid ) ;
                }
            }

            exit() ;
        }

        // Insert User Points in Database

        public static function insert_user_points_in_database( $user_id ) {
            global $wpdb ;
            $user_points = get_user_meta( $user_id , '_my_reward_points' , true ) ;
            $table_name  = $wpdb->prefix . "rspointexpiry" ;
            $currentdate = time() ;
            $query       = $wpdb->get_row( "SELECT * FROM $table_name WHERE userid = $user_id and expirydate = 999999999999" , ARRAY_A ) ;
            if ( ! empty( $query ) ) {
                $id              = $query[ 'id' ] ;
                $oldearnedpoints = $query[ 'earnedpoints' ] ;
                $oldearnedpoints = $oldearnedpoints + $user_points ;
                $wpdb->update( $table_name , array( 'earnedpoints' => $oldearnedpoints ) , array( 'id' => $id ) ) ;
            } else {
                $wpdb->insert( $table_name , array(
                    'earnedpoints'      => $user_points ,
                    'usedpoints'        => '' ,
                    'expiredpoints'     => '0' ,
                    'userid'            => $user_id ,
                    'earneddate'        => $currentdate ,
                    'expirydate'        => '999999999999' ,
                    'checkpoints'       => 'OUP' ,
                    'orderid'           => '' ,
                    'totalearnedpoints' => '' ,
                    'totalredeempoints' => '' ,
                    'reasonindetail'    => ''
                ) ) ;
            }
        }

    }

    RSAdminEnqueues::init() ;
}