from flask import Flask, request, redirect, g
from flask.ext.babel import Babel

app = Flask(__name__)
app.config.from_object('config')
babel = Babel(app)


@app.before_request
def set_language():
    try:
        lang = request.view_args['lang']

        if lang in app.config['LANGUAGES']:
            language = lang
        else:
            #Requested language is not a valid one !
            return redirect('/')
    except:
        language = request.accept_languages.best_match(app.config['LANGUAGES'].keys())

    #No languages match! Fallback to Configuration settings 'Default Language'
    if not language:
        language = app.config['DEFAULT_LANGUAGE']

    g.locale = language


@babel.localeselector
def get_locale():

    return g.locale


from app import views, models

app.register_blueprint(views.groups, url_prefix='/groups')
app.register_blueprint(views.hosts, url_prefix='/hosts')
