<?php
/*
Plugin Name: Sofa Front Post 
Plugin URI: http://20script.ir
Description: Front-end posting that makes sense.
Version: 1.0
Author: 20script.ir
Author URI: http://20script.ir
*/

if (!class_exists('sofa_front_post')) {
	class sofa_front_post {
		/**
		* @var string The options string name for this plugin
		*/
		var $optionsName = 'sofa_front_post_options';

		/**
		* @var array $options Stores the options for this plugin
		*/
		var $options = array();
		/**
		* @var string $localizationDomain Domain used for localization
		*/
		var $localizationDomain = 'sofa_front_post';

		/**
		* @var string $url The url to this plugin
		*/ 
		var $url = '';
		/**
		* @var string $urlpath The path to this plugin
		*/
		var $urlpath = '';
		
		/**
		* @var arrays: paypal locales and currencies
		*/
		var $paypal_locales = array(
		"EN" => "English - US",
		"AU" => "English - Australian",
		"GB" => "English - UK",
		"CN" => "Chinese",
		"FR" => "French",
		"DE" => "German",
		"IT" => "Italian",
		"JP" => "Japanese",
		"ES" => "Spanish"
		);
		
		var $paypal_currencies = array(
		"AUD" => "Australian Dollar",
		"BRL" => "Brazilian Real",
		"CAD" => "Canadian Dollar",
		"CZK" => "Czech Koruna",
		"DKK" => "Danish Krone",
		"EUR" => "Euro",
		"HKD" => "Hong Kong Dollar",
		"HUF" => "Hungarian Forint",
		"ILS" => "Israeli New Sheqel",
		"JPY" => "Japanese Yen",
		"MYR" => "Malaysian Ringgit",
		"MXN" => "Mexican Peso",
		"NOK" => "Norwegian Krone",
		"NZD" => "New Zealand Dollar",
		"PHP" => "Philippine Peso",
		"PLN" => "Polish Zloty",
		"GBP" => "Pound Sterling",
		"SGD" => "Singapore Dollar",
		"SEK" => "Swedish Krona",
		"CHF" => "Swiss Franc",
		"TWD" => "Taiwan New Dollar",
		"THB" => "Thai Baht",
		"TRY" => "Turkish Lira",
		"USD" => "U.S. Dollar"
		);
		
		/**
		* @var string max file size for upload
		*/
		var $max_upload_file_size = '';
		
		/**
		* @var string max file size for upload
		*/
		var $upload_file_type = array( 'image/jpeg', 'image/png', 'image/gif' );

		//Class Functions
		/**
		* PHP 4 Compatible Constructor
		*/
		function sofa_front_post(){ $this->__construct(); }

		/**
		* PHP 5 Constructor
		*/		
		function __construct(){
			//Initialize the options
			$this->getOptions();
			
			//Language Setup
			$locale = get_locale();
			$mo = plugin_dir_path(__FILE__) . 'languages/' . $this->localizationDomain . '-' . $locale . '.mo';	
			load_textdomain($this->localizationDomain, $mo);

			//"Constants" setup
			$this->url = plugins_url(basename(__FILE__), __FILE__);
			$this->urlpath = plugins_url('', __FILE__);
			$this->max_upload_file_size = ( isset( $this->options[ 'sfp_limit_file_size' ] ) ? ( $this->options[ 'sfp_limit_file_size' ] ) : ( ini_get( 'upload_max_filesize' ) ) );
			
			//Admin menu
			add_action('admin_menu', array(&$this,'admin_menu_link'));
			add_action('admin_menu', array(&$this,'disable_default_dashboard_widgets'));

			//Actions
			add_action('admin_enqueue_scripts', array(&$this,'sofa_front_post_script')); // or wp_enqueue_scripts, login_enqueue_scripts
			add_action('init', array(&$this,'sofa_front_post_init'));
			
			//Initialize CPT and CT
			add_action('init', array(&$this,'sofa_front_post_cpt_and_ct'));
			
			/* shortcodes */
			add_shortcode('sfp_list', array(&$this,'add_sfp_list_shortcode'));
			add_shortcode('sfp_search', array(&$this,'add_sfp_search_shortcode'));
			add_shortcode('sfp_search', array(&$this,'add_sfp_search_shortcode'));
			add_shortcode('sfp_form', array(&$this,'add_sfp_form_shortcode'));
			add_shortcode('sfp_edit', array(&$this,'add_sfp_edit_shortcode'));
			add_shortcode('sfp_payment', array(&$this,'add_sfp_payment_shortcode'));
			add_shortcode('sfp_transactions', array(&$this,'add_sfp_transactions_shortcode'));
			add_shortcode('sfp_login', array(&$this,'add_sfp_login_shortcode'));
			add_shortcode('sfp_archives', array(&$this,'add_sfp_archives_shortcode'));
			add_shortcode('sfp_latest', array(&$this,'add_sfp_sc_latest_entries'));
			
			/* scheduled jobs */
			// wp_clear_scheduled_hook( 'sfp_cron_expired_hourly' ); // quick clean
			if( !wp_next_scheduled( 'sfp_cron_expired_hourly' ) ) wp_schedule_event( current_time( 'timestamp' ), 'hourly', 'sfp_cron_expired_hourly' );
			add_action( 'sfp_cron_expired_hourly', array(&$this, 'sfp_cron_expired') );
			register_deactivation_hook( __FILE__, array(&$this, 'sfp_deactivate_schedule_expired') ); // prevent from running after plugin deactivation
			// wp_clear_scheduled_hook( 'sfp_cron_expired_hourly' ); // quick clean
			if( !wp_next_scheduled( 'sfp_cron_duetopay_hourly' ) ) wp_schedule_event( current_time( 'timestamp' ), 'hourly', 'sfp_cron_duetopay_hourly' );
			add_action( 'sfp_cron_duetopay_hourly', array(&$this, 'sfp_cron_duetopay') );
			register_deactivation_hook( __FILE__, array(&$this, 'sfp_deactivate_schedule_duetopay') ); // prevent from running after plugin deactivation
			
			/* append new post status: expired and due to pay */
			add_action( 'init', array(&$this,'sfp_new_post_status_expired') );
			add_action( 'init', array(&$this,'sfp_new_post_status_duetopay') );
			
			/* create db table */
			add_action( 'init', array(&$this,'sfp_create_database_table') );
			
			/* enable session */
			add_action( 'init', 'session_start', 0 );
		}

		/**
		* @desc Initialize plugin
		*/
		function sofa_front_post_init() {
			// initialize autocomplete, jquery.suggest for tags: sofa_front_post_user_script
			if( !is_admin() ) {
				add_action( 'wp_footer', array( &$this, 'sofa_front_post_user_js' ) );
				// screen dimmer
				add_action( 'wp_footer', array( &$this, 'sfp_add_dim_screen_layer' ) );
				// remove admin bar
				if( !current_user_can( 'administrator' ) ) add_filter( 'show_admin_bar', '__return_false' );
			}
			
			// sfpposts additional columns in Admin edit page
			add_filter( 'manage_edit-sfpposts_columns', array(&$this,'sfp_edit_columns') ) ;
			add_action( 'manage_sfpposts_posts_custom_column', array(&$this,'sfp_manage_columns'), 10, 2 );
			
			// initialize attachment deletion
			add_action( 'wp_ajax_sfp_delete_attachment', array(&$this,'sfp_delete_attachment') );
			add_action( 'wp_ajax_nopriv_sfp_delete_attachment', array(&$this,'sfp_delete_attachment') );
			
			// change post status
			add_action( 'admin_enqueue_scripts', array(&$this,'sfp_force_change_status_jquery') );
			add_action( 'wp_ajax_sfp_force_change_status', array(&$this,'sfp_force_change_status') );
			
			// switch featured image
			add_action( 'wp_ajax_sfp_make_image_featured', array(&$this,'sfp_make_image_featured') );
			add_action( 'wp_ajax_nopriv_sfp_make_image_featured', array(&$this,'sfp_make_image_featured') );
			
			// delete Entry
			add_action( 'wp_ajax_sfp_delete_entry', array(&$this,'sfp_delete_entry') );
			add_action( 'wp_ajax_nopriv_sfp_delete_entry', array(&$this,'sfp_delete_entry') );
			
			// cancel sponsored Entry
			add_action( 'wp_ajax_sfp_cancel_sponsored_entry', array(&$this,'sfp_cancel_sponsored_entry') );
			add_action( 'wp_ajax_nopriv_sfp_cancel_sponsored_entry', array(&$this,'sfp_cancel_sponsored_entry') );
			
			// contact entry author
			add_action( 'wp_ajax_sfp_contact_publisher', array(&$this,'sfp_contact_publisher') );
			add_action( 'wp_ajax_nopriv_sfp_contact_publisher', array(&$this,'sfp_contact_publisher') );
			
			// logins
			add_action( 'wp_ajax_sfp_handle_logins', array(&$this,'sfp_handle_logins') );
			add_action( 'wp_ajax_nopriv_sfp_handle_logins', array(&$this,'sfp_handle_logins') );
			
			// suggest in search
			add_action( 'wp_ajax_sfp_suggest_tag_cat', array(&$this,'sfp_suggest_tag_cat') );
			add_action( 'wp_ajax_nopriv_sfp_suggest_tag_cat', array(&$this,'sfp_suggest_tag_cat') );
			add_action( 'wp_ajax_sfp_suggest_search_cat', array(&$this,'sfp_suggest_search_cat') );
			add_action( 'wp_ajax_nopriv_sfp_suggest_search_cat', array(&$this,'sfp_suggest_search_cat') );
			add_action( 'wp_ajax_sfp_suggest_search_meta', array(&$this,'sfp_suggest_search_meta') );
			add_action( 'wp_ajax_nopriv_sfp_suggest_search_meta', array(&$this,'sfp_suggest_search_meta') );
			
			// disable Dashboard access for non-admins
			add_action( 'admin_menu', array(&$this,'sfp_knock_off_dashboard') );
			
			// dashboard widget - stats
			add_action( 'wp_dashboard_setup', array(&$this,'sfp_add_dashboard_widgets') );
			
			// redirect to proper templates
			add_filter( 'template_include', array( &$this,'sfp_custom_template_single') );
			
			// pagination fix for custom taxonomy
			add_action( 'pre_get_posts', array( &$this,'sfp_pagination_fix') );

			// custom sorting
			add_action( 'pre_get_posts', array( &$this,'sfp_chck_query_vars') );
			
			// preview of expired, due-to-pay and pending posts
			add_filter( 'posts_results', array( &$this,'sfp_peek_into_private'), NULL, 2 );
			
			// paragraph fix for new entry and edit entry form
			add_filter( 'the_content', array( &$this,'sfp_paragraph_fix') );
		}
		
		/**
		* @desc we'll need an extra table that will hold payments
		*/
		function sfp_create_database_table() {
			global $wpdb;
			$table = $wpdb->prefix . 'sfp_payments';
			if( mysql_num_rows( mysql_query( "SHOW TABLES LIKE '" . $table . "'" ) ) == 1) return;
			$run_sql = "CREATE TABLE " . $table . " (
					  id INT NOT NULL AUTO_INCREMENT,
					  post_id VARCHAR(10) NOT NULL DEFAULT '',
					  user_id VARCHAR(10) NOT NULL DEFAULT '',
					  pub_type VARCHAR(20) NOT NULL DEFAULT 'free',
					  paypal_bulk LONGTEXT NOT NULL DEFAULT '',
					  UNIQUE KEY id (id)
					  );";
		
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			dbDelta( $run_sql );
		}
		
		/**
		* @desc register new post status: expired
		*/
		function sfp_new_post_status_expired() {
			register_post_status( 'expired', array(
			  'label' => _x( 'Expired', 'sfpposts' ),
			  'public' => false,
			  'exclude_from_search' => true,
			  'show_in_admin_all_list' => true,
			  'show_in_admin_status_list' => true,
			  'label_count' => _n_noop( 'Expired <span class="count">(%s)</span>', 'Expired <span class="count">(%s)</span>' ),
			) );
		}
		
		/**
		* @desc register new post status: due to pay
		*/
		function sfp_new_post_status_duetopay() {
			register_post_status( 'due-to-pay', array(
			  'label' => _x( 'Due to pay', 'sfpposts' ),
			  'public' => false,
			  'exclude_from_search' => true,
			  'show_in_admin_all_list' => true,
			  'show_in_admin_status_list' => true,
			  'label_count' => _n_noop( 'Due to pay <span class="count">(%s)</span>', 'Due to pay <span class="count">(%s)</span>' ),
			) );
		}
		
		/**
		* @desc assign scheduled event: make all expired entries status to expired
		*/
		function sfp_cron_expired() {
			if( $this->options[ 'sfp_expire' ] > 0 ) {
				// check for expired entries every hour
				global $wpdb;
				$key_post_type = 'sfpposts';
				$key_post_status = 'publish';
				$expiration_days = $this->options[ 'sfp_expire' ];
				$mysql_q = "UPDATE {$wpdb->prefix}posts SET post_status='expired' WHERE post_type=%s AND post_status=%s AND (post_date + INTERVAL %d DAY) < CURDATE()";
				$q_store = $wpdb->query( $wpdb->prepare( $mysql_q, $key_post_type, $key_post_status, $expiration_days ) );
				// send mail to all whose entry has expired
				if( $q_store ) {
					$key_table = "{$wpdb->prefix}posts";
					$key_post_status = 'expired';
					$q_expired = "SELECT post_title, post_author FROM %s WHERE post_status=%s";
					$q_expired_results = $wpdb->get_results( $wpdb->prepare( $q_expired, $key_table, $key_post_status ) );
					if( $q_expired_results ) {
						
						if( is_multisite() ) $blogname = $GLOBALS[ 'current_site' ]->site_name;
						else $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
						$from = $this->options[ 'sfp_public_email' ];
						
						foreach( $q_expired_results as $result ) {

							$headers = "MIME-Version: 1.0\n" . "From: <$from>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n";
							
							$title = sprintf( __( '[%s] - Entry EXPIRED!', $this->localizationDomain ), $blogname );
							
							$message = '::::: ' . __( 'Your Entry with the following title has expired:', $this->localizationDomain ) . ' <strong>' . $result->post_title . '</strong><br /><br /><br />';
							$message .= __( 'Expired entries are not listed on our site! You have an option to renew your entry or delete it in case you don\'t want to receive this notification any more.', $this->localizationDomain ) . "<br /><br />";
							$message .= get_permalink( $this->options[ 'sfp_page_entries_list' ] ) . '<br />';
							
							// userdata
							$curr_user = get_userdata( $result->post_author );
							
							if( $message && !mail( $curr_user->user_email, $title, $message, $headers ) ) $err_msg = __( 'Message could not be sent! Possible reason: your host may have disabled PHP\'s mail() function.', $this->localizationDomain );
							
						}
					}
				}
			}
		}
		function sfp_deactivate_schedule_expired() {
			wp_clear_scheduled_hook( 'sfp_cron_expired_hourly' );
		}
		
		/**
		* @desc assign scheduled event: delete all entries that are over due to pay
		*/
		function sfp_cron_duetopay() {
			if( $this->options[ 'sfp_expire' ] > 0 ) {
				// check for due-to-pay entries every hour
				global $wpdb;
				$key_post_type = 'sfpposts';
				$key_post_status = 'due-to-pay';
				$expiration_hours = $this->options[ 'sfp_drop_due_to_pays' ];
				if( !$this->options[ 'sfp_force_dtp_delete' ] ) {
					$mysql_q = "DELETE FROM {$wpdb->prefix}posts WHERE post_type =%s AND post_status=%s AND (post_date > DATE_SUB( NOW(), INTERVAL %d HOUR ))";
				} else {
					// sometimes it happens on localhost
					$mysql_q = "DELETE FROM {$wpdb->prefix}posts WHERE post_type =%s AND post_status=%s AND (post_date < DATE_SUB( NOW(), INTERVAL %d HOUR ))";
				}
				$q_store = $wpdb->query( $wpdb->prepare( $mysql_q, $key_post_type, $key_post_status, $expiration_hours ) );
			}
		}
		function sfp_deactivate_schedule_duetopay() {
			wp_clear_scheduled_hook( 'sfp_cron_duetopay_hourly' );
		}
		
		/**
		* @desc Support for shortcode [sfp_form]
		*/
		function add_sfp_form_shortcode() {
			ob_start();
			require_once( 'include/sfp_entry_form.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_edit]
		*/
		function add_sfp_edit_shortcode() {
			ob_start();
			require_once( 'include/sfp_edit_form.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_list]
		*/
		function add_sfp_list_shortcode() {
			ob_start();
			require_once( 'include/sfp_entry_list_by_user.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_search]
		*/
		function add_sfp_search_shortcode( $atts ) {
			ob_start();
			require_once( 'include/sfp_search.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_transactions]
		*/
		function add_sfp_transactions_shortcode() {
			ob_start();
			require_once( 'include/sfp_user_payments.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_payment]
		*/
		function add_sfp_payment_shortcode() {
			ob_start();
			require_once( 'include/sfp_make_payment.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_login]
		*/
		function add_sfp_login_shortcode() {
			ob_start();
			require_once( 'include/sfp_login.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_archives] --- beware of filtering parameters aka shortcode arguments
		*/
		function add_sfp_archives_shortcode( $atts ) {
			ob_start();
			require_once( 'include/sfp_archives.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc Support for shortcode [sfp_latest]
		*/
		function add_sfp_sc_latest_entries( $atts ) {
			ob_start();
			require_once( 'include/sfp_latest.php' );
			return ob_get_clean();
		}
		
		/**
		* @desc this plugin should be theme independent. custom post type does require single-{cpt}.php to work properly. if not found WP's default single.php will be used. no good. we need our own template instead.
		* the same goes for taxonomy, search, archive...
		*/
		function sfp_custom_template_single( $template ) {
			$post_type = 'sfpposts';
			if( is_singular() ) {
				if( FALSE !== strpos( $template, "/single-$post_type.php" ) ) return $template;
				if( $post_type === get_post_type( $GLOBALS[ 'post' ] ) ) return dirname( __FILE__ ) . "/templates/single-$post_type.php";
			} else if( is_tax( 'sfp_post_category' ) ) {
				if( FALSE !== strpos( $template, '/taxonomy-sfp_post_category.php' ) ) return $template;
				if( $post_type === get_post_type( $GLOBALS[ 'post' ] ) ) return dirname( __FILE__ ) . "/templates/taxonomy-sfp_post_category.php";
			} else if( is_tax( 'sfp_post_tags' ) ) {
				if( FALSE !== strpos( $template, '/taxonomy-sfp_post_tags.php' ) ) return $template;
				if( $post_type === get_post_type( $GLOBALS[ 'post' ] ) ) return dirname( __FILE__ ) . "/templates/taxonomy-sfp_post_tags.php";
			}
			return $template;
		}
		
		/**
		* @desc manage columns of custom post type in edit screen
		*/
		function sfp_edit_columns( $columns ) {
		
			$columns = array(
				'cb' => '<input type="checkbox" />',
				'featuredimage' => __( 'Featured Image', $this->localizationDomain ),
				'title' => __( 'Title', $this->localizationDomain ),
				'status' => __( 'Status', $this->localizationDomain ),
				'sponsored' => __( 'Sponsored', $this->localizationDomain ),
				'publishedin' => __( 'Published', $this->localizationDomain ),
				'author' => __( 'Author', $this->localizationDomain ),
				'date' => __( 'Date', $this->localizationDomain )
			);
		
			return $columns;
		}
		function sfp_manage_columns( $column ) {
			global $post;
			switch( $column ) {
				
				case 'featuredimage' :

					if( has_post_thumbnail( $post->ID ) ) {
						$thumb = get_post_thumbnail_id();
						$image = vt_resize( $thumb, '', 100, 60, false );
						echo '<img class="sfp-image-thumb" src="' .  $image[ 'url' ] . '" width="' . $image[ 'width' ] . '" height="' . $image[ 'height' ] . '" />';
					}
					break;
				
				case 'status' :
					
					$current_post_status = get_post_status( $post->ID );
					$statuses = array( 'pending', 'publish', 'due-to-pay', 'expired' );
					echo '<select id="sfp-admin-change-post-status_' . $post->ID . '">';
					$cnt_statuses = count( $statuses );
					$cnt_loop = 0;
					while( $cnt_loop < $cnt_statuses ) {
						if( $statuses[ $cnt_loop ] == $current_post_status ) echo '<option value="' . $statuses[ $cnt_loop ] . '" selected="selected"> -- ' . $statuses[ $cnt_loop ] . ' -- </option>';
						else echo '<option value="' . $statuses[ $cnt_loop ] . '"> -- ' . $statuses[ $cnt_loop ] . ' -- </option>';
						$cnt_loop ++;
					}
					echo '</select>';
					break;
					
				case 'sponsored' :
					
					$is_entry_sponsored = get_post_meta( $post->ID, 'is_sponsored', true );
					if( $is_entry_sponsored ) echo '<span class="sponsored-yes">' . __( 'YES', $this->localizationDomain ) . '</span>';
					else echo '<span class="sponsored-no">' . __( 'NO', $this->localizationDomain ) . '</span>';
					break;
		
				case 'publishedin' :
		
					$terms = get_the_terms( $post->ID, 'sfp_post_category' );
		
					if ( !empty( $terms ) ) {
						$out = array();
						foreach ( $terms as $term ) {
							$out[] = sprintf( '<a href="%s">%s</a>',
								esc_url( add_query_arg( array( 'post_type' => $post->post_type, 'sfp_post_category' => $term->slug ), 'edit.php' ) ),
								esc_html( sanitize_term_field( 'name', $term->name, $term->term_id, 'sfp_post_category', 'display' ) )
							);
						}
						echo join( ', ', $out );
					}
					break;
		
				default :
					break;
			}
		}
		function sfp_force_change_status_jquery() {
			$screen = get_current_screen();
			if( $screen->id != 'edit-sfpposts') return;
			wp_enqueue_script( 'admin_post_status', $this->urlpath . '/js/admin_change_post_status.js' );
			wp_localize_script( 'admin_post_status', 'sfp_status_vars', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'statusnonce' => wp_create_nonce( 'sfp-change-status' ), 'msgok' => __( "Entry status has been changed!", $this->localizationDomain ), 'msgnotok' => __( "ERROR! Entry status can not be changed!", $this->localizationDomain ), 'confirmation' => __( 'Are you sure you want to do it that way?', $this->localizationDomain ) ) );
		}
		function sfp_force_change_status() {
			$get_selected_status = $_POST[ 'status' ];
			$pst_id = (int)$_POST[ 'pst_ID' ];
			$nonce = $_POST[ 'statusnonce' ];
			if( !wp_verify_nonce( $nonce, 'sfp-change-status' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			$my_post = array();
			$my_post[ 'ID' ] = $pst_id;
			$my_post[ 'post_status' ] = $get_selected_status;
			wp_update_post( $my_post );
			$response = json_encode( array( 'success' => true, 'post_id' => $pst_id, 'selected_status' => $get_selected_status ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		
		/**
		* @desc Return custom taxonomies as drop-down
		*/
		function sfp_entry_categories_dropdown( $taxonomy, $selected ) {
			return wp_dropdown_categories( array( 'taxonomy' => $taxonomy, 'name' => 'sfp_entry_category', 'selected' => $selected, 'hide_empty' => 0, 'echo' => 0 ) );
		}
		
		/**
		* @desc handle entry meta data
		*/
		function sfp_entry_meta( $entry_id, $meta_name, $meta_value = '' ) {
			if( empty( $meta_value ) || !$meta_value ) {
				delete_post_meta( $entry_id, $meta_name );
			} elseif( !get_post_meta( $entry_id, $meta_name ) ) {
				add_post_meta( $entry_id, $meta_name, $meta_value );
			} else {
				update_post_meta( $entry_id, $meta_name, $meta_value );
			}
		}
		
		/**
		* @desccheck for errors by file upload
		*/
		function sfp_file_upload_error_chck( $all_files = array() ) {
			$messages = array();
			if( isset( $all_files[ 'tmp_name' ] ) ) {
				$num_files = count( $all_files[ 'tmp_name' ] );
				for( $i = 0; $i < $num_files; $i ++ ) {
					// check if there is a file in the array
					if( !is_uploaded_file( $all_files[ 'tmp_name' ][ $i ] ) ) continue;
					$image_data = getimagesize( $all_files[ 'tmp_name' ][ $i ] ); // check whether image size fits
					if( !in_array( $image_data[ 'mime' ], $this->upload_file_type ) ) $messages[] = $all_files[ 'name' ][ $i ] . ' - <span class="sfp-upload-error-msg">' . __( 'File type mismatch, must be one of:', $this->localizationDomain ) . ' ' . implode( ', ', $this->upload_file_type ) . '</span>';
					if( ( $all_files[ 'size' ][ $i ] / 1000000 > $this->max_upload_file_size ) ) $messages[] = $all_files[ 'name' ][ $i ] . ' - <span class="sfp-upload-error-msg">' . __( 'File too big, max allowed:', $this->localizationDomain ) . ' ' . $this->max_upload_file_size . ' Megabytes' . '</span>';
				}
			}
			return $messages;
		}
		
		/**
		* @desccheck handle file upload
		*/
		function sfp_file_upload_handler( $file_handler, $post_id, $cnt ) {
			if( $_FILES[ $file_handler ][ 'error' ] !== UPLOAD_ERR_OK ) __return_false();
			require_once( ABSPATH . 'wp-admin/includes/admin.php' ); // include media handler
			$attach_id = media_handle_upload( $file_handler, $post_id );
			if( $cnt == 1 && !has_post_thumbnail( $post_id ) ) update_post_meta( $post_id, '_thumbnail_id', $attach_id );
			return $attach_id;
		}
		
		/**
		* @desccheck handle file/attachment delete
		*/
		function sfp_delete_attachment() {
			$att_id = (int)$_POST[ 'att_ID' ];
			$pst_id = (int)$_POST[ 'pst_ID' ];
			$nonce = $_POST[ 'delnonce' ];
			if( !wp_verify_nonce( $nonce, 'att-rem-nonce' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			if( $att_id ) wp_delete_attachment( $att_id, true );
			// calc how many empty slots for uploads are left
			$free_slots = 0;
			if( $this->options[ 'sfp_limit_img_upload' ] > 0 ) {
				$att_args = array( 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => -1, 'post_status' => null, 'post_parent' => (int)$pst_id );
				$attachments = get_posts( $att_args );
				if( $attachments ) {
					$num_allowed = $this->options[ 'sfp_limit_img_upload' ];
					$num_current = count( $attachments );
					$free_slots = $num_allowed - $num_current;
				}
			}
			$response = json_encode( array( 'success' => true, 'freeslots' => $free_slots ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		function sfp_calc_free_slots( $postid ) {
			$free_slots = 0;
			$att_args = array( 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => -1, 'post_status' => null, 'post_parent' => (int)$postid );
			$attachments = get_posts( $att_args );
			if( $attachments ) {
				$num_allowed = $this->options[ 'sfp_limit_img_upload' ];
				$num_current = count( $attachments );
				$free_slots = $num_allowed - $num_current;
			} else $free_slots = $this->options[ 'sfp_limit_img_upload' ];
			return $free_slots;
		}
		
		/**
		* @desc make featured image
		*/
		function sfp_make_image_featured() {
			$att_id = (int)$_POST[ 'att_ID' ];
			$pst_id = (int)$_POST[ 'pst_ID' ];
			$nonce = $_POST[ 'featurednonce' ];
			if( !wp_verify_nonce( $nonce, 'sfp-switch-featured' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			update_post_meta( $pst_id, '_thumbnail_id', $att_id );
			$response = json_encode( array( 'success' => true ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		
		/**
		* @desc suggest for tags and search
		*/
		function sfp_suggest_tag_cat() {
			global $wpdb;
			$input = $_GET[ 'q' ];
			$q_res = "SELECT $wpdb->terms.term_id, $wpdb->terms.name, $wpdb->term_taxonomy.term_id, $wpdb->term_taxonomy.taxonomy 
						FROM $wpdb->terms 
						INNER JOIN $wpdb->term_taxonomy ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id 
						WHERE $wpdb->terms.name LIKE '%$input%' 
						AND $wpdb->term_taxonomy.taxonomy = 'sfp_post_tags'";
			$q_res_run = $wpdb->get_results( $q_res );
			if( $q_res_run ) {
				foreach( $q_res_run as $result ) echo $result->name . "\n";
			}
			exit;
		}
		function sfp_suggest_search_cat() {
			global $wpdb;
			$input = $_GET[ 'q' ];
			$q_res = "SELECT $wpdb->terms.term_id, $wpdb->terms.name, $wpdb->term_taxonomy.term_id, $wpdb->term_taxonomy.taxonomy 
						FROM $wpdb->terms 
						INNER JOIN $wpdb->term_taxonomy ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id 
						WHERE $wpdb->terms.name LIKE '%$input%' 
						AND ($wpdb->term_taxonomy.taxonomy = 'sfp_post_category' OR $wpdb->term_taxonomy.taxonomy = 'sfp_post_tags')";
			$q_res_run = $wpdb->get_results( $q_res );
			if( $q_res_run ) {
				foreach( $q_res_run as $result ) echo $result->name . "\n";
			}
			exit;
		}
		function sfp_suggest_search_meta() {
			global $wpdb;
			$input = $_GET[ 'q' ];
			$q_res = "SELECT meta_key, meta_value  
						FROM $wpdb->postmeta 
						WHERE ( meta_key = 'pd_city' OR meta_key = 'pd_country' ) 
						AND meta_value LIKE '%$input%' 
						GROUP BY meta_value";
			$q_res_run = $wpdb->get_results( $q_res );
			if( $q_res_run ) {
				foreach( $q_res_run as $result ) echo $result->meta_value . "\n";
			}
			exit;
		}
		
		/**
		* @desc delete entry
		*/
		function sfp_delete_entry() {
			$pst_id = (int)$_POST[ 'pst_ID' ];
			$nonce = $_POST[ 'deletenonce' ];
			if( !wp_verify_nonce( $nonce, 'sfp-delete-entry' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			wp_delete_post( $pst_id ); // post to delete
			// remove attachments too
			$args = array( 'post_parent' => $pst_id );
			$post_attachments = get_children( $args );
			if( $post_attachments ) {
				foreach( $post_attachments as $attachment ) wp_delete_attachment( $attachment->ID, true );
			}
			$response = json_encode( array( 'success' => true ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		
		/**
		* @desc cancel sponsored entry
		*/
		function sfp_cancel_sponsored_entry() {
			$pst_id = (int)$_POST[ 'pst_ID' ];
			$nonce = $_POST[ 'cancelnonce' ];
			if( !wp_verify_nonce( $nonce, 'sfp-cancel-sponsored-entry' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			// delete post meta 'is_sponsored'
			$dpm_result = update_post_meta( $pst_id, 'is_sponsored', '0' );
			$response = json_encode( array( 'success' => true, 'dpm_result' => $dpm_result ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		
		/**
		* @desc contact publisher
		*/
		function sfp_contact_publisher() {
			$pst_id = (int)$_POST[ 'pst_id' ];
			$pst_title = isset( $_POST[ 'pst_title' ] ) ? esc_attr( $_POST[ 'pst_title' ] ) : NULL;
			$author_email = isset( $_POST[ 'author_email' ] ) ? esc_attr( $_POST[ 'author_email' ] ) : NULL;
			$msg_email = isset( $_POST[ 'msg_email' ] ) ? esc_attr( $_POST[ 'msg_email' ] ) : NULL;
			$msg_subject = isset( $_POST[ 'msg_subject' ] ) ? esc_attr( $_POST[ 'msg_subject' ] ) : NULL;
			$msg_cont = isset( $_POST[ 'msg_cont' ] ) ? esc_attr( $_POST[ 'msg_cont' ] ) : NULL;
			$nonce = $_POST[ 'contactnonce' ];
			$err_msg = '';
			if( !wp_verify_nonce( $nonce, 'sfp-contact-publisher' ) ) die ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
			// send message to publisher
			$author_email_decoded = gzinflate( base64_decode( $author_email ) );
			if( is_email( $author_email_decoded ) ) {
				
				if( is_email( $msg_email ) ) {
					if( is_multisite() ) $blogname = $GLOBALS[ 'current_site' ]->site_name;
					else $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
					
					$headers = "MIME-Version: 1.0\n" . "From: <$msg_email>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n";
					
					$title = '';
					if( !$msg_subject ) $title = sprintf( __( '[%s] - Inquiry', $this->localizationDomain ), $blogname );
					else $title = $blogname . ', "' . $msg_subject . '"';
					
					if( trim( $msg_cont ) == '' || !$msg_cont ) {
						$err_msg = __( 'Message field can not be empty, please enter some text.', $this->localizationDomain );
					} else {
						$message = '::::: ' . __( 'User inquiry regarding your Entry:', $this->localizationDomain ) . ' <strong>' . $pst_title . '</strong><br /><br /><br />';
						$message .= $msg_cont . "<br /><br />";
						$message .= get_permalink( $pst_id ) . '<br />';
						
						if( $message && !mail( $author_email_decoded, $title, $message, $headers ) ) $err_msg = __( 'Message could not be sent! Possible reason: your host may have disabled PHP\'s mail() function.', $this->localizationDomain );
					}
				} else $err_msg = __( 'Your e-mail address doesn\'t seem to be valid!', $this->localizationDomain );
				
			} else $err_msg = __( 'Entry author e-mail address is unknown.', $this->localizationDomain );
			
			$response = json_encode( array( 'success' => true, 'err' => $err_msg ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		
		/**
		* @desc login, registration, forgotten password
		*/
		function sfp_handle_logins() {
			global $wpdb;
			$u_name = ( isset( $_POST[ 'u_name' ] ) ) ? $_POST[ 'u_name' ] : NULL;
			$u_pass = ( isset( $_POST[ 'u_pass' ] ) ) ? $_POST[ 'u_pass' ] : NULL;
			$u_email = ( isset( $_POST[ 'u_email' ] ) ) ? $_POST[ 'u_email' ] : NULL;
			$u_lost = ( isset( $_POST[ 'u_lost' ] ) ) ? $_POST[ 'u_lost' ] : NULL;
			$u_action = ( isset( $_POST[ 'u_action' ] ) ) ? $_POST[ 'u_action' ] : NULL;
			$u_redirect = ( isset( $_POST[ 'u_redirect' ] ) ) ? $_POST[ 'u_redirect' ] : NULL;
			$u_remember = ( isset( $_POST[ 'u_remember' ] ) ) ? $_POST[ 'u_remember' ] : NULL;
			$u_pass1 = ( isset( $_POST[ 'u_pass1' ] ) ) ? $_POST[ 'u_pass1' ] : NULL;
			$u_pass2 = ( isset( $_POST[ 'u_pass2' ] ) ) ? $_POST[ 'u_pass2' ] : NULL;
			$u_obj = ( isset( $_POST[ 'u_id' ] ) ) ? $_POST[ 'u_id' ] : NULL; // serialized, obfuscated object
			$nonce = $_POST[ 'loginnonce' ];
			
			if( !wp_verify_nonce( $nonce, 'sfp-handle-logins' ) ) {
				echo ( __( 'You are not allowed to perform such action!', $this->localizationDomain ) );
				return;	
			}

			// proceed according to action
			$err_msg = '';
			if( $u_action == 'login' ) { // handle login
				$user_arr = array( 'user_login' => $u_name, 'user_password' => $u_pass, 'remember' => $u_remember );
				$sign_user_on = wp_signon( $user_arr, false );
				if( is_wp_error( $sign_user_on ) ) {
					if( !empty( $sign_user_on->errors[ 'invalid_username' ] ) ) $err_msg = __( 'Wrong Username or Password!', $this->localizationDomain );
					else {
						$err_msg = __( 'Login error!', $this->localizationDomain );
					}
				}
			} else if( $u_action == 'lost' ) { // handle password lost
			
				$user_data = false;
				if( $u_lost ) {

					$login = trim( $u_lost );
					if( strpos( $u_lost, '@' ) ) $user_data = get_user_by( 'email', trim( $u_lost ) );
					else $user_data = get_user_by( 'login', $login );
					
					do_action( 'lostpassword_post' );

				} else $err_msg = __( 'Username or e-mail address not provided!', $this->localizationDomain );
				
				if( $u_lost && !$user_data ) $err_msg = __( 'Username or e-mail do not exist! You can register if you like.', $this->localizationDomain );
				
				if( $u_lost && $user_data ) {
					
					do_action( 'lostpassword_post' );
					
					$user_login = $user_data->user_login;
					$user_email = $user_data->user_email;
					
					//do_action( 'retreive_password', $user_login );
					do_action( 'retrieve_password', $user_login );
					
					$allow = apply_filters( 'allow_password_reset', true, $user_data->ID );
					
					if( !$allow ) $err_msg = __( 'Password reset is currently not allowed!', $this->localizationDomain );
					else if( is_wp_error( $allow ) ) $err_msg = $allow->get_error_message();
					
					if( $allow && !is_wp_error( $allow ) ) {
	
						$key = $wpdb->get_var( $wpdb->prepare( "SELECT user_activation_key FROM $wpdb->users WHERE user_login = %s", $user_login ) );
						if( empty( $key ) ) {
							$key = wp_generate_password( 20, false );
							do_action( 'retrieve_password_key', $user_login, $key );
							$wpdb->update( $wpdb->users, array( 'user_activation_key' => $key ), array( 'user_login' => $user_login ) );
						}
						$message = __( 'Someone requested that the password be reset for the following account:', $this->localizationDomain ) . "\r\n\r\n";
						$message .= network_home_url( '/' ) . "\r\n\r\n";
						$message .= sprintf( __( 'Username: %s', $this->localizationDomain ), $user_login ) . "\r\n\r\n";
						$message .= __( 'If this was a mistake, just ignore this email and nothing will happen.', $this->localizationDomain ) . "\r\n\r\n";
						$message .= __( 'To reset your password, visit the following address:', $this->localizationDomain ) . "\r\n\r\n";
						//$message .= '<' . network_site_url( "wp-login.php?action=rp&key=$key&login=" . rawurlencode( $user_login ), 'login' ) . ">\r\n";
						$message .= '<' . add_query_arg( array( 'action' => 'rp', 'key' => $key, 'login' => rawurlencode( $user_login ) ), get_permalink( $this->options[ 'sfp_page_login' ] ) ) . ">\r\n";
					
						if( is_multisite() ) $blogname = $GLOBALS[ 'current_site' ]->site_name;
						else $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
					
						$title = sprintf( __( '[%s] Password Reset', $this->localizationDomain ), $blogname );
					
						$title = apply_filters( 'retrieve_password_title', $title );
						$message = apply_filters( 'retrieve_password_message', $message, $key );
					
						if( $message && !mail( $user_email, $title, $message ) ) $err_msg = __( 'E-mail with a new password could not be sent! Possible reason: your host may have disabled PHP\'s mail() function.', $this->localizationDomain );
					
					}
					
				}
			} else if( $u_action == 'register' ) { // handle new user registration
				// is user info valid?
				$u_name_valid  = validate_username( $u_name );
				$u_name_exist  = username_exists( $u_name );
				$u_email_valid = is_email( $u_email );
				$u_email_exist = email_exists( $u_email );
				
				if( $u_name_valid && !$u_name_exist ) {
					
					if( $u_email_valid && !$u_email_exist ) {
						
						// both username and email are valid and do not exist
						$upass = wp_generate_password();
						$user_data = array(
							'ID' => '',
							'user_pass' => $upass,
							'user_login' => $u_name,
							'user_email' => $u_email,
							'role' => get_option( 'default_role' )
						);
						
						$user_id = wp_insert_user( $user_data );
						if( is_wp_error( $user_id ) ) $err_msg = $user_id->get_error_message();
						else {
							do_action( 'user_register', $user_id );
							// send email
							if( is_multisite() ) $blogname = $GLOBALS[ 'current_site' ]->site_name;
							else $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
						
							$title = sprintf( __( '[%s] New user account created', $this->localizationDomain ), $blogname );
							
							$message = __( 'Great! You have created a brand new account at our website:', $this->localizationDomain ) . "\r\n\r\n";
							$message .= network_home_url( '/' ) . "\r\n\r\n";
							$message .= sprintf( __( 'Username: %s', $this->localizationDomain ), $u_name ) . "\r\n\r\n";
							$message .= sprintf( __( 'Password: %s', $this->localizationDomain ), $upass ) . "\r\n\r\n";
							$message .= __( 'You can login here:', $this->localizationDomain ) . "\r\n\r\n";
							$message .= '<' . get_permalink( $this->options[ 'sfp_page_login' ] ) . ">\r\n";
							
							if( $message && !mail( $u_email, $title, $message ) ) $err_msg = __( 'Registration e-mail could not be sent! Possible reason: your host may have disabled PHP\'s mail() function.', $this->localizationDomain );
						}
						
					} else {
						if( !$u_email_valid ) $err_msg = __( 'E-mail is not valid!', $this->localizationDomain );
						else if( $u_email_exist ) $err_msg = __( 'E-mail already exist!', $this->localizationDomain );
					}
					
				} else {
					if( !$u_name_valid ) $err_msg = __( 'Username is not valid!', $this->localizationDomain );
					else if( $u_name_exist ) $err_msg = __( 'Username already exist!', $this->localizationDomain );
				}
				
			} else if( $u_action == 'reset' ) { // handle forgotten password
				if( $u_pass1 && $u_pass1 != $u_pass2 ) {
					$err_msg = __( 'The passwords do not match.', $this->localizationDomain );
				} elseif( $u_pass1 && !empty( $u_pass1 ) ) {
					$u_obj_unserial = unserialize( gzinflate( base64_decode( $u_obj ) ) );
					
					do_action( 'password_reset', $u_obj_unserial, $u_pass1 );
					wp_set_password( $u_pass1, $u_obj_unserial->ID );
					
					// send email
					if( is_multisite() ) $blogname = $GLOBALS[ 'current_site' ]->site_name;
					else $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
				
					$title = sprintf( __( '[%s] Password reset', $this->localizationDomain ), $blogname );
					
					$message = __( 'OK! You have successfully reset your password at our website:', $this->localizationDomain ) . "\r\n\r\n";
					$message .= network_home_url( '/' ) . "\r\n\r\n";
					$message .= sprintf( __( 'Your new password: %s', $this->localizationDomain ), $u_pass1 ) . "\r\n\r\n";
					$message .= __( 'You can login here:', $this->localizationDomain ) . "\r\n\r\n";
					$message .= '<' . get_permalink( $this->options[ 'sfp_page_login' ] ) . ">\r\n";
					
					if( $message && !mail( $u_obj_unserial->user_email, $title, $message ) ) $err_msg = __( 'New password could not be sent! Possible reason: your host may have disabled PHP\'s mail() function.', $this->localizationDomain );
				}
			}
			
			$response = json_encode( array( 'success' => true, 'err' => $err_msg ) );
			header( "Content-Type: application/json" );
			echo $response;
			exit;
		}
		function sfp_check_password_reset_key( $key, $login ) {
			global $wpdb;
			$key = preg_replace( '/[^a-z0-9]/i', '', $key );
			if( empty( $key ) || !is_string( $key ) ) return new WP_Error( 'invalid_key', __( 'Invalid key' ) );
			if( empty( $login ) || !is_string( $login ) ) return new WP_Error( 'invalid_key', __( 'Invalid key' ) );
			$user = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $wpdb->users WHERE user_activation_key = %s AND user_login = %s", $key, $login ) );
			if( empty( $user ) ) return new WP_Error( 'invalid_key', __( 'Invalid key' ) );
			return $user;
		}
		
		/**
		* @desc Tidy Dashboard
		*/
		function disable_default_dashboard_widgets() {
			//remove_meta_box('dashboard_right_now', 'dashboard', 'core');
			//remove_meta_box('dashboard_recent_comments', 'dashboard', 'core');
			remove_meta_box('dashboard_incoming_links', 'dashboard', 'core');
			remove_meta_box('dashboard_plugins', 'dashboard', 'core');
			//remove_meta_box('dashboard_quick_press', 'dashboard', 'core');
			remove_meta_box('dashboard_recent_drafts', 'dashboard', 'core');
			remove_meta_box('dashboard_primary', 'dashboard', 'core');
			remove_meta_box('dashboard_secondary', 'dashboard', 'core');
		}
		
		/**
		* @desc add plugin stats to Dashboard as a widget
		*/
		function sfp_dashboard_widget() {
			global $wpdb;
			$key_meta_key = 'is_sponsored';
			$key_meta_value = '1';
			//$q_sponsored = "SELECT p.ID, p.post_status, m.post_id, m.meta_key, m.meta_value FROM $wpdb->posts p LEFT JOIN $wpdb->postmeta m ON p.ID = m.post_id WHERE m.meta_key = 'is_sponsored' AND m.meta_value = '1' AND p.post_status = 'publish'";
			$q_sponsored = "SELECT p.ID, p.post_status, m.post_id, m.meta_key, m.meta_value FROM $wpdb->posts p LEFT JOIN $wpdb->postmeta m ON p.ID = m.post_id WHERE m.meta_key = %s AND m.meta_value = %s AND p.post_status = 'publish'";
			$q_all_sponsored = $wpdb->get_results( $wpdb->prepare( $q_sponsored, $key_meta_key, $key_meta_value ) );
			$_num_posts = wp_count_posts( 'sfpposts' ); // sfpposts
			$num_publish = number_format_i18n( $_num_posts->publish );
			$num_pending = number_format_i18n( $_num_posts->pending );
			$num_expired = number_format_i18n( $_num_posts->expired );
			$num_duetopay = number_format_i18n( $_num_posts->{'due-to-pay'} );
			$_num_cats  = wp_count_terms( 'sfp_post_category' ); // categs
			$num_cats = number_format_i18n( $_num_cats );
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-published">' . $num_publish . '</span><span class="data-string">' . __( 'Published Entries', $this->localizationDomain ) . '</span></div>';
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-pending">' . $num_pending . '</span><span class="data-string">' . __( 'Entries Pending Approval', $this->localizationDomain ) . '</span></div>';
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-expired">' . $num_expired . '</span><span class="data-string">' . __( 'Expired Entries', $this->localizationDomain ) . '</span></div>';
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-due">' . $num_duetopay . '</span><span class="data-string">' . __( 'Due-to-pay Entries', $this->localizationDomain ) . '</span></div>';
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-sponsored">' . count( $q_all_sponsored ) . '</span><span class="data-string">' . __( 'Sponsored Entries', $this->localizationDomain ) . '</span></div>';
			echo '<div class="sfp-dashboard-widget-row"><span class="data-num n-cats">' . $num_cats . '</span><span class="data-string">' . __( 'Categories', $this->localizationDomain ) . '</span></div>';
			// payments
			$tbl_name = "{$wpdb->prefix}sfp_payments";
			//$q_earnings = "SELECT paypal_bulk FROM {$wpdb->prefix}sfp_payments";
			$q_earnings = "SELECT paypal_bulk FROM %s";
			$q_all_earnings = $wpdb->get_results( $wpdb->prepare( $q_earnings, $tbl_name ) );
			$earnings = 0;
			if( $q_all_earnings ) {
				foreach( $q_all_earnings as $item ) {
					$item_array = unserialize( $item->paypal_bulk );
					$earnings = $earnings + $item_array[ 'mc_gross' ];
				}
			}
			echo '<h2>' . __( 'Earnings total', $this->localizationDomain ) . ': ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $earnings, 2, '.', '' ) . '</h2>';
		}
		function sfp_add_dashboard_widgets() {
			global $wp_meta_boxes;
			wp_add_dashboard_widget( 'sofa_front_post_stats', 'Sofa Front Post stats', array(&$this,'sfp_dashboard_widget') );

			$normal_dashboard = $wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ];

			$widget_backup = array( 'sofa_front_post_stats' => $normal_dashboard[ 'sofa_front_post_stats' ] );
			unset( $normal_dashboard[ 'sofa_front_post_stats' ] );
		
			$sorted_dashboard = array_merge( $widget_backup, $normal_dashboard );

			$wp_meta_boxes[ 'dashboard' ][ 'normal' ][ 'core' ] = $sorted_dashboard;
		}
		
		/**
		* @desc Create Custom Post Type and Custom Taxonomy
		*/
		function sofa_front_post_cpt_and_ct() {
			
			$sfp_type_labels = array(
				'name' => _x( 'SFP Posts', 'post type general name' ),
				'singular_name' => _x( 'SFP Post', 'post type singular name' ),
				'add_new' => _x( 'Add New SFP Post', 'sfppost' ),
				'add_new_item' => __( 'Add New SFP Post', $this->localizationDomain ),
				'edit_item' => __( 'Edit SFP Post', $this->localizationDomain ),
				'new_item' => __( 'Add New SFP Post', $this->localizationDomain ),
				'all_items' => __( 'View SFP Posts', $this->localizationDomain ),
				'view_item' => __( 'View SFP Post', $this->localizationDomain ),
				'search_items' => __( 'Search SFP Posts', $this->localizationDomain ),
				'not_found' =>  __( 'No SFP Posts found', $this->localizationDomain ),
				'not_found_in_trash' => __( 'No SFP Posts found in Trash', $this->localizationDomain ), 
				'parent_item_colon' => '',
				'menu_name' => 'SFP Posts'
			);
			
			$sfp_type_args = array(
				'labels' => $sfp_type_labels,
				'public' => true,
				'query_var' => true,
				'rewrite' => true,
				'capability_type' => 'post',
				'has_archive' => true, 
				'hierarchical' => false,
				'show_ui' => true,
				'publicly_queryable' => true,
				/*'show_in_menu' => 'true',*/
				'menu_position' => '',
				'menu_icon' => $this->urlpath .'/images/sfp_icon.png',
				'supports' => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'custom-fields', 'comments', 'revisions' )
			); 
			
			register_post_type( 'sfpposts', $sfp_type_args );
			
			// entry categories
			$sfp_category_labels = array(
				'name' => _x( 'SFP Categories', 'taxonomy general name' ),
				'singular_name' => _x( 'SFP Post', 'taxonomy singular name' ),
				'search_items' =>  __( 'Search SFP Post Categories', $this->localizationDomain ),
				'all_items' => __( 'All SFP Post Categories', $this->localizationDomain ),
				'parent_item' => __( 'Parent SFP Post Category', $this->localizationDomain ),
				'parent_item_colon' => __( 'Parent SFP Post Category:', $this->localizationDomain ),
				'edit_item' => __( 'Edit SFP Post Category', $this->localizationDomain ), 
				'update_item' => __( 'Update SFP Post Category', $this->localizationDomain ),
				'add_new_item' => __( 'Add New SFP Post Category', $this->localizationDomain ),
				'new_item_name' => __( 'New SFP Post Name', $this->localizationDomain ),
				'menu_name' => __( 'SFP Post Categories', $this->localizationDomain ),
			); 	
			
			$sfp_category_args = array(
				'hierarchical' => true,
				'labels' => $sfp_category_labels,
				'show_ui' => true,
				'query_var' => true,
				'show_in_nav_menus' => true,
				'rewrite' => array( 'slug' => 'sfp_post_category' ),
			);
			
			register_taxonomy( 'sfp_post_category', array( 'sfpposts' ), $sfp_category_args );
			
			$default_sfp_cat = array( 'Miscellaneous' );
			if( !term_exists( $default_sfp_cat[ 0 ], 'sfp_post_category' ) ) wp_insert_term( $default_sfp_cat[ 0 ], 'sfp_post_category' );
			
			// entry tags
			$sfp_tag_labels = array(
				'name' => _x( 'SFP Tags', 'taxonomy tag name' ),
				'singular_name' => _x( 'SFP Tag', 'taxonomy tag singular name' ),
				'search_items' =>  __( 'Search SFP Tags', $this->localizationDomain ),
				'all_items' => __( 'All SFP Tags', $this->localizationDomain ),
				'parent_item' => __( 'Parent SFP Tag', $this->localizationDomain ),
				'parent_item_colon' => __( 'Parent SFP Tag:', $this->localizationDomain ),
				'edit_item' => __( 'Edit SFP Tag', $this->localizationDomain ), 
				'update_item' => __( 'Update SFP Tag', $this->localizationDomain ),
				'add_new_item' => __( 'Add New SFP Tag', $this->localizationDomain ),
				'new_item_name' => __( 'New SFP Tag', $this->localizationDomain ),
				'menu_name' => __( 'SFP Tags', $this->localizationDomain ),
			); 	
			
			$sfp_tag_args = array(
				'hierarchical' => false,
				'labels' => $sfp_tag_labels,
				'show_ui' => true,
				'query_var' => true,
				'show_in_nav_menus' => false,
				'rewrite' => array( 'slug' => 'sfp_post_tags' ),
			);
			
			register_taxonomy( 'sfp_post_tags', array( 'sfpposts' ), $sfp_tag_args );
			
			flush_rewrite_rules(); // we have to avoid 404 by flushing rewrite rules!!!			
		}
		
		/**
		* @desc enqueue admin relevant javascript
		*/
		function sofa_front_post_script() {
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'jquery-validate', $this->urlpath . '/js/jquery.validate.js', array( 'jquery' ) );
			wp_enqueue_script( 'sofa_front_post_script', $this->urlpath . '/js/admin_options.js' );
			wp_localize_script( 'sofa_front_post_script', 'sfp_limits', array(
				'required' => __('Please enter a number.', $this->localizationDomain),
				'number'   => __('Please enter a number.', $this->localizationDomain),
				'min'	  => __('Please enter a value greater than or equal to 0.', $this->localizationDomain),
				'less'	  => __('Please enter a value greater than or equal to 0.1', $this->localizationDomain),
				'one'	  => __('Please enter a value greater than or equal to 1.', $this->localizationDomain)
			) );

			/* styles */
			wp_register_style( 'sfp_css_admin', $this->urlpath . '/css/css_admin.css' );
			wp_enqueue_style( 'sfp_css_admin' );
		}
		
		/**
		* @desc enqueue user relevant javascript
		*/
		function sofa_front_post_user_js() {
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'suggest' );
			/* validation */
			if( is_page( $this->options[ 'sfp_page_new_entry' ] ) || is_page( $this->options[ 'sfp_page_edit_entry' ] ) ) {
				wp_enqueue_script( 'jquery-validate', $this->urlpath . '/js/jquery.validate.js', array( 'jquery' ) );
				wp_enqueue_script( 'sfp_validation_rules_entry', $this->urlpath . '/js/validation_rules_entry.js' );
				wp_localize_script( 'sfp_validation_rules_entry', 'sfp_vrule', array( 
					'gmapsenabled' => $this->options[ 'sfp_enable_gmaps' ],
					'required' => __('This field is mandatory!', $this->localizationDomain),
					'sfptitle' => __('Title is mandatory! It must contain at least 5 characters.', $this->localizationDomain),
					'sfpcontent' => __('Content is mandatory! It must contain at least 165 characters.', $this->localizationDomain),
					'sfpexcerpt' => __('This is non-mandatory input field. If you are about to fill it up, at least 120 characters is required!', $this->localizationDomain),
					'sfpaddress' => __('Address must be at least 5 characters long.', $this->localizationDomain),
					'sfpcity' => __('City must be at least 2 characters long.', $this->localizationDomain),
					'sfpzip' => __('ZIP code must be at least 4 characters long.', $this->localizationDomain),
					'sfpcountry' => __('Country must be at least 3 characters long.', $this->localizationDomain),
					'sfpurl' => __('This is non-mandatory input field. If you are about to fill it up, URL must be valid!', $this->localizationDomain)
				) );
				
				/* dynamic upload image fields */
				wp_enqueue_script( 'file_upload', $this->urlpath . '/js/file_upload.js' );
				wp_localize_script( 'file_upload', 'sfp_file_upload', array( 'counter' => $this->options[ 'sfp_limit_img_upload' ] ) );
				
				/* suggest tags for new entry form and edit entry form */
				wp_enqueue_script( 'run_suggest', $this->urlpath . '/js/run_suggest.js' );
				wp_localize_script( 'run_suggest', 'run_suggest_vars', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ) ) );
			
			}

			/* suggest for search */
			wp_enqueue_script( 'run_suggest_search', $this->urlpath . '/js/run_suggest_search.js' );
			wp_localize_script( 'run_suggest_search', 'run_suggest_search_vars', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ) ) );
			
			/* remove images from entry gallery */
			if( is_page( $this->options[ 'sfp_page_edit_entry' ] ) ) {
				wp_enqueue_script( 'file_remove', $this->urlpath . '/js/file_remove.js' );
				wp_localize_script( 'file_remove', 'sfp_file_remove', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'delnonce' => wp_create_nonce( 'att-rem-nonce' ), 'msgnotok' => __( "ERROR! Entry attachment can not be deleted!", $this->localizationDomain ), 'confirmation' => __( "Do you really want to delete selected image?", $this->localizationDomain ) ) );
				
				/* switch featured image */
				wp_enqueue_script( 'make_featured_image', $this->urlpath . '/js/make_featured_image.js' );
				wp_localize_script( 'make_featured_image', 'sfp_featured_maker', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'featurednonce' => wp_create_nonce( 'sfp-switch-featured' ), 'msgok' => __( "Featured image has been changed!", $this->localizationDomain ), 'msgnotok' => __( "ERROR! Featured image can not be changed!", $this->localizationDomain ), 'makeitfeatured' => __( 'Make it Featured', $this->localizationDomain ), 'isalreadyfeatured' => __( 'Featured Image', $this->localizationDomain ) ) );
			}
			
			/* delete entry, cancel sponsored entry */
			if( is_page( $this->options[ 'sfp_page_entries_list' ] ) ) {
				wp_enqueue_script( 'delete_entry', $this->urlpath . '/js/delete_entry.js' );
				wp_localize_script( 'delete_entry', 'sfp_delete_user_entry', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'deletenonce' => wp_create_nonce( 'sfp-delete-entry' ), 'msgnotok' => __( "ERROR! Selected Entry can\'t be deleted!", $this->localizationDomain ), 'confirmation' => __( 'Are you sure about deleting selected Entry?', $this->localizationDomain ) ) );
				
				wp_enqueue_script( 'cancel_sponsored_entry', $this->urlpath . '/js/cancel_sponsored_entry.js' );
				wp_localize_script( 'cancel_sponsored_entry', 'sfp_cancel_sponsorship', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'cancelnonce' => wp_create_nonce( 'sfp-cancel-sponsored-entry' ), 'msgnotok' => __( "ERROR! Sponsorship for selected Entry can\'t be canceled!", $this->localizationDomain ), 'confirmation' => __( 'Do you really want to cancel sponsorship for selected Entry?', $this->localizationDomain ) ) );
			}
			
			/* login, registration, pass recovery */
			if( is_page( $this->options[ 'sfp_page_login' ] ) ) {
				wp_enqueue_script( 'handle_logins', $this->urlpath . '/js/handle_logins.js' );
				wp_localize_script( 'handle_logins', 'handle_logins_vars', array( 
					'ajaxpath' => admin_url( 'admin-ajax.php' ), 
					'loginnonce' => wp_create_nonce( 'sfp-handle-logins' ), 
					'usernamevalid' => __( "ERROR! Selected username is invalid!", $this->localizationDomain ), 
					'userexist' => __( "ERROR! Selected username already exist!", $this->localizationDomain ), 
					'emailexist' => __( 'ERROR! Selected e-mail address already exist!', $this->localizationDomain ) ) );
			}
			
			if( is_singular( 'sfpposts' ) && $this->options[ 'sfp_enable_gmaps' ] ) {
				// includeGoogleMaps
				wp_enqueue_script( 'googlemaps', 'http://maps.googleapis.com/maps/api/js?key=' . $this->options[ 'sfp_gmaps_api_key' ] . '&sensor=true' );
				wp_enqueue_script( 'run_gmaps', $this->urlpath . '/js/google_maps.js' );
			}
			
			/* contact entry author */
			if( is_singular( 'sfpposts' ) ) {
				wp_enqueue_script( 'contact_author', $this->urlpath . '/js/contact_author.js' );
				wp_localize_script( 'contact_author', 'var_contact_author', array( 'ajaxpath' => admin_url( 'admin-ajax.php' ), 'contactnonce' => wp_create_nonce( 'sfp-contact-publisher' ) ) );
			}
			
			/* helpers */
			wp_enqueue_script( 'sfp_helpers', $this->urlpath . '/js/helpers.js' );
			
			/* plugin front-end styles */
			wp_register_style( 'sfp_css', $this->urlpath . '/css/style.css' );
			wp_enqueue_style( 'sfp_css' );

		}
		
		/**
		* @desc Retrieves the plugin options from the database.
		* @return array
		*/
		function getOptions() {
			if (!$theOptions = get_option($this->optionsName)) {
				$theOptions = array(
				'sfp_edit_in_html' => '1',
				'sfp_edit_post' => '0',
				'sfp_delete_post' => '1',
				'sfp_allow_img_upload' => '1',
				'sfp_limit_img_upload' => '1',
				'sfp_limit_file_size' => '2',
				'sfp_save_post_as' => 'pending',
				'sfp_enable_excerpt' => '1',
				'sfp_enable_tags' => '1',
				'sfp_enable_phone' => '1',
				'sfp_enable_url' => '1',
				'sfp_enable_personal_details' => '1',
				'sfp_enable_gmaps' => '1',
				'sfp_gmaps_api_key' => 'Enter your own API key',
				'sfp_enable_contact' => '1',
				'sfp_page_login' => '2',
				'sfp_page_entries_list' => '2',
				'sfp_page_entries_search' => '2',
				'sfp_page_entries_archives' => '2',
				'sfp_page_user_payments' => '2',
				'sfp_page_new_entry' => '2',
				'sfp_page_edit_entry' => '2',
				'sfp_page_make_payment' => '2',
				'sfp_page_terms' => '2',
				'sfp_publish_type' => 'optional',
				'sfp_enable_sandbox' => '1',
				'sfp_enable_sandbox_email' => 'valid.sandbox@paypalsandbox.com',
				'sfp_paypal_email' => 'your.paypal@yoursite.com',
				'sfp_currency' => 'USD',
				'sfp_paypal_locale' => 'EN',
				'sfp_fee' => '5',
				'sfp_sponsored_fee' => '2',
				'sfp_drop_due_to_pays' => '24',
				'sfp_expire' => '30',
				'sfp_force_accept_terms' => '1',
				'sfp_show_n_entries' => '10',
				'sfp_knock_off_dash' => '0',
				'sfp_notify_upon_expiration' => '0',
				'sfp_public_email' => 'you@yourdomain.com',
				'sfp_disable_entry_comments' => '0',
				'sfp_force_dtp_delete' => '0'
				);
				update_option($this->optionsName, $theOptions);
			}
			$this->options = $theOptions;
		}
		/**
		* Saves the admin options to the database.
		*/
		function saveAdminOptions(){
			return update_option($this->optionsName, $this->options);
		}

		/**
		* @desc Adds the options subpanel
		*/
		function admin_menu_link() {
			add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array(&$this, 'filter_plugin_actions'), 10, 2 );
			
			// add new page to edit custom post type menu
			add_submenu_page( 'edit.php?post_type=sfpposts', __('Manage Options', $this->localizationDomain), __('Manage Options', $this->localizationDomain), 'manage_options', 'sfp-manage-options', array(&$this,'admin_options_page') );
		}

		/**
		* @desc Adds the Settings link to the plugin activate/deactivate page
		*/
		function filter_plugin_actions($links, $file) {
		   $settings_link = '<a href="edit.php?post_type=sfpposts&page=sfp-manage-options">' . __('Settings') . '</a>';
		   array_unshift( $links, $settings_link ); // before other links

		   return $links;
		}

		/**
		* Adds settings/options page
		*/
		function admin_options_page() { 
			if( isset( $_POST[ 'sofa_front_post_save' ] ) ) {
				if( !wp_verify_nonce( $_POST[ '_wpnonce' ], 'sofa_front_post-update-options') ) {
					_e('Whoops! There was a problem with the data you posted. Please go back and try again.', $this->localizationDomain);
					return;
				}
				/* user permissions */
				$this->options[ 'sfp_edit_in_html' ] = ( isset( $_POST[ 'sfp_edit_in_html' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_edit_post' ] = ( isset( $_POST[ 'sfp_edit_post' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_delete_post' ] = ( isset( $_POST[ 'sfp_delete_post' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_allow_img_upload' ] = ( isset( $_POST[ 'sfp_allow_img_upload' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_limit_img_upload' ] = (int)$_POST[ 'sfp_limit_img_upload' ];
				$this->options[ 'sfp_limit_file_size' ] = (float)$_POST[ 'sfp_limit_file_size' ];
				$this->options[ 'sfp_save_post_as' ] = $_POST[ 'sfp_save_post_as' ];
				/* -- end user permissions -- */
				/* input fields */
				$this->options[ 'sfp_enable_excerpt' ] = ( isset( $_POST[ 'sfp_enable_excerpt' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_tags' ] = ( isset( $_POST[ 'sfp_enable_tags' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_phone' ] = ( isset( $_POST[ 'sfp_enable_phone' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_url' ] = ( isset( $_POST[ 'sfp_enable_url' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_personal_details' ] = ( isset( $_POST[ 'sfp_enable_personal_details' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_gmaps' ] = ( isset( $_POST[ 'sfp_enable_gmaps' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_gmaps_api_key' ] = $_POST[ 'sfp_gmaps_api_key' ];
				$this->options[ 'sfp_enable_contact' ] = ( isset( $_POST[ 'sfp_enable_contact' ] ) ) ? 1 : 0;
				/* -- end input fields -- */
				/* plugin pages  */
				$this->options[ 'sfp_page_login' ] = $_POST[ 'sfp_page_login' ];
				$this->options[ 'sfp_page_entries_list' ] = $_POST[ 'sfp_page_entries_list' ];
				$this->options[ 'sfp_page_entries_search' ] = $_POST[ 'sfp_page_entries_search' ];
				$this->options[ 'sfp_page_entries_archives' ] = $_POST[ 'sfp_page_entries_archives' ];
				$this->options[ 'sfp_page_user_payments' ] = $_POST[ 'sfp_page_user_payments' ];
				$this->options[ 'sfp_page_new_entry' ] = $_POST[ 'sfp_page_new_entry' ];
				$this->options[ 'sfp_page_edit_entry' ] = $_POST[ 'sfp_page_edit_entry' ];
				$this->options[ 'sfp_page_make_payment' ] = $_POST[ 'sfp_page_make_payment' ];
				$this->options[ 'sfp_page_terms' ] = $_POST[ 'sfp_page_terms' ];
				/* -- end plugin pages -- */
				/* payment settings */
				$this->options[ 'sfp_publish_type' ] = $_POST[ 'sfp_publish_type' ];
				$this->options[ 'sfp_enable_sandbox' ] = ( isset( $_POST[ 'sfp_enable_sandbox' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_enable_sandbox_email' ] = $_POST[ 'sfp_enable_sandbox_email' ];
				$this->options[ 'sfp_paypal_email' ] = $_POST[ 'sfp_paypal_email' ];
				$this->options[ 'sfp_currency' ] = $_POST[ 'sfp_currency' ];
				$this->options[ 'sfp_paypal_locale' ] = $_POST[ 'sfp_paypal_locale' ];
				$this->options[ 'sfp_fee' ] = (float)$_POST[ 'sfp_fee' ];
				$this->options[ 'sfp_sponsored_fee' ] = (float)$_POST[ 'sfp_sponsored_fee' ];
				$this->options[ 'sfp_drop_due_to_pays' ] = (int)$_POST[ 'sfp_drop_due_to_pays' ]; 
				$this->options[ 'sfp_expire' ] = (int)$_POST[ 'sfp_expire' ];
				$this->options[ 'sfp_force_accept_terms' ] = ( isset( $_POST[ 'sfp_force_accept_terms' ] ) ) ? 1 : 0;
				/* -- end payment settings -- */
				/* other settings */ 
				$this->options[ 'sfp_show_n_entries' ] = (int)$_POST[ 'sfp_show_n_entries' ];
				$this->options[ 'sfp_knock_off_dash' ] = ( isset( $_POST[ 'sfp_knock_off_dash' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_notify_upon_expiration' ] = ( isset( $_POST[ 'sfp_notify_upon_expiration' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_public_email' ] = $_POST[ 'sfp_public_email' ];
				$this->options[ 'sfp_disable_entry_comments' ] = ( isset( $_POST[ 'sfp_disable_entry_comments' ] ) ) ? 1 : 0;
				$this->options[ 'sfp_force_dtp_delete' ] = ( isset( $_POST[ 'sfp_force_dtp_delete' ] ) ) ? 1 : 0;
				/* -- end other settings -- */

				$this->saveAdminOptions();

				echo '<div class="updated"><p>' . __('Success! Your changes were sucessfully saved!', $this->localizationDomain) . '</p></div>';
			}
			
			// include options
			//require_once( plugin_dir_path( __FILE__ ) . 'include/options_set.php' );
			require_once( 'include/options_set.php' );
		}
		

		/**
		* @desc if post is not public (like pending, expired or due-to-pay), it can't be previewed by regular user.
		*       we have to enable entry preview irregardless the post status
		*/
		function sfp_peek_into_private( $posts, &$query ) {
			if( is_user_logged_in() ) {
				global $current_user;
				get_currentuserinfo();
				if( !isset( $_GET[ 'key' ] ) ) return $posts;
				$key = esc_attr( $_GET[ 'key' ] );
				$key_sent = gzinflate( base64_decode( $key ) );
				$author_email_addr = get_the_author_meta( 'user_email', $current_user->ID );
				if( $key_sent != $author_email_addr ) return $posts;
				if( sizeof( $posts ) != 1 ) return $posts;
				$status = get_post_status( $posts[ 0 ] );
				$post_status_obj = get_post_status_object( $status );
				if( $post_status_obj->public ) return $posts;
				$query->_my_private_stash = $posts; /* stash away */
				add_filter( 'the_posts', array(&$this,'sfp_inject_private'), NULL, 2 );
			} else return $posts;
		}
		function sfp_inject_private( $posts, &$query ) {
			remove_filter( 'the_posts', array(&$this,'sfp_inject_private'), NULL, 2 );
			return $query->_my_private_stash;
		}
		
		/**
		* @desc Return list of pages based on input
		*/
		function list_of_plugin_pages( $selection_id_string ) {
			
			$pages_list = '<select name="' . $selection_id_string . '">';
			$options_pages = array();  
			$options_pages_obj = get_pages( 'sort_column=post_parent,menu_order' );

			foreach ( $options_pages_obj as $page ) {
				$pages_list .= '<option value="' . $page->ID . '" ' . selected( $page->ID, $this->options[ $selection_id_string ], false ) . '> -- ' . $page->post_title . ' -- </option>';
			}
			
			$pages_list .= '</select>';
			
			echo $pages_list;
		}
		
		/**
		* @desc check for similar entry in database
		*/
		function sfp_found_similar( $pack_up_mandatory ) {
			
			global $wpdb;
			
			if( $pack_up_mandatory ) {
				$unpack_mandatory = unserialize( $pack_up_mandatory );
				$p_title = $unpack_mandatory[ 0 ];
				$p_content = $unpack_mandatory[ 1 ];
				
				// match stuff
				$q_match_stuff = "SELECT ID FROM $wpdb->posts WHERE post_type = 'sfpposts' AND ( post_status = 'publish' OR post_status = 'pending' OR post_status = 'due-to-pay' OR post_status = 'expired' ) AND ( post_title LIKE '%{$p_title}%' OR post_content = '{$p_content}' ) LIMIT 0, 1";
				$match_stuff = $wpdb->get_row( $q_match_stuff );
				if( $match_stuff ) return $match_stuff->ID;
				
			} else return 0;
			
		}
		
		/**
		* @desc add extra layer to footer
		*/
		function sfp_add_dim_screen_layer() {
			echo '<div id="sfp-fuzz"><div class="sfp-fuzz-msgbox"><img src="' . $this->urlpath . '/images/loader.gif" alt="loading..." /></div></div>';
		}
		
		/**
		* @desc disable dashboard access for non-admins
		*/
		function sfp_knock_off_dashboard() {
			if( $this->options[ 'sfp_knock_off_dash' ] ) {
				if( !current_user_can( 'administrator' ) ) {
					wp_redirect( home_url() );
					exit();
				}
			}
		}
		
		/**
		* @desc pagination fix for custom taxonomy
		*/
		function sfp_pagination_fix( $wp_query ) {
			if( !is_admin() && ( is_tax( 'sfp_post_category' ) || is_tax( 'sfp_post_tags' ) ) ) {
				$wp_query->query_vars[ 'posts_per_page' ] = $this->options[ 'sfp_show_n_entries' ];
			}
			return $wp_query;
		}
		
		/**
		* @desc return no paragraphed content for new entry form and edit entry form
		*/
		function sfp_paragraph_fix( $content ) {
			if( is_page( $this->options[ 'sfp_page_new_entry' ] ) || is_page( $this->options[ 'sfp_page_edit_entry' ] ) ) {
				$content = str_replace( "\r\n", '', $content );
			}
			return $content;
		}
		
		/**
		* @desc complicated sorting fix for sfpposts (is_sponsored first)
		*/	
		function sfp_chck_query_vars( $query ) {
			/* SPECIAL CASE FOR ARCHIVES */
			if( isset( $query->query_vars[ 'sfp_archives' ] ) && $query->query_vars[ 'sfp_archives' ] === 'yeap' ) add_filter( 'posts_orderby', array( &$this,'sfp_modify_orderby' ) );
			/* SPECIAL CASE FOR LATEST ENTRIES SHORTCODE */
			if( isset( $query->query_vars[ 'sfp_sc_request' ] ) && $query->query_vars[ 'sfp_sc_request' ] === 'yeap' ) add_filter( 'posts_orderby', array( &$this,'sfp_modify_orderby_shortcode' ) );
			/* SPECIAL CASE FOR SEACRH */
			if( isset( $query->query_vars[ 'sfp_complex_search' ] ) && $query->query_vars[ 'sfp_complex_search' ] === 'yeap' ) {
				add_filter( 'posts_join', array( &$this,'sfp_modify_search_join' ) );
				add_filter( 'posts_where', array( &$this,'sfp_modify_search_where' ) );
				add_filter( 'posts_orderby', array( &$this,'sfp_modify_search_order' ) );
			}
			/* END SPECIAL CASE FOR SEACRH */
			return $query;
		}
		function sfp_modify_orderby( $orderby ) {
			if( !is_admin() && ( is_tax( 'sfp_post_category' ) || is_tax( 'sfp_post_tags' ) || is_page( $this->options[ 'sfp_page_entries_archives' ] ) || is_page( $this->options[ 'sfp_page_entries_search' ] ) ) ) {
				global $wpdb;
				$orderby = " $wpdb->postmeta.meta_value DESC, $wpdb->posts.post_date DESC ";
			}
			return $orderby;
		}
		function sfp_modify_orderby_shortcode( $orderby ) {
			if( !is_admin() ) {
				global $wpdb;
				$orderby = " $wpdb->postmeta.meta_value DESC, $wpdb->posts.post_date DESC ";
			}
			return $orderby;
		}
		function sfp_modify_search_join( $join ) {
			global $wpdb;
			$join .= " INNER JOIN $wpdb->postmeta AS mt2 ON ($wpdb->posts.ID = mt2.post_id) ";
			return $join;
		}
		function sfp_modify_search_where( $where ) {
			global $wpdb;
			$clause = " AND mt2.meta_key = 'is_sponsored' ";
			$where = $clause . $where;
			return $where;
		}
		function sfp_modify_search_order( $orderby ) {
			global $wpdb;
			$orderby = " CASE WHEN mt2.meta_value = 0 THEN 1 END, $wpdb->posts.post_date DESC ";
			return $orderby;
		}
		
		function sfp_remove_orderby_filter() {
			remove_filter( 'posts_orderby', array( &$this,'sfp_modify_orderby' ) );
		}
		function sfp_remove_orderby_filter_shortcode() {
			remove_filter( 'posts_orderby', array( &$this,'sfp_modify_orderby_shortcode' ) );
		}
		function sfp_remove_search_filters() {
			remove_filter( 'posts_join', array( &$this,'sfp_modify_search_join' ) );
			remove_filter( 'posts_where', array( &$this,'sfp_modify_search_where' ) );
			remove_filter( 'posts_orderby', array( &$this,'sfp_modify_search_order' ) );
		}
		
	} //End Class
} //End if class exists statement


if (isset($_GET['sofa_front_post_javascript'])) {
	//embed javascript
	Header("content-type: application/x-javascript");
	echo<<<ENDJS
ENDJS;

} else {
	if( class_exists( 'sofa_front_post' ) ) { 
		$SFP = new sofa_front_post();
	}
}

// something that will be needed sooner or later
require_once( 'include/custom_functions.php' );
require_once( 'update-notifier.php' );