// JavaScript Document
/* a set of rules to apply to new Entry form and edit Entry form before saved to database */

jQuery( document ).ready( function() {

// Validate
// http://bassistance.de/jquery-plugins/jquery-plugin-validation/
// http://docs.jquery.com/Plugins/Validation/
// http://docs.jquery.com/Plugins/Validation/validate#toptions

	// if google maps are enabled, address, city, zip and country are mandatory!
	if( parseInt( sfp_vrule.gmapsenabled ) ) {
		
		jQuery( '#add_new_entry_form' ).validate( {
			ignore: "",
			rules: {
			  sfp_personal_details_address: {
				minlength: 5,
				required: true
			  },
			  sfp_personal_details_city: {
				minlength: 2,
				required: true
			  },
			  sfp_personal_details_zip: {
				minlength: 4,
				required: true
			  },
			  sfp_personal_details_country: {
				minlength: 3,
				required: true
			  },
			  sfp_entry_title: {
				minlength: 5,
				required: true
			  },
			  sfp_entry_content: {
				minlength: 165,
				required: true
			  },
			  sfp_entry_excerpt: {
				minlength: 120
			  },
			  sfp_entry_url: {
				url: true
			  }
			},
			messages: {
			  sfp_personal_details_address: {
				sfpaddress: sfp_vrule.sfpaddress,
				required: sfp_vrule.required
			  },
			  sfp_personal_details_city: {
				sfpcity: sfp_vrule.sfpcity,
				required: sfp_vrule.required
			  },
			  sfp_personal_details_zip: {
				  sfpzip: sfp_vrule.sfpzip,
				  required: sfp_vrule.required
			  },
			  sfp_personal_details_country: {
				  sfpcountry: sfp_vrule.sfpcountry,
				  required: sfp_vrule.required
			  },
			  sfp_entry_title: {
				sfptitle: sfp_vrule.sfptitle,
				required: sfp_vrule.required
			  },
			  sfp_entry_content: {
				sfpcontent: sfp_vrule.sfpcontent,
				required: sfp_vrule.required
			  },
			  sfp_entry_excerpt: sfp_vrule.sfpexcerpt,
			  sfp_entry_url: sfp_vrule.sfpurl
			},
			errorPlacement: function( label, element ) {
				if( element.is( "textarea" ) && !element.is( ":visible" ) ) label.insertAfter( element.next() );
				else label.insertAfter( element );
			}
			
		} );
		
	} else {
	
	jQuery( '#add_new_entry_form' ).validate( {
		ignore: "",
		rules: {
		  sfp_entry_title: {
			minlength: 5,
			required: true
		  },
		  sfp_entry_content: {
			minlength: 165,
			required: true
		  },
		  sfp_entry_excerpt: {
			minlength: 120
		  },
		  sfp_entry_url: {
			url: true
		  }
		},
		messages: {
		  sfp_entry_title: {
			sfptitle: sfp_vrule.sfptitle,
			required: sfp_vrule.required
		  },
		  sfp_entry_content: {
			sfpcontent: sfp_vrule.sfpcontent,
			required: sfp_vrule.required
		  },
		  sfp_entry_excerpt: sfp_vrule.sfpexcerpt,
		  sfp_entry_url: sfp_vrule.sfpurl
		},
		errorPlacement: function( label, element ) {
			if( element.is( "textarea" ) && !element.is( ":visible" ) ) label.insertAfter( element.next() );
			else label.insertAfter( element );
		}
		
		} );
	
	}
	
	jQuery( '#sfp_submit' ).click( function() {
		tinyMCE.triggerSave();
		var status;
		status = jQuery( "#add_new_entry_form" ).valid(); //Validate again
		if( status == true ) jQuery( "#sfp-fuzz" ).fadeIn();
	} );
	  
} ); // end document.ready

function tinyMCE_callback_validate() {
    tinyMCE.triggerSave();
    jQuery( '#sfp_entry_content' ).valid();
}