// JavaScript Document
/* handle login, registration, password recovery */

jQuery( document ).ready( function() {

	jQuery( '#sfp-u-login' ).click( function() {
		
		jQuery( "#sfp-fuzz" ).fadeIn();
		jQuery( "#sfp-err-response" ).fadeOut();
		
		var form = jQuery( this ).parents( 'form:first' ); // form id
		var logg = jQuery( '#log', form ).val();
		var pwd = jQuery( '#pwd', form ).val();
		var rem = jQuery( '#rememberme', form ).val();
		var act = jQuery( '#sfp-action', form ).val();
		var redir = jQuery( '#sfp-redirect', form ).val();

		jQuery.post(
			handle_logins_vars.ajaxpath,
			{
				action: 'sfp_handle_logins',
				u_name: logg,
				u_pass: pwd,
				u_remember: rem,
				u_action: act,
				u_redirect: redir,
				loginnonce: handle_logins_vars.loginnonce
			},
			function( response ) {
				if( response != 0 ) {
					if( response.err != '' ) {
						jQuery( "#sfp-err-response span" ).text( response.err );
						jQuery( "#sfp-err-response" ).fadeIn();
						jQuery( "#sfp-fuzz" ).hide();
					} else window.location.href = redir;
				} else {
					alert( "Something went really wrong..." );
				}
			}
		);
		
		return false;
		
	} );
	
	jQuery( '#sfp-u-register' ).click( function() {
		
		jQuery( "#sfp-fuzz" ).fadeIn();
		jQuery( "#sfp-err-response" ).fadeOut();
		
		var form = jQuery( this ).parents( 'form:first' ); // form id
		var logg = jQuery( '#user_login', form ).val();
		var email = jQuery( '#user_email', form ).val();
		var act = jQuery( '#sfp-action-register', form ).val();
		var redir = jQuery( '#sfp-redirect-register', form ).val();
		
		jQuery.post(
			handle_logins_vars.ajaxpath,
			{
				action: 'sfp_handle_logins',
				u_name: logg,
				u_email: email,
				u_action: act,
				u_redirect: redir,
				loginnonce: handle_logins_vars.loginnonce
			},
			function( response ) {
				if( response != 0 ) {
					if( response.err != '' ) {
						jQuery( "#sfp-err-response span" ).text( response.err );
						jQuery( "#sfp-err-response" ).fadeIn();
						jQuery( "#sfp-fuzz" ).hide();
					} else window.location.href = redir;
				} else {
					alert( "Something went really wrong..." );
				}
			}
		);

		return false;
		
	} );
	
	jQuery( '#sfp-u-lost' ).click( function() {
		
		jQuery( "#sfp-fuzz" ).fadeIn();
		jQuery( "#sfp-err-response" ).fadeOut();
		
		var form = jQuery( this ).parents( 'form:first' ); // form id
		var lost = jQuery( '#user_lost', form ).val();
		var act = jQuery( '#sfp-action-lost', form ).val();
		var redir = jQuery( '#sfp-redirect-lost', form ).val();
		
		jQuery.post(
			handle_logins_vars.ajaxpath,
			{
				action: 'sfp_handle_logins',
				u_action: act,
				u_lost: lost,
				u_redirect: redir,
				loginnonce: handle_logins_vars.loginnonce
			},
			function( response ) {
				if( response != 0 ) {
					if( response.err != '' ) {
						jQuery( "#sfp-err-response span" ).text( response.err );
						jQuery( "#sfp-err-response" ).fadeIn();
						jQuery( "#sfp-fuzz" ).hide();
					} else window.location.href = redir;
				} else {
					alert( "Something went really wrong..." );
				}
			}
		);

		return false;
		
	} );
	
	jQuery( '#sfp-u-password-reset' ).click( function() {
		
		jQuery( "#sfp-fuzz" ).fadeIn();
		jQuery( "#sfp-err-response" ).fadeOut();
		
		var form = jQuery( this ).parents( 'form:first' ); // form id
		var pass1 = jQuery( '#pass1', form ).val();
		var pass2 = jQuery( '#pass2', form ).val();
		var logg = jQuery( '#user_login', form ).val();
		var uid = jQuery( '#true_user', form ).val();
		var act   = jQuery( '#sfp-action-reset', form ).val();
		var redir = jQuery( '#sfp-redirect-reset', form ).val();
		
		jQuery.post(
			handle_logins_vars.ajaxpath,
			{
				action: 'sfp_handle_logins',
				u_pass1: pass1,
				u_pass2: pass2,
				u_name: logg,
				u_id: uid,
				u_action: act,
				u_redirect: redir,
				loginnonce: handle_logins_vars.loginnonce
			},
			function( response ) {
				if( response != 0 ) {
					if( response.err != '' ) {
						jQuery( "#sfp-err-response span" ).text( response.err );
						jQuery( "#sfp-err-response" ).fadeIn();
						jQuery( "#sfp-fuzz" ).hide();
					} else window.location.href = redir;
				} else {
					alert( "Something went really wrong..." );
				}
			}
		);

		return false;
		
	} );
	
} );