// JavaScript Document
/* geocoding google maps method */

function sfp_initialize_google_maps() {
	var geocoder;
	var map;
	var infowindow = new google.maps.InfoWindow();
	geocoder = new google.maps.Geocoder();
	//var latlng = new google.maps.LatLng(-34.397, 150.644);
	var mapOptions = {
		zoom: 16,
		/*center: latlng,*/
		mapTypeId: google.maps.MapTypeId.ROADMAP
	}
	map = new google.maps.Map( document.getElementById( "map_canvas" ), mapOptions );

	var address = document.getElementById( "map_address" ).value;
	var address_trunks = address.split( ',' ); // [ 0 ] - street, [ 1 ] - city, [ 2 ] - state + zip, [ 3 ] - country
	var address_marker = address_trunks[ 0 ] + '<br />' + address_trunks[ 1 ] + '<br />' + address_trunks[ 2 ] + '<br />' + address_trunks[ 3 ];
	geocoder.geocode( { 'address': address }, function( results, status ) {
		if( status == google.maps.GeocoderStatus.OK ) {
			map.setCenter( results[ 0 ].geometry.location );
			var marker = new google.maps.Marker( {
				map: map,
				position: results[ 0 ].geometry.location
			} ); // marker end
			
			google.maps.event.addListener( marker, 'click', function() {
				infowindow.close();
				infowindow.setContent( address_marker );
				infowindow.open( map, marker );
			} );
			
		} else {
			//alert( "Geocode was not successful for the following reason: " + status );
			document.getElementById( "map_canvas" ).style.display = "none";
		}
	} );
}

/* initialize map */
jQuery( function() {
	sfp_initialize_google_maps();
} );