// JavaScript Document
/* handle files removal from entry gallery */

jQuery( document ).ready( function() {

	var slot_counter = 2;
	// we must find out what's initial number of free upload slots
	var slots_keeper = jQuery( 'input#att_slots_keeper' ).attr( 'name' );
	free_slots_handler( parseInt( slots_keeper ) );
	
	jQuery( 'a.sfp-media-remove' ).click( function() {
		
		var answer = confirm( sfp_file_remove.confirmation );
		if( !answer ) return false;
		
		var tag_name = jQuery( this ).attr( 'name' );
		var params_in_name = tag_name.split( '_' ); // first: att_NNN, second: post_NNN
		var attID = parseInt( params_in_name[ 1 ] );
		var pstID = parseInt( params_in_name[ 3 ] );
		jQuery.post(
			sfp_file_remove.ajaxpath,
			{
				action: 'sfp_delete_attachment',
				att_ID: attID,
				pst_ID: pstID,
				delnonce: sfp_file_remove.delnonce,
				post_type: 'attachment'
			},
			function( response ) {
				if( response != 0 ) {
					jQuery( 'dl.sfp_att-item-' + attID ).fadeOut( 250 );
					slots_keeper = response.freeslots;
					free_slots_handler( slots_keeper );
				} else {
					alert( sfp_file_remove.msgnotok );
				}
			}
		);
		
		return false;
		
	} );
	
	jQuery( '#sfp_append_file' ).click( function() {
		if( slot_counter <= parseInt( slots_keeper ) ) {
			jQuery( '#sfp_new_file_tools' ).before( '<div class="sfp_new_file_upload" id="sfp_new_file_' + slot_counter + '"><input name="sfp_new_file[]" type="file"></div>' );
			jQuery( '#sfp_drop_file' ).fadeIn( 150 );
			slot_counter ++;
			if( slot_counter == ( parseInt( slots_keeper ) + 1 ) ) jQuery( '#sfp_append_file' ).hide();
		}
	} );
	
	jQuery( '#sfp_drop_file' ).click( function() {
		if( slot_counter == 3 ) jQuery( '#sfp_drop_file' ).hide();
		if( slot_counter <= ( parseInt( slots_keeper ) + 1 ) ) jQuery( '#sfp_append_file' ).fadeIn( 150 );
		slot_counter --;
		jQuery( '#sfp_new_file_' + slot_counter ).remove();
	} );	
	
} );

function free_slots_handler( free_left ) {
	jQuery( '#sfp_upload_limit em' ).text( free_left );
	if( free_left <= 0 ) {
		jQuery( '#sfp_new_file_1' ).hide();
		jQuery( '#sfp_new_file_tools' ).hide();
		jQuery( '#sfp-quota-full' ).show();
		return;
	} else {
		jQuery( '#sfp_new_file_1' ).show();
		jQuery( '#sfp_new_file_tools' ).show();
		jQuery( '#sfp-quota-full' ).hide();
	}
	
	jQuery( '#sfp_drop_file' ).hide();
	
	if( parseInt( free_left )  == 1 ) jQuery( '#sfp_append_file' ).hide();
	else if( parseInt( free_left )  > 1 ) jQuery( '#sfp_append_file' ).show();
	
}