<?php
/**
* @desc Support for shortcode [sfp_transactions]
*/

global $current_user;
get_currentuserinfo();

// if user is logged in ...
if( !is_user_logged_in() ) {
	echo __( 'You must be logged in otherwise you are not allowed to access your Entries!', $this->localizationDomain );
	return;
}

global $wpdb;
$cu_ID = $current_user->ID;
$sfp_query = "SELECT p.post_title, s.id, s.user_id, s.paypal_bulk FROM {$wpdb->prefix}posts p RIGHT JOIN {$wpdb->prefix}sfp_payments s ON p.ID = s.post_id WHERE s.user_id = %d ORDER BY s.id DESC";
$sfp_q_store = $wpdb->get_results( $wpdb->prepare( $sfp_query, $cu_ID ) );

if( $sfp_q_store ) {
	foreach( $sfp_q_store as $row ) {
		$post_title_true = $row->post_title;
		$transaction_arr = unserialize( $row->paypal_bulk );
		//var_dump( $transaction_arr );
		// is entry alive or deleted?
		$entry_status = 'sfp-alive'; // sfp-alive, sfp-deleted
		if( $post_title_true != $transaction_arr[ 'item_name' ] ) $entry_status = 'sfp-deleted';
?>

<div class="sfp-trnsaction-row <?php echo $entry_status; ?>">
	<h2 class="entry-h2-loop">
		<?php 
		if( $entry_status == 'sfp-alive' ) echo '<a href="' . get_permalink( $transaction_arr[ 'item_number' ] ) . '" target="_blank">' . $transaction_arr[ 'item_name' ] . '</a>';
		else echo $transaction_arr[ 'item_name' ];
		?>
	</h2>
	<span class="sfp-trans-meta-row sfp-meta-fee">
		<?php 
		$custom_arr = explode( '~', $transaction_arr[ 'custom' ] );
		$transaction_reason = $custom_arr[ 2 ]; // regular, regular_sponsored, sponsored
		$trans_regular_str = __( 'Payed for Entry publish.', $this->localizationDomain );
		$trans_sponsored_str = __( 'Payed for Sponsored Entry publish.', $this->localizationDomain );
		$trans_regular_sponsored_str = __( 'Payed for Entry publish and Sponsorship.', $this->localizationDomain );
		echo '<span class="sfp-sub-fee">' . __( 'Fee:', $this->localizationDomain ) . ' ' . currency_handler( $transaction_arr[ 'mc_currency' ] ) . ' ' . number_format( $transaction_arr[ 'mc_gross' ], 2, '.', '' ) . '</span>';
		if( $transaction_reason == 'regular' ) {
			echo ' ( ' . $trans_regular_str . ' )';
		} elseif( $transaction_reason == 'sponsored' ) {
			echo ' ( ' . $trans_sponsored_str . ' )';
		} elseif( $transaction_reason == 'regular_sponsored' ) {
			echo ' ( ' . $trans_regular_sponsored_str . ' )';
		}
		?> 
	</span>
	<span class="sfp-trans-meta-row sfp-meta-transid">
		<?php echo __( 'Transaction ID', $this->localizationDomain ) . ': ' . $transaction_arr[ 'txn_id' ]; ?>
	</span>
	<span class="sfp-trans-meta-row sfp-meta-transdate add-bottom">
		<?php echo __( 'Date of transaction', $this->localizationDomain ) . ': ' . $transaction_arr[ 'payment_date' ]; ?>
	</span>
	<p class="sfp-separator"></p>
</div>

<?php
	}
} else {
	echo '<p>' . __( 'No payments/transactions found for your account!', $this->localizationDomain ) . '</p>';
}