<?php
/**
* @desc Support for shortcode [sfp_search per_page=NN]
*/
?>

<?php
global $wp_query;

$sfp_search_tax  = ( isset( $_GET[ 'sfp_search_tax' ] ) ? esc_attr( $_GET[ 'sfp_search_tax' ] ) : NULL );
$sfp_search_meta = ( isset( $_GET[ 'sfp_search_meta' ] ) ? esc_attr( $_GET[ 'sfp_search_meta' ] ) : NULL );

// default posts per page
$postsperpage = get_option( 'posts_per_page' );
// extract attributes
extract( shortcode_atts( array( 'per_page' => $postsperpage, 'show_search_form' => 'yes' ), $atts ) );

// show form or not
if( $show_search_form == 'yes' ) sfp_search_form();

// handle term
$term_id = 0;
$terms_arr = get_term_by( 'name', $sfp_search_tax, 'sfp_post_category' );
if( $terms_arr ) $term_id = $terms_arr->term_id;
else {
	// try searching for term in entry tags
	$terms_arr_tags = get_term_by( 'name', $sfp_search_tax, 'sfp_post_tags' );
	if( $terms_arr_tags ) $term_id = $terms_arr_tags->term_id;
}
$selected_tax = !$terms_arr ? 'sfp_post_tags' : 'sfp_post_category';

// compose query
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
if( !$sfp_search_meta ) {
	// if no value provided for $sfp_search_meta
	$sfp_query_args = array(
		'sfp_archives' => 'yeap', 
		'tax_query' => array( array( 'taxonomy' => $selected_tax, 'terms' => $term_id ) ),
		'meta_key' => 'is_sponsored',
		'post_type' => 'sfpposts',
		'post_status' => 'publish',
		'showposts' => (int)$per_page,
		'paged' => $paged
	);
} else {
	$sfp_query_args = array(
		'sfp_complex_search' => 'yeap', 
		'tax_query' => array( array( 'taxonomy' => $selected_tax, 'terms' => $term_id ) ),
		'post_type' => 'sfpposts',
		'post_status' => 'publish',
		'showposts' => (int)$per_page,
		'paged' => $paged, 
		'meta_query' => array( 'relation' => 'OR', 
				array( 'key' => 'pd_city', 'value' => $sfp_search_meta, 'compare' => 'LIKE' ), 
				array( 'key' => 'pd_country', 'value' => $sfp_search_meta, 'compare' => 'LIKE' )
				)
	);
}

$sfp_search = new WP_Query( $sfp_query_args );

// preserve original query
$TEMP_query = $wp_query;
$wp_query = NULL;
$wp_query = $sfp_search;

// Start the Loop
if( have_posts() ) : while( have_posts() ) : the_post();
?>
            
<div class="sfp-entry-wrap<?php if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo ' sfp-sponsored'; ?>" id="sfp-entry-wrap-<?php the_ID(); ?>">
    
    <hgroup>
        <h2 class="entry-h2-loop">
            <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', $this->localizationDomain ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                <?php the_title(); ?>
            </a>
        </h2>
        <h3 class="sfp-entry-cat">
        <?php 
        if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo __( 'Sponsored', $this->localizationDomain ) . ' | ';
        $categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
        printf( __( '<span class="%1$s">Found in:</span> %2$s', $this->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
        ?>
        </h3>
    </hgroup>
    
    <div class="sfp-section sfp-section-meta border-b">
    
        <dl>
        
            <dt class="meta-text">
        
                <?php
                if( $this->options[ 'sfp_enable_personal_details' ] ) : 

                    $sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
                    $sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
                    $sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
                    $sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
                    $sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
                    $sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
                    $gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
                    $personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
                ?>
                    <div class="meta-personal-details"><?php echo $personal_details; ?></div>
                <?php endif; ?>
                
                <?php if( $this->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
                    <div class="meta-phone">
                        <span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $this->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
                    </div>
                <?php endif; ?>
                
                <?php if( $this->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
                    <div class="meta-website">
                        <a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
                    </div>
                <?php endif; ?>
        
            </dt>
            
            <?php if( has_post_thumbnail( get_the_ID() ) ) : ?>
            <dt class="meta-image">
                <?php
                $thumb = get_post_thumbnail_id();
                $image = vt_resize( $thumb, '', 100, 60, false );
                ?>
                <img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
            </dt>
            <?php endif; ?>
        
        </dl>
    
    </div>
    
    
    <?php if( $this->options[ 'sfp_enable_excerpt' ] && has_excerpt( get_the_ID() ) ) : ?>
    <div class="sfp-entry-content-wrap">
    <?php the_excerpt(); ?>
    <?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', $this->localizationDomain ) . '</span>', 'after' => '</div>' ) ); ?>
    </div><!-- .entry-content -->
    <?php endif; ?>

    <footer class="sfp-tags-wrap">
        
        <?php
        $tags_list = get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' );
        if( $tags_list && $this->options[ 'sfp_enable_tags' ] ) :
        echo $tags_list;
        endif;
		?>

    </footer>
    
</div>

<?php endwhile; ?>

<?php 
if( function_exists( 'wp_pagenavi' ) ) wp_pagenavi();
else {
	$total_pages = $wp_query->max_num_pages;
	if ( $total_pages > 1 ) {
?>
<div class="navigation">
	<div class="alignleft"><?php previous_posts_link( __( '&laquo; Previous Entries', $this->localizationDomain ) ); ?></div>
	<div class="alignright"><?php next_posts_link( __( 'Next Entries &raquo;', $this->localizationDomain ) ); ?></div>
</div>
<?php
	} // end if total pages > 1
} // end else; if wp_pagenavi doesn't exist
?>
<?php
// get back original loop
$wp_query = $TEMP_query;
?>
<?php
else :
	if( isset( $_GET[ 'sfp-submit-search' ] ) ) echo '<p>' . __( 'Sorry, no Entries found in here!', $this->localizationDomain ) . '</p>';
endif;

wp_reset_query();
$this->sfp_remove_search_filters(); // remove all search filters