<?php
/**
* @desc Support for shortcode [sfp_payment]
*/
global $current_user;
get_currentuserinfo();

if( !isset( $_POST[ 'payment_action' ] ) && !isset( $_POST[ 'post_id' ] ) ) {
	echo '<p>' . __( 'Error! Payment can not be processed.', $this->localizationDomain ) . '</p>';
	return;
}
if( isset( $_POST[ 'due-to-pay-form-submitted' ] ) && wp_verify_nonce( $_POST[ 'due-to-pay-form-submitted' ], 'due-to-pay-form' ) ) {
	// entry details
	$post_id = (int)$_POST[ 'post_id' ];
	$post_OBJ = get_post( $post_id );
	$post_title = $post_OBJ->post_title;
	$is_sponsored = get_post_meta( $post_id, 'is_sponsored', true );
	$current_action = $_POST[ 'payment_action' ]; // renew, sponsor, due-to-pay
	
	$fee_total = $this->options[ 'sfp_fee' ];
	$fee_string = '<br /><br />';
	$pp_publish_type = ''; // regular, regular_sponsored, sponsored
	$pay_publish_as = $this->options[ 'sfp_save_post_as' ];
	
	if( $current_action != 'sponsor' ) { // action is either renew or due-to-pay
		if( $this->options[ 'sfp_publish_type' ] == 'payed' ) {
			$fee_string .= __( 'Regular fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_fee' ], 2, '.', '' );
			$pp_publish_type = 'regular';
			if( $is_sponsored ) {
				$fee_total = $this->options[ 'sfp_fee' ] + $this->options[ 'sfp_sponsored_fee' ];
				$fee_string .= '<br />';
				$fee_string .= __( 'Sponsored fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' ) . '<br />';
				$fee_string .= '-----------------------------------<br />';
				$fee_string .= __( 'Total:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $fee_total, 2, '.', '' );
				$pp_publish_type = 'regular_sponsored';
			}
			$pay_publish_as = get_post_status( $post_id );
		} elseif( $this->options[ 'sfp_publish_type' ] == 'optional' ) {
			if( $is_sponsored ) {
				$fee_total = $this->options[ 'sfp_sponsored_fee' ];
				$fee_string .= __( 'Sponsored fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' ) . '<br />';
				$pp_publish_type = 'sponsored';
				$pay_publish_as = get_post_status( $post_id );
			}
		}
	} else {
		// user wants to make Entry sponsored irregardless current publish type
		$fee_total = $this->options[ 'sfp_sponsored_fee' ];
		$fee_string .= __( 'Sponsored fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' ) . '<br />';
		$pp_publish_type = 'sponsored';
		$pay_publish_as = get_post_status( $post_id );
	}
?>
	<p class="sfp-separator"></p>
    
    <?php if( $pp_publish_type == '' ) { 
		// entry was published free of charge
		$post_stuff = array();
		$post_stuff[ 'ID' ] = $post_id;
		$post_stuff[ 'post_date' ] = date( 'Y-m-d H:i:s' );
		$post_stuff[ 'post_date_gmt' ] = date( 'Y-m-d H:i:s' );
		$post_stuff[ 'post_status' ] = 'publish';
		$update_score = wp_update_post( $post_stuff ); // update post
		$update_message = '<p class="entry-form-p">';
		if( $update_score ) {
			$update_message .= '<strong>' . __( 'Payment is not required!', $this->localizationDomain ) . '</strong><br />';
			$update_message .= sprintf( __( 'Your Entry "<strong>%s</strong>" has been successfully renewed!', $this->localizationDomain ), $post_title );
		} else {
			$update_message .= sprintf( __( 'Error! Your Entry "<strong>%s</strong>" can\'t be renewed!', $this->localizationDomain ), $post_title );
		}
		$update_message .= '</p>';
		echo $update_message;
		echo '<p class="sfp-separator"></p>';
		echo '<p><a class="sfp-button" href="' . get_permalink( $this->options[ 'sfp_page_entries_list' ] ) . '">' . __( 'View my Entries!', $this->localizationDomain ) . '</a></p>';
		return;
	
	} else {
	?>
    
        <p class="entry-form-p">
        <?php
		$payment_action_message = '';
		if( $current_action == 'renew' ) $payment_action_message = __( 'You are about to make the payment and thus renew Entry with the following title:', $this->localizationDomain );
		elseif( $current_action == 'due-to-pay' ) $payment_action_message = __( 'You are about to make the payment for Entry with the following title:', $this->localizationDomain );
		elseif( $current_action == 'sponsor' ) $payment_action_message = __( 'After you make the payment Entry with the following title will become sponsored:', $this->localizationDomain );
        echo $payment_action_message;
        echo '<br /><strong>"' . $post_title . '"</strong>';
        echo $fee_string;
        
        $paypal_action = 'https://www.paypal.com/cgi-bin/webscr';
        if( $this->options[ 'sfp_enable_sandbox' ] ) $paypal_action = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
        
        $paypal_email = $this->options[ 'sfp_paypal_email' ];
        if( $this->options[ 'sfp_enable_sandbox' ] ) $paypal_email = $this->options[ 'sfp_enable_sandbox_email' ];
        
        // paypal meta
        $pp_custom = $current_user->ID . '~' . $pay_publish_as . '~' . $pp_publish_type . '~' . $current_action;
        ?>
        </p>
        <p class="sfp-separator"></p>
        
        <!-- terms and conditions agreement -->
        <?php if( $this->options[ 'sfp_force_accept_terms' ] ) : ?>
        <p class="entry-form-p sfp-accept-terms">
        <label for="sfp_force_accept_terms"><?php _e( 'Accept Terms and Conditions', $this->localizationDomain); ?></label>
        <input name="sfp_force_accept_terms" id="sfp_force_accept_terms" type="checkbox" value="1" checked="checked" />
        <span class="input-field-appendix">
            <a href="<?php echo get_permalink( $this->options[ 'sfp_page_terms' ] ); ?>" target="_blank">
                <?php _e( 'I have read and understood Terms and Conditions!', $this->localizationDomain ); ?>
            </a>
        </span>
        <span class="entry-form-tip cant-proceed"><?php _e('You must accept our Terms and Conditions before making payment!', $this->localizationDomain); ?></span>
        </p>
        <?php endif; ?>
        <!-- end terms and conditions agreement -->
        
        <form id="ppform" name="ppform" method="post" action="<?php echo $paypal_action; ?>">
        <input type="hidden" name="cmd" value="_xclick" />
        <input type="hidden" name="business" value="<?php echo $paypal_email; ?>" />
        <input type="hidden" name="lc" value="<?php echo $this->options[ 'sfp_paypal_locale' ]; ?>" />
        <input type="hidden" name="item_name" value="<?php echo $post_title; ?>" />
        <input type="hidden" name="item_number" value="<?php echo $post_id; ?>" />
        <input type="hidden" name="amount" value="<?php echo number_format( $fee_total, 2, '.', '' ); ?>" />
        <input type="hidden" name="currency_code" value="<?php echo $this->options[ 'sfp_currency' ]; ?>" />
        <input type="hidden" name="custom" value="<?php echo $pp_custom; ?>" />
        <input type="hidden" name="no_note" value="1" />
        <input type="hidden" name="no_shipping" value="1" />
        <input type="hidden" name="rm" value="2" />
        <input type="hidden" name="return" value="<?php echo add_query_arg( 'pp', $pp_custom, get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>" />
        <input type="hidden" name="cancel_return" value="<?php echo add_query_arg( 'pp', 'cancel', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>" />
        <input type="hidden" name="notify_url" value="<?php echo plugin_dir_url( __FILE__ ) . 'paypal_ipn.php'; ?>" />
        <input type="hidden" name="cbt" value="<?php _e( 'Back to website', $this->localizationDomain ); ?>" />
        <input type="hidden" name="bn" value="PP-BuyNowBF" />
        <p class="entry-form-p">
        <input type="submit" id="sfp_pay_button" class="sfp-button" value="<?php _e( 'Make the payment now?', $this->localizationDomain ); ?>" />
        </p>
        </form>

<?php
	} // end if not free
} // end if nonce verified