<?php
/**
* @desc Support for shortcode [sfp_login]
*/

?>
<!-- error msg container -->
<div id="sfp-err-response">
<span></span>
</div>
<!-- end error msg container -->

<div id="login-register-password">

	<?php
	// we are dealing with password resets too!
	if( isset( $_GET[ 'action' ] ) && isset( $_GET[ 'key' ] ) && isset( $_GET[ 'login' ] ) ) {
		$_action = esc_attr( $_GET[ 'action' ] );
		$_key    = $_GET[ 'key' ];
		$_login  = $_GET[ 'login' ];
		
		$true_user = $this->sfp_check_password_reset_key( $_key, $_login );
		if( is_wp_error( $true_user ) ) {
			echo '<p>' . __( 'There was an error by validation of your key!', $this->localizationDomain ) . '</p>';
		} else {
			$true_user_serialized = base64_encode( gzdeflate( serialize( $true_user ) ) );
	?>
        <div class="tab_container_login">
        
            <h2 class="entry-h2-loop"><?php _e('Reset password!', $this->localizationDomain); ?></h2>
            <p><?php _e('Enter your new password below!', $this->localizationDomain); ?></p>
            
            <form method="post" action="" id="sfp-password-reset" class="wp-user-form">
            	<input type="hidden" id="user_login" value="<?php echo $_login; ?>" autocomplete="off" />
                <input type="hidden" id="true_user" value="<?php echo $true_user_serialized; ?>" autocomplete="off" />
				<p class="entry-form-p">
					<label for="pass1"><?php _e( 'New Password', $this->localizationDomain ); ?>: </label>
					<input type="password" name="pass1" value="" id="pass1" autocomplete="off" tabindex="3001" />
				</p>
				<p class="entry-form-p">
					<label for="pass2"><?php _e( 'Confirm new password', $this->localizationDomain ); ?>: </label>
					<input type="password" name="pass2" value="" id="pass2" autocomplete="off" tabindex="3002" />
				</p>
                <p class="sfp-separator"></p>
                <input type="submit" name="user-submit" id="sfp-u-password-reset" value="<?php _e( 'Reset Password!', $this->localizationDomain ); ?>" tabindex="3003" class="sfp-button user-submit" />
                <input type="hidden" name="u_action" id="sfp-action-reset" value="reset" />
                <input type="hidden" name="redirect_to" id="sfp-redirect-reset" value="<?php echo add_query_arg( array( 'tab' => 'forgot', 'newpasssent' => 'ok' ), get_permalink() ); ?>" />
            </form>
        
        </div>
	<?php 
		}
		echo '</div>'; // close <div id="login-register-password">
		return;
		// don't display anythig below
		
	}
	?>

	<?php 
	global $user_ID;
	global $user_identity;
	get_currentuserinfo();
	
	if( !$user_ID ) {
	
		$active_tab = ( isset( $_GET[ 'tab' ] ) ? esc_attr( $_GET[ 'tab' ] ) : 'login' );
		$active_tab_class = ' active_login';
	?>

	<ul class="tabs_login">
		<li class="sfp-quasi-button<?php if( $active_tab == 'login' ) echo $active_tab_class; ?>"><a href="#tab1_login"><?php _e('Login', $this->localizationDomain); ?></a></li>
		<li class="sfp-quasi-button<?php if( $active_tab == 'register' ) echo $active_tab_class; ?>"><a href="#tab2_login"><?php _e('Register', $this->localizationDomain); ?></a></li>
		<li class="sfp-quasi-button<?php if( $active_tab == 'forgot' ) echo $active_tab_class; ?>"><a href="#tab3_login"><?php _e('Forgotten password?', $this->localizationDomain); ?></a></li>
	</ul>
    
	<div class="tab_container_login">
    
		<div id="tab1_login" class="tab_content_login"<?php if( $active_tab != 'login' ) echo ' style="display: none;"'; ?>><!-- tab 1 -->

			<h2 class="entry-h2-loop"><?php _e('Sign in to our site', $this->localizationDomain); ?></h2>
            <p><?php _e('You can\'t participate if not logged in!', $this->localizationDomain); ?></p>

			<form method="post" action="" id="sfp-login" class="wp-user-form">
				<p class="entry-form-p">
					<label for="user_login"><?php _e( 'Username', $this->localizationDomain ); ?>: </label>
					<input type="text" name="log" value="" id="log" tabindex="11" />
				</p>
				<p class="entry-form-p">
					<label for="user_pass"><?php _e( 'Password', $this->localizationDomain ); ?>: </label>
					<input type="password" name="pwd" value="" id="pwd" tabindex="12" />
				</p>
                <p class="entry-form-p">
                    <label for="rememberme"><?php _e( 'Remember me?', $this->localizationDomain ); ?> </label>
                    <input type="checkbox" name="rememberme" value="forever" checked="checked" id="rememberme" tabindex="13" /><span class="input-field-appendix"><?php _e( 'Tick to confirm!', $this->localizationDomain ); ?></span>
                </p>
                
                <p class="sfp-separator"></p>
                
				<p class="entry-form-p">
					<?php do_action( 'login_form' ); ?>
					<input type="submit" name="user-submit" id="sfp-u-login" value="<?php _e( 'Login', $this->localizationDomain ); ?>" tabindex="14" class="sfp-button user-submit" />
                    <input type="hidden" name="u_action" id="sfp-action" value="login" />
					<input type="hidden" name="redirect_to" id="sfp-redirect" value="<?php echo add_query_arg( 'tab', 'login', get_permalink() ); ?>" />
					<input type="hidden" name="user-cookie" value="1" />
				</p>
			</form>
            
		</div><!-- tab 1 end -->
        
		<div id="tab2_login" class="tab_content_login"<?php if( $active_tab != 'register' ) echo ' style="display: none;"'; ?>><!-- tab 2 -->
        
			<h2 class="entry-h2-loop"><?php _e('Register for this site!', $this->localizationDomain); ?></h2>
            
            <?php if( get_option('users_can_register') ) : ?>
            
			<?php 
			if( isset( $_GET[ 'registration' ] ) && esc_attr( $_GET[ 'registration' ] ) == 'ok' ) {
				echo '<p>' . __('Registration done! Check your e-mail, login info has been sent.', $this->localizationDomain) . '</p>';
			} else { 
				echo '<p>' . __('Don\'t hesitate to sign up now for all the great stuff!', $this->localizationDomain) . '</p>';
			?>
            
			<form method="post" action="" id="sfp-register"  class="wp-user-form">
				<p class="entry-form-p">
					<label for="user_login"><?php _e( 'Username', $this->localizationDomain ); ?>: </label>
					<input type="text" name="user_login" value="<?php if( isset( $user_login ) ) echo esc_attr( stripslashes( $user_login ) ); ?>" id="user_login" tabindex="101" />
				</p>
				<p class="entry-form-p">
					<label for="user_email"><?php _e( 'Your e-mail', $this->localizationDomain ); ?>: </label>
					<input type="text" name="user_email" value="<?php if( isset( $user_email ) ) echo esc_attr( stripslashes( $user_email ) ); ?>" id="user_email" tabindex="102" />
				</p>
                
                <p class="sfp-separator"></p>
                
				<p class="entry-form-p">
					<?php do_action( 'register_form' ); ?>
					<input type="submit" name="user-submit" id="sfp-u-register"  value="<?php _e( 'Register!', $this->localizationDomain ); ?>" class="sfp-button user-submit" tabindex="103" />
					<?php 
					$register = ( isset( $_GET[ 'register' ] ) ) ? true : false;
					if( $register == true ) {
					?>
					<span class="entry-form-tip"><?php _e('Now check your email for the password and then return to log in.', $this->localizationDomain); ?></span>
					<?php } ?>
                    <input type="hidden" name="u_action" id="sfp-action-register" value="register" />
					<input type="hidden" name="redirect_to" id="sfp-redirect-register" value="<?php echo add_query_arg( array( 'tab' => 'register', 'registration' => 'ok' ), get_permalink() ); ?>" />
					<input type="hidden" name="user-cookie" value="1" />
				</p>
			</form>
            
            <?php
				} // end if registration successfull
			
			else : ?>
            
            <span class="entry-form-tip"><?php _e('For some reason Admin has disabled new user registration.', $this->localizationDomain); ?></span>
            
            <?php endif; ?>
            
		</div><!-- tab 2 end -->
        
		<div id="tab3_login" class="tab_content_login"<?php if( $active_tab != 'forgot' ) echo ' style="display: none;"'; ?>><!-- tab 3 -->
        
			<h2 class="entry-h2-loop"><?php _e('Did you forget your password?', $this->localizationDomain); ?></h2>
			<?php 
			if( isset( $_GET[ 'recovery' ] ) && esc_attr( $_GET[ 'recovery' ] ) == 'ok' ) {
				echo '<p>' . __('Password reset done! Check your e-mail, activation code has been sent.', $this->localizationDomain) . '</p>';
			} else if( isset( $_GET[ 'newpasssent' ] ) && esc_attr( $_GET[ 'newpasssent' ] ) == 'ok' ) {
				echo '<p>' . __('Your new password is active! For your convenience it has been sent by e-mail too.', $this->localizationDomain) . '</p>';
			} else { 
				echo '<p>' . __('Simply enter your username or email to reset password and start all over.', $this->localizationDomain) . '</p>';
			?>
            
			<form method="post" action="" id="sfp-lost" class="wp-user-form">
				<p class="entry-form-p">
					<label for="user_login" class="hide"><?php _e( 'Username or Email', $this->localizationDomain ); ?>: </label>
					<input type="text" name="user_login" value="" id="user_lost" tabindex="1001" />
				</p>
                
                <p class="sfp-separator"></p>
                
				<p class="entry-form-p">
					<?php do_action( 'login_form', 'resetpass' ); ?>
					<input type="submit" name="user-submit" id="sfp-u-lost" value="<?php _e( 'Reset my password', $this->localizationDomain ); ?>" class="sfp-button user-submit" tabindex="1002" />
					<?php 
					$reset = ( isset( $_GET[ 'reset' ] ) ) ? true : false;
					if( $reset == true ) {
					?>
                    <span class="entry-form-tip"><?php _e('A message will be sent to your email address!', $this->localizationDomain); ?></span>
					<?php } ?>
                    <input type="hidden" name="u_action" id="sfp-action-lost" value="lost" />
					<input type="hidden" name="redirect_to" id="sfp-redirect-lost" value="<?php echo add_query_arg( array( 'tab' => 'forgot', 'recovery' => 'ok' ), get_permalink() ); ?>" />
					<input type="hidden" name="user-cookie" value="1" />
				</p>
			</form>
            
            <?php } // end if recovery successful ?>
            
		</div><!-- tab 3 end -->
        
	</div>

	<?php } else { // is logged in ?>

	<div class="sidebox">
    
		<h2 class="entry-h2-loop"><?php echo sprintf( __( 'Hi %s, it\'s great to have you here!', $this->localizationDomain ), $user_identity );?></h2>
        
        <p class="sfp-separator"></p>
        
		<div class="usericon">
			<?php 
			global $userdata;
			get_currentuserinfo();
			echo get_avatar( $userdata->ID, 60 );
			?>
		</div>
        
		<div class="userinfo">
			<p><?php echo $user_identity . ', ' . $userdata->user_email; ?></p>
			<ul class="sfp-user-menu">
            <?php
			//echo '<li id="widget-logged">' . sprintf( __( 'Hi %s, it\'s great to have you here!', $this->localizationDomain ), $user_identity ) . '</li>';
			echo '<li id="widget-logout"><a href="' . wp_logout_url( 'index.php' ) . '">' . __( 'I want to log out!', $this->localizationDomain ) . '</a></li>';
			// user entries
			$user_entries_page_title = get_the_title( $this->options[ 'sfp_page_entries_list' ] );
			echo '<li id="widget-entries"><a href="' . get_permalink( $this->options[ 'sfp_page_entries_list' ] ) . '">' . $user_entries_page_title . '</a></li>';
			// new entry
			$new_entry_page_title = get_the_title( $this->options[ 'sfp_page_new_entry' ] );
			echo '<li id="widget-new-entry"><a href="' . get_permalink( $this->options[ 'sfp_page_new_entry' ] ) . '">' . $new_entry_page_title . '</a></li>';
			// user_payments
			if( $this->options[ 'sfp_publish_type' ] != 'free' ) {
				$payments_page_title = get_the_title( $this->options[ 'sfp_page_user_payments' ] );
				echo '<li id="widget-payments"><a href="' . get_permalink( $this->options[ 'sfp_page_user_payments' ] ) . '">' . $payments_page_title . '</a></li>';
			}
			?>
			</ul>
		</div>
        
	</div>

	<?php } ?>

</div>