<?php
/**
* @desc Support for shortcode [sfp_latest]
*/
?>

<?php
global $wp_query;
// all taxonomy terms
$curr_tax_terms = get_terms( 'sfp_post_category' );
$object_term = array();
foreach( $curr_tax_terms as $struct ) $object_term[] = $struct->term_id;
// default posts per page
$postsperpage = get_option( 'posts_per_page' );
// extract attributes
extract( shortcode_atts( array(
	'cat_id' => $object_term,
	'num_entries' => 5,
	'offset' => 0,
	'show_images' => 'yes',
	'show_tags' => 'yes'
), $atts ) );
// be sure user input is OK...
if( !is_array( $cat_id ) ) {
	$cat_id_arr = explode( ',', $cat_id );
	if( $cat_id_arr ) {
		$TEMP_arr = array();
		foreach( $cat_id_arr as $member ) if( (int)$member > 0 ) $TEMP_arr[] = (int)$member;
		$cat_id_arr = $TEMP_arr;
	}
} else $cat_id_arr = $cat_id;
if( (int)$num_entries <= 0 ) $num_entries = 1;
if( (int)$offset < 0 ) $offset = 0;
// query
$sfp_query_args = array(
	'sfp_sc_request' => 'yeap', 
	'tax_query' => array( array( 'taxonomy' => 'sfp_post_category', 'terms' => $cat_id_arr ) ),
	'meta_key' => 'is_sponsored',
	'post_type' => 'sfpposts',
	'post_status' => 'publish',
	'offset' => $offset,
	'showposts' => (int)$num_entries
);
$sfp_latest = new WP_Query( $sfp_query_args );
// preserve original query
$TEMP_query = $wp_query;
$wp_query = NULL;
$wp_query = $sfp_latest;
// loop
if( have_posts() ) : while( have_posts() ) : the_post();
?>

<div class="sfp-entry-wrap<?php if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo ' sfp-sponsored'; ?>" id="sfp-entry-wrap-<?php the_ID(); ?>">
	
	<hgroup>
		<h2 class="entry-h2-loop">
			<a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', $this->localizationDomain ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
				<?php the_title(); ?>
			</a>
		</h2>
		<h3 class="sfp-entry-cat">
		<?php 
		$categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
		printf( __( '<span class="%1$s">Found in:</span> %2$s', $this->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
		?>
		</h3>
	</hgroup>
	
	<div class="sfp-section sfp-section-meta border-b">
	
		<dl>
		
			<dt class="meta-text">
		
				<?php
				if( $this->options[ 'sfp_enable_personal_details' ] ) : 

					$sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
					$sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
					$sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
					$sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
					$sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
					$sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
					$gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
					$personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
				?>
					<div class="meta-personal-details"><?php echo $personal_details; ?></div>
				<?php endif; ?>
				
				<?php if( $this->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
					<div class="meta-phone">
						<span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $this->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
					</div>
				<?php endif; ?>
				
				<?php if( $this->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
					<div class="meta-website">
						<a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
					</div>
				<?php endif; ?>
		
			</dt>
			
			<?php if( $show_images == 'yes' && has_post_thumbnail( get_the_ID() ) ) : ?>
			<dt class="meta-image">
				<?php
				$thumb = get_post_thumbnail_id();
				$image = vt_resize( $thumb, '', 100, 60, false );
				?>
				<img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
			</dt>
			<?php endif; ?>
		
		</dl>
	
	</div>

	<?php if( $show_tags == 'yes' ) : ?>
	<footer class="sfp-tags-wrap">
		
		<?php
		$tags_list = get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' );
		if( $tags_list && $this->options[ 'sfp_enable_tags' ] ) :
		echo $tags_list;
		endif;
		?>

	</footer>
    <?php endif; ?>
	
</div>

<?php
endwhile;
else :
	echo '<p>' . __( 'Sorry, no Entries found in here!', $this->localizationDomain ) . '</p>';
endif;
// get back original loop
$wp_query = $TEMP_query;
wp_reset_query();
$this->sfp_remove_orderby_filter_shortcode(); // remove orderby filter