<?php
/**
* @desc Support for shortcode [sfp_list]
*/
global $wpdb;
global $wp_query;
global $current_user;
get_currentuserinfo();

// if user is logged in ...
if( !is_user_logged_in() ) {
	echo __( 'You must be logged in otherwise you are not allowed to access your Entries!', $this->localizationDomain );
	return;
}

// handle paypal messages
$pp_vars_array = array();
$pp_vars = isset( $_GET[ 'pp' ] ) ? $_GET[ 'pp' ] : NULL;
if( $pp_vars ) {
	$pp_vars_array = explode( '~', $pp_vars ); // for later use: [ 0 ] - user_id, [ 1 ] - post_status, [ 2 ] - payment_type
?>

    <div id="sfp-pp-response">
    <?php if( $pp_vars != 'cancel' && $pp_vars_array[ 0 ] ) { ?>
    <h2 class="entry-h2-loop"><?php _e('Thanks!', $this->localizationDomain); ?></h2>
    <p><?php _e('Your payment has been accepted. Transaction details will be sent by PayPal to your e-mail address within a couple of minutes!', $this->localizationDomain); ?></p>
    <?php } else if( $pp_vars == 'cancel' ) { ?>
    <h2 class="entry-h2-loop"><?php _e('Ooops!', $this->localizationDomain); ?></h2>
    <p><?php _e('Your payment has been canceled!', $this->localizationDomain); ?></p>
    <?php } ?>
    </div>

<?php } // end paypal response ?>

<!-- filtering -->
<?php
// tabs
$active_tab = ( isset( $_GET[ 'current' ] ) ? esc_attr( $_GET[ 'current' ] ) : 'publish' );
$active_tab_class = ' active_filter';
// how many posts per status
$cu_ID = $current_user->ID;
$q_all_by_author = "SELECT ID, post_status, post_type FROM $wpdb->posts WHERE post_author = %d AND post_type = 'sfpposts' AND (post_status='publish' OR post_status='pending' OR post_status='due-to-pay' OR post_status='expired') GROUP BY ID";
$q_all_by_author_res = $wpdb->get_results( $wpdb->prepare( $q_all_by_author, $cu_ID ) );
$num_published = 0;
$num_pending = 0;
$num_duetopay = 0;
$num_expired = 0;
//var_dump( $wp_query );
if( $q_all_by_author_res ) {
	foreach( $q_all_by_author_res as $item ) {
		if( $item->post_status == 'publish' ) $num_published ++;
		elseif( $item->post_status == 'pending' ) $num_pending ++;
		elseif( $item->post_status == 'due-to-pay' ) $num_duetopay ++;
		elseif( $item->post_status == 'expired' ) $num_expired ++;
	}
}
?>
<ul class="filter-type">
    <li class="sfp-quasi-button<?php if( $active_tab == 'publish' ) echo $active_tab_class; ?>">
    	<a href="<?php echo add_query_arg( 'current', 'publish', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>">
			<?php echo __('Published', $this->localizationDomain) . ' (' . $num_published . ')'; ?>
        </a>
    </li>
    <li class="sfp-quasi-button<?php if( $active_tab == 'pending' ) echo $active_tab_class; ?>">
    	<a href="<?php echo add_query_arg( 'current', 'pending', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>">
			<?php echo __('Pending Approval', $this->localizationDomain) . ' (' . $num_pending . ')'; ?>
        </a>
    </li>
    <li class="sfp-quasi-button<?php if( $active_tab == 'due-to-pay' ) echo $active_tab_class; ?>">
    	<a href="<?php echo add_query_arg( 'current', 'due-to-pay', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>">
			<?php echo __('Due to pay', $this->localizationDomain) . ' (' . $num_duetopay . ')'; ?>
        </a>
    </li>
    <li class="sfp-quasi-button<?php if( $active_tab == 'expired' ) echo $active_tab_class; ?>">
    	<a href="<?php echo add_query_arg( 'current', 'expired', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>">
			<?php echo __('Expired', $this->localizationDomain) . ' (' . $num_expired . ')'; ?>
        </a>
    </li>
</ul>
<!-- end filtering -->

<?php
// query
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$sfp_query_args = array( 
	'author' => $current_user->ID, 
	'taxonomy' => 'sfp_post_category', 
	'post_type' => 'sfpposts', 
	'post_status' => $active_tab, 
	'paged' => $paged, 
	'showposts' => $this->options[ 'sfp_show_n_entries' ] 
	);
$sfp_entries_list = new WP_Query( $sfp_query_args );
// preserve original query
$TEMP_query = $wp_query;
$wp_query = NULL;
$wp_query = $sfp_entries_list;
// loop
if( have_posts() ) : while( have_posts() ) : the_post();
?>

<div class="sfp-entry-wrap" id="sfp-entry-wrap-<?php the_ID(); ?>">
    
    <?php
	$author_email_addr = get_the_author_meta( 'user_email' );
	$author_email_encoded = base64_encode( gzdeflate( $author_email_addr ) );
	?>
    <h2 class="entry-h2-loop">
    <a href="<?php echo add_query_arg( 'key', $author_email_encoded, get_permalink() ); ?>"><?php the_title(); ?></a>
    </h2>

    <div class="sfp-entry-meta sfp-section border-b">
    
        <span class="sfp-entry-status <?php echo 'sfp-entry-' . get_post_status( get_the_ID() ); ?>">
        <?php 
        echo __( 'Entry status', $this->localizationDomain) . ': ' . get_post_status( get_the_ID() );
        
        // calc expiration date
        $posted_date = get_post_time( 'U', false, get_the_ID() );
        $expires = $posted_date + ( $this->options[ 'sfp_expire' ] * 24 * 60 * 60 );
        $currentdate = time();
        if( $this->options[ 'sfp_expire' ] > 0 && get_post_status( get_the_ID() ) != 'pending' && get_post_status( get_the_ID() ) != 'due-to-pay' ) { 
            if( $currentdate < $expires ) echo ' (' . __( 'expires on', $this->localizationDomain ) . ' ' . date( get_option( 'date_format' ), $expires ) . ')';
            else echo ' (' . __( 'expired on', $this->localizationDomain ) . ' ' . date( get_option( 'date_format' ), $expires ) . ')';
        } 
        ?>
        </span>
        
        <?php
        $is_sponsored = get_post_meta( get_the_ID(), 'is_sponsored', true );
        if( $is_sponsored && get_post_status() != 'due-to-pay' && $this->options[ 'sfp_publish_type' ] != 'free' ) {
        ?>
        <span id="sfp-entry-sponsored-<?php the_ID(); ?>" class="sfp-entry-sponsored">
        <span class="sfp-cancel-string"><?php _e('Sponsored Entry!', $this->localizationDomain); ?></span>
        <?php 
        // users may drop sponsorship with expired entries
        if( get_post_status() == 'expired' ) {
        ?>
        <a id="sfp-cancel-sponsorship-<?php the_ID(); ?>" class="sfp-cancel-sponsorship" name="cancel_<?php the_ID(); ?>" href="#">
            <?php _e('Cancel Sponsorship?', $this->localizationDomain); ?>
        </a>
        <?php } ?>
        </span>
        <?php } ?>
        
        <span class="sfp-entry-date"><?php _e('Added on', $this->localizationDomain); ?>: <?php the_time( get_option( 'date_format' ) ); ?>, <?php echo get_the_term_list( get_the_ID(), 'sfp_post_category', '', ', ', '' );?></span>

        <span class="sfp-entry-button sfp-view">
            <a href="<?php echo add_query_arg( 'key', $author_email_encoded, get_permalink() ); ?>">
                <?php _e('View Entry', $this->localizationDomain); ?>
            </a>
        </span>
        
        <?php if( $this->options[ 'sfp_edit_post' ] && get_post_status( get_the_ID() ) != 'expired' && get_post_status( get_the_ID() ) != 'due-to-pay' ) : ?>
        <span class="sfp-entry-button sfp-edit">
            <a href="<?php echo add_query_arg( 'entry_id', get_the_ID(), get_permalink( $this->options[ 'sfp_page_edit_entry' ] ) ); ?>">
                <?php _e('Edit Entry', $this->localizationDomain); ?>
            </a>
        </span>
        <?php endif; ?>
        
        <?php if( $this->options[ 'sfp_delete_post' ] ) : ?>
        <span class="sfp-entry-button sfp-delete">
            <a id="sfp-delete-entry-<?php the_ID(); ?>" name="delete_<?php the_ID(); ?>" href="#">
                <?php _e('Delete Entry', $this->localizationDomain); ?>
            </a>
        </span>
        <?php endif; ?>
        
        <?php if( get_post_status( get_the_ID() ) == 'expired' ) : ?>
        <form class="sfp-quick-form" id="sfp-renew-<?php the_ID(); ?>" name="sfp-renew-<?php the_ID(); ?>" method="post" action="<?php echo get_permalink( $this->options[ 'sfp_page_make_payment' ] ); ?>">
        <input type="hidden" name="payment_action" value="renew" />
        <input type="hidden" name="post_id" value="<?php the_ID(); ?>" />
        <?php wp_nonce_field( 'due-to-pay-form', 'due-to-pay-form-submitted' ); ?>
        </form>
        <span class="sfp-entry-button sfp-renew">
            <a id="sfp-renew-entry-<?php the_ID(); ?>" href="#" onclick="document.getElementById('sfp-renew-<?php the_ID(); ?>').submit(); return false;"><?php _e('Renew Entry', $this->localizationDomain); ?></a>
        </span>
        <?php endif; ?>
        
        <?php if( $this->options[ 'sfp_publish_type' ] != 'free' && !get_post_meta( get_the_ID(), 'is_sponsored', true ) && get_post_status( get_the_ID() ) != 'expired' && get_post_status( get_the_ID() ) != 'due-to-pay' ) : ?>
        <form class="sfp-quick-form" id="sfp-sponsor-<?php the_ID(); ?>" name="sfp-sponsor-<?php the_ID(); ?>" method="post" action="<?php echo get_permalink( $this->options[ 'sfp_page_make_payment' ] ); ?>">
        <input type="hidden" name="payment_action" value="sponsor" />
        <input type="hidden" name="post_id" value="<?php the_ID(); ?>" />
        <?php wp_nonce_field( 'due-to-pay-form', 'due-to-pay-form-submitted' ); ?>
        </form>
        <span class="sfp-entry-button sfp-sponsor">
            <a id="sfp-sponsor-entry-<?php the_ID(); ?>" href="#" onclick="document.getElementById('sfp-sponsor-<?php the_ID(); ?>').submit(); return false;"><?php _e('Make Sponsored', $this->localizationDomain); ?></a>
        </span>
        <?php endif; ?>
        
        <?php if( $this->options[ 'sfp_publish_type' ] != 'free' && get_post_status( get_the_ID() ) == 'due-to-pay' ) : ?>
        <form class="sfp-quick-form" id="sfp-due-to-pay-<?php the_ID(); ?>" name="sfp-due-to-pay-<?php the_ID(); ?>" method="post" action="<?php echo get_permalink( $this->options[ 'sfp_page_make_payment' ] ); ?>">
        <input type="hidden" name="payment_action" value="due-to-pay" />
        <input type="hidden" name="post_id" value="<?php the_ID(); ?>" />
        <?php wp_nonce_field( 'due-to-pay-form', 'due-to-pay-form-submitted' ); ?>
        </form>
        <span class="sfp-entry-button sfp-pay">
            <a id="sfp-pay-entry-<?php the_ID(); ?>" href="#" onclick="document.getElementById('sfp-due-to-pay-<?php the_ID(); ?>').submit(); return false;"><?php _e('Make Payment', $this->localizationDomain); ?></a>
        </span>
        <?php endif; ?>
        
    </div>
    
    <div class="sfp-item-content">
        <?php 
        if( has_post_thumbnail( get_the_ID() ) ) { 
            $thumb = get_post_thumbnail_id();
            $image = vt_resize( $thumb, '', 200, 120, true );
        ?>
        
        <img class="sfp-image-thumb" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
        
        <?php
        } 
        
        if( has_excerpt( get_the_ID() ) ) the_excerpt(); 
        else the_content();
        ?>
    </div>
    
</div>
	
<?php endwhile; ?>

<?php 
if( function_exists( 'wp_pagenavi' ) ) wp_pagenavi();
else {
	$total_pages = $wp_query->max_num_pages;
	if ( $total_pages > 1 ) {
?>
<div class="navigation">
	<div class="alignleft"><?php previous_posts_link( __( '&laquo; Previous Entries', $this->localizationDomain ) ); ?></div>
	<div class="alignright"><?php next_posts_link( __( 'Next Entries &raquo;', $this->localizationDomain ) ); ?></div>
</div>
<?php
	} // end if total pages > 1
} // end else; if wp_pagenavi doesn't exist
?>
<?php
// get back original loop
$wp_query = $TEMP_query;
?>

<?php
else :
	$str_type = '';
	if( $active_tab == 'publish' ) $str_type = __( 'Published', $this->localizationDomain );
	elseif( $active_tab == 'pending' ) $str_type = __( 'Pending approval', $this->localizationDomain );
	elseif( $active_tab == 'due-to-pay' ) $str_type = __( 'Due-to-pay', $this->localizationDomain );
	elseif( $active_tab == 'expired' ) $str_type = __( 'Expired', $this->localizationDomain );
	echo '<p>' . sprintf( __( 'No "%s" Entries found for your account!', $this->localizationDomain ), $str_type ) . '</p>';
endif;