<?php
/**
* @desc Support for shortcode [sfp_form]
*/
global $current_user;
get_currentuserinfo();

// if user is logged in ...
if( !is_user_logged_in() ) {
	echo __( 'You must be logged in otherwise you are not allowed to add new Entry!', $this->localizationDomain );
	return;
}

// prevent multiple submissions
if( isset( $_POST[ 'sfp_unique_id' ] ) ) {
	$unique_id = $_POST[ 'sfp_unique_id' ];
	$ck_submital = isset( $_SESSION[ 'ck_submital' ] ) ? $_SESSION[ 'ck_submital' ] : array();
	if( isset( $ck_submital[ $unique_id ] ) ) {
		unset( $_POST[ 'sfp_submit' ] );
		session_destroy();
	}
	else{
		$ck_submital[ $unique_id ] = TRUE;
		$_SESSION[ 'ck_submital' ] = $ck_submital;
	}
}

// form style
$sfp_form_style = '';

// if data is posted ...
if( isset( $_POST[ 'sfp_submit' ] ) && isset( $_POST[ 'add_new_entry_form_submitted' ] ) && wp_verify_nonce( $_POST[ 'add_new_entry_form_submitted' ], 'add_new_entry_form' ) ) {
	
	// is there everything OK with images?
	$uploader_response = $this->sfp_file_upload_error_chck( $_FILES[ 'sfp_file' ] );
	if( !empty( $uploader_response ) ) {
		echo '<h2>' . __( 'Error, new Entry not added!', $this->localizationDomain ) . '</h2><p>' . implode( '<br />', $uploader_response ) . '</p>';
		return;	
	}
	// collect posted
	$sfp_entry_title = wp_filter_nohtml_kses( $_POST[ 'sfp_entry_title' ] ); // sanitaze title!
	$sfp_entry_content = trim( $_POST[ 'sfp_entry_content' ] );
	$sfp_entry_category = (int)$_POST[ 'sfp_entry_category' ];
	
	// is there entry duplicate in database already?
	$pack_up_mandatory = serialize( array( $sfp_entry_title, $sfp_entry_content ) );
	$s_post = $this->sfp_found_similar( $pack_up_mandatory );
	if( $s_post ) {
		echo '<h2>' . __( 'Error by submission!', $this->localizationDomain ) . '</h2><p>' . __( 'Similar Entry is found in database!', $this->localizationDomain ) . '</p>';
		$similar_post = get_post( $s_post );
		echo '<p class="sfp-separator"></p>';
		if( $similar_post->post_status == 'publish' ) echo '<h5><a href="' . get_permalink( $s_post ) . '" target="_blank">' . $similar_post->post_title . '</a></h5>';
		else { 
			echo '<h5>' . $similar_post->post_title . '</h5>';
			echo '<p>' . __( 'Entry can not be viewed, it\'s not published yet!', $this->localizationDomain ) . '</p>';
		}
		return;	
	}
	
	// collect posted - conditioned
	$sfp_entry_excerpt = ( isset( $_POST[ 'sfp_entry_excerpt' ] ) ) ? wp_filter_nohtml_kses( $_POST[ 'sfp_entry_excerpt' ] ) : ''; // sanitaze excerpt!
	
	// post status depends on plugin operable model: free, optional or payed
	$publish_model_status = $this->options[ 'sfp_save_post_as' ];
	$choice_is_sponsored = ( isset( $_POST[ 'sfp_entry_sponsored' ] ) ? 1 : '0' );
	if( $this->options[ 'sfp_publish_type' ] == 'optional' && $choice_is_sponsored ) $publish_model_status = 'due-to-pay';
	elseif( $this->options[ 'sfp_publish_type' ] == 'payed' ) $publish_model_status = 'due-to-pay';
	
	$entry_data = array(
	'post_title' => $sfp_entry_title,
	'post_content' => $sfp_entry_content,
	'post_status' => $publish_model_status,
	'post_author' => $current_user->ID,
	'post_type' => 'sfpposts',
	'post_excerpt' => $sfp_entry_excerpt
	);
	// get new post ID ...
	$new_entry_ID = wp_insert_post( $entry_data );
	
	// is there everything OK?
	if( $new_entry_ID ) {
		wp_set_object_terms( $new_entry_ID, $sfp_entry_category, 'sfp_post_category' ); // taxonomy
		if( isset( $_POST[ 'sfp_entry_tags' ] ) ) wp_set_post_terms( $new_entry_ID, trim( $_POST[ 'sfp_entry_tags' ] ), 'sfp_post_tags', true ); // post tags
		/* entry meta */
		if( isset( $_POST[ 'sfp_entry_phone' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'contact_phone', trim( $_POST[ 'sfp_entry_phone' ] ) ); // contact phone
		if( isset( $_POST[ 'sfp_entry_url' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'website_url', trim( $_POST[ 'sfp_entry_url' ] ) ); // contact phone
		if( isset( $_POST[ 'sfp_personal_details_name' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_name', trim( $_POST[ 'sfp_personal_details_name' ] ) ); // personal details name
		if( isset( $_POST[ 'sfp_personal_details_address' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_address', trim( $_POST[ 'sfp_personal_details_address' ] ) ); // personal details address
		if( isset( $_POST[ 'sfp_personal_details_city' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_city', trim( $_POST[ 'sfp_personal_details_city' ] ) ); // personal details city
		if( isset( $_POST[ 'sfp_personal_details_zip' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_zip', trim( $_POST[ 'sfp_personal_details_zip' ] ) ); // personal details zip
		if( isset( $_POST[ 'sfp_personal_details_state' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_state', trim( $_POST[ 'sfp_personal_details_state' ] ) ); // personal details state
		if( isset( $_POST[ 'sfp_personal_details_country' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_country', trim( $_POST[ 'sfp_personal_details_country' ] ) ); // personal details country
		if( isset( $_POST[ 'sfp_entry_cross_contact' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'contact_form', $_POST[ 'sfp_entry_cross_contact' ] ); // is cross contact allowed by user?
		if( isset( $_POST[ 'sfp_entry_sponsored' ] ) ) add_post_meta( $new_entry_ID, 'is_sponsored', $_POST[ 'sfp_entry_sponsored' ] ); // is post_sponsored?
		else add_post_meta( $new_entry_ID, 'is_sponsored', '0' );
		add_post_meta( $new_entry_ID, 'sfp_date', get_the_time( 'U', $new_entry_ID ) );
		/* image processing */
		if( $_FILES ) {
			$files = $_FILES[ 'sfp_file' ];
			foreach( $files[ 'name' ] as $key => $value ) {
				if( $files[ 'name' ][ $key ] ) {
					$file = array(
						'name'     => $files[ 'name' ][ $key ],
						'type'     => $files[ 'type' ][ $key ],
						'tmp_name' => $files[ 'tmp_name' ][ $key ],
						'error'    => $files[ 'error' ][ $key ],
						'size'     => $files[ 'size' ][ $key ]
					);
		
					$_FILES = array( "sfp_file" => $file );
					$cnt_files = 1;
					foreach( $_FILES as $file => $array ) {
						$newupload = $this->sfp_file_upload_handler( $file, $new_entry_ID, $cnt_files );
						$cnt_files ++;
					}
				}
			}
		}
		
		if( $this->options[ 'sfp_publish_type' ] != 'free' && $choice_is_sponsored ) {
			
			$fee_total = 0;
			$fee_string = '<br /><br />';
			$pp_publish_type = ''; // regular, regular_sponsored, sponsored
			
			if( $this->options[ 'sfp_publish_type' ] == 'payed' ) {
				$fee_string .= __( 'Regular fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_fee' ], 2, '.', '' );
				$pp_publish_type = 'regular';
				if( $choice_is_sponsored ) {
					$fee_total = $this->options[ 'sfp_fee' ] + $this->options[ 'sfp_sponsored_fee' ];
					$fee_string .= '<br />';
					$fee_string .= __( 'Sponsored fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' ) . '<br />';
					$fee_string .= '-----------------------------------<br />';
					$fee_string .= __( 'Total:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $fee_total, 2, '.', '' );
					$pp_publish_type = 'regular_sponsored';
				}
			} elseif( $this->options[ 'sfp_publish_type' ] == 'optional' ) {
				if( $choice_is_sponsored ) {
					$fee_total = $this->options[ 'sfp_sponsored_fee' ];
					$fee_string .= __( 'Sponsored fee:', $this->localizationDomain ) . ' ' . currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' ) . '<br />';
					$pp_publish_type = 'sponsored';
				}
			}
			
			// successfully added payed and/or sponsored, prepare paypal form
            $paypal_action = 'https://www.paypal.com/cgi-bin/webscr';
            if( $this->options[ 'sfp_enable_sandbox' ] ) $paypal_action = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
			
            $paypal_email = $this->options[ 'sfp_paypal_email' ];
            if( $this->options[ 'sfp_enable_sandbox' ] ) $paypal_email = $this->options[ 'sfp_enable_sandbox_email' ];
        ?>
            <p class="entry-form-p">
            <?php
			$quarantine_life_span = $this->options[ 'sfp_drop_due_to_pays' ];
			echo sprintf( __( 'Your Entry will be held in quarantine for the next %s hour(s). Please consider to make the payment in that time frame otherwise it will be deleted.', $this->localizationDomain ), $quarantine_life_span );
			echo $fee_string;
			
			// paypal meta
			$arr_custom = array( 'user_id' => $current_user->ID, 'options_post_status' => $this->options[ 'sfp_save_post_as' ] );
			$pp_custom = $current_user->ID . '~' . $this->options[ 'sfp_save_post_as' ] . '~' . $pp_publish_type;
			?>
            </p>
            <p class="sfp-separator"></p>
            
            <!-- terms and conditions agreement -->
            <?php if( $this->options[ 'sfp_force_accept_terms' ] ) : ?>
            <p class="entry-form-p sfp-accept-terms">
            <label for="sfp_force_accept_terms"><?php _e( 'Accept Terms and Conditions', $this->localizationDomain); ?></label>
            <input name="sfp_force_accept_terms" id="sfp_force_accept_terms" type="checkbox" value="1" checked="checked" />
            <span class="input-field-appendix">
                <a href="<?php echo get_permalink( $this->options[ 'sfp_page_terms' ] ); ?>" target="_blank">
                    <?php _e( 'I have read and understood Terms and Conditions!', $this->localizationDomain ); ?>
                </a>
            </span>
            <span class="entry-form-tip cant-proceed"><?php _e('You must accept our Terms and Conditions before making payment!', $this->localizationDomain); ?></span>
            </p>
            <?php endif; ?>
            <!-- end terms and conditions agreement -->
            
            <form id="ppform" name="ppform" method="post" action="<?php echo $paypal_action; ?>">
            <input type="hidden" name="cmd" value="_xclick" />
            <input type="hidden" name="business" value="<?php echo $paypal_email; ?>" />
            <input type="hidden" name="lc" value="<?php echo $this->options[ 'sfp_paypal_locale' ]; ?>" />
            <input type="hidden" name="item_name" value="<?php echo $sfp_entry_title; ?>" />
            <input type="hidden" name="item_number" value="<?php echo $new_entry_ID; ?>" />
            <input type="hidden" name="amount" value="<?php echo number_format( $fee_total, 2, '.', '' ); ?>" />
            <input type="hidden" name="currency_code" value="<?php echo $this->options[ 'sfp_currency' ]; ?>" />
            <input type="hidden" name="custom" value="<?php echo $pp_custom; ?>" />
            <input type="hidden" name="no_note" value="1" />
            <input type="hidden" name="no_shipping" value="1" />
            <input type="hidden" name="rm" value="2" />
            <input type="hidden" name="return" value="<?php echo add_query_arg( 'pp', $pp_custom, get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>" />
            <input type="hidden" name="cancel_return" value="<?php echo add_query_arg( 'pp', 'cancel', get_permalink( $this->options[ 'sfp_page_entries_list' ] ) ); ?>" />
            <input type="hidden" name="notify_url" value="<?php echo plugin_dir_url( __FILE__ ) . 'paypal_ipn.php'; ?>" />
            <input type="hidden" name="cbt" value="<?php _e( 'Back to website', $this->localizationDomain ); ?>" />
            <input type="hidden" name="bn" value="PP-BuyNowBF" />
            <p class="entry-form-p">
            <input type="submit" id="sfp_pay_button" class="sfp-button" value="<?php _e( 'Make the payment now?', $this->localizationDomain ); ?>" />
            </p>
            </form>
            
        <?php
			
			$sfp_form_style = 'style="display: none;"';
			
		} else {

			// successfully added no sponsored
			echo '<p>' . __( 'New Entry has been successfully added!', $this->localizationDomain ) . '</p>';
			echo '<p class="sfp-separator"></p>';
			echo '<p><a class="sfp-button" href="' . get_permalink( $this->options[ 'sfp_page_entries_list' ] ) . '">' . __( 'View my Entries!', $this->localizationDomain ) . '</a></p>';
			
			$sfp_form_style = 'style="display: none;"';
		}

	} else {
		echo '<p>' . __( 'Error inserting new Entry!', $this->localizationDomain ) . '</p>';
		echo '<p><a class="sfp-button" href="' . get_permalink( $this->options[ 'sfp_page_new_entry' ] ) . '">' . __( 'Try again?', $this->localizationDomain ) . '</a></p>';
		
		$sfp_form_style = 'style="display: none;"';
	}

}
?>
<form id="add_new_entry_form" method="post" action="" <?php echo $sfp_form_style; ?> enctype="multipart/form-data">
<?php 
// quick tags/buttons : link,em,strong,block,del,ins,img,ul,li,ol,code,more,spell,close,fullscreen
// editor styles
$qt = '';
if( $this->options[ 'sfp_edit_in_html' ] ) $qt = array( 'buttons' => 'strong,em,block,del,ul,ol,li,code,spell,close,fullscreen' );
else {
	$qt = FALSE;
	add_filter( 'wp_default_editor', create_function( '', 'return "tinymce";' ) ); // force visual editor
}
$editor_settings = array(
	'theme_advanced_blockformats' => array( 'h2','h3','p' ),
	'wpautop' => true,
	'media_buttons' => false,
	'tinymce' => array(
		'theme_advanced_buttons1' => 'bold,italic,blockquote,strikethrough,bullist,numlist,code,spellchecker,|,undo,redo,|,fullscreen',
		'theme_advanced_buttons2' => '',
		'theme_advanced_buttons3' => '',
		'theme_advanced_buttons4' => ''
	),
	'quicktags' => $qt
);
// security
wp_nonce_field( 'add_new_entry_form', 'add_new_entry_form_submitted' );
?>
<input type="hidden" name="sfp_unique_id" id="sfp_unique_id" value="<?php echo md5( uniqid() ); ?>" />
<!-- post title -->
<p class="entry-form-p">
<label for="sfp_entry_title"><?php _e('Entry Title', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_title" name="sfp_entry_title" value="" />
</p>
<!-- end post title -->

<!-- post content -->
<div class="entry-form-p">
<label for="sfp_entry_content"><?php _e('Entry Content', $this->localizationDomain); ?></label>
<?php wp_editor( '', 'sfp_entry_content', $editor_settings ); ?>
</div>
<!-- end post content -->

<!-- post category -->
<p class="entry-form-p">
<label for="sfp_post_category"><?php _e('Select Entry Category', $this->localizationDomain); ?></label>
<?php echo $this->sfp_entry_categories_dropdown( 'sfp_post_category', 0 ); ?>
<span class="entry-form-tip"><?php _e('Your Entry will be published in selected category!', $this->localizationDomain); ?></span>
</p>
<!-- end post category -->

<!-- post excerpt -->
<p class="entry-form-p">
<?php if( $this->options[ 'sfp_enable_excerpt' ] ) : ?>
<label for="sfp_entry_excerpt"><?php _e('Entry excerpt (aka summary)', $this->localizationDomain); ?></label>
<textarea name="sfp_entry_excerpt" id="sfp_entry_excerpt" rows="3" cols="55" type="textarea"></textarea>
<span class="entry-form-tip"><?php _e('Short description of your entry, no HTML allowed!', $this->localizationDomain); ?></span>
<?php endif; ?>
</p>
<!-- end post excerpt -->

<!-- post tags -->
<?php if( $this->options[ 'sfp_enable_tags' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_tags"><?php _e('Entry Tags', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_tags" name="sfp_entry_tags" autocomplete="off" value="" />
<span class="entry-form-tip"><?php _e('Comma separated keywords, up to 165 characters allowed.', $this->localizationDomain); ?></span>
</p>
<?php endif; ?>
<!-- end post tags -->

<!-- post phone -->
<?php if( $this->options[ 'sfp_enable_phone' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_phone"><?php _e( 'Contact Phone or Cellphone #', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_phone" name="sfp_entry_phone" maxlength="20" value="" />
</p>
<?php endif; ?>
<!-- end post phone -->

<!-- post website url -->
<?php if( $this->options[ 'sfp_enable_url' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_url"><?php _e( 'Your web site URL', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_url" name="sfp_entry_url" maxlength="165" value="" />
</p>
<?php endif; ?>
<!-- end post website url -->

<!-- post img upload -->
<?php if( $this->options[ 'sfp_allow_img_upload' ] ) : ?>
<div class="entry-form-p">
<label><?php _e( 'Upload images', $this->localizationDomain ); ?> 
<span id="sfp_upload_limit">
( <?php 
if( $this->options[ 'sfp_limit_img_upload' ] > 0 ) echo $this->options[ 'sfp_limit_img_upload' ] . ' ' . __( 'allowed', $this->localizationDomain );
else _e( 'Unlimited', $this->localizationDomain ); 
echo ', ' . __( 'max file size per image:', $this->localizationDomain ) . ' ' . $this->max_upload_file_size . ' Megabytes';
?>
 )
</span>
<span class="entry-form-tip"><?php _e('The very first uploaded image will always be used as featured image!', $this->localizationDomain); ?></span>
</label>
<div class="sfp_file_upload" id="sfp_file_1"><input name="sfp_file[]" type="file" /></div>
<div id="sfp_file_tools">
	<span id="sfp_add_file" class="sfp-quasi-button"><?php _e( 'Add New File', $this->localizationDomain); ?></span>
	<span id="sfp_delete_file" class="sfp-quasi-button"><?php _e( 'Delete File', $this->localizationDomain); ?></span>
</div>
</div>
<?php endif; ?>
<!-- end img upload -->

<!-- post personal details block -->
<?php if( $this->options[ 'sfp_enable_personal_details' ] || $this->options[ 'sfp_enable_gmaps' ] ) : ?>
<div class="sfp-personal-details-block">
<p class="entry-form-p">
<label for="sfp_personal_details_name"><?php _e( 'Name, Surname or Company', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_name" name="sfp_personal_details_name" maxlength="165" value="" />
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_address"><?php _e( 'Address', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_address" name="sfp_personal_details_address" maxlength="250" value="" />
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_city"><?php _e( 'City', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_city" name="sfp_personal_details_city" maxlength="165" value="" />
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_zip"><?php _e( 'ZIP code', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_zip" name="sfp_personal_details_zip" maxlength="10" value="" />
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_state"><?php _e( 'State', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_state" name="sfp_personal_details_state" maxlength="165" value="" />
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_country"><?php _e( 'Country', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_country" name="sfp_personal_details_country" maxlength="165" value="" />
</p>
</div>
<?php endif; ?>
<!-- end post personal details block -->

<!-- post allow cross contact -->
<?php if( $this->options[ 'sfp_enable_contact' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_cross_contact"><?php _e( 'Allow e-mail inquiries?', $this->localizationDomain); ?></label>
<input name="sfp_entry_cross_contact" id="sfp_entry_cross_contact" type="checkbox" value="1" checked="checked" />
<span class="entry-form-tip"><?php _e('If ticked, site visitors will be able to contact you by e-mail (web form). Your e-mail address will not be exposed!', $this->localizationDomain); ?></span>
</p>
<?php endif; ?>
<!-- end post allow cross contact -->

<!-- payment fee -->
<?php if( $this->options[ 'sfp_publish_type' ] != 'free' ) : ?>
<p class="entry-form-p sfp-sponsored">
<label for="sfp_entry_sponsored"><?php _e( 'Do you want to add sponsored Entry?', $this->localizationDomain); ?></label>
<input name="sfp_entry_sponsored" id="sfp_entry_sponsored" type="checkbox" value="1" checked="checked" /><span class="input-field-appendix"><?php _e( 'Tick to confirm!', $this->localizationDomain ); ?></span>
<span class="entry-form-tip">
<?php 
// currency_handler( 'USD' . ' ' . number_format( NNN, 2, '.', '' ); // %1$s
$sfp_regular_fee_with_currency = currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_fee' ], 2, '.', '' );
$sfp_sponsored_fee_with_currency = currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $this->options[ 'sfp_sponsored_fee' ], 2, '.', '' );
$calc_total = $this->options[ 'sfp_fee' ] + $this->options[ 'sfp_sponsored_fee' ];
$sfp_total_fee = currency_handler( $this->options[ 'sfp_currency' ] ) . ' ' . number_format( $calc_total, 2, '.', '' );
if( $this->options[ 'sfp_publish_type' ] == 'optional' ) {
	echo sprintf( __( 'If ticked, payment of %s is required! Sponsored Entries will always be on top of listings page and search results.', $this->localizationDomain ), $sfp_sponsored_fee_with_currency );
} elseif( $this->options[ 'sfp_publish_type' ] == 'payed' ) {
	echo sprintf( __( 'Beside regular fee of %1$s, additional payment of %2$s is needed to publish a Sponsored Entry!<br />That\'s %3$s in total. Sponsored Entries will always be on top of listings page and search results.', $this->localizationDomain ), $sfp_regular_fee_with_currency, $sfp_sponsored_fee_with_currency, $sfp_total_fee );
}
?>
</span>
</p>
<?php endif; ?>
<!-- end payment fee -->

<p class="sfp-separator"></p>

<!-- publish content -->
<p class="entry-form-p">
<input type="submit" id="sfp_submit" class="sfp-button" name="sfp_submit" value="<?php _e('Submit Entry', $this->localizationDomain); ?>">
</p>
<!-- end publish content -->
</form>