<?php
/**
* @desc Support for shortcode [sfp_edit]
*/

// if edit is allowed by Admin
if( !$this->options[ 'sfp_edit_post' ] ) {
	echo __( 'Site Admin has disallowed Entry edit feature!', $this->localizationDomain );
	return;
}

global $current_user;
get_currentuserinfo();
$entry_id = (int)$_GET[ 'entry_id' ];

// if user is logged in ...
if( !is_user_logged_in() ) {
	echo '<p>' . __( 'You must be logged in otherwise you are not allowed to edit your Entry!', $this->localizationDomain ) . '</p>';
	return;
}

// is logged in user owner of this entry?
$curr_post = get_post( $entry_id );
if( $curr_post->post_author != $current_user->ID ) {
	echo '<p>' . __( 'You are not Author of this Entry and thus not allowed to edit!', $this->localizationDomain ) . '</p>';
	return;
}

// prevent multiple submissions
if( isset( $_POST[ 'sfp_unique_id' ] ) ) {
	$unique_id = $_POST[ 'sfp_unique_id' ];
	$ck_submital = isset( $_SESSION[ 'ck_submital' ] ) ? $_SESSION[ 'ck_submital' ] : array();
	if( isset( $ck_submital[ $unique_id ] ) ) {
		unset( $_POST[ 'sfp_submit' ] );
		session_destroy();
	}
	else{
		$ck_submital[ $unique_id ] = TRUE;
		$_SESSION[ 'ck_submital' ] = $ck_submital;
	}
}

// form style
$sfp_form_style = '';

// if data is posted ...
if( isset( $_POST[ 'sfp_submit' ] ) && isset( $_POST[ 'edit_entry_form_submitted' ] ) && wp_verify_nonce( $_POST[ 'edit_entry_form_submitted' ], 'edit_entry_form' ) ) {
	// is there everything OK with images?
	$uploader_response = $this->sfp_file_upload_error_chck( $_FILES[ 'sfp_new_file' ] );
	if( !empty( $uploader_response ) ) return '<h2>' . __( 'Error, Entry not saved!', $this->localizationDomain ) . '</h2><p>' . implode( '<br />', $uploader_response ) . '</p>';
	// collect posted
	$sfp_entry_title = wp_filter_nohtml_kses( $_POST[ 'sfp_entry_title' ] ); // sanitaze title!
	$sfp_entry_content = trim( $_POST[ 'sfp_entry_content' ] );
	$sfp_entry_category = (int)$_POST[ 'sfp_entry_category' ];
	// collect posted - conditioned
	$sfp_entry_excerpt = ( isset( $_POST[ 'sfp_entry_excerpt' ] ) ) ? wp_filter_nohtml_kses( $_POST[ 'sfp_entry_excerpt' ] ) : ''; // sanitaze excerpt!
	
	// post status depends on plugin operable model: free, optional or payed
	$publish_model_status = get_post_status( $entry_id );
	
	$edited_entry = array();
	$edited_entry[ 'ID' ] = $entry_id;
	$edited_entry[ 'post_title' ] = $sfp_entry_title;
	$edited_entry[ 'post_content' ] = $sfp_entry_content;
	$edited_entry[ 'post_status' ] = $publish_model_status;
	$edited_entry[ 'post_excerpt' ] = $sfp_entry_excerpt;
	
	// get new post ID ...
	$new_entry_ID = wp_update_post( $edited_entry );
	
	// is there everything OK?
	if( $new_entry_ID ) {
		wp_set_object_terms( $new_entry_ID, $sfp_entry_category, 'sfp_post_category' ); // taxonomy
		if( isset( $_POST[ 'sfp_entry_tags' ] ) ) wp_set_post_terms( $new_entry_ID, trim( $_POST[ 'sfp_entry_tags' ] ), 'sfp_post_tags', true ); // post tags
		/* entry meta */
		if( isset( $_POST[ 'sfp_entry_phone' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'contact_phone', trim( $_POST[ 'sfp_entry_phone' ] ) ); // contact phone
		if( isset( $_POST[ 'sfp_entry_url' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'website_url', trim( $_POST[ 'sfp_entry_url' ] ) ); // contact phone
		if( isset( $_POST[ 'sfp_personal_details_name' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_name', trim( $_POST[ 'sfp_personal_details_name' ] ) ); // personal details name
		if( isset( $_POST[ 'sfp_personal_details_address' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_address', trim( $_POST[ 'sfp_personal_details_address' ] ) ); // personal details address
		if( isset( $_POST[ 'sfp_personal_details_city' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_city', trim( $_POST[ 'sfp_personal_details_city' ] ) ); // personal details city
		if( isset( $_POST[ 'sfp_personal_details_zip' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_zip', trim( $_POST[ 'sfp_personal_details_zip' ] ) ); // personal details zip
		if( isset( $_POST[ 'sfp_personal_details_state' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_state', trim( $_POST[ 'sfp_personal_details_state' ] ) ); // personal details state
		if( isset( $_POST[ 'sfp_personal_details_country' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'pd_country', trim( $_POST[ 'sfp_personal_details_country' ] ) ); // personal details country
		if( isset( $_POST[ 'sfp_entry_cross_contact' ] ) ) $this->sfp_entry_meta( $new_entry_ID, 'contact_form', 1 ); else $this->sfp_entry_meta( $new_entry_ID, 'contact_form', 0 );// is cross contact allowed by user?
		/* image processing */
		if( $_FILES ) {
			$files = $_FILES[ 'sfp_new_file' ];
			foreach( $files[ 'name' ] as $key => $value ) {
				if( $files[ 'name' ][ $key ] ) {
					$file = array(
						'name'     => $files[ 'name' ][ $key ],
						'type'     => $files[ 'type' ][ $key ],
						'tmp_name' => $files[ 'tmp_name' ][ $key ],
						'error'    => $files[ 'error' ][ $key ],
						'size'     => $files[ 'size' ][ $key ]
					);
		
					$_FILES = array( "sfp_new_file" => $file );
					$cnt_files = 1;
					foreach( $_FILES as $file => $array ) {
						$newupload = $this->sfp_file_upload_handler( $file, $new_entry_ID, $cnt_files );
						$cnt_files ++;
					}
				}
			}
		}

		// successfully edited
		echo '<p>' . __( 'Entry has been successfully edited!', $this->localizationDomain ) . '</p>';
		echo '<p class="sfp-separator"></p>';
		echo '<p><a class="sfp-button" href="' . get_permalink( $this->options[ 'sfp_page_entries_list' ] ) . '">' . __( 'View my Entries!', $this->localizationDomain ) . '</a></p>';
		
		$sfp_form_style = 'style="display: none;"';

	} else {
		echo '<p>' . __( 'Error editing new Entry!', $this->localizationDomain ) . '</p>';
		echo '<p class="sfp-separator"></p>';
		echo '<p><a class="sfp-button" href="' . get_permalink( $this->options[ 'sfp_page_new_entry' ] ) . '">' . __( 'Try again?', $this->localizationDomain ) . '</a></p>';
		
		$sfp_form_style = 'style="display: none;"';
	}
	
}
// allow users to insert ready made Entry form
?>
<form id="edit_entry_form" method="post" action="" <?php echo $sfp_form_style; ?> enctype="multipart/form-data">
<?php 
// quick tags/buttons : link,em,strong,block,del,ins,img,ul,li,ol,code,more,spell,close,fullscreen
// editor styles
$qt = '';
if( $this->options[ 'sfp_edit_in_html' ] ) $qt = array( 'buttons' => 'strong,em,block,del,ul,ol,li,code,spell,close,fullscreen' );
else {
	$qt = FALSE;
	add_filter( 'wp_default_editor', create_function( '', 'return "tinymce";' ) ); // force visual editor
}
$editor_settings = array(
	'theme_advanced_blockformats' => array( 'h2','h3','p' ),
	'wpautop' => true,
	'media_buttons' => false,
	'tinymce' => array(
		'theme_advanced_buttons1' => 'bold,italic,blockquote,strikethrough,bullist,numlist,code,spellchecker,|,undo,redo,|,fullscreen',
		'theme_advanced_buttons2' => '',
		'theme_advanced_buttons3' => '',
		'theme_advanced_buttons4' => ''
	),
	'quicktags' => $qt
);
// security
wp_nonce_field( 'edit_entry_form', 'edit_entry_form_submitted' );
?>
<input type="hidden" name="sfp_unique_id" id="sfp_unique_id" value="<?php echo md5( uniqid() ); ?>" />
<!-- post title -->
<p class="entry-form-p">
<label for="sfp_entry_title"><?php _e('Entry Title', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_title" name="sfp_entry_title" value="<?php echo $curr_post->post_title; ?>"/>
</p>
<!-- end post title -->

<!-- post content -->
<div class="entry-form-p">
<label for="sfp_entry_content"><?php _e('Entry Content', $this->localizationDomain); ?></label>
<?php wp_editor( $curr_post->post_content, 'sfp_entry_content', $editor_settings ); ?>
</div>
<!-- end post content -->

<!-- post category -->
<p class="entry-form-p">
<label for="sfp_post_category"><?php _e('Select Entry Category', $this->localizationDomain); ?></label>
<?php
$arr_term_ids = array();
$entry_termz = get_the_terms( $curr_post->ID, 'sfp_post_category' );
foreach ( $entry_termz as $term ) { array_push( $arr_term_ids, $term->term_id ); }
echo $this->sfp_entry_categories_dropdown( 'sfp_post_category', $arr_term_ids[ 0 ] ); 
?>
<span class="entry-form-tip"><?php _e('Your Entry will be published in selected category!', $this->localizationDomain); ?></span>
</p>
<!-- end post category -->

<!-- post excerpt -->
<p class="entry-form-p">
<?php if( $this->options[ 'sfp_enable_excerpt' ] ) : ?>
<label for="sfp_entry_excerpt"><?php _e('Entry excerpt (aka summary)', $this->localizationDomain); ?></label>
<textarea name="sfp_entry_excerpt" id="sfp_entry_excerpt" rows="3" cols="55" type="textarea"><?php echo $curr_post->post_excerpt; ?></textarea>
<span class="entry-form-tip"><?php _e('Short description of your entry, no HTML allowed!', $this->localizationDomain); ?></span>
<?php endif; ?>
</p>
<!-- end post excerpt -->

<!-- post tags -->
<?php if( $this->options[ 'sfp_enable_tags' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_tags"><?php _e('Entry Tags', $this->localizationDomain); ?></label>
<?php 
$entry_terms_list = '';
$entry_terms = wp_get_object_terms( $curr_post->ID, 'sfp_post_tags' );
if( !empty( $entry_terms ) ) {
	if( !is_wp_error( $entry_terms ) ) {
		foreach( $entry_terms as $term ) {
			$entry_terms_list .= $term->name . ', ';
		}
		$entry_terms_list = rtrim( $entry_terms_list, ', ' );
	}
}
?>
<input type="text" id="sfp_entry_tags" name="sfp_entry_tags" autocomplete="off" value="<?php echo $entry_terms_list; ?>"/>
<span class="entry-form-tip"><?php _e('Comma separated keywords, up to 165 characters allowed.', $this->localizationDomain); ?></span>
</p>
<?php endif; ?>
<!-- end post tags -->

<!-- post phone -->
<?php if( $this->options[ 'sfp_enable_phone' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_phone"><?php _e( 'Contact Phone or Cellphone #', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_phone" name="sfp_entry_phone" maxlength="20" value="<?php echo get_post_meta( $curr_post->ID, 'contact_phone', true ); ?>"/>
</p>
<?php endif; ?>
<!-- end post phone -->

<!-- post website url -->
<?php if( $this->options[ 'sfp_enable_url' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_url"><?php _e( 'Your web site URL', $this->localizationDomain); ?></label>
<input type="text" id="sfp_entry_url" name="sfp_entry_url" maxlength="165" value="<?php echo get_post_meta( $curr_post->ID, 'website_url', true ); ?>"/>
</p>
<?php endif; ?>
<!-- end post website url -->

<!-- post personal details block -->
<?php if( $this->options[ 'sfp_enable_personal_details' ] || $this->options[ 'sfp_enable_gmaps' ] ) : ?>
<div class="sfp-personal-details-block">
<p class="entry-form-p">
<label for="sfp_personal_details_name"><?php _e( 'Name, Surname or Company', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_name" name="sfp_personal_details_name" maxlength="165" value="<?php echo get_post_meta( $curr_post->ID, 'pd_name', true ); ?>"/>
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_address"><?php _e( 'Address', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_address" name="sfp_personal_details_address" maxlength="250" value="<?php echo get_post_meta( $curr_post->ID, 'pd_address', true ); ?>"/>
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_city"><?php _e( 'City', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_city" name="sfp_personal_details_city" maxlength="165" value="<?php echo get_post_meta( $curr_post->ID, 'pd_city', true ); ?>"/>
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_zip"><?php _e( 'ZIP code', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_zip" name="sfp_personal_details_zip" maxlength="10" value="<?php echo get_post_meta( $curr_post->ID, 'pd_zip', true ); ?>"/>
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_state"><?php _e( 'State', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_state" name="sfp_personal_details_state" maxlength="165" value="<?php echo get_post_meta( $curr_post->ID, 'pd_state', true ); ?>"/>
</p>
<p class="entry-form-p">
<label for="sfp_personal_details_country"><?php _e( 'Country', $this->localizationDomain); ?></label>
<input type="text" id="sfp_personal_details_country" name="sfp_personal_details_country" maxlength="165" value="<?php echo get_post_meta( $curr_post->ID, 'pd_country', true ); ?>"/>
</p>
</div>
<?php endif; ?>
<!-- end post personal details block -->

<!-- post img upload -->
<?php if( $this->options[ 'sfp_allow_img_upload' ] ) : ?>
<h2 class="sfp-media-library-title"><?php _e( 'Handle images', $this->localizationDomain); ?></h2>
<div class="sfp-media-library">
<?php
$featured_image_id = get_post_meta( $curr_post->ID, '_thumbnail_id', true );
$att_args = array( 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => -1, 'post_status' => null, 'post_parent' => $curr_post->ID, 'order' => 'ASC', 'orderby' => 'menu_order' );
$attachments = get_posts( $att_args );
if( $attachments ) {
	foreach( $attachments as $attachment ) {
	?>
    <dl class="sfp-media-library-item sfp_att-item-<?php echo $attachment->ID; ?>">
    	<dt>
			<?php $image = vt_resize( $attachment->ID, '', 200, 120, true ); ?>
            <img class="sfp-image-thumb" src="<?php echo $image[ 'url' ]; ?>" alt="<?php echo $attachment->post_title; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
    	</dt>
        <dd>
        	<span class="sfp-media-name"><?php echo $attachment->post_title; ?></span>
            <a class="sfp-media-remove sfp-quasi-button" name="att_<?php echo $attachment->ID; ?>_post_<?php echo $curr_post->ID; ?>" href="#">
				<?php _e( 'Delete Image', $this->localizationDomain ); ?>
            </a>
            
            <?php if( $attachment->ID != $featured_image_id ) : ?>
            <span class="sfp-set-featured sfp-quasi-button" id="set-as-featured-<?php echo $attachment->ID;?>" name="att_<?php echo $attachment->ID; ?>_post_<?php echo $curr_post->ID; ?>">
			<?php _e( 'Make it Featured', $this->localizationDomain ); ?>
            </span>
            <?php else : ?>
            <span class="sfp-set-featured not-clickable" id="set-as-featured-<?php echo $attachment->ID;?>" name="att_<?php echo $attachment->ID; ?>_post_<?php echo $curr_post->ID; ?>">
            <?php _e( 'Featured Image', $this->localizationDomain ); ?>
            </span>
            <?php endif; ?>
            
        </dd>
    </dl>
	<?php
	}
}
?>
</div>
<div class="entry-form-p sfp-append-files">
<label><?php _e( 'Upload images', $this->localizationDomain ); ?> 
<span id="sfp_upload_limit">
( <?php 
	if( $this->options[ 'sfp_limit_img_upload' ] > 0 ) echo $this->options[ 'sfp_limit_img_upload' ] . ' ' . __( 'allowed', $this->localizationDomain ) . ', <em>' . $this->sfp_calc_free_slots( $curr_post->ID ) . '</em> ' . __( 'left', $this->localizationDomain );
	else _e( 'Unlimited', $this->localizationDomain );
	echo ', ' . __( 'max file size per image:', $this->localizationDomain ) . ' ' . $this->max_upload_file_size . ' Megabytes';
?> )
</span>
</label>
<div class="sfp_new_file_upload" id="sfp_new_file_1"><input name="sfp_new_file[]" type="file" /></div>
<div id="sfp_new_file_tools">
	<span id="sfp_append_file" class="sfp-quasi-button"><?php _e( 'Add New File', $this->localizationDomain); ?></span>
	<span id="sfp_drop_file" class="sfp-quasi-button"><?php _e( 'Delete File', $this->localizationDomain); ?></span>
</div>
<span class="entry-form-tip" id="sfp-quota-full" style="display: none;"><?php _e('Your image upload quota is full. Delete (some of) existing images if you want to upload another file(s)!', $this->localizationDomain); ?></span>
</div>
<?php endif; ?>
<!-- end img upload -->

<!-- post allow cross contact -->
<?php if( $this->options[ 'sfp_enable_contact' ] ) : ?>
<p class="entry-form-p">
<label for="sfp_entry_cross_contact"><?php _e( 'Allow e-mail inquiries?', $this->localizationDomain); ?></label>
<input name="sfp_entry_cross_contact" id="sfp_entry_cross_contact" type="checkbox" <?php if( get_post_meta( $curr_post->ID, 'contact_form', true ) ) echo 'checked="checked"'; ?> />
<span class="entry-form-tip"><?php _e('If ticked, site visitors will be able to contact you by e-mail (web form). Your e-mail address will not be exposed!', $this->localizationDomain); ?></span>
</p>
<?php endif; ?>
<!-- end post allow cross contact -->

<p class="sfp-separator"></p>

<!-- publish content -->
<p class="entry-form-p">
<input type="hidden" id="att_slots_keeper" name="<?php echo $this->sfp_calc_free_slots( $curr_post->ID ); ?>" />
<input type="submit" id="sfp_submit" class="sfp-button" name="sfp_submit" value="<?php _e('Submit Entry', $this->localizationDomain); ?>">
</p>
<!-- end publish content -->
</form>