<?php
/**
* @desc Support for shortcode [sfp_archives cat_id=NN per_page=NN]
* supported attributes: 
*/
global $wp_query;

// all taxonomy terms
$curr_tax_terms = get_terms( 'sfp_post_category' );
$object_term = array();
foreach( $curr_tax_terms as $struct ) $object_term[] = $struct->term_id;
// default posts per page
$postsperpage = get_option( 'posts_per_page' );
// extract attributes
extract( shortcode_atts( array(
	'cat_id' => $object_term,
	'per_page' => $postsperpage
), $atts ) );
// be sure user input is OK...
if( !is_array( $cat_id ) ) {
	$cat_id_arr = explode( ',', $cat_id );
	if( $cat_id_arr ) {
		$TEMP_arr = array();
		foreach( $cat_id_arr as $member ) if( (int)$member > 0 ) $TEMP_arr[] = (int)$member;
		$cat_id_arr = $TEMP_arr;
	}
} else $cat_id_arr = $cat_id;
if( (int)$per_page <= 0 ) $per_page = 1;
// query
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$sfp_query_args = array(
	'sfp_archives' => 'yeap', 
	'tax_query' => array( array( 'taxonomy' => 'sfp_post_category', 'terms' => $cat_id_arr ) ),
	'meta_key' => 'is_sponsored',
	'post_type' => 'sfpposts',
	'post_status' => 'publish',
	'showposts' => (int)$per_page,
	'paged' => $paged
);

$sfp_archives = new WP_Query( $sfp_query_args );

// preserve original query
$TEMP_query = $wp_query;
$wp_query = NULL;
$wp_query = $sfp_archives;

// Start the Loop
if( have_posts() ) : while( have_posts() ) : the_post();
?>
            
<div class="sfp-entry-wrap<?php if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo ' sfp-sponsored'; ?>" id="sfp-entry-wrap-<?php the_ID(); ?>">
    
    <hgroup>
        <h2 class="entry-h2-loop">
            <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', $this->localizationDomain ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                <?php the_title(); ?>
            </a>
        </h2>
        <h3 class="sfp-entry-cat">
        <?php 
        //if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo __( 'Sponsored', $this->localizationDomain ) . ' | ';
        $categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
        printf( __( '<span class="%1$s">Found in:</span> %2$s', $this->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
        ?>
        </h3>
    </hgroup>
    
    <div class="sfp-section sfp-section-meta border-b">
    
        <dl>
        
            <dt class="meta-text">
        
                <?php
                if( $this->options[ 'sfp_enable_personal_details' ] ) : 

                    $sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
                    $sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
                    $sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
                    $sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
                    $sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
                    $sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
                    $gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
                    $personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
                ?>
                    <div class="meta-personal-details"><?php echo $personal_details; ?></div>
                <?php endif; ?>
                
                <?php if( $this->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
                    <div class="meta-phone">
                        <span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $this->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
                    </div>
                <?php endif; ?>
                
                <?php if( $this->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
                    <div class="meta-website">
                        <a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
                    </div>
                <?php endif; ?>
        
            </dt>
            
            <?php if( has_post_thumbnail( get_the_ID() ) ) : ?>
            <dt class="meta-image">
                <?php
                $thumb = get_post_thumbnail_id();
                $image = vt_resize( $thumb, '', 100, 60, false );
                ?>
                <img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
            </dt>
            <?php endif; ?>
        
        </dl>
    
    </div>
    
    
    <?php if( $this->options[ 'sfp_enable_excerpt' ] && has_excerpt( get_the_ID() ) ) : ?>
    <div class="sfp-entry-content-wrap">
    <?php the_excerpt(); ?>
    <?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', $this->localizationDomain ) . '</span>', 'after' => '</div>' ) ); ?>
    </div><!-- .entry-content -->
    <?php endif; ?>

    <footer class="sfp-tags-wrap">
        
        <?php
        $tags_list = get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' );
        if( $tags_list && $this->options[ 'sfp_enable_tags' ] ) :
        echo $tags_list;
        endif;
		?>

    </footer>
    
</div>

<?php endwhile; ?>

<?php 
if( function_exists( 'wp_pagenavi' ) ) wp_pagenavi();
else {
	$total_pages = $wp_query->max_num_pages;
	if ( $total_pages > 1 ) {
?>
<div class="navigation">
	<div class="alignleft"><?php previous_posts_link( __( '&laquo; Previous Entries', $this->localizationDomain ) ); ?></div>
	<div class="alignright"><?php next_posts_link( __( 'Next Entries &raquo;', $this->localizationDomain ) ); ?></div>
</div>
<?php
	} // end if total pages > 1
} // end else; if wp_pagenavi doesn't exist
?>
<?php
// get back original loop
$wp_query = $TEMP_query;
?>
<?php
else :
	echo '<p>' . __( 'Sorry, no Entries found in here!', $this->localizationDomain ) . '</p>';
endif;

wp_reset_query();
$this->sfp_remove_orderby_filter(); // remove orderby filter