<?php
/* INSTANT PAYMENT NOTIFICATION */

// make wp core functions availabe
$this_file = str_replace( '\\', '/', __FILE__ );
$this_file = explode( 'wp-content', $this_file );
$this_file = $this_file[ 0 ];
require( $this_file . 'wp-config.php' );

$testMode = $SFP->options[ 'sfp_enable_sandbox' ];
$url = 'https://www.paypal.com/cgi-bin/webscr';
if( $testMode ) $url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';

// extract domain name
$from = '';
if( strlen( $SFP->options[ 'sfp_public_email' ] ) < 6 ) {
	$pieces = parse_url( home_url() );
	$domain = isset( $pieces[ host ] ) ? $pieces[ host ] : '';
	if( preg_match( '/(?P[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs ) ) $domain = $regs[ 'domain' ];
	$from = 'noreply@' . $domain;
} else $from = $SFP->options[ 'sfp_public_email' ];

$ipnResponse = ''; // holds the IPN response from paypal
$ipnData = array(); // array will contain the POST values for IPN

$urlParsed = parse_url( $url );

$req = 'cmd=_notify-validate'; // Add 'cmd' to req (ipn command)
$req_debug = "paypal vars:\n--------------------\r"; // DEBUG
// Read the post from PayPal system and add them to req
foreach( $_POST as $key => $value ) {
    $ipnData[ "$key" ] = $value;
    $value = urlencode( stripslashes( $value ) );
    $req .= "&" . $key . "=" . $value;
	$req_debug .= $key . " = " . $value . "\r";
}

// Open the connection to paypal
$fp = fsockopen( 'ssl://' . $urlParsed[ host ], "443", $errno, $errstr, 30 );

$debug_data = $req_debug . "\n--------------------\r";  // DEBUG
$file_to_write_to = dirname( __FILE__ ) . '/paypal_log.log'; // DEBUG
$file_o = fopen( $file_to_write_to, 'w' ); // DEBUG

// If could open the connection and check response
if( $fp ) {
	
	$debug_data .= "fp: passed!\r"; // DEBUG

    fputs( $fp, "POST " . $urlParsed[ path ] . " HTTP/1.1\r\n" );
    fputs( $fp, "Host: " . $urlParsed[ host ] . "\r\n");
    fputs( $fp, "Content-type: application/x-www-form-urlencoded\r\n" );
    fputs( $fp, "Content-length: " . strlen( $req ) . "\r\n" );
    fputs( $fp, "Connection: close\r\n\r\n" );
    fputs( $fp, $req . "\r\n\r\n" );

    while( !feof( $fp ) ) {
        $ipnResponse .= fgets( $fp, 1024 );
    }
	
    fclose( $fp );

    // Valid IPN transaction
    if( eregi( "VERIFIED", $ipnResponse ) ) {
		
		$debug_data .= "verified: passed!\r"; // DEBUG
		
		global $wpdb;
		$table = $wpdb->prefix . 'sfp_payments';
		if( mysql_num_rows( mysql_query( "SHOW TABLES LIKE '" . $table . "'" ) ) == 1 ) { // if table exist
		
			$payer_email  = urldecode( stripslashes( $_POST[ 'payer_email' ] ) );
			$post_id      = (int)$_POST[ 'item_number' ];
			$post_title   = urldecode( stripslashes( $_POST[ 'item_name' ] ) );
			$vendor_stuff = urldecode( stripslashes( $_POST[ 'custom' ] ) );
			$pp_custom    = explode( '~', $vendor_stuff );
			$user_id      = (int)$pp_custom[ 0 ];
			$post_status  = $pp_custom[ 1 ];
			$pub_type     = $pp_custom[ 2 ]; // regular, regular_sponsored, sponsored
			$pay_action   = $pp_custom[ 3 ]; // renew, sponsor, due-to-pay
			$paypal_bulk  = serialize( $_POST );
			
			$debug_data .= "Custom: " . $vendor_stuff . "\r"; // DEBUG

			$insertion_score = $wpdb->insert( ( $table ), array( 'post_id' => $post_id, 'user_id' => $user_id, 'pub_type' => $pub_type, 'paypal_bulk' => $paypal_bulk ), array( '%s', '%s', '%s', '%s' ) ); 
			
			$debug_data .= "Inserted to database? insertion_score: " . $insertion_score . "\r"; // DEBUG
			
			// change entry status
			$post_stuff = array();
			$post_stuff[ 'ID' ] = $post_id;
			if( $pay_action == 'renew' ) {
				$post_stuff[ 'post_date' ] = date( 'Y-m-d H:i:s' );
				$post_stuff[ 'post_date_gmt' ] = date( 'Y-m-d H:i:s' );
			}
			// DAMEER DJ, Nov 26 2012 --------------
			if( $post_status == 'due-to-pay' ) {
				$post_stuff[ 'post_status' ] = $SFP->options[ 'sfp_save_post_as' ];
			} else $post_stuff[ 'post_status' ] = 'publish';
			// End DAMEER DJ, Nov 26 2012 ----------
			// $post_stuff[ 'post_status' ] = ( $post_status == 'due-to-pay' ) ? $SFP->options[ 'sfp_save_post_as' ] : $post_status; // Fix
			$update_score = wp_update_post( $post_stuff ); // update post once payed
			
			// update post meta is_sponsored
			if( $pub_type == 'regular_sponsored' || $pub_type == 'sponsored' ) update_post_meta( $post_id, 'is_sponsored', 1 );
			
			$debug_data .= "Entry updated? update_score: " . $update_score . "\r"; // DEBUG
			
			if( $insertion_score ) {
				
				// notify user
				$notice_subject = __( 'Payment accepted', $SFP->localizationDomain ) . ', ' . get_bloginfo( 'name ');
				$notice_message = sprintf( __( 'Just to let you know that we have received your payment regarding Entry "%s". On a side note, payment details will be sent by PayPal too. Thank you very much!', $SFP->localizationDomain ), $post_title );
				$notice_message .= '<br /><br />' . home_url( '/' );
				
				$headers = "MIME-Version: 1.0\n" . "From: <$from>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n";
				// send message to user
				mail( $payer_email, $notice_subject, $notice_message, $headers );
				
				$debug_data .= "Entry title: $title\r"; // DEBUG
				
			}
		
		}	
           
    }
    // Invalid IPN transaction
    else {
		
        $debug_data .= "verified: failed!\r"; // DEBUG 
		$notice_subject = __( 'Payment NOT accepted', $SFP->localizationDomain ) . ', ' . get_bloginfo( 'name ');
		$notice_message = sprintf( __( 'We can\'t accept your payment regarding Entry "%s". PayPal returned transaction error. Please try again later, thanks!', $SFP->localizationDomain ), $post_title );
		$notice_message .= '<br /><br />' . home_url( '/' );

		$headers = "MIME-Version: 1.0\n" . "From: <$from>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n";
		// send message to user
		mail( $payer_email, $notice_subject, $notice_message, $headers );
			
    }
}
// Else no connection, so maybe wrong url or other reasons, you can do another call later
else {
	$debug_data .= "ERROR. IPN Connection: fsockopen error\r"; // DEBUG 
}

fwrite( $file_o, $debug_data );
fclose( $file_o ); // DEBUG END