<?php
/* Plugin's options */
?>								   
<div class="wrap">
<div class="icon32" id="icon-options-general"><br /></div>
<h2>SOFA Front Post <?php _e('Options', $this->localizationDomain); ?></h2>
<?php $active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'user_permissions'; ?>

<!-- TABBED OPTIONS -->

<h2 class="nav-tab-wrapper">  
    <a href="edit.php?post_type=sfpposts&page=sfp-manage-options&tab=user_permissions" class="nav-tab<?php echo $active_tab == 'user_permissions' ? ' nav-tab-active' : ''; ?>"><?php _e('User Permissions', $this->localizationDomain); ?></a>
    <a href="edit.php?post_type=sfpposts&page=sfp-manage-options&tab=input_fields" class="nav-tab<?php echo $active_tab == 'input_fields' ? ' nav-tab-active' : ''; ?>"><?php _e('Input Fields', $this->localizationDomain); ?></a>
    <a href="edit.php?post_type=sfpposts&page=sfp-manage-options&tab=plugin_pages" class="nav-tab<?php echo $active_tab == 'plugin_pages' ? ' nav-tab-active' : ''; ?>"><?php _e('Plugin Pages', $this->localizationDomain); ?></a>
    <a href="edit.php?post_type=sfpposts&page=sfp-manage-options&tab=payment_settings" class="nav-tab<?php echo $active_tab == 'payment_settings' ? ' nav-tab-active' : ''; ?>"><?php _e('Payment Settings', $this->localizationDomain); ?></a>
    <a href="edit.php?post_type=sfpposts&page=sfp-manage-options&tab=other_settings" class="nav-tab<?php echo $active_tab == 'other_settings' ? ' nav-tab-active' : ''; ?>"><?php _e('Other Settings', $this->localizationDomain); ?></a>
</h2>

<!-- TABBED OPTIONS END -->

<form method="post" id="sofa_front_post_options">

<?php wp_nonce_field('sofa_front_post-update-options'); ?>

    <!-- TAB USER PERMISSIONS -->
    <p class="page-description<?php if( $active_tab == 'user_permissions' ) echo ' showme'; else echo ' hideme'; ?>">
    <?php 
    // page description
    _e('Setup user permissions; what\'s allowed and under which condition.', $this->localizationDomain); 
    ?>
    </p>
    <table cellspacing="2" cellpadding="5" class="form-table<?php if( $active_tab == 'user_permissions' ) echo ' showme'; else echo ' hideme'; ?>"> 
    
        <tr><td class="section-header user_permissions" colspan="2"><?php _e('User Permissions', $this->localizationDomain); ?></td></tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Allow HTML mode for text editor?', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_edit_in_html" id="sfp_edit_in_html" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_edit_in_html' ] ) ) { checked( '1', $this->options[ 'sfp_edit_in_html' ] ); } ?> />
                <br /><span class="setting-description"><?php _e('By default only visual editor is enabled. Tick this option to allow text edit in HTML mode too.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Allow users to Edit their entries?', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_edit_post" id="sfp_edit_post" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_edit_post' ] ) ) { checked( '1', $this->options[ 'sfp_edit_post' ] ); } ?> />
                <br /><span class="setting-description"><?php _e('It\'s up to you to decide. Beware, users may update contet once Entry is being approved!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Allow users to Delete their entries?', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_delete_post" id="sfp_delete_post" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_delete_post' ] ) ) { checked( '1', $this->options[ 'sfp_delete_post' ] ); } ?> />
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Allow users to upload images?', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_allow_img_upload" id="sfp_allow_img_upload" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_allow_img_upload' ] ) ) { checked( '1', $this->options[ 'sfp_allow_img_upload' ] ); } ?> />
            </td> 
        </tr>
        
        <tr valign="top" id="sh_limit_img_upload"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Limit image upload to:', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_limit_img_upload" type="text" id="sfp_limit_img_upload" size="5" value="<?php echo $this->options[ 'sfp_limit_img_upload' ] ;?>"/> file(s)
                <br /><span class="setting-description"><?php _e('Enter 0 (zero) for unlimited.', $this->localizationDomain); ?>
            </td> 
        </tr>
        <tr valign="top" id="sh_limit_file_size"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Limit individual file size to:', $this->localizationDomain); ?></td> 
            <td>
                <input name="sfp_limit_file_size" type="text" id="sfp_limit_file_size" size="10" value="<?php echo $this->options[ 'sfp_limit_file_size' ] ;?>"/> Megabyte(s)
                <br /><span class="setting-description"><?php echo __('Max allowed by your hoster:', $this->localizationDomain) . ' ' . ini_get( 'upload_max_filesize' ) . 'egabytes'; ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('New user entry is saved as:', $this->localizationDomain); ?></td> 
            <td>
            <select name='sfp_save_post_as'>
                <option value='pending' <?php selected( 'pending', $this->options[ 'sfp_save_post_as' ] ); ?>> -- <?php _e('Pending', $this->localizationDomain); ?> -- </option>
                <option value='publish' <?php selected( 'publish', $this->options[ 'sfp_save_post_as' ] ); ?>> -- <?php _e('Auto-publish', $this->localizationDomain); ?> -- </option>
            </select>
            <br /><span class="setting-description beware"><?php _e('Beware: Auto-publish of user Entry allows immediate publishing without content revision!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
    </table>
    <!-- TAB USER PERMISSIONS END -->
    
    <!-- TAB INPUT FIELDS  -->
    <p class="page-description<?php if( $active_tab == 'input_fields' ) echo ' showme'; else echo ' hideme'; ?>">
    <?php 
    // page description
    _e('Entry Title and Content are mandatory so these two will always be visible in New Entry or Edit Entry forms/pages. Optionally, you can enable more if you like...', $this->localizationDomain); 
    ?>
    </p>
    <table cellspacing="2" cellpadding="5" class="form-table<?php if( $active_tab == 'input_fields' ) echo ' showme'; else echo ' hideme'; ?>">
    
        <tr><td class="section-header input_fields" colspan="2"><?php _e('Input Fields', $this->localizationDomain); ?></td></tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Enable excerpt?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_excerpt" id="sfp_enable_excerpt" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_excerpt' ] ) ) { checked( '1', $this->options[ 'sfp_enable_excerpt' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('Excerpt is considered as Entry summary text.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Enable tags input field?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_tags" id="sfp_enable_tags" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_tags' ] ) ) { checked( '1', $this->options[ 'sfp_enable_tags' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('Users will be able to add keywords aka tags to Entry.', $this->localizationDomain); ?>
            <span class="setting-description beware"><?php _e('It\'s great for SEO and improves advanced search by 50%.' , $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Enable phone?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_phone" id="sfp_enable_phone" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_phone' ] ) ) { checked( '1', $this->options[ 'sfp_enable_phone' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('Phone number will not be validated, different countries require different validation rules.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Enable website URL?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_url" id="sfp_enable_url" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_url' ] ) ) { checked( '1', $this->options[ 'sfp_enable_url' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('Users will be able to add their web site URL.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Enable Personal Details?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_personal_details" id="sfp_enable_personal_details" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_personal_details' ] ) ) { checked( '1', $this->options[ 'sfp_enable_personal_details' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('The following input fields will be created: Name (or Company Name), Address, City, Zip, State and Country', $this->localizationDomain); ?>
            <span class="setting-description beware"><?php _e('Please note that advanced search WILL NOT WORK unless this option is enabled!' , $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Enable Google Maps?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_gmaps" id="sfp_enable_gmaps" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_gmaps' ] ) ) { checked( '1', $this->options[ 'sfp_enable_gmaps' ] ); } ?> />
            <br /><span class="setting-description beware"><?php _e('Address, City, Zip, State and Country input fields will become mandatory!', $this->localizationDomain); ?>
            </td> 
        </tr>
        <tr id="sfp-gmaps-api" valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Your GoogleMaps API key', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="50" name="sfp_gmaps_api_key" id="sfp_gmaps_api_key" value="<?php echo $this->options[ 'sfp_gmaps_api_key' ]; ?>" />
            <br /><span class="setting-description beware"><?php _e('API Key allows 25,000 requests per day! You\'ll have to purchase additional quota if usage limits exceeded.' , $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Enable e-mail contact?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_contact" id="sfp_enable_contact" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_contact' ] ) ) { checked( '1', $this->options[ 'sfp_enable_contact' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('This will enable site visitors to send message via web form to Entry author.', $this->localizationDomain); ?>
            </td> 
        </tr>
    
    </table>
    <!-- TAB INPUT FIELDS END -->
    
    <!-- TAB PAGES  -->
    <p class="page-description<?php if( $active_tab == 'plugin_pages' ) echo ' showme'; else echo ' hideme'; ?>">
    <?php 
    // page description
    _e('All pages but Terms and Conditions are mandatory! You will have to create new page for each of these options and assign to corresponding slot!', $this->localizationDomain);
	 echo '<br />';
	 _e('Don\'t enter any other text on these pages but following shortcodes only:', $this->localizationDomain);
    ?>
    </p>
    <table cellspacing="2" cellpadding="5" class="form-table<?php if( $active_tab == 'plugin_pages' ) echo ' showme'; else echo ' hideme'; ?>">
    
        <tr><td class="section-header plugin_pages" colspan="2"><?php _e('Plugin Pages', $this->localizationDomain); ?></td></tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('User login page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_login' ); ?>
                <br /><span class="setting-description"><?php _e('On this page users will be able to register, login or recover password.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('All user Entries page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_entries_list' ); ?>
                <br /><span class="setting-description"><?php _e('This page will be used to list all Entries posted by logged in user.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Search results page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_entries_search' ); ?>
                <br /><span class="setting-description"><?php _e('Search results page for all user Entries.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Archives page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_entries_archives' ); ?>
                <br /><span class="setting-description"><?php _e('All Entries will be listed here. See shortcode accepted attributes to filter out results!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('User payments history:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_user_payments' ); ?>
                <br /><span class="setting-description"><?php _e('History of all payments made by logged in user.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Post new Entry form page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_new_entry' ); ?>
                <br /><span class="setting-description"><?php _e('New Entry form will automatically be generated on this page.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Edit Entry form page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_edit_entry' ); ?>
                <br /><span class="setting-description"><?php _e('It\'s the page where users are able to modify their Entry.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Make payment page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_make_payment' ); ?>
                <br /><span class="setting-description"><?php _e('This page will be used for making payments, it might be considered as a checkout page.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('"Terms and Conditions" page:', $this->localizationDomain); ?></td> 
            <td>
                <?php $this->list_of_plugin_pages( 'sfp_page_terms' ); ?>
                <br /><span class="setting-description"><?php _e('If users are obligatory to accept your Terms and Conditions before making any payment.', $this->localizationDomain); ?>
            </td> 
        </tr>
    
    </table>
    <!-- TAB PAGES END -->
    
    <!-- PAYMENT SETTINGS  -->
    <p class="page-description<?php if( $active_tab == 'payment_settings' ) echo ' showme'; else echo ' hideme'; ?>">
    <?php 
    // page description
    _e('Select operable model, manage expiration, currency and PayPal stuff!', $this->localizationDomain); 
    ?>
    </p>
    <table cellspacing="2" cellpadding="5" class="form-table<?php if( $active_tab == 'payment_settings' ) echo ' showme'; else echo ' hideme'; ?>">
    
        <tr><td class="section-header payment_settings" colspan="2"><?php _e('Payment Settings', $this->localizationDomain); ?></td></tr>
        
        <tr valign="top"> 
            <td width="33%" class="option-name" scope="row"><?php _e('Select operable model...', $this->localizationDomain); ?></td> 
            <td>
            <select name='sfp_publish_type' id="publish_type">
                <option value='free' <?php selected( 'free', $this->options[ 'sfp_publish_type' ] ); ?>> -- <?php _e('Users don\'t pay for publishing', $this->localizationDomain); ?> -- </option>
                <option value='payed' <?php selected( 'payed', $this->options[ 'sfp_publish_type' ] ); ?>> -- <?php _e('User pay for publishing', $this->localizationDomain); ?>  -- </option>
                <option value='optional' <?php selected( 'optional', $this->options[ 'sfp_publish_type' ] ); ?>> -- <?php _e('Users may select', $this->localizationDomain); ?> -- </option>
            </select>
            <br /><span class="setting-description beware"><?php _e('If you let users decide, all payed Entries will be listed first in search or category pages!', $this->localizationDomain); ?>
            
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Make user Entries expire after', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="10" name="sfp_expire" id="sfp_expire" value="<?php echo $this->options[ 'sfp_expire' ]; ?>" /> <?php _e('Days', $this->localizationDomain); ?>
            <br /><span class="setting-description"><?php _e('Enter 0 (zero) if you don\'t need expiration, otherwise enter number of days. Expired Entry needs to be renewed by user or will not be listed!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr id="payment_opts" class="sub-table-holder"><td colspan="2" class="no-padding">
        
        <table cellspacing="2" cellpadding="5" class="form-table">
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Enable PayPal Sandbox mode?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_enable_sandbox" id="sfp_enable_sandbox" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_enable_sandbox' ] ) ) { checked( '1', $this->options[ 'sfp_enable_sandbox' ] ); } ?> />
            <br /><span class="setting-description beware"><?php _e('If unticked all transactions will run for real!!!', $this->localizationDomain); ?>
            </td> 
        </tr>
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('PayPal Sandbox e-mail address', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="50" name="sfp_enable_sandbox_email" id="sfp_enable_sandbox_email" value="<?php echo $this->options[ 'sfp_enable_sandbox_email' ]; ?>" />
            <br /><span class="setting-description"><?php _e('It must be valid PayPal Sandbox e-mail address!', $this->localizationDomain); ?>
            </td> 
        </tr>
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Your real PayPal account e-mail address', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="50" name="sfp_paypal_email" id="sfp_paypal_email" value="<?php echo $this->options[ 'sfp_paypal_email' ]; ?>" />
            <br /><span class="setting-description"><?php _e('It must be valid PayPal account e-mail address!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Select PayPal currency', $this->localizationDomain); ?></td> 
            <td>
            <select name="sfp_currency">
            <?php
            foreach( $this->paypal_currencies as $key => $value ) {
                echo '<option value="' . $key . '" ' . selected( $key, $this->options[ 'sfp_currency' ], false ) . '> -- ' . $value . ' -- </option>';
            }
            ?>
            </select>
            <br /><span class="setting-description"><?php _e('Only those accepted by PayPal can be selected!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Select PayPal locale', $this->localizationDomain); ?></td> 
            <td>
            <select name="sfp_paypal_locale">
            <?php
            foreach( $this->paypal_locales as $key => $value ) {
                echo '<option value="' . $key . '" ' . selected( $key, $this->options[ 'sfp_paypal_locale' ], false ) . '> -- ' . $value . ' -- </option>';
            }
            ?>
            </select>
            <br /><span class="setting-description"><?php _e('This will be PayPal\'s payment page interface language.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr id="regular-fee-row" valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('New Entry publish fee', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="5" name="sfp_fee" id="sfp_fee" value="<?php echo $this->options[ 'sfp_fee' ]; ?>" />
            <br /><span class="setting-description"><?php _e('New Entry fee. Enter floating point or integer (number).', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr id="sponsored-fee-row" valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Sponsored Entry publish fee', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="5" name="sfp_sponsored_fee" id="sfp_sponsored_fee" value="<?php echo $this->options[ 'sfp_sponsored_fee' ]; ?>" />
            <br /><span class="setting-description"><?php _e('Sponsored Entry fee. Enter floating point or integer (number).', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Delete all "Due to pay" Entries after', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="5" name="sfp_drop_due_to_pays" id="sfp_drop_due_to_pays" value="<?php echo $this->options[ 'sfp_drop_due_to_pays' ]; ?>" /> <?php _e('hours', $this->localizationDomain); ?>
            <br /><span class="setting-description"><?php _e('Unpaid Entries will be held in quarnatine and deleted automatically unless user makes the payment in given time frame.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Force accept "Terms and Conditions"?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_force_accept_terms" id="sfp_force_accept_terms" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_force_accept_terms' ] ) ) { checked( '1', $this->options[ 'sfp_force_accept_terms' ] ); } ?> />
            <br /><span class="setting-description beware"><?php _e('Are users obligatory to accept your "Terms and Conditions" before making payments?', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        </table>
        
        </td></tr>
    
    </table>
    <!-- PAYMENT SETTINGS END -->
    
    <!-- OTHER SETTINGS  -->
    <p class="page-description<?php if( $active_tab == 'other_settings' ) echo ' showme'; else echo ' hideme'; ?>">
    <?php 
    // page description
    _e('Other crucial plugin settings!', $this->localizationDomain); 
    ?>
    </p>
    <table cellspacing="2" cellpadding="5" class="form-table<?php if( $active_tab == 'other_settings' ) echo ' showme'; else echo ' hideme'; ?>">
    
        <tr><td class="section-header other_settings" colspan="2"><?php _e('Other Settings', $this->localizationDomain); ?></td></tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Entry category shows at most:', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="5" name="sfp_show_n_entries" id="sfp_show_n_entries" value="<?php echo $this->options[ 'sfp_show_n_entries' ]; ?>" /> <?php _e( 'Entries', $this->localizationDomain ); ?>
            <br /><span class="setting-description"><?php _e('The number of Entries displayed per category page.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Disallow Dashboard access for non Admins?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_knock_off_dash" id="sfp_knock_off_dash" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_knock_off_dash' ] ) ) { checked( '1', $this->options[ 'sfp_knock_off_dash' ] ); } ?> />
            <br /><span class="setting-description beware"><?php _e('If you tick this option only Admin(s) will have an access to Dashboard!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Notify author(s) when Entry expired?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_notify_upon_expiration" id="sfp_notify_upon_expiration" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_notify_upon_expiration' ] ) ) { checked( '1', $this->options[ 'sfp_notify_upon_expiration' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('E-mail notice will be sent to all authors whose Entries have expired.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Public e-mail address', $this->localizationDomain); ?></td> 
            <td>
            <input type="text" size="50" name="sfp_public_email" id="sfp_public_email" value="<?php echo $this->options[ 'sfp_public_email' ]; ?>" />
            <br /><span class="setting-description"><?php _e('Auto responder will use this email address as Sender\'s name.', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Disable Entry comments?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_disable_entry_comments" id="sfp_disable_entry_comments" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_disable_entry_comments' ] ) ) { checked( '1', $this->options[ 'sfp_disable_entry_comments' ] ); } ?> />
            <br /><span class="setting-description"><?php _e('If you disable Entry comments people will not be able to post feedback!', $this->localizationDomain); ?>
            </td> 
        </tr>
        
        <tr valign="top">
            <td width="33%" class="option-name" scope="row"><?php _e('Due-to-pay Entries don\'t get deleted?', $this->localizationDomain); ?></td> 
            <td>
            <input name="sfp_force_dtp_delete" id="sfp_force_dtp_delete" type="checkbox" value="1" <?php if( isset( $this->options[ 'sfp_force_dtp_delete' ] ) ) { checked( '1', $this->options[ 'sfp_force_dtp_delete' ] ); } ?> />
            <br /><span class="setting-description beware"><?php _e('In case due-to-pay Entries don\'t get removed after defined period of time, tick this option to force another method.', $this->localizationDomain); ?>
            </td> 
        </tr>
    
    </table>
    <!-- OTHER SETTINGS END -->
    
    <p class="submit">
        <input type="submit" name="sofa_front_post_save" class="button-primary" value="<?php _e('Save Changes', $this->localizationDomain); ?>" />
    </p>
    
</form>