<?php
/* TEMPLATE PARTS ------------------------------------------------------------------------------------------------------ */
/**
* @desc TEMPLATE PARTS - WRAPPER
*/
function sfp_template_wrap_begin( $pre_wrap = NULL ) {
	if( $pre_wrap ) echo $pre_wrap;
	else echo '<div>';
}
function sfp_template_wrap_end( $post_wrap = NULL ) {
	if( $post_wrap ) echo $post_wrap;
	else echo '</div>';
}
/**
* @desc TEMPLATE PARTS - SINGLE
*/
function sfp_single_template_content() {
	global $SFP;
	while( have_posts() ) : the_post(); 
	?>

    <div class="sfp-entry-wrap" id="sfp-entry-wrap-<?php the_ID(); ?>">
        
        <hgroup>
            <h1 class="title-single"><?php the_title(); ?></h1>
            <h3 class="sfp-entry-cat">
            <?php 
            $categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
            printf( __( '<span class="%1$s">Found in</span> %2$s', $SFP->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
            ?>
            </h3>
        </hgroup>
        
        <div class="sfp-section sfp-section-meta border-b">
        
            <dl>
            
                <dt class="meta-text">
            
                    <?php
                    if( $SFP->options[ 'sfp_enable_personal_details' ] ) : 

                        $sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
                        $sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
                        $sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
                        $sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
                        $sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
                        $sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
                        $gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
                        $personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
                    ?>
                        <div class="meta-personal-details"><?php echo $personal_details; ?></div>
                    <?php endif; ?>
                    
                    <?php if( $SFP->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
                        <div class="meta-phone">
                            <span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $SFP->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if( $SFP->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
                        <div class="meta-website">
                            <a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
                        </div>
                    <?php endif; ?>
            
                </dt>
                
                <?php if( has_post_thumbnail( get_the_ID() ) ) : ?>
                <dt class="meta-image">
                    <?php
                    $thumb = get_post_thumbnail_id();
                    $image = vt_resize( $thumb, '', 100, 60, false );
                    ?>
                    <img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
                </dt>
                <?php endif; ?>
            
            </dl>
        
        </div>
    
        <div class="sfp-entry-content-wrap">
        
            <?php if( $SFP->options[ 'sfp_enable_gmaps' ] ) : ?>
            <div class="sfp-section sfp-section-gmap">
                <input type="hidden" id="map_address" name="map_address" value="<?php echo $gmap_address; ?>" />
                <div id="map_canvas"></div>
            </div>
            <?php endif; ?>
        
            <div class="sfp-section sfp-section-content">
                <h2 class="entry-h2-sectional"><?php _e( 'About Us', $SFP->localizationDomain ); ?></h2>
                <?php the_content(); ?>
            </div>
            
            <?php
            // any additional images?
            $att_args = array( 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => -1, 'post_status' => null, 'post_parent' => get_the_ID() );
            $attachments = get_posts( $att_args );
            if( $attachments ) {
            ?>
            <div class="sfp-section sfp-section-photos">
                <h2 class="entry-h2-sectional"><?php _e( 'Photos', $SFP->localizationDomain ); ?></h2>
                <?php echo do_shortcode( '[gallery columns=4]' ); ?>
            </div>
            <?php } ?>
            
            <?php
            // entry terms aka tags
            $entry_terms = wp_get_post_terms( get_the_ID(), 'sfp_post_tags' );
            if( !empty( $entry_terms ) ) {
            ?>
            <div class="sfp-section sfp-section-tags">
                <h2 class="entry-h2-sectional"><?php _e( 'Entry keywords', $SFP->localizationDomain ); ?></h2>
                <?php echo get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' ); ?>
            </div>
            <?php } ?>

            <?php
            // contact publisher
            if( $SFP->options[ 'sfp_enable_contact' ] && get_post_meta( get_the_ID(), 'contact_form', true ) ) {
                $publisher_email = get_the_author_meta( 'user_email' );
            ?>
            
            <div id="sfp-contact-author" class="sfp-section sfp-section-contactform">
                <h2 class="entry-h2-sectional"><?php _e( 'Contact publisher', $SFP->localizationDomain ); ?></h2>
                
                <!-- error msg container -->
                <div id="sfp-err-response">
                <span></span>
                </div>
                <!-- end error msg container -->
            
                <form id="sfp-form-contact-publisher" action="" method="post">
                    <p class="sfp-form-section">
                        <label for="sfp-form-user-email"><?php _e( 'Your e-mail', $SFP->localizationDomain ); ?></label>
                        <input type="text" id="sfp-form-user-email" name="sfp-form-user-email" maxlength="80" autocomplete="off" />
                    </p>
                    <p class="sfp-form-section">
                        <label for="sfp-form-contact-subject"><?php _e( 'Inquiry subject', $SFP->localizationDomain ); ?></label>
                        <input type="text" id="sfp-form-contact-subject" name="sfp-form-contact-subject" maxlength="80" autocomplete="off" />
                    </p>
                    <p class="sfp-form-section">
                        <label for="sfp-form-contact-message"><?php _e( 'Message', $SFP->localizationDomain ); ?></label>
                        <textarea id="sfp-form-contact-message" name="sfp-form-contact-message" rows="5"></textarea>
                    </p>
                    
                    <p class="sfp-separator"></p>
                    
                    <p class="sfp-form-section">
                        <?php
                        $author_email_addr = get_the_author_meta( 'user_email' );
                        $author_email_encoded = base64_encode( gzdeflate( $author_email_addr ) );
                        ?>
                        <input type="hidden" name="pst_id" id="pst_id" value="<?php the_ID(); ?>" />
                        <input type="hidden" name="pst_title" id="pst_title" value="<?php the_title(); ?>" />
                        <input type="hidden" name="author_email" id="author_email" value="<?php echo $author_email_encoded; ?>" />
                        <input class="sfp-button" type="button" id="sfp-form-contact-submit" type="submit" value="<?php _e( 'Send Message', $SFP->localizationDomain ); ?>" />
                    </p>
                </form>
                
                <p id="sfp-contact-publisher-success" style="display: none;"><?php _e( 'Your message has been sent successfully!', $SFP->localizationDomain ); ?></p>
                
            </div>
            
            <?php } ?>
            
            <?php
            // related entries based on tags
            $current_entry_id = get_the_ID();
            $related_entries = sfp_get_posts_related_by_taxonomy( $current_entry_id, 'sfp_post_category' );
            if( $related_entries->have_posts() ) : 
            ?>
            <div class="sfp-section sfp-section-related">
                <h2 class="entry-h2-sectional"><?php _e( 'Possibly related Entries', $SFP->localizationDomain ); ?></h2>
                <ul class="sfp-related">
                <?php 
                while( $related_entries->have_posts() ): $related_entries->the_post(); 
                    // meta
                    if( $SFP->options[ 'sfp_enable_personal_details' ] ) {
                        $sfp_name_rel = get_post_meta( get_the_ID(), 'pd_name', true );
                        $sfp_address_rel = get_post_meta( get_the_ID(), 'pd_address', true );
                        $sfp_city_rel = get_post_meta( get_the_ID(), 'pd_city', true );
                        $sfp_zip_rel = get_post_meta( get_the_ID(), 'pd_zip', true );
                        $sfp_state_rel = get_post_meta( get_the_ID(), 'pd_state', true );
                        $sfp_country_rel = get_post_meta( get_the_ID(), 'pd_country', true );
                        $gmap_address_rel = $sfp_address_rel . ',' . $sfp_city_rel . ',' . ( ( !empty( $sfp_state_rel ) ) ? $sfp_state_rel . ' '  : '' ) . $sfp_zip_rel . ',' . $sfp_country_rel;
                        $personal_details_rel =( ( !empty( $sfp_name_rel ) ) ? $sfp_name_rel . ', '  : '' ) . $sfp_address_rel . ', ' . $sfp_city_rel . ', ' . ( ( !empty( $sfp_state_rel ) ) ? $sfp_state_rel . ' '  : '' ) . $sfp_zip_rel . ', ' . $sfp_country_rel;
                    }
                ?>
                    <li>
                    <a href="<?php the_permalink(); ?>" class="sfp-related-title"><?php the_title(); ?></a>
                    <?php if( $SFP->options[ 'sfp_enable_personal_details' ] ) { ?><span class="sfp-related-meta"><?php echo $personal_details_rel; ?></span><?php } ?>
                    </li>
                <?php endwhile; ?>
                </ul>
            </div>
            <?php
            wp_reset_query();
            endif;
            ?>
            
        </div>
        
    </div>

    <?php 
    if( !$SFP->options[ 'sfp_disable_entry_comments' ] ) comments_template( '', true );
    endwhile; // end of the loop.
}
/* --------------------------------------- */

/**
* @desc TEMPLATE PARTS - CATEGORY
*/
function sfp_category_template_content() {
	global $SFP;
	global $wp_query;
    // build query for this taxonomy
	$current_tax = get_query_var( 'sfp_post_category' );
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	$sfp_query_args = array(
	'sfp_archives' => 'yeap', 
	'sfp_post_category' => $current_tax,
	'meta_key' => 'is_sponsored',
	'post_type'    => 'sfpposts',
	'post_status'  => 'publish',
	'showposts' => $SFP->options[ 'sfp_show_n_entries' ],
	'paged' => $paged
	);
	
	$sfp_archives = new WP_Query( $sfp_query_args );
	// preserve original query
	$TEMP_query = $wp_query;
	$wp_query = NULL;
	$wp_query = $sfp_archives;
	
    if( have_posts() ) : ?>

        <header class="page-header">
            <h1 class="page-title"><?php printf( __( 'Category: %s', $SFP->localizationDomain ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h1>

            <?php
                $term_description = term_description();
                if( !empty( $term_description ) ) echo apply_filters( 'category_archive_meta', '<div class="category-archive-meta">' . $term_description . '</div>' );
            ?>
        </header>

        <?php /* Start the Loop */ ?>
        <?php while( have_posts() ) : the_post(); ?>
            
        <div class="sfp-entry-wrap<?php if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo ' sfp-sponsored'; ?>" id="sfp-entry-wrap-<?php the_ID(); ?>">
            
            <hgroup>
                <h2 class="entry-h2-loop">
                    <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', $SFP->localizationDomain ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                        <?php the_title(); ?>
                    </a>
                </h2>
                <h3 class="sfp-entry-cat">
                <?php 
                if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo __( 'Sponsored', $SFP->localizationDomain ) . ' | ';
                $categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
                printf( __( '<span class="%1$s">Found in:</span> %2$s', $SFP->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
                ?>
                </h3>
            </hgroup>
            
            <div class="sfp-section sfp-section-meta border-b">
            
                <dl>
                
                    <dt class="meta-text">
                
                        <?php
                        if( $SFP->options[ 'sfp_enable_personal_details' ] ) : 

                            $sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
                            $sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
                            $sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
                            $sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
                            $sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
                            $sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
                            $gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
                            $personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
                        ?>
                            <div class="meta-personal-details"><?php echo $personal_details; ?></div>
                        <?php endif; ?>
                        
                        <?php if( $SFP->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
                            <div class="meta-phone">
                                <span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $SFP->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if( $SFP->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
                            <div class="meta-website">
                                <a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
                            </div>
                        <?php endif; ?>
                
                    </dt>
                    
                    <?php if( has_post_thumbnail( get_the_ID() ) ) : ?>
                    <dt class="meta-image">
                        <?php
                        $thumb = get_post_thumbnail_id();
                        $image = vt_resize( $thumb, '', 100, 60, false );
                        ?>
                        <img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
                    </dt>
                    <?php endif; ?>
                
                </dl>
            
            </div>
            
            
			<?php if( $SFP->options[ 'sfp_enable_excerpt' ] && has_excerpt( get_the_ID() ) ) : ?>
            <div class="sfp-entry-content-wrap">
            <?php the_excerpt(); ?>
            <?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', $SFP->localizationDomain ) . '</span>', 'after' => '</div>' ) ); ?>
            </div><!-- .entry-content -->
            <?php endif; ?>
    
            <footer class="sfp-tags-wrap">
                
                <?php
                $tags_list = get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' );
                if( $tags_list && $SFP->options[ 'sfp_enable_tags' ] ) :
                echo $tags_list;
                endif;
                ?>
        
            </footer><!-- #entry-meta -->
            
        </div>

        <?php endwhile; ?>

		<?php 
        if( function_exists( 'wp_pagenavi' ) ) wp_pagenavi();
        else {
            $total_pages = $wp_query->max_num_pages;
            if ( $total_pages > 1 ) {
        ?>
        <div class="navigation">
            <div class="alignleft"><?php previous_posts_link( __( '&laquo; Previous Entries', $SFP->localizationDomain ) ); ?></div>
            <div class="alignright"><?php next_posts_link( __( 'Next Entries &raquo;', $SFP->localizationDomain ) ); ?></div>
        </div>
        <?php
            } // end if total pages > 1
        } // end else; if wp_pagenavi doesn't exist
        ?>
        
		<?php
        // get back original loop
        $wp_query = $TEMP_query;
        ?>
    
        <?php else : ?>
        
            <h2 class="entry-h2-loop"><?php _e( 'Nothing Found', $SFP->localizationDomain ); ?></h2>

            <div class="sfp-entry-content-wrap">
                <p><?php _e( 'Sorry, no Entries found in here!', $SFP->localizationDomain ); ?></p>
            </div>
    
        <?php 
		endif; 
		wp_reset_query();
		$SFP->sfp_remove_orderby_filter(); // remove orderby filter
}
/* --------------------------------------- */

/**
* @desc TEMPLATE PARTS - TAGS
*/
function sfp_tags_template_content() {
	global $SFP;
	global $wp_query;
    // build query for this taxonomy
	$current_tax = get_query_var( 'sfp_post_tags' );
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	$sfp_query_args = array(
	'sfp_archives' => 'yeap',
	'sfp_post_tags' => $current_tax,
	'meta_key' => 'is_sponsored',
	'post_type'    => 'sfpposts',
	'post_status'  => 'publish',
	'showposts' => $SFP->options[ 'sfp_show_n_entries' ],
	'paged' => $paged
	);
	
	$sfp_archives = new WP_Query( $sfp_query_args );
	// preserve original query
	$TEMP_query = $wp_query;
	$wp_query = NULL;
	$wp_query = $sfp_archives;
	
    if( have_posts() ) : ?>

        <header class="page-header">
            <h1 class="page-title"><?php printf( __( 'Tagged as: %s', $SFP->localizationDomain ), '<span>#' . single_cat_title( '', false ) . '</span>' ); ?></h1>

            <?php
                $term_description = term_description();
                if( !empty( $term_description ) ) echo apply_filters( 'category_archive_meta', '<div class="category-archive-meta">' . $term_description . '</div>' );
            ?>
        </header>

        <?php /* Start the Loop */ ?>
        <?php while( have_posts() ) : the_post(); ?>
            
        <div class="sfp-entry-wrap<?php if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo ' sfp-sponsored'; ?>" id="sfp-entry-wrap-<?php the_ID(); ?>">
            
            <hgroup>
                <h2 class="entry-h2-loop">
                    <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', $SFP->localizationDomain ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
                        <?php the_title(); ?>
                    </a>
                </h2>
                <h3 class="sfp-entry-cat">
                <?php 
                if( get_post_meta( get_the_ID(), 'is_sponsored', true ) ) echo __( 'Sponsored', $SFP->localizationDomain ) . ' | ';
                $categories_list = get_the_term_list( get_the_ID(), 'sfp_post_category', '<span class="sfp-entry-cat">', ', ', '</span>' );
                printf( __( '<span class="%1$s">Found in:</span> %2$s', $SFP->localizationDomain ), 'entry-utility-prep entry-utility-prep-cat-links', $categories_list );
                ?>
                </h3>
            </hgroup>
            
            <div class="sfp-section sfp-section-meta border-b">
            
                <dl>
                
                    <dt class="meta-text">
                
                        <?php
                        if( $SFP->options[ 'sfp_enable_personal_details' ] ) : 

                            $sfp_name = get_post_meta( get_the_ID(), 'pd_name', true );
                            $sfp_address = get_post_meta( get_the_ID(), 'pd_address', true );
                            $sfp_city = get_post_meta( get_the_ID(), 'pd_city', true );
                            $sfp_zip = get_post_meta( get_the_ID(), 'pd_zip', true );
                            $sfp_state = get_post_meta( get_the_ID(), 'pd_state', true );
                            $sfp_country = get_post_meta( get_the_ID(), 'pd_country', true );
                            $gmap_address = $sfp_address . ',' . $sfp_city . ',' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ',' . $sfp_country;
                            $personal_details =( ( !empty( $sfp_name ) ) ? $sfp_name . ', '  : '' ) . $sfp_address . ', ' . $sfp_city . ', ' . ( ( !empty( $sfp_state ) ) ? $sfp_state . ' '  : '' ) . $sfp_zip . ', ' . $sfp_country;
                        ?>
                            <div class="meta-personal-details"><?php echo $personal_details; ?></div>
                        <?php endif; ?>
                        
                        <?php if( $SFP->options[ 'sfp_enable_phone' ] && get_post_meta( get_the_ID(), 'contact_phone', true ) != '' ) : ?>
                            <div class="meta-phone">
                                <span class="sfp-meta-prefix"><?php _e( 'Contact phone:', $SFP->localizationDomain ); ?></span> <?php echo get_post_meta( get_the_ID(), 'contact_phone', true ); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if( $SFP->options[ 'sfp_enable_url' ] && get_post_meta( get_the_ID(), 'website_url', true ) != '' ) : ?>
                            <div class="meta-website">
                                <a href="<?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?>" target="_blank" rel="follow"><?php echo get_post_meta( get_the_ID(), 'website_url', true ); ?></a>
                            </div>
                        <?php endif; ?>
                
                    </dt>
                    
                    <?php if( has_post_thumbnail( get_the_ID() ) ) : ?>
                    <dt class="meta-image">
                        <?php
                        $thumb = get_post_thumbnail_id();
                        $image = vt_resize( $thumb, '', 100, 60, false );
                        ?>
                        <img class="sfp-image-mini" src="<?php echo $image[ 'url' ]; ?>" width="<?php echo $image[ 'width' ]; ?>" height="<?php echo $image[ 'height' ]; ?>" />
                    </dt>
                    <?php endif; ?>
                
                </dl>
            
            </div>
            
            
			<?php if( $SFP->options[ 'sfp_enable_excerpt' ] && has_excerpt( get_the_ID() ) ) : ?>
            <div class="sfp-entry-content">
            <?php the_excerpt(); ?>
            <?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', $SFP->localizationDomain ) . '</span>', 'after' => '</div>' ) ); ?>
            </div><!-- .entry-content -->
            <?php endif; ?>
    
            <footer class="sfp-tags-wrap">
                
                <?php
                $tags_list = get_the_term_list( get_the_ID(), 'sfp_post_tags', '<span class="sfp-entry-tag">', '', '</span>' );
                if( $tags_list && $SFP->options[ 'sfp_enable_tags' ] ) :
                echo $tags_list;
                endif;
                ?>
        
            </footer><!-- #entry-meta -->
            
        </div>

        <?php endwhile; ?>

		<?php 
        if( function_exists( 'wp_pagenavi' ) ) wp_pagenavi();
        else {
            $total_pages = $wp_query->max_num_pages;
            if ( $total_pages > 1 ) {
        ?>
        <div class="navigation">
            <div class="alignleft"><?php previous_posts_link( __( '&laquo; Previous Entries', $SFP->localizationDomain ) ); ?></div>
            <div class="alignright"><?php next_posts_link( __( 'Next Entries &raquo;', $SFP->localizationDomain ) ); ?></div>
        </div>
        <?php
            } // end if total pages > 1
        } // end else; if wp_pagenavi doesn't exist
        ?>
        
		<?php
        // get back original loop
        $wp_query = $TEMP_query;
        ?>

		<?php else : ?>
            
            <h2 class="entry-h2-loop"><?php _e( 'Nothing Found', $SFP->localizationDomain ); ?></h2>

            <div class="sfp-entry-content-wrap">
                <p><?php _e( 'Sorry, no Entries found in here!', $SFP->localizationDomain ); ?></p>
            </div>
    
        <?php 
		endif; 
		wp_reset_query();
		$SFP->sfp_remove_orderby_filter(); // remove orderby filter
}
/* --------------------------------------- END TEMPLATE PARTS */




/* EXTRA FUNCTIONS USED FOR PLUGIN */

/*
 * Resize images dynamically using wp built in functions
 * Victor Teixeira
 *
 * php 5.2+
 *
 * Exemplo de uso:
 * 
 * <?php 
 * $thumb = get_post_thumbnail_id(); 
 * $image = vt_resize( $thumb, '', 140, 110, true );
 * ?>
 * <img src="<?php echo $image[url]; ?>" width="<?php echo $image[width]; ?>" height="<?php echo $image[height]; ?>" />
 *
 * @param int $attach_id
 * @param string $img_url
 * @param int $width
 * @param int $height
 * @param bool $crop
 * @return array
 */
function vt_resize( $attach_id = null, $img_url = null, $width, $height, $crop = false ) {

	// this is an attachment, so we have the ID
	if ( $attach_id ) {
	
		$image_src = wp_get_attachment_image_src( $attach_id, 'full' );
		$file_path = get_attached_file( $attach_id );
	
	// this is not an attachment, let's use the image url
	} else if ( $img_url ) {
		
		$file_path = parse_url( $img_url );
		$file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];
		
		//$file_path = ltrim( $file_path['path'], '/' );
		//$file_path = rtrim( ABSPATH, '/' ).$file_path['path'];
		
		$orig_size = getimagesize( $file_path );
		
		$image_src[0] = $img_url;
		$image_src[1] = $orig_size[0];
		$image_src[2] = $orig_size[1];
	}
	
	$file_info = pathinfo( $file_path );
	$extension = '.'. $file_info['extension'];

	// the image path without the extension
	$no_ext_path = $file_info['dirname'].'/'.$file_info['filename'];

	$cropped_img_path = $no_ext_path.'-'.$width.'x'.$height.$extension;

	// checking if the file size is larger than the target size
	// if it is smaller or the same size, stop right here and return
	if ( $image_src[1] > $width || $image_src[2] > $height ) {

		// the file is larger, check if the resized version already exists (for $crop = true but will also work for $crop = false if the sizes match)
		if ( file_exists( $cropped_img_path ) ) {

			$cropped_img_url = str_replace( basename( $image_src[0] ), basename( $cropped_img_path ), $image_src[0] );
			
			$vt_image = array (
				'url' => $cropped_img_url,
				'width' => $width,
				'height' => $height
			);
			
			return $vt_image;
		}

		// $crop = false
		if ( $crop == false ) {
		
			// calculate the size proportionaly
			$proportional_size = wp_constrain_dimensions( $image_src[1], $image_src[2], $width, $height );
			$resized_img_path = $no_ext_path.'-'.$proportional_size[0].'x'.$proportional_size[1].$extension;			

			// checking if the file already exists
			if ( file_exists( $resized_img_path ) ) {
			
				$resized_img_url = str_replace( basename( $image_src[0] ), basename( $resized_img_path ), $image_src[0] );

				$vt_image = array (
					'url' => $resized_img_url,
					'width' => $proportional_size[0],
					'height' => $proportional_size[1]
				);
				
				return $vt_image;
			}
		}

		// no cache files - let's finally resize it
		$new_img_path = image_resize( $file_path, $width, $height, $crop );
		$new_img_size = getimagesize( $new_img_path );
		$new_img = str_replace( basename( $image_src[0] ), basename( $new_img_path ), $image_src[0] );

		// resized output
		$vt_image = array (
			'url' => $new_img,
			'width' => $new_img_size[0],
			'height' => $new_img_size[1]
		);
		
		return $vt_image;
	}

	// default output - without resizing
	$vt_image = array (
		'url' => $image_src[0],
		'width' => $image_src[1],
		'height' => $image_src[2]
	);
	
	return $vt_image;
}

/**
* @desc convert currency shortcode to symbol
*/
function currency_handler( $curr = '', $meth = 0 ) {
    $currency = array( "AUD", "BRL", "CAD", "CZK", "DKK", "EUR", "HKD", "HUF", "ILS", "JPY", "MYR", "MXN", "NOK", "NZD", "PHP", "PLN", "GBP", "SGD", "SEK", "CHF", "TWD", "THB", "TRY", "USD" ); 
    $curr_cod = array( "&#36;", "R&#36;", "&#36;", "Kč", "kr", "&euro;", "&#36;", "Ft", "&#8362;", "&#165;", "MR", "&#36;", "kr", "&#36;", "&#8369;", "zl", "&pound;", "&#36;", "kr", "Fr", "&#36;", "&#3647;", "TL", "&#36;" );
	$curr_sym = array( "$", "R$", "$", "Kč", "kr", "€", "$", "Ft", "₪", "¥", "MR", "$", "kr", "$", "₱", "zl", "£", "$", "kr", "Fr", "$", "฿", "TL", "$" );
	$ret_symbol = '$';
	$the_key = array_search( $curr, $currency );
	if( $the_key > -1 ) { 
		if( !$meth ) $ret_symbol = $curr_cod[ $the_key ];
		else $ret_symbol = $curr_sym[ $the_key ];
	}
	return $ret_symbol;
}

/**
* @desc make vlaidator validate tinyMCE properly
*/
function sfp_tinymce_callback( $initArray ) {
	$initArray[ "onchange_callback" ]  = "tinyMCE_callback_validate";
	return $initArray;
}
add_filter( 'tiny_mce_before_init', 'sfp_tinymce_callback' );

/**
* @desc sfp search form
*/
function sfp_search_form() {
	global $SFP;
	if( $SFP->options[ 'sfp_enable_personal_details' ] ) :
?>
	<div class="sfp-search-form-wrap">
		<form method="get" id="sfp-searchform" action="<?php bloginfo( 'url' ); ?>">
		<div class="sfp-search-form-section">
			<label for="sfp_search_tax">* <?php _e( 'Looking for:', $SFP->localizationDomain ); ?></label>
			<input type="text" value="" name="sfp_search_tax" id="sfp_search_tax" class="sfp-search" autocomplete="off" tabindex="9001" />
		</div>
		<div class="sfp-search-form-section">
			<label for="sfp_search_meta"><?php _e( 'Where?', $SFP->localizationDomain ); ?></label>
			<input type="text" value="" name="sfp_search_meta" id="sfp_search_meta" class="sfp-search" autocomplete="off" tabindex="9002" />
		</div>
		<div class="sfp-search-form-section remove-right">
			<input type="hidden" name="page_id" value="<?php echo $SFP->options[ 'sfp_page_entries_search' ]; ?>" />
            <label for="sfp-submit-search">&nbsp;</label>
			<input type="submit" id="sfp-submit-search" name="sfp-submit-search" class="sfp-button" value="<?php _e( 'Search', $SFP->localizationDomain ); ?>" tabindex="9003" />
		</div>
		</form>
	</div>
<?php else : ?>
	<div class="sfp-search-form-wrap">
    	<p><?php _e( '"Enable Personal Details?" option of plugin\'s settings page (SFP Posts :: Manage Options :: Input Fields) is disabled. You can\'t use Advanced Search unless Personal Details are enabled, hawever, regular search will work just fine.', $SFP->localizationDomain ); ?></p>
    </div>	
<?php
	endif;
}
add_shortcode( 'sfp_search_form', 'sfp_search_form_shortcode' );
function sfp_search_form_shortcode() {
	ob_start();
	global $SFP;
	if( $SFP->options[ 'sfp_enable_personal_details' ] ) :
?>
	<div class="sfp-search-form-wrap">
		<form method="get" id="sfp-searchform" action="<?php bloginfo( 'url' ); ?>">
		<div class="sfp-search-form-section">
			<label for="sfp_search_tax">* <?php _e( 'Looking for:', $SFP->localizationDomain ); ?></label>
			<input type="text" value="" name="sfp_search_tax" id="sfp_search_tax" class="sfp-search" autocomplete="off" tabindex="9001" />
		</div>
		<div class="sfp-search-form-section">
			<label for="sfp_search_meta"><?php _e( 'Where?', $SFP->localizationDomain ); ?></label>
			<input type="text" value="" name="sfp_search_meta" id="sfp_search_meta" class="sfp-search" autocomplete="off" tabindex="9002" />
		</div>
		<div class="sfp-search-form-section remove-right">
			<input type="hidden" name="page_id" value="<?php echo $SFP->options[ 'sfp_page_entries_search' ]; ?>" />
            <label for="sfp-submit-search">&nbsp;</label>
			<input type="submit" id="sfp-submit-search" name="sfp-submit-search" class="sfp-button" value="<?php _e( 'Search', $SFP->localizationDomain ); ?>" tabindex="9003" />
		</div>
		</form>
	</div>
<?php else : ?>
	<div class="sfp-search-form-wrap">
    	<p><?php _e( '"Enable Personal Details?" option of plugin\'s settings page (SFP Posts :: Manage Options :: Input Fields) is disabled. You can\'t use Advanced Search unless Personal Details are enabled, hawever, regular search will work just fine.', $SFP->localizationDomain ); ?></p>
    </div>	
<?php
	endif;
	return ob_get_clean();
}

/**
* @desc related posts based on taxonomy
*/
function sfp_get_posts_related_by_taxonomy( $post_id, $taxonomy, $args=array() ) {
	$query = new WP_Query();
	$terms = wp_get_object_terms( $post_id, $taxonomy );
	if( count( $terms ) ) {
		$city = get_post_meta( $post_id, 'pd_city', true );
		$country = get_post_meta( $post_id, 'pd_country', true );
		$post = get_post( $post_id );
		$args = wp_parse_args( $args, array(
			'showposts' => 10,
			'post_type' => $post->post_type, 
			'post__not_in' => array( $post_id ), 
			'post_status' => 'publish', 
			'tax_query' => array( array( 'taxonomy' => $taxonomy, 'field' => 'slug', 'terms' => $terms[ 0 ]->slug ) ), 
			'meta_query' => array( 'relation' => 'OR', 
					array( 'key' => 'pd_city', 'value' => $city, 'compare' => '=' ), 
					array( 'key' => 'pd_country', 'value' => $country, 'compare' => '=' )
					)
		) );
		$query = new WP_Query( $args );

	}
	return $query;
}

/**
* @desc show categories and number of entries per category. Omit those where posts are pending, are expired or due to pay
*/
add_shortcode( 'sfp_categories', 'sfp_get_categs_list' );
function sfp_get_categs_list( $atts ) {
	global $SFP;
	extract( shortcode_atts( array( 'hide_empty' => 0, 'include_children' => 'yes' ), $atts ) );
	$all_parents = '';
	if( (int)$hide_empty > 1 ) $hide_empty = 1;
	elseif( (int)$hide_empty < 0 ) $hide_empty = 0;
	if( $include_children == 'yes' ) $all_parents = '';
	elseif( $include_children == 'no' ) $all_parents = '&parent=0';
	else $all_parents = '';
	$term_list = '';
	$terms = get_terms( 'sfp_post_category', 'orderby=title&hide_empty=' . (int)$hide_empty . $all_parents );
	$count = count( $terms );
	if( $count > 0 ) {
		$term_list = '<div class="sfp-cat-list-item-wrap">';
		foreach( $terms as $term ) {
			// by default empty ones will be omitted
			$posts_args = array( 
			'fields' => 'ids', 
			'numberposts' => -1, 
			'post_type' => 'sfpposts', 	
			'post_status' => 'publish', 
			'tax_query' => array(
				array(
					'taxonomy' => 'sfp_post_category',
					'field' => 'slug',
					'terms' => $term->slug
				)
			)
			);
			$count_posts = get_posts( $posts_args );
			$term_list .= '<a class="sfp-cat-list-item" href="' . get_term_link( $term->slug, $term->taxonomy ) . '" title="' . $term->name . '">' . $term->name . ' (' . count( $count_posts ) . ')</a>';
		}
		$term_list .= '</div>';
	}
	if( $term_list == '' ) return '<p>' . __( 'No categories found!', $SFP->localizationDomain ) . '</p>';
	else return $term_list;
}

/**
* @desc create menu widget
*/
class SFP_User_Menu extends WP_Widget {
	function SFP_User_Menu() {
		global $SFP;
		$widget_ops = array( 'classname' => 'widget_sfp_user_menu', 'description' => __( 'This Widget will add useful navigation.', $SFP->localizationDomain ) );
		parent::__construct( 'sfp_user_menu', 'SFP User Menu', $widget_ops );
	}
	function widget( $args, $instance ) {
		global $SFP;
		global $current_user;
		get_currentuserinfo();
		extract( $args, EXTR_SKIP );
		echo $before_widget;
		$widget_sfp_title = empty( $instance[ 'widget_sfp_title' ] ) ? __( 'Navigate...', $SFP->localizationDomain ) : apply_filters( 'widget_widget_sfp_title', $instance[ 'widget_sfp_title' ] );
		echo $before_title . $widget_sfp_title . $after_title;
		echo '<div class="sfp-user-menu-wrap"><ul class="sfp-user-menu-widget">';
		// login page
		if( !is_user_logged_in() ) {
			echo '<li id="widget-logged">' . __( 'Please login if you want to participate!', $SFP->localizationDomain ) . '</li>';
			$login_page_title = get_the_title( $SFP->options[ 'sfp_page_login' ] );
			echo '<li id="widget-login"><a href="' . get_permalink( $SFP->options[ 'sfp_page_login' ] ) . '">' . $login_page_title . '</a></li>';
		} else {
			global $user_identity;
			global $userdata;
			echo '<li id="widget-logged">' . get_avatar( $userdata->ID, 30 ) . sprintf( __( 'Hi %s, it\'s great to have you here!', $SFP->localizationDomain ), $user_identity ) . '</li>';
			echo '<li id="widget-logout"><a href="' . wp_logout_url( 'index.php' ) . '">' . __( 'I want to log out!', $SFP->localizationDomain ) . '</a></li>';
			// user entries
			$user_entries_page_title = get_the_title( $SFP->options[ 'sfp_page_entries_list' ] );
			echo '<li id="widget-entries"><a href="' . get_permalink( $SFP->options[ 'sfp_page_entries_list' ] ) . '">' . $user_entries_page_title . '</a></li>';
			// new entry
			$new_entry_page_title = get_the_title( $SFP->options[ 'sfp_page_new_entry' ] );
			echo '<li id="widget-new-entry"><a href="' . get_permalink( $SFP->options[ 'sfp_page_new_entry' ] ) . '">' . $new_entry_page_title . '</a></li>';
			// user_payments
			if( $SFP->options[ 'sfp_publish_type' ] != 'free' ) {
				$payments_page_title = get_the_title( $SFP->options[ 'sfp_page_user_payments' ] );
				echo '<li id="widget-payments"><a href="' . get_permalink( $SFP->options[ 'sfp_page_user_payments' ] ) . '">' . $payments_page_title . '</a></li>';
			}
		}
			
		echo '</ul></div>';
		echo $after_widget;
	}
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'widget_sfp_title' ] = strip_tags( $new_instance[ 'widget_sfp_title' ] );
		return $instance;
	}
	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'widget_sfp_title' => '' ) );
		$widget_sfp_title = strip_tags( $instance[ 'widget_sfp_title' ] );
?>

<p>
<label for="<?php echo $this->get_field_id( 'widget_sfp_title' ); ?>">
Title: 
<input class="widefat" id="<?php echo $this->get_field_id( 'widget_sfp_title' ); ?>" name="<?php echo $this->get_field_name( 'widget_sfp_title' ); ?>" type="text" value="<?php echo esc_attr( $widget_sfp_title ); ?>" />
</label>
</p>
            
<?php
	}
}

class SFP_Search extends WP_Widget {
	function SFP_Search() {
		global $SFP;
		$widget_ops = array( 'classname' => 'widget_sfp_search', 'description' => __( 'This Widget will add search form that will search all user Entries only.', $SFP->localizationDomain ) );
		parent::__construct( 'sfp_search', 'SFP Search', $widget_ops );
	}
	function widget( $args, $instance ) {
		global $SFP;
		extract( $args, EXTR_SKIP );
		echo $before_widget;
		$search_sfp_title = empty( $instance[ 'search_sfp_title' ] ) ? __( 'Search Entries...', $SFP->localizationDomain ) : apply_filters( 'widget_search_sfp_title', $instance[ 'search_sfp_title' ] );
		echo $before_title . $search_sfp_title . $after_title;
		
		sfp_search_form();
		
		echo $after_widget;
	}
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'search_sfp_title' ] = strip_tags( $new_instance[ 'search_sfp_title' ] );
		return $instance;
	}
	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'search_sfp_title' => '' ) );
		$search_sfp_title = strip_tags( $instance[ 'search_sfp_title' ] );
?>

<p>
<label for="<?php echo $this->get_field_id( 'search_sfp_title' ); ?>">
Title: 
<input class="widefat" id="<?php echo $this->get_field_id( 'search_sfp_title' ); ?>" name="<?php echo $this->get_field_name( 'search_sfp_title' ); ?>" type="text" value="<?php echo esc_attr( $search_sfp_title ); ?>" />
</label>
</p>
            
<?php
	}
}

class SFP_Related_Business extends WP_Widget {
	function SFP_Related_Business() {
		global $SFP;
		$widget_ops = array( 'classname' => 'widget_sfp_related_business', 'description' => __( 'This Widget will list sub-categories of currently selected category - if any.', $SFP->localizationDomain ) );
		parent::__construct( 'sfp_related_business', 'SFP Related Business', $widget_ops );
	}
	function widget( $args, $instance ) {
		if( !is_tax() ) return;
		global $SFP;
		global $wp_query;
		extract( $args, EXTR_SKIP );
		// where are we at?
		$current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
		$descendants  = get_term_children( $current_term->term_id, $current_term->taxonomy );
		
		if( !is_wp_error( $descendants ) && !empty( $descendants ) ) {  
			$args = array(
				'child_of' => $current_term->term_id,
				'taxonomy' => $current_term->taxonomy,
				'hide_empty' => 0,
				'hierarchical' => true,
				'show_count' => 1,
				'depth'  => 1,
				'title_li' => '',
				'echo' => 0
			);
			
			$curr_children = wp_list_categories( $args );
			
			echo $before_widget;
			$related_business_sfp_title = empty( $instance[ 'related_business_sfp_title' ] ) ? __( 'Related Businesses...', $SFP->localizationDomain ) : apply_filters( 'widget_related_business_sfp_title', $instance[ 'related_business_sfp_title' ] );
			echo $before_title . $related_business_sfp_title . $after_title;

			echo '<ul class="sfp-related-business">';
			echo $curr_children;
			echo '</ul>';
			
			echo $after_widget;
		}
	}
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'related_business_sfp_title' ] = strip_tags( $new_instance[ 'related_business_sfp_title' ] );
		return $instance;
	}
	function form( $instance ) {
		$instance = wp_parse_args( ( array ) $instance, array( 'related_business_sfp_title' => '' ) );
		$related_business_sfp_title = strip_tags( $instance[ 'related_business_sfp_title' ] );
?>

<p>
<label for="<?php echo $this->get_field_id( 'related_business_sfp_title' ); ?>">
Title: 
<input class="widefat" id="<?php echo $this->get_field_id( 'related_business_sfp_title' ); ?>" name="<?php echo $this->get_field_name( 'related_business_sfp_title' ); ?>" type="text" value="<?php echo esc_attr( $related_business_sfp_title ); ?>" />
</label>
</p>
            
<?php
	}
}
function sfp_register_widgets() {
	register_widget( 'SFP_User_Menu' );
	register_widget( 'SFP_Search' );
	register_widget( 'SFP_Related_Business' );
}
add_action( 'widgets_init', 'sfp_register_widgets' );