<?php

class Bunyad_LatestPosts_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'bunyad-latest-posts-widget',
			'Bunyad - Recent Posts',
			array('description' => 'Recent posts with thumbnail.', 'classname' => 'latest-posts')
		);
		
		add_action('save_post', array($this, 'flush_widget_cache'));
		add_action('edit_post', array($this, 'flush_widget_cache')); // comments covered
		add_action('deleted_post', array($this, 'flush_widget_cache'));
		add_action('switch_theme', array($this, 'flush_widget_cache'));
		add_action('bunyad_widget_flush_cache', array($this, 'flush_widget_cache'));
	}
	
	// code below is modified from default
	public function widget($args, $instance) 
	{
		$cache = get_transient('bunyad_widget_latest_posts');
		
		if (!is_array($cache)) {
			$cache = array();
		}

		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}
		
		// cache available
		if (!defined('ICL_LANGUAGE_CODE') && isset($cache[ $args['widget_id'] ])) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = apply_filters('widget_title', empty($instance['title']) ? __('Recent Posts', 'bunyad-widgets') : $instance['title'], $instance, $this->id_base);
		if (empty($instance['number']) || !$number = absint($instance['number'])) {
 			$number = 5;
		}

		// Start of args
		$query_args = array(
			'posts_per_page' => $number, 'post_status' => 'publish', 'ignore_sticky_posts' => 1
		);

		// Limit by category
		if (!empty($instance['category'])) {
			$query_args['cat'] = $instance['category'];
		}
		
		// Limited by tag?
		if (!empty($instance['limit_tag'])) {
			$query_args = array_merge($query_args, array('tag' => $instance['limit_tag']));
		}
		
		$r = new WP_Query(apply_filters('bunyad_widget_latest_posts_query_args', $query_args));
		
		// do custom loop if available
		if (has_action('bunyad_widget_latest_posts_loop')):

			$args['title'] = $title;
			do_action('bunyad_widget_latest_posts_loop', array_merge($args, $instance), $r);
		
		elseif ($r->have_posts()):
?>

			<?php echo $before_widget; ?>
			
			<?php if ($title): ?>
				<?php echo $before_title . $title . $after_title; ?>
			<?php endif;?>
			
			<ul class="posts-list">
			
			<?php  while ($r->have_posts()) : $r->the_post(); global $post; ?>
				<li>
				
					<a href="<?php the_permalink() ?>"><?php the_post_thumbnail('post-thumbnail', array('title' => strip_tags(get_the_title()))); ?>
					
					<?php if (class_exists('Bunyad') && Bunyad::options()->review_show_widgets): ?>
						<?php echo apply_filters('bunyad_review_main_snippet', ''); ?>
					<?php endif; ?>
					
					</a>
					
					<div class="content">
					
						<?php echo Bunyad::blocks()->meta('above', 'latest-posts', array('type' => 'widget')); ?>
					
						<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(get_the_title() ? get_the_title() : get_the_ID()); ?>">
							<?php if (get_the_title()) the_title(); else the_ID(); ?></a>
							
						<?php echo Bunyad::blocks()->meta('below', 'latest-posts', array('type' => 'widget')); ?>
																	
					</div>
				
				</li>
			<?php endwhile; ?>
			</ul>
			
			<?php echo $after_widget; ?>
<?php
		endif;
		
		// reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		$cache[$args['widget_id']] = ob_get_flush();
		
		set_transient('bunyad_widget_latest_posts', $cache);
	}

	public function update($new, $old) 
	{
		foreach ($new as $key => $val) {
			$new[$key] = wp_filter_kses($val);
		}
				
		$this->flush_widget_cache();

		return $new;
	}

	public function flush_widget_cache() 
	{
		delete_transient('bunyad_widget_latest_posts');
	}

	public function form($instance)
	{	
		$instance = array_merge(array('title' => '', 'number' => 5, 'category' => '', 'limit_tag' => ''), $instance);
		extract($instance);
		
		$fields = apply_filters('bunyad_widget_latest_posts_form', array('title' => '', 'category' => '', 'number' => ''));
?>

	<?php if (isset($fields['title'])): ?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'bunyad-widgets'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
	<?php endif; ?>

	<?php if (isset($fields['category'])): ?>
		<p><label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('Limit to Category:', 'bunyad-widgets'); ?></label>
		<?php wp_dropdown_categories(array(
				'show_option_all' => __('-- Not Limited --', 'bunyad-widgets'), 
				'hierarchical' => 1,
				'hide_empty' => 0,
				'order_by' => 'name', 
				'class' => 'widefat', 
				'name' => $this->get_field_name('category'), 
				'selected' => $category
		)); ?>
		</p>
	<?php endif; ?>
	
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('limit_tag')); ?>"><?php echo esc_html_x('Limit to Tag (Optional):', 'bunyad-widgets'); ?></label>
			
			<input id="<?php echo esc_attr($this->get_field_id('limit_tag')); ?>" name="<?php 
				echo esc_attr($this->get_field_name('limit_tag')); ?>" type="text" class="widefat" value="<?php echo esc_attr($limit_tag); ?>" />
		</p>

	<?php if (isset($fields['type'])): ?>
	
		<p><label for="<?php echo $this->get_field_id('type'); ?>"><?php _e('Type:', 'bunyad-widgets'); ?></label>
		
		<select id="<?php echo $this->get_field_id('type'); ?>" name="<?php echo $this->get_field_name('type'); ?>" class="widefat">
			<option value="list" <?php selected($type, 'list'); ?>><?php _e('List', 'bunyad-widgets'); ?></option>
			<option value="blocks" <?php selected($type, 'blocks'); ?>><?php _e('Image Blocks', 'bunyad-widgets'); ?></option>
			<option value="numbered" <?php selected($type, 'numbered'); ?>><?php _e('Numbered List (No Thumbnails)', 'bunyad-widgets'); ?></option>
		</select>
		
		</p>
		
	<?php endif; ?>
	

	<?php if (isset($fields['number'])): ?>
		<p><label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of posts to show:', 'bunyad-widgets'); ?></label>
		<input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
	<?php endif; ?>
	
<?php
	}
}