<?php
set_time_limit(0);
include('../includes/db.php');
include('../includes/config.php');
?>
<!DOCTYPE html>
<html lang="en">
<meta charset="utf-8">
<head>
<title>Statistics for - <?=$title;?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description" content="<?php echo $description?>"/>
<meta name="keywords" content="<?php echo $keywords?>" />
<link rel="shortcut icon" type="image" href="../favicon.png">
<link rel="stylesheet" media="screen" href="../css/<?=$stylesheet;?>.css" /> 
<link rel="stylesheet" media="screen" href="css/main.css" /> 
<link href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css" rel="stylesheet"/>
</head>
<body>
<div class="wrapper">
<a href="../" style="float:right;" class="success">Back to Home</a>
<?php
		$result = mysqli_query($conDB, "SELECT COUNT(url) FROM sm_shorturl");
		$row = mysqli_fetch_row($result);
		$geturl = number_format($row[0]);
?>
<h1>Total Links Generated:<?=$geturl?></h1>
<?php
		$result = mysqli_query($conDB, "SELECT SUM(clicks) FROM sm_shorturl");
		$row = mysqli_fetch_row($result);
		$gethits = number_format($row[0]);
?>
<h3>Overall Total Hits Generated:<?=$gethits?></h3><br>
    <div class="container">
    <table id="myTable">
        <thead>
          <tr>
              <th data-field="short_id">Short</th>
              <th data-field="orig_url">Original URL</th>
              <th data-field="hits">Hits</th>
          </tr>
        </thead>
        <tbody>
            <?php
            $result = mysqli_query($conDB, "SELECT * FROM sm_shorturl ORDER BY id DESC LIMIT 100");
            while($display = mysqli_fetch_array($result))
            {
                $short = $display['short'];
                $clicks = $display['clicks'];
                echo "<tr>"; 
                echo"<td>" .$display['short']."</td>";
                echo"<td style='word-break:break-all;'>". $display['url']. "</td>";
                echo"<td>". $display['clicks']. "</td>";
                echo "</tr>";           
            }
            ?>
          </tr>
        </tbody>
      </table>
      </div>
  <script src="http://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.7.1.min.js"></script> 
  <script src="js/jquery.dataTables.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/0.97.0/js/materialize.min.js"></script>
  <script>
   $(document).ready(function(){
    $('#myTable').dataTable();
   });
  </script>
</body>
</html>