// LOOK UP FOR THE (http://cittr.us) URL AND CHANGE IT WITH YOUR OWN URL
//////////////////////////////////////////////////////////////////////////////
(function() {
var UTIL = UTIL || {};

(function(UTIL) {
  UTIL.addEvent = function addEvent(node, event, callback) {
    if (node.addEventListener) {
      node.addEventListener(event, callback, false);
      return true;
    } else if (node.attachEvent) {
      // Simulates W3C event model in IE
      return node.attachEvent('on' + event, function() {
        callback( {
          target : window.event.srcElement,
          pageX : window.event.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft),
          pageY : window.event.clientY  + (document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop),
          clientX : window.event.clientX,
          clientY : window.event.clientY,
          keyCode : window.event.keyCode,
          ctrlKey : window.event.ctrlKey,
          altKey : window.event.altKey,
          shiftKey : window.event.shiftKey,
          type : window.event.type,
          preventDefault : function() {
            window.event.returnValue = false;
          },
          stopPropagation : function() {
            window.event.cancelBubble = true;
          }
        });
      });
    }
    return false;
  };

  UTIL.StringBuffer = function StringBuffer() {
    var buffer = [];

    this.append = function append(string) {
      buffer.push(string);
      return this;
    };

    this.toString = function toString() {
      return buffer.join('');
    };
  };

  UTIL.forEach = function forEach(array, callback) {
    var i = 0, length = array.length, value;

    if (length) {
      for (value = array[0]; i < length && callback.call(value, i, value) !== false; value = array[++i]) {
      }
    }
  };

  UTIL.animate = function animate(callback, steps, delay) {
    var index = 1, timer;

    timer = window.setInterval(function() {
      if (index < steps) {
        callback(index, false);
        index += 1;
      } else {
        clearInterval(timer);
        callback(index, true);
      }
    }, delay);
  };

  
  UTIL.isQuirksMode = function isQuirksMode() {
    return ((document.documentMode && document.documentMode == 5) ||
      (document.compatMode && document.compatMode == 'BackCompat'));
  };

  UTIL.uniqueArray = function uniqueArray(array, compare) {
    array.sort(compare);
    for (var i = 1; i < array.length;) {
      if (compare(array[i - 1], array[i]) === 0) {
        array.splice(i, 1);
      } else {
        i++;
      }
    }

    return array;
  };
})(UTIL);

  var BookmarkletLoader = function BookmarkletLoader() {
    var adjustBookmarkletPosition = function adjustBookmarkletPosition(element) {
      var offsetTop = 0;
      if (window.pageYOffset) {
        offsetTop = parseInt(window.pageYOffset);
      } else if (document.documentElement.scrollTop) {
        offsetTop = parseInt(document.documentElement.scrollTop);
      } else if (document.body.scrollTop) {
        offsetTop = parseInt(document.body.scrollTop);
      } else {
        offsetTop = 0;
      }
      element.style.position = 'absolute';
      element.style.top = offsetTop + 100 + 'px';
      element.style.left = '30%';
      element.style.minWidth = '230px';
      element.style.height = '120px';
      element.style.display = 'block';
    };

    if (typeof window.__m4to == 'number') {
      window.clearTimeout(window.__m4to);
      window.__m4to = undefined;
    }

    var bookmarklet = document.getElementById('m4-bookmarklet-popup');

    if (bookmarklet != undefined) {
      document.body.removeChild(bookmarklet);
    }

    bookmarklet = document.createElement('div');
    bookmarklet.id = 'm4-bookmarklet-popup';

    var cloneUrl = encodeURIComponent(window.location.href.replace(/#.*$/, ''));
    var iframe = document.createElement('iframe');
    iframe.frameBorder = '0';
    iframe.style.width = '100%';
    iframe.style.height = '100%';
    iframe.src = 'http://cittr.us/bookmarklet.php?url=' + encodeURIComponent(location.href); // CHANGE URL HERE

    var closeAnchorImage = document.createElement('img');
    closeAnchorImage.src = 'http://cittr.us/img/closelabel.gif'; // CHANGE URL HERE

    var closeAnchor = document.createElement('a');
    closeAnchor.style.position = 'absolute';
    closeAnchor.style.top = '10px';
    closeAnchor.style.right = '5px';
    closeAnchor.style.cursor = 'pointer';
    closeAnchor.onclick = function() {
      document.body.removeChild(bookmarklet);
      return false;
    };

    closeAnchor.appendChild(closeAnchorImage);

    bookmarklet.appendChild(closeAnchor);

    bookmarklet.appendChild(iframe);

    if (UTIL.isQuirksMode()) {
      UTIL.addEvent(document.body, 'change', function() {
        adjustBookmarkletPosition(bookmarklet);
      });
      UTIL.addEvent(window, 'scroll', function() {
        adjustBookmarkletPosition(bookmarklet);
      });
      adjustBookmarkletPosition(bookmarklet);
    } else {
      bookmarklet.style.position = 'fixed';
      bookmarklet.style.top = '100px';
      bookmarklet.style.left = '30%';
      bookmarklet.style.minWidth = '230px';
      bookmarklet.style.height = '120px';
      bookmarklet.style.display = 'block';
    }

    bookmarklet.style.boxShadow = '0px 0px 10px #3399ff';
    bookmarklet.style.MozBoxShadow = '0px 0px 10px #3399ff';
    bookmarklet.style.zIndex = '2147483647';
    bookmarklet.style.backgroundColor = '#fff';
    bookmarklet.style.borderRadius = '5px';
    bookmarklet.style.MozBorderRadius = '5px';

    document.body.appendChild(bookmarklet);

    if (window.postMessage) {
      var onMessage = function onMessage(event) {
        if ('http://hostb.tld'.indexOf(event.origin) != -1 && event.data === 'closeDialog') {
          document.body.removeChild(bookmarklet);
        }
      };

      if (window.addEventListener) {
        window.addEventListener('message', onMessage, false);
      } else if (window.attachEvent)  {
        window.attachEvent('onmessage', onMessage);
      }
    } else {
    }
  };

  // init

  new BookmarkletLoader();
})();