<?php
global $error;
class mime_mail
{
 var $body;
 var $headers;
 var $boundary;
 var $num_images;
 var $mime_types;
 var $error;


 function mime_mail()
 {
  $this->body='';
  $this->headers='';
  $this->boundary=md5(uniqid(mktime()));
  $this->num_images=0;
  $this->mime_types=array(
                          'gif'=>'image/gif',
                          'jpg'=>'image/jpeg',
                          'jpeg'=>'image/jpeg',
                          'png'=>'image/png',
                          'bmp'=>'image/bmp',
                          'tif'=>'image/tiff',
                          'tiff'=>'image/tiff',
                          'html'=>'text/html',
                          'htm'=>'text/html',
                          'swf'=>'application/x-shockware-flash',
                          'rar'=>'application/x-rar-compressed',
                          'zip'=>'application/zip'
                         );
 }


 function destroy()
 {
  $this->body='';
  $this->headers='';
  $this->boundary='';
  $this->mime_types=array();
 }

 function add_text_plain($text_plain,$file_path,$charset,$wrap=80)
 {
  if(trim($file_path)!=='')
  {
     $file_name=basename($file_path);
     if(!file_exists($file_path)){ $error .= 'File "'.$file_name.'" does not exist!<br>'; $this->error=1; }
     elseif(!is_file($file_path)){ $error .= 'File "'.$file_name.'" not a regular file!<br>'; $this->error=1; }
     elseif(!is_readable($file_path)){ $error .= 'File "'.$file_name.'" can not read!<br>'; $this->error=1; }
     elseif(!ereg("^(.*)\.txt$",$file_name)){ $error .= 'File "'.$file_name.'" is not a text!<br>'; $this->error=1; }
     elseif(!filesize($file_path)){ $error .= 'File "'.$file_name.'" is empty!<br>'; $this->error=1; }
     else
     {

         $file_open=fopen($file_path,'r');
         $text_plain=fread($file_open,filesize($file_path));
         fclose($file_open);
         if(IsSet($this->variable)&&!IsSet($this->error))
         {
            $text_plain=ereg_replace('{\$([A-Za-z0-9_]+)}','\'.$this->variable["\\1"].\'',addslashes($text_plain));
            eval('$text_plain=stripslashes(\''.$text_plain.'\');');
         }
     }
  }
  $text_plain=wordwrap($text_plain,$wrap,"\n"); 
  $this->body.='--'.$this->boundary."\r\n";
  $this->body.='Content-type: text/plain; charset='.$charset."\r\n";
  $this->body.='Content-Transfer-Encoding: 8bit'."\r\n\r\n";
  $this->body.=$text_plain."\n\n";
 }


 function add_text_html($text_html,$file_path,$charset)
 {
  if(trim($file_path)!=='')
  {
     $file_name=basename($file_path);
     if(!file_exists($file_path)){ $error .= 'File "'.$file_name.'" does not exist!<br>'; $this->error=1; }
     elseif(!is_file($file_path)){ $error .= 'File "'.$file_name.'" not a regular file!<br>'; $this->error=1; }
     elseif(!is_readable($file_path)){ $error .= 'File "'.$file_name.'" can not read!<br>'; $this->error=1; }
     elseif(!ereg("^(.*)\.(html|htm)$",$file_name)){ $error .= 'File "'.$file_name.'" not an html file!<br>'; $this->error=1; }
     elseif(!filesize($file_path)){ $error .= 'File "'.$file_name.'" is empty!<br>'; $this->error=1; }
     else
     {

         $file_open=fopen($file_path,'r');
         $text_html=fread($file_open,filesize($file_path));
         fclose($file_open);

         if(IsSet($this->variable)&&!IsSet($this->error))
         {
            $text_html=ereg_replace('{\$([A-Za-z0-9_]+)}','\'.$this->variable["\\1"].\'',addslashes($text_html));
            eval('$text_html=stripslashes(\''.$text_html.'\');');
         }
     }
  }
  $this->body.='--'.$this->boundary."\r\n";
  $this->body.='Content-type: text/html; charset='.$charset."\r\n";
  $this->body.='Content-Transfer-Encoding: Quot-Printed'."\r\n\r\n";
  $this->body.=$text_html."\n\n";
 }


 function add_attachment($file_path)
 {
  if(trim($file_path)!=='')
  {
     $file_name=basename($file_path);
     if(!file_exists($file_path)){ $error .= 'File "'.$file_name.'" does not exist!<br>'; $this->error=1; }
     elseif(!is_readable($file_path)){ $error .= 'File "'.$file_name.'" can not read!<br>'; $this->error=1; }
     elseif(!filesize($file_path)){ $error .= 'File "'.$file_name.'" is empty!<br>'; $this->error=1; }
     else
     {

         $file_open=fopen($file_path,'rb');
         $file_body=fread($file_open,filesize($file_path));
         fclose($file_open);

         $ext=strtolower(substr($file_name,strrpos($file_name,'.')+1));
         if(array_key_exists($ext,$this->mime_types)) $mime_type=$this->mime_types["$ext"];
         else $mime_type='application/octet-stream';
         $this->body.='--'.$this->boundary."\r\n";
         $this->body.='Content-Type: '.$mime_type.' name="'.$file_name.'"'."\r\n";
         $this->body.='Content-Transfer-Encoding: base64'."\r\n";
         $this->body.='Content-Disposition: attachment; filename="'.$file_name."\r\n\r\n";
         $this->body.=chunk_split(base64_encode($file_body))."\n\n";
     }
  }
  else $error .= 'Вы не указали путь к вложению!<br>';
 }

 function add_image_in_html($name,$file_path)
 {
  $image_types=array_slice($this->mime_types,0,6); 
  if(trim($file_path)!=='')
  {
     $file_name=basename($file_path);
     $ext=strtolower(substr($file_name,strrpos($file_name,'.')+1));
     if(!file_exists($file_path)){ $error .= 'File "'.$file_name.'" does not exist!<br>'; $this->error=1; }
     elseif(!is_readable($file_path)){ $error .= 'File "'.$file_name.'" can not read!<br>'; $this->error=1; }
     elseif(!filesize($file_path)){ $error .= 'File "'.$file_name.'" is empty!<br>'; $this->error=1; }
     elseif(!array_key_exists($ext,$image_types)){ $error .= 'File "'.$file_name.'" is not an image or type is not supported!<br>'; $this->error=1; }
     elseif(trim($name)===''){ $error .= 'You do not specify a file name "'.$file_name.'"!<br>'; $this->error=1; }
     elseif(!ereg("^[a-zA-Z0-9_]+$",$name)){ $error .= 'Filename "'.$file_name.'" contains invalid characters! You can use uppercase, lowercase, numbers, and the underscore!<br>'; $this->error=1; }
     else
     {

         $file_open=fopen($file_path,'rb');
         $file_body=fread($file_open,filesize($file_path));
         fclose($file_open);

         $mime_type=$image_types["$ext"];
         $this->body.='--'.$this->boundary."\r\n";
         $this->body.='Content-Type: '.$mime_type.' name="'.$file_name.'"'."\r\n";
         $this->body.='Content-Transfer-Encoding: base64'."\r\n";
         $this->body.='Content-Disposition: inline; filename="'.$file_name."\r\n";
         $this->body.='Content-ID: <'.$name.'>'."\r\n\r\n";
         $this->body.=chunk_split(base64_encode($file_body))."\n\n";
     }
  }
  else $error .= 'You did not specify the path to the attached images!<br>';
 }


 function add_variables()
 {

  for($i=0;$i<func_num_args();$i++)
  {
       $variable=func_get_arg($i);
       if(strpos(trim($variable),'=>')!==FALSE&&strpos(trim($variable),'=>')!==0&&(strpos(trim($variable),'=>')+2)!==strlen(trim($variable)))
       {
           list($key,$value)=explode('=>',$variable);
           $this->variable["$key"]=$value;
       }
       else
       {
           $error .= '<p class="status_bad">Invalid syntax for adding variables. example: key=>value.</p>';
           $this->error=1;
           break;
       }
  }
 }



 function send_mail($to,$from,$subject, $importance)
 {
  if(!IsSet($this->error))
  {

     $headers='From: '.$from."\r\n";
     $headers.='MIME-Version: 1.0'."\r\n";
     $headers.='Content-Type: multipart/mixed; boundary="'.$this->boundary.'"'."\r\n";
	 if($importance == 'high'){
		 $headers.= "X-Priority: 1\nX-MSmail-Priority: high"."\r\n"; 
	 }else{
		$headers.= "X-Priority: 3\nX-MSmail-Priority: normal"."\r\n";	 
	 }
     $headers.=$this->headers;

     $body=''."\r\n\r\n";
     $body.=$this->body;
     $body.='--'.$this->boundary.'--'."\r\n";
     $body.='Class Mime Mail was created by Creator'."\r\n\r\n";
     mail($to,$subject,$body,$headers);
  }
 }
}
		require_once('../_config.php');
		if(isset($_POST['feed_name']) && isset($_POST['feed_email'])
		&& isset($_POST['feed_message'])
		){
		$mime_mail=new mime_mail;
		$text_html= 'User name:'.$_POST['feed_name'].'<br>Email:'.$_POST['feed_email'].'<br>Message:'.$_POST['feed_message'];
		$mime_mail->add_text_html($text_html,'','utf-8');
		$mime_mail->send_mail($_SET['email_from'],$_SET['email_from'],$_SET['title_from'],'order');
		$mime_mail->destroy();
			
			$result = __('Thanks, your request has been sent');
		}else{
			$result = __('An error has occurred, please try later');
		}

		echo json_encode($result);


?>
