<div class="row">
<div class="col-md-3">
    <div class="list-group">
      <a href="/?api#create" class="list-group-item"><?php echo __('Create');?></a>
      <a href="/?api#disable" class="list-group-item"><?php echo __('Disable')?></a>
      <a href="/?api#activate" class="list-group-item"><?php echo __('Activate')?></a>
      <a href="/?api#info" class="list-group-item"><?php echo __('Info')?></a>  
      <a href="/?api#list" class="list-group-item"><?php echo __('List')?></a>  
    </div>
</div>
<div class="col-md-9">
<div class="panel panel-default" id="create">
  <div class="panel-heading"><?php echo __('Create');?></div>
	<div class="panel-body">
  	<h4><?php echo __('Parameters');?></h4>
  	<table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>api key</td>
            	<td>string</td>
            	<td>your api key</td>                                
            </tr>
		   	<tr>
            	<td>url</td>
            	<td>string</td>
            	<td>Base64 encoded version of your long url. <code>base64_encode()</code> in PHP.</td>                                
            </tr>
        </tbody>
    </table>
    <h4><?php echo __('Return values');?></h4>
    <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>url_id</td>
            	<td>int</td>
            	<td>The unique id value of making URL</td>                                                               
            </tr>
		   	<tr>
            	<td>short_url</td>
            	<td>string</td>
            	<td>Short URL including the domain name.</td>                                                               
            </tr>
		   	<tr>
            	<td>part_short_url</td>
            	<td>string</td>
            	<td>Short URL without the domain name.</td>                                                               
            </tr>
		   	<tr>
            	<td>original_url</td>
            	<td>string</td>
            	<td>Original long url</td>                                                               
            </tr>
		   	<tr>
            	<td>date_create</td>
            	<td>string</td>
            	<td>Date created. In the format dd.mm.YYYY hh:mm:ss</td>                                                               
            </tr>            
        </tbody>
    </table> 
    <h4><?php echo __('Example request');?></h4>
    <pre>
jQuery.noConflict()(function($){
    $(document).ready(function (e) {
        var url = 'http://<?php echo $_SERVER['HTTP_HOST']?>/api/v1/api.php';
        var url_long = '&lt;?php echo base64_encode("<?php echo "http://".$_SERVER['HTTP_HOST']?>");?&gt;';
        $.get
          (
             url,'api_key=e00cf25ad42683b3df678c61f42c6bda&url='+url_long,function(result,status)
                {
                    alert(result.data.url_id+'||'+
                            result.data.short_url+'||'+
                            result.data.part_short_url+'||'+
                            result.data.original_url+'||'+
                            result.data.date_create);		
                },
                "json"
        );
    });
});    
    </pre>
    <h4><?php echo __('Example response');?></h4>  
    <pre>
{
   "status":200,
   "data":{
      "url_id":"1",
      "short_url":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv",
      "part_short_url":"P87Ayv",
      "original_url":"<?php echo base64_decode(base64_encode("http://".$_SERVER['HTTP_HOST']))?>",
      "date_create":"<?php echo date("d.m.Y H:i:s",time())?>"
   }
}
    </pre>
    </div>
</div>
<div class="panel panel-default">
  <div class="panel-heading" id="disable"><?php echo __('Disable')?></div>
  <div class="panel-body">
  <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>api key</td>
            	<td>string</td>
            	<td>your api key</td>                                
            </tr>
		   	<tr>
            	<td>disable_url</td>
            	<td>string</td>
            	<td>Base64 encoded version of your short url. <code>base64_encode()</code> in PHP.</td>                                
            </tr>
        </tbody>
    </table>
    <h4><?php echo __('Return values');?></h4>
    <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>url_id</td>
            	<td>int</td>
            	<td>The unique id value of URL</td>                                                               
            </tr>
		   	<tr>
            	<td>short_url</td>
            	<td>string</td>
            	<td>Short URL including the domain name.</td>                                                               
            </tr>
		   	<tr>
            	<td>status</td>
            	<td>string</td>
            	<td>Short url status.</td>                                                               
            </tr>
		   	<tr>
            	<td>date_create</td>
            	<td>string</td>
            	<td>Date created. In the format dd.mm.YYYY hh:mm:ss</td>                                                               
            </tr>            
        </tbody>
    </table> 
    <h4><?php echo __('Example request');?></h4>
    <pre>
jQuery.noConflict()(function($){
    $(document).ready(function (e) {
        var url = 'http://<?php echo $_SERVER['HTTP_HOST']?>/api/v1/api.php';
        var url_short = '&lt;?php echo base64_encode("<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv");?&gt;';
        $.get
          (
             url,'api_key=e00cf25ad42683b3df678c61f42c6bda&disable_url='+url_short,function(result,status)
                {
                    alert(result.data.url_id+'||'+
                            result.data.status+'||'+
                            result.data.short_url+'||'+
                            result.data.date_create);		
                },
                "json"
        );
    });
});    
    </pre>
    <h4><?php echo __('Example response');?></h4>  
    <pre>
{
   "status":200,
   "data":{
      "url_id":"1",
      "status":"disabled",
      "short_url":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv",
      "date_create":"<?php echo date("d.m.Y H:i:s",time())?>"
   }
}
    </pre>
    </div>
</div>
<div class="panel  panel-default">
  <div class="panel-heading" id="activate"><?php echo __('Activate')?></div>
  <div class="panel-body">
   <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>api key</td>
            	<td>string</td>
            	<td>your api key</td>                                
            </tr>
		   	<tr>
            	<td>enable_url</td>
            	<td>string</td>
            	<td>Base64 encoded version of your short url. <code>base64_encode()</code> in PHP.</td>                                
            </tr>
        </tbody>
    </table>
    <h4><?php echo __('Return values');?></h4>
    <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>url_id</td>
            	<td>int</td>
            	<td>The unique id value of URL</td>                                                               
            </tr>
		   	<tr>
            	<td>short_url</td>
            	<td>string</td>
            	<td>Short URL including the domain name.</td>                                                               
            </tr>
		   	<tr>
            	<td>status</td>
            	<td>string</td>
            	<td>Short url status.</td>                                                               
            </tr>
		   	<tr>
            	<td>date_create</td>
            	<td>string</td>
            	<td>Date created. In the format dd.mm.YYYY hh:mm:ss</td>                                                               
            </tr>            
        </tbody>
    </table> 
    <h4><?php echo __('Example request');?></h4>
    <pre>
jQuery.noConflict()(function($){
    $(document).ready(function (e) {
        var url = 'http://<?php echo $_SERVER['HTTP_HOST']?>/api/v1/api.php';
        var url_short = '&lt;?php echo base64_encode("<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv");?&gt;';
        $.get
          (
             url,'api_key=e00cf25ad42683b3df678c61f42c6bda&enable_url='+url_short,function(result,status)
                {
                    alert(result.data.url_id+'||'+
                            result.data.status+'||'+
                            result.data.short_url+'||'+
                            result.data.date_create);		
                },
                "json"
        );
    });
});    
    </pre>
    <h4><?php echo __('Example response');?></h4>  
    <pre>
{
   "status":200,
   "data":{
      "url_id":"1",
      "status":"enable",
      "short_url":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv",
      "date_create":"<?php echo date("d.m.Y H:i:s",time())?>"
   }
}
    </pre>
    </div>
</div>
<div class="panel  panel-default">
  <div class="panel-heading" id="info"><?php echo __('Info')?></div>
  <div class="panel-body">
   <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>api key</td>
            	<td>string</td>
            	<td>your api key</td>                                
            </tr>
		   	<tr>
            	<td>enable_url</td>
            	<td>string</td>
            	<td>Base64 encoded version of your short url. <code>base64_encode()</code> in PHP.</td>                                
            </tr>
        </tbody>
    </table>
    <h4><?php echo __('Return values');?></h4>
    <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>url_id</td>
            	<td>int</td>
            	<td>The unique id value of URL</td>                                                               
            </tr>
        <tr>
            	<td>long_url</td>
            	<td>string</td>
            	<td>The original decoded long url.</td>                                                               
            </tr>
        <tr>
            	<td>short_url</td>
            	<td>string</td>
            	<td>Short url part. (excluding domain name)</td>                                                               
            </tr>
        <tr>
            	<td>create_time</td>
            	<td>string</td>
            	<td>Date created. In the format dd.mm.YYYY hh:mm:ss</td>                                                               
            </tr>
        <tr>
            	<td>clicks</td>
            	<td>int</td>
            	<td>Total visits</td>                                                               
            </tr>
        <tr>
            	<td>preview_img</td>
            	<td>string</td>
            	<td>Link on the preview image</td>                                                               
            </tr>
        <tr>
            	<td>qr_img</td>
            	<td>string</td>
            	<td>Link to image qr-code</td>                                                               
            </tr>
        <tr>
            	<td>favicon</td>
            	<td>string</td>
            	<td>Link to the favicon</td>                                                               
            </tr>
        <tr>
            	<td>status</td>
            	<td>string</td>
            	<td>Short url status.</td>                                                               
            </tr>
            <tr>
            	<td>password</td>
                <td>bool</td>
                <td>Whether the url needs a password to access.</td>
            </tr>
        </tbody>
    </table> 
    <h4><?php echo __('Example request');?></h4>
    <pre>
jQuery.noConflict()(function($){
    $(document).ready(function (e) {
        var url = 'http://<?php echo $_SERVER['HTTP_HOST']?>/api/v1/api.php';
        var url_short = '&lt;?php echo base64_encode("<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv");?&gt;';
        $.get
          (
             url,'api_key=e00cf25ad42683b3df678c61f42c6bda&info_url='+url_short,function(result,status)
                {
                    alert(result.data.url_id+"||\n"+
                        result.data.long_url+"||\n"+
                        result.data.short_url+"||\n"+
                        result.data.create_time+"||\n"+
                        result.data.clicks+"||\n"+
                        result.data.preview_img+"||\n"+
                        result.data.qr_img+"||\n"+
                        result.data.favicon+"||\n"+
                        result.data.status+"||\n"+
                        result.data.password);		
                },
                "json"
        );
    });
});    
    </pre>
    <h4><?php echo __('Example response');?></h4>  
    <pre>
{
   "status":200,
   "data":{
     "url_id":"1",
        "long_url":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>",
        "short_url":"P87Ayv",
        "create_time":"<?php echo date("d.m.Y H:i:s",time())?>",
        "clicks":"63",
        "preview_img":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/images/<?php echo $_SERVER['HTTP_HOST'];?>.png",
        "qr_img":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/qrcodes/P87Ayv.png",
        "favicon":"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/favicons/<?php echo $_SERVER['HTTP_HOST'];?>.ico",
        "status":"enable",
        "password":"true"
   }
}
    </pre>
    </div>
</div>
<div class="panel  panel-default">
  <div class="panel-heading" id="list"><?php echo __('List')?></div>
  <div class="panel-body">
  <h4><?php echo __('Parameters');?></h4>
  	<table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
        	<tr>
            	<td>api key</td>
            	<td>string</td>
            	<td>your api key</td>                                
            </tr>
        	<tr>
            	<td>list</td>
            	<td>boolean</td>
            	<td>true</td>                                
            </tr>            
        </tbody>
    </table>
    <h4><?php echo __('Return values');?></h4>
    <table class="table table-bordered">
    	<thead>
        	<tr>
    			<th class="col-2"><?php echo __('Name');?></th>
                <th class="col-2"><?php echo __('Type')?></th>
                <th class="col-6"><?php echo __('Description');?></th>
            </tr>
        </thead>
        <tbody>
		   	<tr>
            	<td>short_url</td>
            	<td>string</td>
            	<td>Short URL including the domain name.</td>                                                               
            </tr>         
        </tbody>
    </table> 
    <h4><?php echo __('Example request');?></h4>
    <pre>
jQuery.noConflict()(function($){
    $(document).ready(function (e) {
        var url = 'http://<?php echo $_SERVER['HTTP_HOST']?>/api/v1/api.php';
        $.get
          (
             url,'api_key=e00cf25ad42683b3df678c61f42c6bda&list_url=true',function(result,status)
                {
                    alert(result.data.short_url);		
                },
                "json"
        );
    });
});    
    </pre>
    <h4><?php echo __('Example response');?></h4>  
    <pre>
{
   "status":200,
   "data":{
      "short_url":{
      		"<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P87Ayv",
                "<?php echo "http://".$_SERVER['HTTP_HOST'];?>/sdw12v",
                "<?php echo "http://".$_SERVER['HTTP_HOST'];?>/P415av"
      		}
   }
}
    </pre>
    </div>
</div>
</div>
</div>