<?php
	header('content-type: image/jpeg');

	$header_sent = 1;

	require_once('../config.php');

	function resize($localImage,$new_width,$new_height) {

		$sData = getimagesize($localImage);

		$origType = $sData[2];
		$mimeType = $sData['mime'];

		$mimeType = str_replace('image/','',$mimeType);

		$quality = 90;

		if ($new_width == 0 && $new_height == 0) {
		    $new_width = 100;
		    $new_height = 100;
		}

		if($mimeType == 'jpeg') {
			$image = imagecreatefromjpeg ($localImage);
		}

		if($mimeType == 'png') {
			$image = imagecreatefrompng ($localImage);
		}

		if($mimeType == 'gif') {
			$image = imagecreatefromgif ($localImage);
		}

		$width = imagesx ($image);
		$height = imagesy ($image);
		$origin_x = 0;
		$origin_y = 0;

		if ($new_width && !$new_height) {
			$new_height = floor ($height * ($new_width / $width));
		} else if ($new_height && !$new_width) {
			$new_width = floor ($width * ($new_height / $height));
		}

		$canvas = imagecreatetruecolor ($new_width, $new_height);
		imagealphablending ($canvas, false);

		$src_x = $src_y = 0;
		$src_w = $width;
		$src_h = $height;

		$cmp_x = $width / $new_width;
		$cmp_y = $height / $new_height;

		if ($cmp_x > $cmp_y) {

			$src_w = round ($width / $cmp_x * $cmp_y);
			$src_x = round (($width - ($width / $cmp_x * $cmp_y)) / 2);

		} else if ($cmp_y > $cmp_x) {

			$src_h = round ($height / $cmp_y * $cmp_x);
			$src_y = round (($height - ($height / $cmp_y * $cmp_x)) / 2);

		}

		$src_y = 0;
		$src_x = 0;

		imagecopyresampled ($canvas, $image, $origin_x, $origin_y, $src_x, $src_y, $new_width, $new_height, $src_w, $src_h);

		imagejpeg($canvas); 
		imagedestroy($canvas);
		imagedestroy($image);

	}

	if(isset($_GET['id']) && is_numeric($_GET['id']) && isset($_GET['w']) && is_numeric($_GET['w']) && isset($_GET['h']) && is_numeric($_GET['h'])) {

		$id = mysqli_real_escape_string($db,$_GET['id']);
		
		$w = mysqli_real_escape_string($db,$_GET['w']);
		$h = mysqli_real_escape_string($db,$_GET['h']);

		$sql_54 = mysqli_query($db,"SELECT `id`,`pic` FROM `users` WHERE `id` = '".$id."' LIMIT 1");
		if(mysqli_num_rows($sql_54) == 0) {

			$picture = '../uploads/profiles/no_profile_pic.jpg';

		} else {

			$fetch_54 = mysqli_fetch_array($sql_54);

			if($fetch_54['pic'] == '') {
				$picture = '../uploads/profiles/no_profile_pic.jpg';
			} else {
				$picture = '../uploads/profiles/'.$fetch_54['pic'].'.jpg';
			}

		}

		resize($picture,$w,$h);

	}
?>