<?php
	
	require_once($folder.'/language/langs.php');
	require_once('mobile_detect.php');

	function redirect($url) {

		if(headers_sent()) {

			echo('<script>location.href = "'.$url.'";</script>');

		} else {

			header('location: '.$url);

		}

	}

	if(isset($_COOKIE['logged']) && is_numeric($_COOKIE['logged']) && isset($_COOKIE['logged_security'])) {
		if(!isset($_SESSION['logged_security'])) {
			$cookie_id = mysqli_real_escape_string($db,$_COOKIE['logged']);
			$sql_145 = mysqli_query($db,"SELECT `id`,`time` FROM `users` WHERE `id` = '".$cookie_id."' LIMIT 1");
			if(mysqli_num_rows($sql_145) == 0) {
				redirect('http://'.$_SERVER['HTTP_HOST'].'/inc/logout.php');
			} else {
				$fetch_145 = mysqli_fetch_array($sql_145);
				if(md5($fetch_145['time']) == mysqli_real_escape_string($db,$_COOKIE['logged_security'])) {
					$_SESSION['logged_security'] = $cookie_id;
				} else {
					redirect('http://'.$_SERVER['HTTP_HOST'].'/inc/logout.php');
				}
			}
		} else {
			if($_COOKIE['logged'] == $_SESSION['logged_security']) {
				$_SESSION['logged_security'] = $_COOKIE['logged'];
			} else {
				redirect('http://'.$_SERVER['HTTP_HOST'].'/inc/logout.php');
			}
		}
	}
		
	$sql_3 = mysqli_query($db,"SELECT * FROM `settings` WHERE `id` = '1' LIMIT 1");
	$fetch_3 = mysqli_fetch_array($sql_3);

	$video_size = explode('|',$fetch_3['video_size']);
	$video_size_w = $video_size[0];
	$video_size_h = $video_size[1];		
			
	$settings = array(
		'logo_text' => $fetch_3['logo'],
		'site_url' => get_current_host(),
		'fb_api' => $fetch_3['fb_api'],
		'analytics' => $fetch_3['analytics'],
		'terms_page' => stripslashes($fetch_3['terms_page']),
		'privacy_page' => stripslashes($fetch_3['privacy_page']),
		'about_page' => stripslashes($fetch_3['about_page']),
		'contact' => $fetch_3['contact'],
		'meta_1' => $fetch_3['meta_1'],
		'meta_2' => $fetch_3['meta_2'],
		'meta_3' => $fetch_3['meta_3'],
		'meta_4' => $fetch_3['meta_4'],
		'meta_5' => $fetch_3['meta_5'],
		'meta_6' => $fetch_3['meta_6'],
		'meta_7' => $fetch_3['meta_7'],
		'meta_8' => $fetch_3['meta_8'],
		'meta_9' => $fetch_3['meta_9'],
		'meta_10' => $fetch_3['meta_10'],
		'meta_11' => $fetch_3['meta_11'],
		'meta_12' => $fetch_3['meta_12'],
		'hashtags' => $fetch_3['hashtags'],
		'social_photos' => $fetch_3['social_photos'],
		'fullsize_photos' => $fetch_3['fullsize_photos'],
		'custom_1' => $fetch_3['custom_1'],
		'custom_2' => $fetch_3['custom_2'],
		'custom_3' => $fetch_3['custom_3'],
		'custom_4' => $fetch_3['custom_4'],
		'custom_5' => $fetch_3['custom_5'],
		'custom_6' => $fetch_3['custom_6'],
		'verified' => $fetch_3['verified'],
		'video' => $fetch_3['video'],
		'desc_links' => $fetch_3['desc_links'],
		'comments_links' => $fetch_3['comments_links'],
		'video_skin' => $fetch_3['video_skin'],
		'video_size_w' => $video_size_w,
		'video_size_h' => $video_size_h,
		'rating_system' => $fetch_3['rating_system'],
		'report_setting' => $fetch_3['report_setting'],
		'comments_icons' => $fetch_3['comments_icons'],
		'about_me' => $fetch_3['about_me'],
		'remove_comments' => $fetch_3['remove_comments'],
		'cookie_bar' => $fetch_3['cookie_bar'],
		'lang' => $fetch_3['lang'],
		'allow_lang' => $fetch_3['allow_lang']
	);

	if(!isset($_COOKIE['language'])) {
		require_once($folder.'/language/'.$settings['lang']);
	} else {
		require_once($folder.'/language/'.$_COOKIE['language']);
	}

	$detect = new Mobile_Detect;

	if($detect->isMobile()) {
		$mobile = 1;
	} else {
		$mobile = 0;
	}

	function get_current_page() {

		$explode = explode('/',$_SERVER['REQUEST_URI']);

		if($explode[1] == 'photos' || $explode[1] == 'videos' || $explode[1] == 'login' || $explode[1] == 'contact' || $explode[1] == 'join' || $explode[1] == 'lost-password' || $explode[1] == 'settings') {
			return 'index.php';
		} else {
			$strip_multi_slashes = str_replace(array('////','///','//'),array('/','/','/'),$_SERVER['REQUEST_URI']);
			if($explode[1] != 'videos' && $explode[1] != 'photos' && $explode[1] != 'settings') {
				return str_replace('/','',$strip_multi_slashes);
			} else {
				return $strip_multi_slashes;
			}
		}

	}

	function unique_id() {

		$string = microtime();
		$string = str_replace('0.','',trim($string));
		$string = str_replace(' ','',$string);
		return $string;
	
	}

	function strip_spam($string) {
		
		return htmlspecialchars(html_entity_decode(stripslashes(strip_tags($string)), ENT_QUOTES, 'UTF-8'), ENT_QUOTES, 'UTF-8');
		
	}

	function get_current_url() {

		$current_host = substr($_SERVER['HTTP_HOST'],0,7);

		if($current_host == 'http://') {
			$current_url_1 = '';
		} else {
			$current_url_1 = 'http://';
		}

		return $current_url_1.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];

	}

	function get_current_host() {

		$current_host = substr($_SERVER['HTTP_HOST'],0,7);

		if($current_host == 'http://') {
			$current_url_2 = '';
		} else {
			$current_url_2 = 'http://';
		}
	
		return $current_url_2.$_SERVER['HTTP_HOST'];

	}

	function create_hashtags($desc){
	
		$regex = '/#+([a-zA-Z0-9_]+)/';
		$desc = preg_replace($regex, '<a href="'.get_current_host().'/hashtags/$1">$0</a>', $desc);
	
		return($desc);

	}

	function create_links($text) {

		$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";

		if(preg_match($reg_exUrl, $text, $url)) {
       			return preg_replace($reg_exUrl, '<a href="'.$url[0].'" target="_blank">'.$url[0].'</a> ', $text);
		} else {
			return $text;
		}

	}

	function get_form($type) {

		if($type == 'upload_cover') {

			return '
			<form id="upload_cover" method="post" enctype="multipart/form-data" action="inc/upload_cover.php">
				<input name="file" type="file" id="cover"/>
				<input name="cover_id" id="cover_id" type="hidden" />
			</form>';

		}

		if($type == 'upload_profile_pic') {

			return '
			<form id="upload_profile_pic" method="post" enctype="multipart/form-data" action="inc/upload_profile_pic.php">
				<input name="file" type="file" id="profile_pic"/>
			</form>';

		}

	}

	function safe_string($string) {

		global $db;

		$string = mysqli_real_escape_string($db,strip_tags(stripslashes($string)));
		
		return $string;
	
	}

	function str_to_k($string) {

		if($string < 1000) {
			return $string;
		} else {
			if($string < 10000) {
				return substr($string,0,1).'k';
			} else {
				if($string < 100000) {
					return substr($string,0,2).'k';
				} else {
					if($string < 1000000) {
						return substr($string,0,3).'k';
					} else {
						if($string < 10000000) {
							return substr($string,0,1).'m';
						} else {
							if($string < 100000000) {
								return substr($string,0,2).'m';
							} else {
								if($string < 1000000000) {
									return substr($string,0,3).'m';
								} else {
									if($string < 10000000000) {
										return substr($string,0,1).'b';
									} else {
										return substr($string,0,2).'b';
									}
								}
							}
						}
					}
				}
			}
		}

	}

    	function objectToArray( $object ) {
        
		if( !is_object( $object ) && !is_array( $object ) ) {
            		return $object;
        	}
        	if( is_object( $object ) ) {
            		$object = get_object_vars( $object );
        	}
        	
		return array_map( 'objectToArray', $object );
   
	}

	function subval_sort($a,$subkey) {
       
		if(count($a) > 0) {

		foreach($a as $k=>$v) {
            		$b[$k] = strtolower($v[$subkey]);
        	}
        
		asort($b);

        	foreach($b as $key=>$val) {
            		$c[] = $a[$key];
        	}
        
		return $c;

		}
    	
	}

	function unique_username($name,$email) {

		global $db;

		$generated_username = '';

		if(isset($email) && $email != '' && $email != 'test') {
			
			$user_split = explode('@',$email);

			if(check_username($user_split[0]) == 1) {
	
				$generated_username = $user_split[0];

			} else {

				$user_split_2 = $user_split[0].'1';

				if(check_username($user_split_2) == 1) {

					$generated_username = $user_split_2;

				}

			}

		} else {

			$name = ltrim($name);
			$name = rtrim($name);
			$name = strtolower($name);
			$name = str_replace('.',' ',$name);
		
			if(check_username($name) == 1) {

				$generated_username = $name;

			} else {

				$name_2 = $name.'1';
				
				if(check_username($name_2) == 1) {

					$generated_username = $name_2;

				} else {

					$name_3 = $name.'2';

					if(check_username($name_3) == 1) {
			
						$generated_username = $name_3;

					} else {

						$name_4 = $name.'3';
		
						if(check_username($name_4) == 1) {

							$generated_username = $name_4;

						}

					}

				}

			}

		}

		if($generated_username == '' || $generated_username == 'cpanel' || $generated_username == 'privacy.html' || $generated_username == 'about.html' || $generated_username == 'index.php' || $generated_username == 'footer.php' || $generated_username == 'thumbs.php' || $generated_username == '.htaccess' || $generated_username == 'config.php' || $generated_username == 'settings' || $generated_username == 'photos' || $generated_username == 'hashtag' || $generated_username == 'language' || $generated_username == 'cp' || $generated_username == 'css' || $generated_username == 'assets' || $generated_username == 'uploads' || $generated_username == 'cache' || $generated_username == 'phpmyadmin' || $generated_username == 'inc' || $generated_username == 'layout' || $generated_username == 'layout_m') {

			$generated_username = time();

		}

		return $generated_username;

	}

	function check_username($username)  {
		
		global $db;
    
		if(preg_match('/^[a-zA-Z0-9.]+$/',$username) && strlen($username) > 1) {
	
			$sql_68 = mysqli_query($db,"SELECT `user` FROM `users` WHERE `user` = '".$username."' LIMIT 1");
			if(mysqli_num_rows($sql_68) == 0) {
				return 1;
			} else {
				return 0;
			}

		} else {

			return 0;

		}

	}

	function get_birthmonth() {

		global $lang;

		$return = '';

		for($birthmonth = 1; $birthmonth <=12; $birthmonth++) {

			if($_COOKIE['logged_born'] != 0) {
			
				$birthmonth_present = date('n',$_COOKIE['logged_born']);
								
				if($birthmonth_present == $birthmonth) {
					$birthmonth_selected = ' selected';
				} else {
					$birthmonth_selected = '';
				}
									
			} else {
			
				$birthmonth_selected = '';
			
			}

			$return.='<option value="'.$birthmonth.'"'.$birthmonth_selected.'>'.$lang['birthmonth_'.$birthmonth].'</option>';

		}

		return $return;
								

	}

	function get_gender() {

		global $lang;

		$return = '';
		$male_selected = '';
		$female_selected = '';

		if(isset($_COOKIE['logged_gender']) && is_numeric($_COOKIE['logged_gender'])) {
			if($_COOKIE['logged_gender'] == 1) {
				$female_selected = ' selected';
			} else {
				$male_selected = ' selected';
			}
		}

		$return = '
		<option value="1"'.$female_selected.'>'.$lang['join_gender_f'].'</option>
		<option value="2"'.$male_selected.'>'.$lang['join_gender_m'].'</option>';

		return $return;

	}

	function validate_url($url) {

		if(in_array(parse_url($url, PHP_URL_SCHEME),array('http','https'))) {
    		
			if(filter_var($url, FILTER_VALIDATE_URL) !== false) {
        			
				return 1;

    			} else {
       
				return 0;

    			}

		} else {
    		
			return 0;

		}

	}

	function get_birthday() {

		$return = '';

		for($birthday = 1; $birthday <=31; $birthday++) {

			if($_COOKIE['logged_born'] != 0) {
			
				$birthday_present = date('j',$_COOKIE['logged_born']);
										
				if($birthday_present == $birthday) {
					$birthday_selected = ' selected';
				} else {
					$birthday_selected = '';
				}
								
			} else {
				
				$birthday_selected = '';
				
			}

			if($birthday < 10) { $birthday = '0'.$birthday; }
				
			$return.='<option value="'.$birthday.'"'.$birthday_selected.'>'.$birthday.'</option>';

		}

		return $return;				

	}

	function get_birthyear() {

		$return = '';

		for($birthyear = 1950; $birthyear <=2000; $birthyear++) {

			if($_COOKIE['logged_born'] != 0) {
			
				$birthyear_present = date('Y',$_COOKIE['logged_born']);
										
				if($birthyear_present == $birthyear) {
					$birthyear_selected = ' selected';
				} else {
					$birthyear_selected = '';
				}

			} else {

				$birthyear_selected = '';

			}
									
			$return.='<option value="'.$birthyear.'"'.$birthyear_selected.'>'.$birthyear.'</option>';
								

		}
								
		return $return;

	}

	function email_exists($email) {

		global $db;

		$sql_66 = mysqli_query($db,"SELECT `email` FROM `users` WHERE `email` = '".$email."' LIMIT 1");
		return mysqli_num_rows($sql_66);
	
	}

	function check_lostpw($key) {

		global $db;

		$sql_67 = mysqli_query($db,"SELECT `email`,`key`,`password` FROM `temp` WHERE `key` = '".$key."' LIMIT 1");
		if(mysqli_num_rows($sql_67) == 0) {

			return 0;

		} else {

			$fetch_67 = mysqli_fetch_array($sql_67);
			mysqli_query($db,"UPDATE `users` SET `password` = '".$fetch_67['password']."' WHERE `email` = '".$fetch_67['email']."' LIMIT 1");
			mysqli_query($db,"DELETE FROM `temp` WHERE `key` = '".$fetch_67['key']."' LIMIT 1");
			return 1;

		}
	
	}

	function check_verifykey($key) {

		global $db;

		$explode = explode(',',$key);

		$sql_67 = mysqli_query($db,"SELECT `email`,`id` FROM `users` WHERE `id` = '".$explode[1]."' LIMIT 1");
		if(mysqli_num_rows($sql_67) > 0) {

			$fetch_67 = mysqli_fetch_array($sql_67);

			$new_key = md5($fetch_67['id'].$fetch_67['email']);
			if($new_key == $explode[0]) {

				mysqli_query($db,"UPDATE `users` SET `verified` = '1' WHERE `id` = '".$fetch_67['id']."' LIMIT 1");
				return 1;

			} else {

				return 0;

			}

		} else {

			return 0;

		}
	
	}

	function count_users() {

		global $db;

		$sql_44 = mysqli_query($db,"SELECT `id` FROM `users`");
		return mysqli_num_rows($sql_44);

	}

	function check_rate($pid) {

		global $db;

		$ip = $_SERVER['REMOTE_ADDR'];

		$check_ip = mysqli_query($db,"SELECT `from`,`to` FROM `ratings` WHERE `from` = '".$ip."' AND `to` = '".$pid."' LIMIT 1");
		if(mysqli_num_rows($check_ip) == 0) {

			return 1;
	
		} else {

			return 0;

		}

	}

	function set_rate($pid,$id) {

		global $db;

		$ip = $_SERVER['REMOTE_ADDR'];

		$check_ip = mysqli_query($db,"SELECT `from`,`to` FROM `ratings` WHERE `from` = '".$ip."' AND `to` = '".$pid."' LIMIT 1");
		if(mysqli_num_rows($check_ip) == 0) {
	
			$sql_13 = mysqli_query($db,"SELECT `id`,`ratings`,`votes` FROM `photos` WHERE `url` = '".$pid."' LIMIT 1");
			$fetch_13 = mysqli_fetch_array($sql_13);

			if($fetch_13['ratings']=='') {
				$new_rating = $id;
				$new_ratings = $id;
			} else {
				$new_ratings = $fetch_13['ratings'].'|'.$id;
				$ratings = array_sum(explode('|',$new_ratings)) / ($fetch_13['votes']+1);
				$new_rating = substr($ratings,0,4);
			}

			if(is_numeric($new_rating) && $new_rating <= 10) {
				$voted = 1;
				mysqli_query($db,"UPDATE `photos` SET `votes` = '".($fetch_13['votes']+1)."', `ratings` = '".$new_ratings."', `score` = '".$new_rating."' WHERE `url` = '".$pid."' LIMIT 1");
			} else {
				$voted = 0;
			}

			$votes = $fetch_13['votes']+1;

			$note_back = $new_rating;
		
			if(strlen($note_back)==1) {
				$the_back = $note_back.'.0';
			} else {
				if(strlen($note_back) > 4) {
					$the_back = substr($note_back,0,4);
				} else {
					$the_back = $note_back;
				}
			}

			mysqli_query($db,"INSERT INTO `ratings` (`from`,`to`,`time`) VALUES ('".$ip."','".$pid."','".(time()+86400)."')");

		} else {
			$voted = 0;
			$the_back = 0;
			$votes = ' ';
		}

		return $voted.'|'.$the_back.'|'.$votes;		

	}

	function set_like($pid,$status) {

		global $db;

		$ip = $_SERVER['REMOTE_ADDR'];

		$sql_13 = mysqli_query($db,"SELECT `id`,`votes` FROM `photos` WHERE `url` = '".$pid."' LIMIT 1");
		$fetch_13 = mysqli_fetch_array($sql_13);

		if($status == 1) {
			mysqli_query($db,"UPDATE `photos` SET `votes` = '".($fetch_13['votes']+1)."' WHERE `url` = '".$pid."' LIMIT 1");
			mysqli_query($db,"INSERT INTO `ratings` (`from`,`to`,`time`) VALUES ('".$ip."','".$pid."','".(time()+86400)."')");
		} else {
			mysqli_query($db,"UPDATE `photos` SET `votes` = '".($fetch_13['votes']-1)."' WHERE `url` = '".$pid."' LIMIT 1");
			mysqli_query($db,"DELETE FROM `ratings` WHERE `from` = '".$ip."' AND `to` = '".$pid."' ORDER BY `id` LIMIT 1");
		}

		return 1;	

	}

	function timeAgo($time,$ago=0) {

		global $lang;

   		$time_sent = time() - $time;

		$text_single = array($lang['timeago_few_seconds'],$lang['timeago_minute'],$lang['timeago_hour'],$lang['timeago_day'],$lang['timeago_week'],$lang['timeago_month'],$lang['timeago_year']);
		$text_multi = array($lang['timeago_few_seconds'],$lang['timeago_minutes'],$lang['timeago_hours'],$lang['timeago_days'],$lang['timeago_weeks'],$lang['timeago_months'],$lang['timeago_years']);

		$current = 0;

		if($time_sent < 315705600) {

			$returned_time = floor($time_sent / 31570560);
			if($returned_time == 1) { $returned_text = $text_single[6]; } else { $returned_text = $text_multi[6]; }
			$current = 6;

		}

		if($time_sent < 31570560) {

			$returned_time = floor($time_sent / 2630880);
			if($returned_time == 1) { $returned_text = $text_single[5]; } else { $returned_text = $text_multi[5]; }
			$current = 5;

		}

		if($time_sent < 2630880) {

			$returned_time = floor($time_sent / 604800);
			if($returned_time == 1) { $returned_text = $text_single[4]; } else { $returned_text = $text_multi[4]; }
			$current = 4;

		}

		if($time_sent < 604800) {

			$returned_time = floor($time_sent / 86400);
			if($returned_time == 1) { $returned_text = $text_single[3]; } else { $returned_text = $text_multi[3]; }
			$current = 3;

		}

		if($time_sent < 86400) {

			$returned_time = floor($time_sent / 3600);
			if($returned_time == 1) { $returned_text = $text_single[2]; } else { $returned_text = $text_multi[2]; }
			$current = 2;

		}

		if($time_sent < 3600) {

			$returned_time = floor($time_sent / 60);
			if($returned_time == 1) { $returned_text = $text_single[1]; } else { $returned_text = $text_multi[1]; }
			$current = 1;

		}

		if($time_sent < 61) {

			$returned_time = floor($time_sent / 1);
			if($returned_time == 1) { $returned_text = $text_single[0]; } else { $returned_text = $text_multi[0]; }
			$current = 0;

		}

		if($current != 0) {
			$return = $returned_time.' '.$returned_text;
		} else {
			$return = $lang['timeago_few_seconds'];
		}

		if($ago == 0) {
			return str_replace('%',$return,$lang['timeago']);
		} else {
			return $return;
		}

	}

	function get_photos_nr($id) {

		global $db;

		$sql_25 = mysqli_query($db,"SELECT `uid` FROM `photos` WHERE `uid` = '".$id."'");
		return mysqli_num_rows($sql_25);

	}

	function add_follower($fid) {

		global $db, $user_id;

		$sql_58 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `id` = '".$fid."' LIMIT 1");
		$fetch_58 = mysqli_fetch_array($sql_58);

		if($fetch_58['followers'] == '' || $fetch_58['followers'] == '[]') {
			$followers = array();
		} else {
			$followers = objectToArray(json_decode($fetch_58['followers']));
		}

		$followers[] = '+'.$user_id.'+';

		if(mysqli_query($db,"UPDATE `users` SET `followers` = '".json_encode($followers)."' WHERE `id` = '".$fid."' LIMIT 1")) {
			return 1;
		} else {
			return 0;
		}

	}

	function remove_follower($fid) {

		global $db, $user_id;

		$sql_59 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `id` = '".$fid."' AND `followers` LIKE '%+".$user_id."+%' LIMIT 1");
		if(mysqli_num_rows($sql_59) == 0) {

			return 0;

		} else {

			$fetch_59 = mysqli_fetch_array($sql_59);
			$followers = objectToArray(json_decode($fetch_59['followers']));

			$key = array_search('+'.$user_id.'+', $followers);
			unset($followers[$key]);

			$followers_2 = array_values($followers);

			if(mysqli_query($db,"UPDATE `users` SET `followers` = '".json_encode($followers_2)."' WHERE `id` = '".$fid."' LIMIT 1")) {
				return 1;
			} else {
				return 0;
			}

		}

	}

	function remove_follower_cp($fid) {

		global $db;

		$sql_59 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `followers` LIKE '%+".$fid."+%'");
		if(mysqli_num_rows($sql_59) == 0) {

			return 0;

		} else {

			$fetch_59 = mysqli_fetch_array($sql_59);
			$followers = objectToArray(json_decode($fetch_59['followers']));

			$key = array_search('+'.$fid.'+', $followers);
			unset($followers[$key]);

			$followers_2 = array_values($followers);

			if(mysqli_query($db,"UPDATE `users` SET `followers` = '".json_encode($followers_2)."' WHERE `id` = '".$fetch_59['id']."' LIMIT 1")) {
				return 1;
			} else {
				return 0;
			}

		}

	}

	function my_json_encode($arr) {
        	
		array_walk_recursive($arr, function (&$item, $key) {
			if (is_string($item)) $item = mb_encode_numericentity($item, array (0x80, 0xffff, 0, 0xffff), 'UTF-8');
		});
        
		return mb_decode_numericentity(json_encode($arr), array (0x80, 0xffff, 0, 0xffff), 'UTF-8');

	}	

	function load_user($id) {

		global $db, $lang;

		$sql_21 = mysqli_query($db,"SELECT `id`,`user`,`about_me`,`verified`,`social`,`born`,`gender`,`location`,`seen`,`time`,`followers`,`cover`,`pic`,`name` FROM `users` WHERE `user` = '".$id."' LIMIT 1");
		$fetch_21 = mysqli_fetch_array($sql_21);

		$info = array();
		$info['username'] = $fetch_21['user'];
		$info['id'] = $fetch_21['id'];
		$info['cover'] = $fetch_21['cover'];
		$info['pic'] = $fetch_21['pic'];
		$info['name'] = strip_spam($fetch_21['name']);
		$info['user'] = $fetch_21['user'];
		$info['verified'] = $fetch_21['verified'];
		$info['about_me'] = $fetch_21['about_me'];
		
		$info['since'] = timeAgo($fetch_21['time']);

		if($fetch_21['followers'] == '' || $fetch_21['followers'] == '[]') {
			$info['followers'] = 0;
		} else {
			$followers = array_unique(objectToArray(json_decode($fetch_21['followers'])));
			$info['followers'] = str_to_k(count($followers));
		}

		$social = objectToArray(json_decode($fetch_21['social']));
		$location = objectToArray(json_decode($fetch_21['location']));

		$info['social'] = array();
		if(isset($social['facebook']) && $social['facebook'] != '') { $info['social']['facebook'] = '<a href="'.$social['facebook'].'" target="_blank">Facebook profile</a>'; }
		if(isset($social['twitter']) && $social['twitter'] != '') { $info['social']['twitter'] = '<a href="'.$social['twitter'].'" target="_blank">Twitter profile</a>'; }
		if(isset($social['google']) && $social['google'] != '') { $info['social']['google'] = '<a href="'.$social['google'].'" target="_blank">Google+ profile</a>'; }
		if(isset($social['pinterest']) && $social['pinterest'] != '') { $info['social']['pinterest'] = '<a href="'.$social['pinterest'].'" target="_blank">Pinterest profile</a>'; }

		$info['location'] = array();
		if(isset($location['city']) && $location['city']!='') { $info['location']['city'] = strip_spam($location['city']); } else { $info['location']['city'] = '--'; }
		if(isset($location['country']) && $location['country']!='') { $info['location']['country'] = strip_spam($location['country']); } else { $info['location']['country'] = '--'; }
		
		if($fetch_21['seen'] == 0) { $info['seen'] = '--'; } else { $info['seen'] = timeAgo($fetch_21['seen']); }
		if($fetch_21['born'] == 0) { $info['born'] = '--'; } else { $info['born'] = date('j',$fetch_21['born']).' '.$lang['birthmonth_'.date('n',$fetch_21['born'])].' '.date('Y',$fetch_21['born']); }

		if($fetch_21['gender'] == 1) { $info['gender'] = $lang['join_gender_f']; } else { $info['gender'] = $lang['join_gender_m']; }

		$info['covers'] = array();

		if($info['cover'] != '' || $info['cover'] != '[]') {

			$covers = objectToArray(json_decode($info['cover']));

			for($i=0;$i<=count($covers)-1;$i++) {

				$info['covers'][] = $covers[$i];

			}
		}

		return $info;

	}		

	function follow_button($id,$page = 'none') {

		global $db, $user_id, $lang;

		if($page == 'user') {
			$class = ' user_side';
		} else {
			$class = '';
		}


		$sql_59 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `id` = '".$id."' LIMIT 1");
		$fetch_59 = mysqli_fetch_array($sql_59);

		if($fetch_59['followers'] == '' || $fetch_59['followers'] == '[]') {
			$follows_count = 0;
		} else {
			$follows = array_unique(objectToArray(json_decode($fetch_59['followers'])));
			$follows_count = count($follows);
		}

		if(is_numeric($user_id)) {

			if($user_id != $id) {

				$sql_28 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `id` = '".$id."' AND `followers` LIKE '%+".$user_id."+%' LIMIT 1");
				if(mysqli_num_rows($sql_28) > 0) {
					return '<div class="unfollow'.$class.'" data-uid="'.$id.'"><div class="follows_op">'.$lang['unfollow'].'</div><div class="follows_count">'.str_to_k($follows_count).'</div></div>';
				} else {
					return '<div class="follow'.$class.'" data-uid="'.$id.'"><div class="follows_op">'.$lang['follow'].'</div><div class="follows_count">'.str_to_k($follows_count).'</div></div>';
				}

			}

		} else {

			return '<div class="follow'.$class.'" data-uid="'.$id.'"><div class="follows_op">'.$lang['follow'].'</div><div class="follows_count">'.str_to_k($follows_count).'</div></div>';

		}

	}

	function message_button($id) {

		global $db, $lang, $user_id;

		if($user_id != $id) {

			return '<div class="message user_side" id="chat_'.$id.'">'.$lang['user_message'].'</div>';

		}

	}

	function get_followers($type='1') {

		global $db, $user_id;

		$follows = array();

		$sql_30 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `id` = '".$user_id."'");
		while($fetch_30 = mysqli_fetch_array($sql_30)) {

			$followers = objectToArray(json_decode($fetch_30['followers']));

			if(Count($followers) == 1) {
				$follows[] = str_replace('+','',$followers[0]);
			} else {

				if($type == 0) {
				
					for($i=0;$i<=count($followers)-1;$i++) {

						if(isset($followers[$i]) && $followers[$i] != '') {
							$follows[] = str_replace('+','',$followers[$i]);
						}

					}

				}

			}

		}

		if($type == 0) {
			return $follows;
		} else {
			return $followers;
		}

	}

	function get_following($type='1') {

		global $db, $user_id;

		$follows = array();

		$sql_30 = mysqli_query($db,"SELECT `id`,`followers` FROM `users` WHERE `followers` LIKE '%+".$user_id."+%'");
		while($fetch_30 = mysqli_fetch_array($sql_30)) {

			$follows[] = $fetch_30['id'];

		}

		return $follows;

	}

	function following_count($fid) {

		global $db, $user_id;

		$sql_64 = mysqli_query($db,"SELECT `followers` FROM `users` WHERE `followers` LIKE '%+".$fid."+%'");
		return mysqli_num_rows($sql_64);

	}

	function add_activity($type,$uid,$content='',$content_id='') {

		global $db, $user_id;

		// Rate photo

		if($type == 1) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`content`,`content_id`,`date`) VALUES ('1','".$uid."','".$_COOKIE['logged']."','".$content."','".$content_id."','".time()."')");

		}

		// New comment

		if($type == 2) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`content`,`content_id`,`date`) VALUES ('2','".$uid."','".$_COOKIE['logged']."','".$content."','".$content_id."','".time()."')");

		}

		// Follow

		if($type == 3) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`date`) VALUES ('3','".$uid."','".$_COOKIE['logged']."','".time()."')");

		}

		// Unfollow

		if($type == 4) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`date`) VALUES ('4','".$uid."','".$_COOKIE['logged']."','".time()."')");

		}

		// Register date

		if($type == 5) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`date`) VALUES ('5','".$uid."','".$uid."','".time()."')");

		}

		// Like

		if($type == 6) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`content`,`content_id`,`date`) VALUES ('6','".$uid."','".$_COOKIE['logged']."','".$content."','".$content_id."','".time()."')");

		}

		// Unlike

		if($type == 7) {

			mysqli_query($db,"INSERT INTO `activity` (`type`,`uid`,`aid`,`content`,`content_id`,`date`) VALUES ('7','".$uid."','".$_COOKIE['logged']."','".$content."','".$content_id."','".time()."')");

		}

	}

	function send_mail($to, $subject, $message, $fromemail) {
				
		global $db;

		$sql_3 = mysqli_query($db,"SELECT * FROM `settings` WHERE `id` = '1' LIMIT 1");
		$fetch_3 = mysqli_fetch_array($sql_3);

		if($fromemail == 'owner') { $fromemail = $fetch_3['contact']; }

		$from = $fetch_3['logo'];
		$reply = $fromemail;

		$message = str_replace('\n\n\n','<br><br><br>',$message);
		$message = str_replace('\n\n','<br><br>',$message);
		$message = str_replace('\n','<br>',$message);

		$header = "";
		$header .= "Reply-To: Support <$reply>\r\n"; 
    		$header .= "Return-Path: Support <$reply>\r\n"; 
    		$header .= "From: $from <$fromemail>\r\n"; 
    		$header .= "Organization: ".$fetch_3["logo"]."\r\n"; 
   		$header .= "Content-Type: text/html\r\n"; 
 
		if($to == 'owner') { $to = $fetch_3['contact']; }
		if(mail($to, $subject, $message, $header)) {
			return true;
		} else {
			return false;
		}

	}

	function send_verify($email) {

		global $db;

		$sql = mysqli_query($db,"SELECT `email`,`id` FROM `users` WHERE `id` = '".$_COOKIE['logged']."' LIMIT 1");
		$fetch = mysqli_fetch_array($sql);

		$key = md5($fetch['id'].$fetch['email']).','.$fetch['id'];

		if(send_mail($fetch['email'], 'Confirm e-mail', 'Hey,<br /><br /> Your account will be confirmed only if you click link below<br /><br /><a href="'.get_current_host().'/verify/'.$key.'">Confirm e-mail</a><br /><br />If this was not for you just ignore it', 'owner')) {

			return 1;

		} else {

			return 2; 
	
		}

	}

	function send_recover($email) {

		global $db;

		$key = md5(time() * rand(1000,9999999));
		$password = substr(md5(time() * rand(999,999999)),0,6);

		if(mysqli_query($db,"INSERT INTO `temp` (`email`,`key`,`password`) VALUES ('".$email."','".$key."','".$password."')")) {

			if(send_mail($email, 'Password recover', 'Hey,<br /><br />Your new password: <b>'.$password.'</b><br /><br /> Your password will be reseted only if you click link below<br /><br /><a href="'.get_current_host().'/lostpw/'.$key.'">Reset password</a><br /><br />If this was not for you just ignore it', 'owner')) {

				return 1;

			} else {

				return 2; 
	
			}

		} else {

			return 2;

		}

	}

	function login_cp($login,$pass) {

		global $db;

		$sql_71 = mysqli_query($db,"SELECT * FROM `cp` WHERE `login` = '".$login."' AND `pass` = '".$pass."' LIMIT 1");
		if(mysqli_num_rows($sql_71) == 1) {
			return 1;
		} else {
			return 0;
		}

	}

	function send_contact($email,$message) {

		$subject = 'Contact';

		if(send_mail('owner',$subject, $message, $email)) {

			return 1;

		} else {

			return 2; 
	
		}

	}

	function image_fix_orientation($filename) {
    
		if (function_exists('exif_read_data')) {

			$exif = exif_read_data($filename);
    
			if (!empty($exif['Orientation'])) {
       
				$image = imagecreatefromjpeg($filename);		
				switch ($exif['Orientation']) {
            				case 3:
                				$image = imagerotate($image, 180, 0);
                			break;

            				case 6:
                				$image = imagerotate($image, -90, 0);
                			break;

            				case 8:
                				$image = imagerotate($image, 90, 0);
                			break;
        			}

        			imagejpeg($image, $filename, 90);

			}

    		}

	}
?>