<?php
// Display total average ratings
function wrap_rating_form_total( $atts, $ajax ) {

	$args = array();
	$content = '';

	global $post;
	global $wpdb;

	// Attributes
	$args = shortcode_atts(
		array(
			'id' => '0',
			'post_id' => '',
			'comment_id' => '',
			'custom_id' => '0',
			'user_id' => '',
			'term_id' => '',
			'round' => '1',
			'live' => 'true',
			'type' => 'star',
			'type_count' => 'count',
			'text' => '',
			'form' => 'false',
			'class' => '',
			'html' => 'true',
			'custom_id_group' => '0'
		), $atts );

	$args['id'] = intval($args['id']);
	$args['post_id'] = intval($args['post_id']);
	$args['comment_id'] = empty($args['comment_id']) ? 0 : intval($args['comment_id']);
	$args['custom_id'] = Rating_Form_API::convertFieldIDArray($args['custom_id']);
	$args['user_id'] = empty($args['user_id']) ? 0 : intval($args['user_id']);
	$args['term_id'] = empty($args['term_id']) ? 0 : intval($args['term_id']);
	$args['round'] = intval($args['round']);
	$args['live'] = $args['live'] == 'true' ? true : false;
	$args['form'] = $args['form'] == 'true' ? true : false;
	$args['class'] = empty($args['class']) ? '' : ' ' . $args['class'];
	$args['custom_id_group'] = empty($args['custom_id_group']) ? '0' : strtolower($args['custom_id_group']);

	if (empty($args['post_id'])) {
		if (isset($post)) {
			$args['post_id'] = $post->ID;
		}
	}

	if ( is_admin() && ( !defined( 'DOING_AJAX' ) || !DOING_AJAX ) ) {
		$args['post_id'] = 1;
	}

	// Get current comment ID
	if (have_comments() && in_the_loop() && empty($args['comment_id'])) {
		$args['comment_id'] = get_comment_ID();
	}

	// Rating Form Settings
	$this_form_query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = '" . $args['id'] . "'", ARRAY_A );
	$this_form_num = $wpdb->num_rows;
	// Default settings if args ID is empty
	$jsonDisplay = empty($this_form_query['display']) ? array() : json_decode($this_form_query['display'], true);
	$max = empty($jsonDisplay['max']) ? 5 : intval($jsonDisplay['max']);
	$round = empty($jsonDisplay['round']) ? 1 : intval($jsonDisplay['round']);
	$rtl = in_array("rtl", $jsonDisplay) ? true : false;
	$display_empty = in_array("empty", $jsonDisplay) ? '-empty' : '';
	$display_half = '-half hover';
	$args['type'] = $this_form_num > 0 ? Rating_Form_Setup::form_types($this_form_query['type'], 'type') : $args['type'];

	// Total average rating
	// Check if post id exist in WP
	$postQuery = $wpdb->get_row( "SELECT * FROM " . $wpdb->posts . " WHERE ID = '".$args['post_id']."'", ARRAY_A );
	$postExists = ($wpdb->num_rows > 0);

	if (!$postExists && !is_admin() && (empty($args['term_id']) || empty($args['user_id']))) {

		if (empty($args['post_id'])) {
			$content .= __( 'Post ID is empty', 'rating-form' );
		} else {
			$content .= sprintf( __( 'Post ID %d not found', 'rating-form' ), $args['post_id'] );
		}

	} else {

		// Args to SQL
		if (count($args['custom_id']) > 1) {
			$sql_custom_id = "custom_id IN('" . implode("','", $args['custom_id']) . "')";
		} else {
			$sql_custom_id = "custom_id = '" . $args['custom_id'] . "'";
		}

		// Average rating of all custom ids
		if ($args['custom_id'] == "all") {
			$sql_custom_id = "custom_id != '0'";
		}

		// Args to SQL
		$args_id_sql = "comment_id = " . $args['comment_id'] .
						" AND " . $sql_custom_id .
						" AND user_id = " . $args['user_id'] .
						" AND term_id = " . $args['term_id'];

		// Rating Form Total #ID
		$divRFid = 'RFTO' . Rating_Form_API::getDivID($args);

		//begin ajax
		if ($ajax == false) $content .= '<div data-rf-id="'.$divRFid.'" class="' . $args['class'] . '">'."\r\n";

		if ($args['live']) {
			$content .= '<script type="text/javascript">'."\r\n";
			$content .= 'function ' . $divRFid . '(){'."\r\n";
				$content .= 'jQuery.ajax({'."\r\n";
					$content .= 'type: "POST",'."\r\n";
					$content .= 'url : rating_form_script.ajaxurl,'."\r\n";
					$content .= 'data : { '."\r\n";
					$content .= 'action : "display_rating_form_total_ajax", '."\r\n";
					$content .= 'args : ' . json_encode($args) . "\r\n";
					$content .= '}, '."\r\n";
					$content .= 'success : function(data) { jQuery("body").find("[data-rf-id=' . $divRFid . ']").html(data) }'."\r\n";
				$content .= '});'."\r\n";
			$content .= '}'."\r\n";
			$content .= '</script>'."\r\n";
		}

		$content .= '<span>';

		// Get ratings
		$ratingData = Rating_Form_API::getData($args);
		if (trim($args['type']) == 'tud') {
			$total_tud_query_up = $wpdb->get_row( "SELECT COUNT(*) AS avgTotal FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated = '1u' AND post_id = '" . $args['post_id'] . "' AND ". $args_id_sql, ARRAY_A );
			$total_tud_query_down = $wpdb->get_row( "SELECT COUNT(*) AS avgTotal FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated = '1d' AND post_id = '" . $args['post_id'] . "' AND ". $args_id_sql, ARRAY_A );
			$total_tud_query_total = $wpdb->get_row( "SELECT COUNT(*) AS avgTotal FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE (rated = '1u' OR rated = '1d') AND post_id = '" . $args['post_id'] . "' AND ". $args_id_sql, ARRAY_A );
		} else { // type 'star'
			$total_average_query = $wpdb->get_row( "SELECT COUNT(*) AS avgTotal, (SUM(rated)/COUNT(post_id)) AS avgRated FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE rated REGEXP '^[0-9]+$' AND post_id = '" . $args['post_id'] . "' AND ". $args_id_sql, ARRAY_A );
		}

		if ($args['form']) {
			//TODO: Create method for generating rating form based on average
			// Attributes
			$atts = array (
				'id' => $args['id'],
				'result' => true,
				'tooltip' => false
			);
			// Rating Form
			$rf = new Rating_Form( $atts );
			$rf->wrapper(
				$rf->container(
					$rf->items()
				)
			);
			$content .= $rf->show();
		} else {
			// Type Count / Percentage
			if (empty($args['text'])) {
				if (trim($args['type']) == 'tud') {
					$textData = __( 'Up: %1$s Down: %3$s based on %2$s ratings', 'rating-form' );
				} else {
					$textData = __( '%1$s average based on %2$s ratings', 'rating-form' );
				}
			}
			$countRating = ($args['type_count'] == 'percentage') ? $ratingData['count_percent'] : $ratingData['count'];
			$firstData = (trim($args['type']) == 'tud') ? $ratingData['up_count'] : $ratingData['average'] ;
			$args['text'] = sprintf( htmlentities($textData), $firstData, $countRating, $ratingData['down_count'] );
			$content .= html_entity_decode(trim($args['text']));
		}

		$content .= '</span>'."\r\n";

		// end ajax
		if ($ajax == false) $content .= '</div>'."\r\n";
	}
	return $content;
}
// Display total average ratings
function display_rating_form_total( $atts ) {
	// Total average rating
	return wrap_rating_form_total( $atts, false );
}
add_shortcode( 'rating_form_total', 'display_rating_form_total' );
?>
