<?php
// Display rating form stats
function display_rating_form_stats( $atts ) {

	global $post;
	global $wpdb;

	$content = '';
	$sort_sql = '';
	$args = array();
	$current_user = wp_get_current_user();

	// Attributes
	$args = shortcode_atts(
		array(
			'ip' => '0',
			'user_id' => '0',
			'user_logged_in' => 'false',
			'target' => 'false',
			'rating' => 'false',
			'sort' => '',
			'state' => '',
			'class' => ''
		), $atts );

	$args['ip'] = empty($args['ip']) ? Rating_Form_API::getIP() : 0;
	$args['user_id'] = empty($args['user_id']) ? 0 : intval($args['user_id']);
	$args['class'] = empty($args['class']) ? '' : ' ' . trim($args['class']);
	$args['user_logged_in'] = $args['user_logged_in'] == 'true' ? true : false;
	$args['target'] = $args['target'] == 'false' ? false : trim($args['target']);
	$args['rating'] = $args['rating'] == 'true' ? true : false;
	$splitSort = empty($args['sort']) ? array() : explode(',', $args['sort']); // split post types to array
	$args['sort'] = count( $splitSort ) == 0 ? array() : $splitSort;
	$args['state'] = strtolower($args['state']);

	// State: review
	$isStateReview = ($args['state'] == 'review' ? true : false);
	$review_rating = ($isStateReview ? 'r' : '');

	// Sort by: old,new,top_rating,down_rating
	$sort_sql = 'date DESC';
	$sort_sql_field = array();
	if (!empty($args['sort'])) {
		if (in_array("old", $args['sort'])) {
			$sort_sql_field[] = 'date ASC';
		} else if (in_array("new", $args['sort'])) {
			$sort_sql_field[] = 'date DESC';
		}

		if (in_array("down_rating", $args['sort'])) {
			$sort_sql_field[] = 'avgRated ASC';
		} else if (in_array("top_rating", $args['sort'])) {
			$sort_sql_field[] = 'avgRated DESC';
		}
		$sort_sql = implode(", ", $sort_sql_field);
	}
	$field = !empty($args['user_id']) ? 'user' : 'ip';
	$value = !empty($args['user_id']) ? $args['user_id'] : $args['ip'];

	// Get current user ID
	if ($args['user_id'] == 'auto' && is_user_logged_in()) {
		$field = 'user';
		$value = $current_user->ID;
	}

	$this_query = $wpdb->get_results( "SELECT *, post_id, (SUM(rated)/COUNT(post_id)) AS avgRated FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE " . ($isStateReview ? "rated LIKE '" . $review_rating . "%' AND " : "") . $field . " = '" . $value . "' GROUP BY post_id ORDER BY " . $sort_sql, ARRAY_A );
	$this_num_rows = $wpdb->num_rows;

	if ($this_num_rows > 0) {
		$content .= '<div class="rf_stats' . $args['class'] . '"><ul>';
		foreach ($this_query as $this_post) {
			$target = $args['target'] == false ? '' : '" target="'. $args['target'] .'"';
			$rating = $args['rating'] == true ? ' (' . round($this_post['avgRated'], 1) . ')' : '';
			$content .= '<li><a href="' . get_permalink( $this_post['post_id'] ) . '"' . $target . '>' . get_the_title( $this_post['post_id'] ) . $rating . '</a></li>';
		}
		$content .= '</ul></div>';
	}
	if ($args['user_logged_in'] == true && !is_user_logged_in()) {
		$content = '';
	}

	return $content;
}
add_shortcode( 'rating_form_stats', 'display_rating_form_stats' );
?>
