<?php
// Wrap rating form results
function wrap_rating_form_results( $args, $ajax ) {

	// Default values
	$args['id'] = empty($args['id']) ? 1 : intval($args['id']);
	$args['post_id'] = empty($args['post_id']) ? 0 : intval($args['post_id']);
	$args['comment_id'] = empty($args['comment_id']) ? 0 : intval($args['comment_id']);
	$args['custom_id'] = Rating_Form_API::convertFieldIDArray($args['custom_id']);
	$args['user_id'] = empty($args['user_id']) ? 0 : intval($args['user_id']);
	$args['term_id'] = empty($args['term_id']) ? 0 : intval($args['term_id']);
	$args['class'] = empty($args['class']) ? '' : ' ' . trim($args['class']);
	$args['outer_color'] = empty($args['outer_color']) ? '#dddddd' : strtolower($args['outer_color']);
	$args['inner_color'] = empty($args['inner_color']) ? '#ffd700' : strtolower($args['inner_color']);
	// Attr values to boolean
	$args['live'] = $args['live'] == 'true' ? true : false;
	$args['show_count'] = $args['show_count'] == 'true' ? true : false;
	$args['custom_id_group'] = empty($args['custom_id_group']) ? '0' : strtolower($args['custom_id_group']);

	global $wpdb;
	$content = '';
	$argsInSql = '';

	// Args to SQL
	if (count($args['custom_id']) > 1) {
		$sql_custom_id = "custom_id IN('" . implode("','", $args['custom_id']) . "')";
	} else {
		$sql_custom_id = "custom_id = '" . $args['custom_id'] . "'";
	}

	// Average rating of all custom ids
	if ($args['custom_id'] == "all") {
		$sql_custom_id = "custom_id != '0'";
	}

	// Args to SQL
	$argsInSql = " AND comment_id = " . $args['comment_id'] .
					" AND " . $sql_custom_id .
					" AND user_id = " . $args['user_id'] .
					" AND term_id = " . $args['term_id'];

	// Post ID = 0
	if (!empty($args['term_id'])) {
		$args['post_id'] = 0;
	}

	// Rating Form #ID
	$divRFid = 'RFRS' . Rating_Form_API::getDivID($args);

	// Rating Form Settings
	$this_form_query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " WHERE form_id = '" . $args['id'] . "'", ARRAY_A );
	// Default settings if args ID is empty
	$jsonDisplay = empty($this_form_query['display']) ? array() : json_decode($this_form_query['display'], true);
	$max = empty($jsonDisplay['max']) ? 5 : intval($jsonDisplay['max']);
	$round = empty($jsonDisplay['round']) ? 1 : intval($jsonDisplay['round']);

	if ($ajax == false) {
		$content .= '<div data-rf-id="' . $divRFid . '" class="rf_results' . $args['class'] . '">'."\r\n"; // begin
	}

	if ($args['live']) {
		$content .= '<script type="text/javascript">'."\r\n";
		$content .= 'function ' . $divRFid . '(){'."\r\n";
			$content .= 'jQuery.ajax({'."\r\n";
				$content .= 'type: "POST",'."\r\n";
				$content .= 'url : rating_form_script.ajaxurl,'."\r\n";
				$content .= 'data : { '."\r\n";
				$content .= 'action : "display_rating_form_results_ajax", '."\r\n";
				$content .= 'args : ' . json_encode($args) . "\r\n";
				$content .= '}, '."\r\n";
				$content .= 'success : function(data) { jQuery("body").find("[data-rf-id=' . $divRFid . ']").html(data) }'."\r\n";
			$content .= '});'."\r\n";
		$content .= '}'."\r\n";
		$content .= '</script>'."\r\n";
	}

	// Count total Ratings
	$totalRatings = $wpdb->get_row( "SELECT COUNT(rated) AS total FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE post_id = " . $args['post_id'] . " AND rated REGEXP '^[0-9]+$'" . $argsInSql, ARRAY_A );

	$content .= '<table>'."\r\n";
	$content .= '<tbody>'."\r\n";
	for ($i = $max; $i >= 1; $i--) {
		// Count Ratings
		$totalRatingI = $wpdb->get_row( "SELECT COUNT(rated) AS count FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG . " WHERE post_id = " . $args['post_id'] . " AND rated = '" . $i . "'" . $argsInSql, ARRAY_A );

		// Stars type
		$txt_stars = '';
		if ($args['type_stars'] == 'stars') {
			$txt_stars = sprintf($args['txt_stars'], $i);
		} else if ($args['type_stars'] == 'titles') {
			$arrTitles = Rating_Form_API::getTitles($this_form_query['form_id']);
			$txt_stars = $arrTitles[$i];
		}

		// Count text
		$txt_count = '';
		$percentage = $totalRatings['total'] > 0 ? round(($totalRatingI['count']/$totalRatings['total'])*100, $round) : 0;
		if ($args['type_count'] == 'count') {
			$txt_count = $totalRatingI['count'];
		} else if ($args['type_count'] == 'percentage') {
			$txt_count = $percentage . '%';
		}
		// Outer Style
		$outer_style = 'background-color:' . $args['layout_color'] . ';';
		$outer_style .= 'width:' . $args['layout_width'] . ';';
		$outer_style .= 'height:' . $args['layout_height'];
		// Inner Style
		$inner_style = 'background-color:' . $args['fill_color'] . ';';
		$inner_style .= 'width:' . (round($percentage)/100)*intval($args['layout_width']) . 'px;';
		$inner_style .= 'height:' . $args['layout_height'];
		// Markup
		$content .= '<tr class="rf_results_container">';
		$content .= '<td>' . $txt_stars . '</td>';
		$content .= '<td>';
		$content .= '<div class="rf_results_outer" style="' . $outer_style . '">';
		$content .= '<div class="rf_results_inner" style="' . $inner_style . '"></div>';
		$content .= '</div>';
		$content .= '</td>';
		$content .= $args['show_count'] ? '<td>' . sprintf($args['txt_count'], $txt_count) . '</td>' : '';
		$content .= '</tr>'."\r\n";
	}
	$content .= '</tbody>'."\r\n";
	$content .= '</table>'."\r\n";

	if ($ajax == false) {
		$content .= '</div>'; // end
	}

	return $content;
}
// Display rating form results
function display_rating_form_results( $atts ) {

	$args = array();
	global $post;

	// Attributes
	$args = shortcode_atts(
		array(
			'id' => '',
			'post_id' => '',
			'comment_id' => '0',
			'custom_id' => '0',
			'user_id' => '0',
			'term_id' => '0',
			'class' => '',
			'layout_height' => '15px',
			'layout_width' => '100px',
			'layout_color' => '#dddddd',
			'fill_color' => '#ffd700',
			'type_stars' => 'stars',
			'type_count' => 'count',
			'show_count' => 'true',
			'live' => 'true',
			'custom_id_group' => '0',
			'txt_stars' => '%s stars',
			'txt_count' => '%s'
		), $atts );

	// Get current post ID
	if (empty($args['post_id'])) {
		if (isset($post)) {
			$args['post_id'] = $post->ID;
		}
	}
	// Get current comment ID
	if (have_comments() && in_the_loop() && empty($args['comment_id'])) {
		$args['comment_id'] = get_comment_ID();
	}
	// For preview, use post ID 1
	if ( is_admin() && ( !defined( 'DOING_AJAX' ) || !DOING_AJAX ) ) {
		$args['post_id'] = 1;
	}

	return wrap_rating_form_results( $args, false );
}
add_shortcode( 'rating_form_results', 'display_rating_form_results' );
?>
