<?php
function rf_update_db() {
	$current_version = get_option( Rating_Form_Setup::OPTION_VERSION );

	if ( $current_version != Rating_Form_Setup::PLUGIN_VERSION && $current_version < '1.4.1' ) { // Version 1.4.1 update
		rf_upgrade_to_1_4_1();
	}

	if ( $current_version != Rating_Form_Setup::PLUGIN_VERSION && $current_version < '1.5.2' ) { // Version 1.5.2 update
		rf_upgrade_to_1_5_2();
	}

	if ( $current_version != Rating_Form_Setup::PLUGIN_VERSION && $current_version < '1.5.3' ) { // Version 1.5.3 update
		rf_upgrade_to_1_5_3();
	}

	if ( $current_version != Rating_Form_Setup::PLUGIN_VERSION && $current_version < '1.5.9' ) { // Version 1.5.9 update
		rf_upgrade_to_1_5_9();
	}

	// Admin message
	if ( get_option('rf_admin_notice') == 1 ) add_action( 'admin_notices', 'admin_msg_rf_1_5_9' );

	// Update to current version
	if ( $current_version != Rating_Form_Setup::PLUGIN_VERSION ) {
		update_option( Rating_Form_Setup::OPTION_VERSION, Rating_Form_Setup::PLUGIN_VERSION );
	}
}
function rf_upgrade_to_1_4_1() {
	global $wpdb;
	$spinner = '';
	$post_ids = '';
	$ex_post_ids = '';
	$redirect_url = '';
	$redirect_target = '';
	$ustats_row = '';
	$ustats_per_row = '';
	$ustats_av_size = '';

	$existing_columns = $wpdb->get_col("DESC " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, 0);
	$remove_columns = array(
			'active',
			'max',
			'restrict_ip',
			'user_logged_in',
			'ajax_load',
			'rich_snippet',
			'spinner',
			'round',
			'rtl',
			'limitation',
			'time',
			'txt_ty',
			'txt_rated',
			'txt_login',
			'txt_limit',
			'txt_edit_rating'
		); //Array of columns to remove
	$remove_columns = array_intersect($remove_columns, $existing_columns);
	if( !empty($remove_columns) ) {
		// List of Rating Forms
		$update_forms_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, ARRAY_A );
		$update_forms_num = $wpdb->num_rows;
		if ($update_forms_num > 0) {
			//echo '<pre>';
			foreach ($update_forms_query as $form) {
				$display = empty($form['display']) ? array() : json_decode($form['display'], true);

				// First check if fields are being used by a Rating Form
				$getSpinner_gp = preg_grep("/^spinner\d/", $display);
				if (!empty($getSpinner_gp)) {
					$spinner = str_replace('spinner', '', array_shift($getSpinner_gp));
				}
				$post_ids_match = preg_grep("/^post_ids-(.*)/", $display);
				if (!empty($post_ids_match)) {
					$post_ids = str_replace('post_ids-', '', array_shift($post_ids_match));
				}
				$ex_post_ids_match = preg_grep("/^ex_post_ids-(.*)/", $display);
				if (!empty($ex_post_ids_match)) {
					$ex_post_ids = str_replace('ex_post_ids-', '', array_shift($ex_post_ids_match));
				}
				// Redirect
				$redirect_url_match = preg_grep("/^redirect_url-(.*)/", $display);
				if (!empty($redirect_url_match)) {
					$redirect_url = str_replace('redirect_url-', '', array_shift($redirect_url_match));
				}
				$redirect_target_match = preg_grep("/^redirect_target-(.*)/", $display);
				if (!empty($redirect_target_match)) {
					$redirect_target = str_replace('redirect_target-', '', array_shift($redirect_target_match));
				}
				// User Stats
				$ustats_row_match = preg_grep("/^ustats_row-(.*)/", $display);
				if (!empty($ustats_row_match)) {
					$ustats_row = str_replace('ustats_row-', '', array_shift($ustats_row_match));
				}
				$ustats_per_row_match = preg_grep("/^ustats_per_row-(.*)/", $display);
				if (!empty($ustats_per_row_match)) {
					$ustats_per_row = str_replace('ustats_per_row-', '', array_shift($ustats_per_row_match));
				}
				$ustats_av_size_match = preg_grep("/^ustats_av_size-(.*)/", $display);
				if (!empty($ustats_av_size_match)) {
					$ustats_av_size = str_replace('ustats_av_size-', '', array_shift($ustats_av_size_match));
				}
				// No check needed
				if ($form['active'] == 1) {
					$display[] = 'active';
				}
				if ($form['restrict_ip'] == 1) {
					$display[] = 'restrict_ip';
				}
				if ($form['user_logged_in'] == 1) {
					$display[] = 'user_logged_in';
				}
				if ($form['ajax_load'] == 1) {
					$display[] = 'ajax_load';
				}
				if ($form['rich_snippet'] == 1) {
					$display[] = 'rich_snippet';
				}
				if ($form['rtl'] == 1) {
					$display[] = 'rtl';
				}
				if ($form['spinner'] == 1) {
					$display['spinner']['check'] = 'enable';
					if (!empty($spinner)) {
						$display['spinner']['type'] = $spinner;
					}
				}
				if (!empty($post_ids)) {
					$display['post_ids'] = $post_ids;
				}
				if (!empty($ex_post_ids)) {
					$display['ex_post_ids'] = $ex_post_ids;
				}
				if (in_array("redirect_enable", $display)) {
					$display['redirect']['check'] = 'enable';
				}
				if (!empty($redirect_url)) {
					$display['redirect']['url'] = $redirect_url;
				}
				if (!empty($redirect_target)) {
					$display['redirect']['target'] = $redirect_target;
				}
				if (in_array("ustats_enable", $display)) {
					$display['ustats']['check'] = 'enable';
				}
				if (!empty($ustats_row)) {
					$display['ustats']['row_size'] = $ustats_row;
				}
				if (!empty($ustats_per_row)) {
					$display['ustats']['per_row'] = $ustats_per_row;
				}
				if (!empty($ustats_av_size)) {
					$display['ustats']['av_size'] = $ustats_av_size;
				}
				if (in_array("ustats_av_remove",$display)) {
					$display['ustats'][] = 'av_remove';
				}
				if (in_array("ustats_rating_show",$display)) {
					$display['ustats'][] = 'rating_show';
				}
				if (in_array("ustats_login",$display)) {
					$display['ustats'][] = 'login_required';
				}
				$display['max'] = $form['max'];
				$display['round'] = $form['round'];
				$display['limitation'] = $form['limitation'];
				$display['time'] = $form['time'];
				$display['messages']['ty'] = $form['txt_ty'];
				$display['messages']['rated'] = $form['txt_rated'];
				$display['messages']['login'] = $form['txt_login'];
				$display['messages']['limit'] = $form['txt_limit'];
				$display['messages']['edit_rating'] = $form['txt_edit_rating'];
				// Post type
				$post_type_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "rating_form_post_type WHERE post_type_form_id = '". $form['form_id'] ."'", ARRAY_A );
				$post_type_query_num_row = $wpdb->num_rows;
				if ($post_type_query_num_row > 0) {
					foreach ($post_type_query as $post_type) {
						$display['post_type'][] = $post_type['post_type'];
					}
				}
				// User roles
				$user_role_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "rating_form_user_role WHERE user_role_form_id = '". $form['form_id'] ."'", ARRAY_A );
				$user_role_query_num_row = $wpdb->num_rows;
				if ($user_role_query_num_row > 0) {
					foreach ($user_role_query as $user_role) {
						$display['user_role'][] = $user_role['user_role'];
					}
				}
				// Titles
				$titles_query = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "rating_form_title WHERE title_form_id = '". $form['form_id'] ."'", ARRAY_A );
				$titles_query_num_row = $wpdb->num_rows;
				if ($titles_query_num_row > 0) {
					foreach ($titles_query as $titles) {
						$display['title'][] = $titles['title_id'];
					}
				}
				//print_r($display);
				// Update form
				$wpdb->update( $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, array(
						'display' => json_encode($display)
				), array('form_id' => $form['form_id']) );
			}
			//echo '</pre>';
			$wpdb->query("ALTER TABLE " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM . " DROP COLUMN ".implode(', DROP COLUMN ',$remove_columns).';');
			$wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "rating_form_title" );
			$wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "rating_form_post_type" );
			$wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "rating_form_user_role" );
			update_option( Rating_Form_Setup::OPTION_VERSION, Rating_Form_Setup::PLUGIN_VERSION );
			add_action( 'admin_notices', 'admin_msg_rf_db_remove_fields' );
		}
	}
}
function admin_msg_rf_db_remove_fields() {
	$class = 'notice notice-success is-dismissible';
	$message = 'Rating Form is successfully upgraded to 1.5';

	printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
}
function rf_upgrade_to_1_5_2() {
	$args = array(
		'meta_query' => array(
			'relation' => 'OR',
			array(
				'key' => 'rf_total_votes'
			),
			array(
				'key' => 'rf_average_result'
			),
			array(
				'key' => 'rf_votes_up'
			),
			array(
				'key' => 'rf_votes_down'
			),
			array(
				'key' => 'rf_real_average'
			),
			array(
				'key' => 'rf_real_up'
			),
			array(
				'key' => 'rf_real_down'
			)
		)
	);
	$posts = get_posts($args);

	foreach ($posts as $post) {
		$get_all_meta_keys = get_post_meta($post->ID);
		$new_keys = array(
			'rf_total_votes' => 'rf_fake_total',
			'rf_average_result' => 'rf_fake_average',
			'rf_votes_up' => 'rf_fake_up',
			'rf_votes_down' => 'rf_fake_down',
			'rf_real_average' => 'rf_average',
			'rf_real_up' => 'rf_up',
			'rf_real_down' => 'rf_down'
		);

		foreach ($get_all_meta_keys as $key => $value) {
			if (array_key_exists($key, $new_keys)) {
				$old_value = get_post_meta($post->ID, $key, true);
				//echo 'old_key: ' . $key . '<br>';
				//echo 'new_key: ' . $new_keys[$key] . '<br>';
				//echo 'old_value: ' . $old_value . '<br>';
				// add/update new meta
				update_post_meta($post->ID, $new_keys[$key], $old_value);
				// delete old meta
				delete_post_meta($post->ID, $key);
			}
		}
	}

	// OLD - Delete post meta
 	delete_post_meta_by_key( 'rf_average_result' );
	delete_post_meta_by_key( 'rf_votes_up' );
	delete_post_meta_by_key( 'rf_votes_down' );
	delete_post_meta_by_key( 'rf_total_votes' );
	delete_post_meta_by_key( 'rf_real_average' );
	delete_post_meta_by_key( 'rf_real_up' );
	delete_post_meta_by_key( 'rf_real_down' );
	update_option( Rating_Form_Setup::OPTION_VERSION, Rating_Form_Setup::PLUGIN_VERSION );
	add_action( 'admin_notices', 'admin_msg_rf_remove_post_metas' );
}
function admin_msg_rf_remove_post_metas() {
	$class = 'notice notice-success is-dismissible';
	$message = 'Rating Form is successfully upgraded to 1.5.3';

	printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
}
function rf_upgrade_to_1_5_3() {
	global $wpdb;
	// Post Meta
	// Star
	$sql_post = 'SELECT post_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_average' ) ) add_post_meta( $item['post_id'], 'rf_average', round($item['avgRated'], 1) );
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_total' ) ) add_post_meta( $item['post_id'], 'rf_total', $item['total'] );
		}
	}
	// star - custom id
	$sql_post = 'SELECT post_id, custom_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_average' . $meta_key_custom_id ) ) add_post_meta( $item['post_id'], 'rf_average' . $meta_key_custom_id, round($item['avgRated'], 1) );
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_total' . $meta_key_custom_id ) ) add_post_meta( $item['post_id'], 'rf_total' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD up
	$sql_post = 'SELECT post_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_up' ) ) add_post_meta( $item['post_id'], 'rf_up', $item['total'] );
		}
	}
	// TUD up custom id
	$sql_post = 'SELECT post_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_up' . $meta_key_custom_id ) ) add_post_meta( $item['post_id'], 'rf_up' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD down
	$sql_post = 'SELECT post_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_down' ) ) add_post_meta( $item['post_id'], 'rf_down', $item['total'] );
		}
	}
	// TUD down custom id
	$sql_post = 'SELECT post_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND post_id <> 0 ' .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY post_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'post', $item['post_id'], 'rf_down' . $meta_key_custom_id ) ) add_post_meta( $item['post_id'], 'rf_down' . $meta_key_custom_id, $item['total'] );
		}
	}

	// Comment Meta
	// Star
	$sql_post = 'SELECT comment_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_average' ) ) add_comment_meta( $item['comment_id'], 'rf_average', round($item['avgRated'], 1) );
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_total' ) ) add_comment_meta( $item['comment_id'], 'rf_total', $item['total'] );
		}
	}
	// star - custom id
	$sql_post = 'SELECT comment_id, custom_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_average' . $meta_key_custom_id ) ) add_comment_meta( $item['comment_id'], 'rf_average' . $meta_key_custom_id, round($item['avgRated'], 1) );
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_total' . $meta_key_custom_id ) ) add_comment_meta( $item['comment_id'], 'rf_total' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD up
	$sql_post = 'SELECT comment_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_up' ) ) add_comment_meta( $item['comment_id'], 'rf_up', $item['total'] );
		}
	}
	// TUD up custom id
	$sql_post = 'SELECT comment_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_up' . $meta_key_custom_id ) ) add_comment_meta( $item['comment_id'], 'rf_up' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD down
	$sql_post = 'SELECT comment_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_down' ) ) add_comment_meta( $item['comment_id'], 'rf_down', $item['total'] );
		}
	}
	// TUD down custom id
	$sql_post = 'SELECT comment_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND post_id <> 0 ' .
	'AND comment_id <> 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY comment_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'comment', $item['comment_id'], 'rf_down' . $meta_key_custom_id ) ) add_comment_meta( $item['comment_id'], 'rf_down' . $meta_key_custom_id, $item['total'] );
		}
	}

	// Term Meta
	// Star
	$sql_post = 'SELECT term_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_average' ) ) add_term_meta( $item['term_id'], 'rf_average', round($item['avgRated'], 1) );
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_total' ) ) add_term_meta( $item['term_id'], 'rf_total', $item['total'] );
		}
	}
	// star - custom id
	$sql_post = 'SELECT term_id, custom_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_average' . $meta_key_custom_id ) ) add_term_meta( $item['term_id'], 'rf_average' . $meta_key_custom_id, round($item['avgRated'], 1) );
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_total' . $meta_key_custom_id ) ) add_term_meta( $item['term_id'], 'rf_total' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD up
	$sql_post = 'SELECT term_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_up' ) ) add_term_meta( $item['term_id'], 'rf_up', $item['total'] );
		}
	}
	// TUD up custom id
	$sql_post = 'SELECT term_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_up' . $meta_key_custom_id ) ) add_term_meta( $item['term_id'], 'rf_up' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD down
	$sql_post = 'SELECT term_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_down' ) ) add_term_meta( $item['term_id'], 'rf_down', $item['total'] );
		}
	}
	// TUD down custom id
	$sql_post = 'SELECT term_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id <> 0 ' .
	'AND user_id = 0 ' .
	'GROUP BY term_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'term', $item['term_id'], 'rf_down' . $meta_key_custom_id ) ) add_term_meta( $item['term_id'], 'rf_down' . $meta_key_custom_id, $item['total'] );
		}
	}

	// User Meta
	// Star
	$sql_post = 'SELECT user_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_average' ) ) add_user_meta( $item['user_id'], 'rf_average', round($item['avgRated'], 1) );
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_total' ) ) add_user_meta( $item['user_id'], 'rf_total', $item['total'] );
		}
	}
	// star - custom id
	$sql_post = 'SELECT user_id, custom_id, (SUM(rated)/COUNT(*)) AS avgRated, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated REGEXP '^[0-9]+$' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_average' . $meta_key_custom_id ) ) add_user_meta( $item['user_id'], 'rf_average' . $meta_key_custom_id, round($item['avgRated'], 1) );
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_total' . $meta_key_custom_id ) ) add_user_meta( $item['user_id'], 'rf_total' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD up
	$sql_post = 'SELECT user_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_up' ) ) add_user_meta( $item['user_id'], 'rf_up', $item['total'] );
		}
	}
	// TUD up custom id
	$sql_post = 'SELECT user_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1u' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_up' . $meta_key_custom_id ) ) add_user_meta( $item['user_id'], 'rf_up' . $meta_key_custom_id, $item['total'] );
		}
	}
	// TUD down
	$sql_post = 'SELECT user_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND comment_id = 0 ' .
	"AND custom_id = '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_down' ) ) add_user_meta( $item['user_id'], 'rf_down', $item['total'] );
		}
	}
	// TUD down custom id
	$sql_post = 'SELECT user_id, custom_id, COUNT(*) AS total ' .
	'FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_LOG .
	" WHERE rated = '1d' " .
	'AND comment_id = 0 ' .
	"AND custom_id <> '0' " .
	'AND term_id = 0 ' .
	'AND user_id <> 0 ' .
	'GROUP BY user_id, custom_id';
	$query_post = $wpdb->get_results( $sql_post, ARRAY_A );
	$num_rows = $wpdb->num_rows;
	if (count($num_rows)) {
		foreach ($query_post as $item) {
			$meta_key_custom_id = '_cui_' . $item['custom_id'];
			if ( !metadata_exists( 'user', $item['user_id'], 'rf_down' . $meta_key_custom_id ) ) add_user_meta( $item['user_id'], 'rf_down' . $meta_key_custom_id, $item['total'] );
		}
	}
	update_option( Rating_Form_Setup::OPTION_VERSION, Rating_Form_Setup::PLUGIN_VERSION );
	add_action( 'admin_notices', 'admin_msg_rf_add_metas' );
}
function admin_msg_rf_add_metas() {
	$class = 'notice notice-success is-dismissible';
	$message = 'Rating Form: database successfully upgraded to version 1.5.4';

	printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
}
function rf_upgrade_to_1_5_9() {
	update_option( Rating_Form_Setup::OPTION_VERSION, Rating_Form_Setup::PLUGIN_VERSION );
	update_option('rf_admin_notice', 1);
}
function admin_msg_rf_1_5_9() {
	$class = 'rf-notice notice notice-success';
	$message = '<h3>Rating Form v1.5.9 - Important notice</h3>';
	$message .= '<a target="_blank" href="https://en.wikipedia.org/wiki/General_Data_Protection_Regulation">GDPR EU regulation</a> will take effect on 25th of May. In order to comply with this law, there are a few changes:';
	$message .= '<ul>';
	$message .= '<li><i>- Default validation is set to Cookies</i></li>';
	$message .= '<li><i>- Storing IP address and validation has been turned off</i></li>';
	$message .= '<li><i>- Anonymize IP Addresses</i></li>';
	$message .= '</ul>';
	$message .= 'Go to <a href=" ' . admin_url('admin.php?page='. Rating_Form_Setup::PAGE_SETTINGS_SLUG) . '">settings</a> page to adjust settings.';
	$message .= '<p><button class="button btn_rf_admin_notice">Dismiss</button></p>';
	printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
}
?>
