<?php
if( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class Rating_Form_Titles_Table extends WP_List_Table {

	//Prepare the items for the table to process
	public function prepare_items()
    {
		global $wpdb;

        $columns = $this->get_columns();
        $hidden = $this->get_hidden_columns();
        $sortable = $this->get_sortable_columns();

		$query = 'SELECT * FROM ' . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES;
        $data = $wpdb->get_results($query, ARRAY_A);
        usort($data, array($this, 'sort_data'));

        $perPage = 10;
        $currentPage = $this->get_pagenum();
        $totalItems = count($data);

        $this->set_pagination_args( array(
            'total_items' => $totalItems,
            'per_page'    => $perPage
        ) );

        $data = array_slice($data,(($currentPage-1)*$perPage),$perPage);

        $this->_column_headers = array($columns, $hidden, $sortable);
        $this->items = $data;
    }

	//Override the parent columns method.
	//Defines the columns to use in your listing table
	public function get_columns()
    {
        $columns = array(
            'title_id' => __( 'Title ID', 'rating-form' ),
            'position' => __( 'Position', 'rating-form' ),
            'text' => __( 'Title', 'rating-form' )
        );

        return $columns;
    }

	//Define what data to show on each column of the table
    public function column_default( $item, $column_name )
    {
        switch( $column_name ) {
            case 'title_id':
            case 'text':
				$item['text'] = stripslashes($item['text']);
            case 'position':
				$item['position'] = '<strong>'. $item['position'] .'</strong> <span class="row-actions"><span class="edit"><a href="' . admin_url( ) . 'admin.php?page='.Rating_Form_Setup::PAGE_TITLES_RATING_SLUG.'&edit='. $item['title_id'] .'">'. __( 'Edit', 'rating-form' ) .'</a></span> | <span class="delete"><a onclick="return confirm(&quot;'. __( 'Are you sure you want to delete this title?', 'rating-form' ) .'&quot;)" href="' . admin_url( ) . 'admin.php?page='.Rating_Form_Setup::PAGE_TITLES_RATING_SLUG.'&delete='. $item['title_id'] .'">'. __( 'Delete', 'rating-form' ) .'</a></span></span>';
				return $item[ $column_name ];

            default:
                return print_r( $item, true ) ;
        }
    }

	//Define which columns are hidden
    public function get_hidden_columns()
    {
        return array('title_id');
    }

	//Define the sortable columns
    public function get_sortable_columns()
    {
        return array(
			'title_id' => array('title_id', false),
			'text' => array('text', false),
			'position' => array('position', true)
			);
    }

	//Allows you to sort the data by the variables set in the $_GET
    private function sort_data( $a, $b )
    {
        // Set defaults
        $orderby = 'position';
        $order = 'asc';

        // If orderby is set, use this as the sort column
        if(!empty($_GET['orderby']))
        {
            $orderby = $_GET['orderby'];
        }

        // If order is set use this as the order
        if(!empty($_GET['order']))
        {
            $order = $_GET['order'];
        }

        $result = strnatcmp( $a[$orderby], $b[$orderby] );

        if($order === 'asc')
        {
            return $result;
        }

        return -$result;
    }
}

function rating_form_titles() {
?>
	<div class="wrap rf_wrap<?php echo Rating_Form_Setup::getAdminRTLclass(); ?>"<?php echo Rating_Form_Setup::getAdminRTL(); ?>>
	<?php
	Rating_Form_Setup::admin_menus();
	if (isset($_GET['edit'])) {

		global $wpdb;

		$edit_query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE title_id = '".$_GET['edit']."'", ARRAY_A );
		$rowCount = $wpdb->num_rows;

		if ($rowCount > 0) {

			if (isset($_POST['edit'])) {
				$msg_success = null;
				$msg_error = null;
				$text = $_POST['title'];
				$position = $_POST['position'];

				if (isset($text) && isset($position)) {

					if (strlen($msg_error) == 0) {

						$wpdb->update( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_TITLES, array(
								'text' => $text,
								'position' => $position
						), array('title_id' => $edit_query['title_id'] ) );

						// WPML register string for translation - Update title
						if (has_action('wpml_register_single_string')) {
							do_action('wpml_register_single_string', 'rating-form', 'Title ID ' . $edit_query['title_id'], $text);
						}
						$msg_success .= __( 'Successfully updated!', 'rating-form' );
					}

				} else {
					$msg_error .= __( 'Error! Title not updated.', 'rating-form' );
				}

				if ( strlen( $msg_success ) > 0) {
					echo '<div class="rf_updated">' . $msg_success . '</div>';
				}

				if ( strlen( $msg_error ) > 0) {
					echo '<div class="rf_error">' . $msg_error . '</div>';
				}
			}

		} else {
			echo '<div class="rf_error">'. sprintf( __( 'Title ID %d not found!', 'rating-form' ), $_GET['edit'] ) .'</div>';
		}
?>
    <div class="rf_content rf_100p">
		<div class="rf_content_inner rf_border_box rf_50p alignleft">
			<h3 class="rf_content_title"><?php _e( 'Edit Title', 'rating-form' ); ?> <strong><?php echo isset($_POST['title']) ? $_POST['title'] : stripslashes($edit_query['text']); ?></strong></h3>
			<?php
			if (has_action('wpml_translate_single_string')) {
				$languages = icl_get_languages('skip_missing=1');
				$curr_lang = array();
				if (!empty($languages)) {
					foreach ($languages as $language) {
						if (!empty($language['active'])) {
							$curr_lang = $language;
							break;
						}
					}
				}
				$translated_text = apply_filters('wpml_translate_single_string', $edit_query['text'], 'rating-form', 'Title ID ' . $edit_query['title_id'], $curr_lang['code']);
				if ($translated_text != $edit_query['text']) {
					echo '<img src="'.$curr_lang['country_flag_url'].'" alt="'.$curr_lang['code'].'" /> ' . $translated_text;
				}
			}
			?>
			<form class="rf_form_table" id="rating_form_add_edit" action="<?php echo admin_url( ) . 'admin.php?page='.Rating_Form_Setup::PAGE_TITLES_RATING_SLUG . '&edit=' . $edit_query['title_id']; ?>" method="post">
				<table class="form-table">
					<tbody>
						<tr>
							<th scope="row"><?php _e( 'Text', 'rating-form' ); ?></th>
							<td>
								<input id="title" type="text" name="title" value="<?php echo isset($_POST['title']) ? $_POST['title'] : stripslashes($edit_query['text']); ?>">
								<p class="description"><?php _e( 'Type a new title, example: Wow, So bad, Cool, Super!', 'rating-form' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php _e( 'Position', 'rating-form' ); ?></th>
							<td>
								<?php for ($i = 1; $i <= 10; $i++) { ?>
									<?php if ($i == (isset($_POST['position']) ? $_POST['position'] : $edit_query['position'])) { ?>
									<label><input class="position" type="radio" name="position" value="<?php echo $i; ?>" checked="checked" /> <?php echo $i; ?></label><br>
									<?php } else { ?>
									<label><input class="position" type="radio" name="position" value="<?php echo $i; ?>" /> <?php echo $i; ?></label><br>
									<?php } ?>
								<?php } ?>
								<p class="description"><?php _e( 'Set position of title<br>Thumbs Up = position 1<br>Thumbs Down = position 2', 'rating-form' ); ?></p>
							</td>
						</tr>
					</tbody>
				</table>
				<?php submit_button( __( 'Update', 'rating-form' ), 'primary', 'edit'); ?>
			</form>
		</div>
<?php
	} else {

		if (isset($_GET['delete'])) {
			global $wpdb;

			$query = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE title_id = '".$_GET['delete']."'", ARRAY_A );
			$rowCount = $wpdb->num_rows;

			$titleInForm = array();
			$titleUsedQuery = $wpdb->get_results( "SELECT form_id, display FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_ADD_FORM, ARRAY_A );
			$titleUsedQuery_num = $wpdb->num_rows;

			if ($titleUsedQuery_num > 0) {
				foreach ($titleUsedQuery AS $form) {
					$jsonDisplay = empty($form['display']) ? array() : json_decode($form['display'], true);
					$titles = empty($jsonDisplay['title']) ? array() : $jsonDisplay['title'];

					if (in_array($_GET['delete'], $titles)) {
						$titleInForm[] = $form['form_id'];
					}
				}
			}
			if ($rowCount == 0) {
				echo '<div class="rf_error">'. sprintf( __( 'Title ID %d does not exist!', 'rating-form' ), $_GET['delete'] ) .'</div>';
			} else {
				if (empty($titleInForm)) {
					$wpdb->query(
						$wpdb->prepare(
								"DELETE FROM " . $wpdb->prefix . Rating_Form_Setup::TBL_RATING_TITLES . " WHERE title_id = %d",
								$_GET['delete']
							)
					);
					echo '<div class="rf_updated"><p>'. __( 'Successfully deleted!', 'rating-form' ) .'</p></div>';
				} else {
					echo '<div class="rf_error">' . sprintf( __( 'Title ID %d could not be deleted, because this title is being used in the following Rating Form ID\'s: %s', 'rating-form' ), $_GET['delete'], implode(", ", $titleInForm) ) . '</div>';
				}
			}
		}

		if (isset($_POST['add'])) {
			$msg_success = null;
			$msg_error = null;
			$text = $_POST['title'];
			$position = $_POST['position'];

			if (isset($text) && isset($position)) {

				if (empty($text)) {
					$msg_error .= '<p>'. __( 'Field <strong>Text</strong> is empty', 'rating-form' ) .'</p>';
				}

				if (strlen($msg_error) == 0) {
					global $wpdb;

					$wpdb->insert( $wpdb->prefix.Rating_Form_Setup::TBL_RATING_TITLES, array(
								'text' => $text,
								'position' => intval($position)
						));

					// WPML register string for translation - New title
					if (has_action('wpml_register_single_string')) {
						do_action('wpml_register_single_string', 'rating-form', 'Title ID ' . $wpdb->insert_id, $text);
					}
					$msg_success .= sprintf( __( 'Successfully added title: <strong>%s</strong>', 'rating-form' ), stripslashes($text) );
				}

			} else {
				$msg_error .= __( 'Error! Title not added. Forgot to fill a field?', 'rating-form' );
			}

			if ( strlen( $msg_success ) > 0) {
				echo '<div class="rf_updated">' . $msg_success . '</div>';
			}

			if ( strlen( $msg_error ) > 0) {
				echo '<div class="rf_error">' . $msg_error . '</div>';
			}
		}
?>
    <div class="rf_content rf_100p">
		<div class="rf_content_inner rf_border_box rf_50p alignleft">
			<h3 class="rf_content_title"><?php _e( 'Add Title', 'rating-form' ); ?></h3>
			<form class="rf_form_table" id="rating_form_add_edit" action="<?php echo admin_url( ) . 'admin.php?page='.Rating_Form_Setup::PAGE_TITLES_RATING_SLUG; ?>" method="post">
				<table class="form-table">
					<tbody>
						<tr>
							<th scope="row"><?php _e( 'Text', 'rating-form' ); ?></th>
							<td>
								<input id="title" type="text" name="title" value="">
								<p class="description"><?php _e( 'Type a new title, example: Wow, So bad, Cool, Super!', 'rating-form' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php _e( 'Position', 'rating-form' ); ?></th>
							<td>
								<?php for ($i = 1; $i <= 10; $i++) { ?>
									<?php if ($i == 1) { ?>
									<label><input class="position" type="radio" name="position" value="<?php echo $i; ?>" checked="checked" /> <?php echo $i; ?></label><br>
									<?php } else { ?>
									<label><input class="position" type="radio" name="position" value="<?php echo $i; ?>" /> <?php echo $i; ?></label><br>
									<?php } ?>
								<?php } ?>
								<p class="description"><?php _e( 'Set position of title<br>Thumbs Up = position 1<br>Thumbs Down = position 2', 'rating-form' ); ?></p>
							</td>
						</tr>
					</tbody>
				</table>
				<?php submit_button( __( 'Add', 'rating-form' ), 'primary', 'add'); ?>
			</form>
        </div>
<?php
	}

	$rating_form_titles_table = new Rating_Form_Titles_Table();
	$rating_form_titles_table->prepare_items();
?>
    	<div class="rf_border_box rf_50p alignright">
    		<form class="rf_form_table" id="rating_form_titles_table" method="post">
    			<?php $rating_form_titles_table->display(); ?>
    		</form>
    	</div>
    </div> <!-- / .rf_content -->
</div> <!-- / .rf_wrap -->
<?php
}
?>
