<?php session_start(); ?> <!-- session start -->
<?php include("../include/config.php"); ?> <!-- database connection -->
<?php include("../include/connect_url.php"); ?> <!-- connection url/link folder -->
<?php include("../include/date_time.php"); ?> <!-- date & time format -->
<?php include("../database/account.php"); ?> <!-- query database account -->
<?php include("../include/lang.php"); ?> <!-- language -->
<?php include("../include/session_login.php"); ?> <!-- session login -->

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
<title><?php echo $lang['Inpatient']; ?></title>

<link rel="shortcut icon" href="<?php echo $connect_url_data; ?>/favicon.ico" />

<link href="<?php echo $connect_url_data; ?>/css/styles.css" rel="stylesheet" type="text/css" />
<!--[if IE]> <link href="<?php echo $connect_url_data; ?>/css/ie.css" rel="stylesheet" type="text/css"> <![endif]-->
<link rel="stylesheet" href="<?php echo $connect_url_data; ?>/font/font-awesome-4.3.0/css/font-awesome.min.css">

<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/download/jquery183.js"></script> 
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/download/jquery192.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/plugins/charts/jquery.sparkline.min.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/plugins/ui/jquery.collapsible.min.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/plugins/ui/jquery.breadcrumbs.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/plugins/ui/jquery.easytabs.min.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data; ?>/js/files/functions_blank_no_sidebar.js"></script>

<script type="text/javascript" src="<?php echo $connect_url_data ?>/datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo $connect_url_data ?>/datatable/js/columnFilter.js"></script>

<script type="text/javascript" src="<?php echo $connect_url_data ?>/js/files/bootstrap.js"></script>

</head>

<body>

<!-- header-->
<?php include("../template/header.php"); ?>

<!-- sidebar-->
<?php include("../template/sidebar.php"); ?>
   
<!-- Content begins -->
<div id="content">
    
    <!-- Breadcrumbs line -->
    <div class="breadLine">
        <div class="bc">
            <ul id="breadcrumbs" class="breadcrumbs">
               <li><a href="<?php echo $connect_url_data; ?>/dashboard"><?php echo $lang['Dashboard']; ?></a></li>
               <li class="current"><a href="#"><?php echo $lang['Inpatient']; ?></a></li>
            </ul>
        </div>
        
<!-- breaklink -->
<?php include("../menu/breadlink.php"); ?>
	
    </div>
    
    <!-- Main content -->
    <div class="wrapper">
    
  <div class="widget">
            <div class="whead">
                <h6><span class="icon-user" style="margin-top:-2px;"></span>&nbsp; <?php echo $lang['Inpatient']; ?></h6>
                <div class="titleOpt">
                    <a href="<?php echo $connect_url_data; ?>/create-inpatient" style="color:#3e76af;"><span class="icos-add" ></span>&nbsp;<u><?php echo $lang['Create Inpatient']; ?></u></a>
                </div>
            </div>
											
<div style="position:relative;height:1px;left:-15px;float:right;top:12px;z-index:10;">
  <a class="buttonM bBlue" href="javascript:void(0);" onclick="oTable.fnReloadAjax();" style="border-radius:5px;"><span class="fa fa-refresh"></span><span><?php echo $lang['Refresh']; ?></span></a>
</div>

<script type="text/javascript" charset="utf-8">      
$(document).ready(function () {
  
  oTable =$('#inpatient-datatable').dataTable(
  {
    
"fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
      
if ( aData[0]){$('td:eq(0)', nRow).html( '<center><i class="icon-user"></i></center>');}

if ( aData[15]==1){$('td:eq(7)', nRow).html("<center><a href='#' onclick=\"window.open('<?php echo $connect_url_data; ?>/inpatient/e/"+ aData[0] +"', 'popup1',  'status,menubar=0,scrollbars=1,resizable=0,top=50,left=50,width=1220,height=550')\" class='btn' rel='tooltip' title='<?php echo $lang['Account']; ?>'><i class='fa fa-user'></i> <?php echo $lang['Account']; ?></a>&nbsp;&nbsp;<a href='#' onclick=\"window.open('<?php echo $connect_url_data; ?>/transaction/patient/charge/"+ aData[0] +"', 'popup1',  'status,menubar=0,resizable=0,scrollbars=1,top=50,left=50,width=1220,height=550')\" class='btn' rel='tooltip' title='<?php echo $lang['Charges']; ?>'><i class='fa fa-connectdevelop'></i> <?php echo $lang['Charges']; ?></a>&nbsp;&nbsp; <a href='<?php echo $connect_url_data; ?>/charge/a/"+ aData[0] +"' title='<?php echo $lang['Add Charge']; ?>'><i class='fa fa-plus'></i> <?php echo $lang['Add Charge']; ?></a></center>");}
      else {$('td:eq(7)', nRow).html("<center><a href='#' onclick=\"window.open('<?php echo $connect_url_data; ?>/inpatient/e/"+ aData[0] +"', 'popup1',  'status,menubar=0,scrollbars=1,resizable=0,top=50,left=50,width=1220,height=550')\" class='btn' rel='tooltip' title='<?php echo $lang['Account']; ?>'><i class='fa fa-user'></i> <?php echo $lang['Account']; ?></a>&nbsp;&nbsp;<a href='#' onclick=\"window.open('<?php echo $connect_url_data; ?>/transaction/patient/charge/"+ aData[0] +"', 'popup1',  'status,menubar=0,resizable=0,scrollbars=1,top=50,left=50,width=1220,height=550')\" class='btn' rel='tooltip' title='<?php echo $lang['Charges']; ?>'><i class='fa fa-connectdevelop'></i> <?php echo $lang['Charges']; ?></a></center>");}
     },

"sPaginationType": "full_numbers",
"aaSorting": [[ 1, "desc" ]],
"sDom": '<"top"f>rt<"bottom"i><"bottom"p>',
"bAutoWidth": false,
"oLanguage": {
"sSearch": "<i class='fa fa-search' style='margin-left:20px;'></i>"
},

"sAjaxSource": "<?php echo $connect_url_data; ?>/inpatient/inpatient-datatable.php",
"aoColumns": [
    { "mData": null },
           null,
           null,
           null,
	   null,
	   null,
	   null,
    { "mData": null },
           
         ]          
  });

$('.dataTables_filter input').attr("placeholder", "<?php echo $lang['Search Keywords']; ?>");

});
//end ready function

 $.fn.dataTableExt.oApi.fnReloadAjax = function ( oSettings, sNewSource, fnCallback, bStandingRedraw )
{
    if ( sNewSource !== undefined && sNewSource !== null ) {
        oSettings.sAjaxSource = sNewSource;
    }
 
    // Server-side processing should just call fnDraw
    if ( oSettings.oFeatures.bServerSide ) {
        this.fnDraw();
        return;
    }
 
    this.oApi._fnProcessingDisplay( oSettings, true );
    var that = this;
    var iStart = oSettings._iDisplayStart;
    var aData = [];
 
    this.oApi._fnServerParams( oSettings, aData );
 
    oSettings.fnServerData.call( oSettings.oInstance, oSettings.sAjaxSource, aData, function(json) {
        /* Clear the old information from the table */
        that.oApi._fnClearTable( oSettings );
 
        /* Got the data - add it to the table */
        var aData =  (oSettings.sAjaxDataProp !== "") ?
            that.oApi._fnGetObjectDataFn( oSettings.sAjaxDataProp )( json ) : json;
 
        for ( var i=0 ; i<aData.length ; i++ )
        {
            that.oApi._fnAddData( oSettings, aData[i] );
        }
         
        oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();
 
        that.fnDraw();
 
        if ( bStandingRedraw === true )
        {
            oSettings._iDisplayStart = iStart;
            that.oApi._fnCalculateEnd( oSettings );
            that.fnDraw( false );
        }
 
        that.oApi._fnProcessingDisplay( oSettings, false );
 
        /* Callback inpatient function - for event handlers etc */
        if ( typeof fnCallback == 'function' && fnCallback !== null )
        {
            fnCallback( oSettings );
        }
    }, oSettings );
};
</script>

<div class="shownpars">					
<table width="100%" cellpadding="0" cellspacing="0" border="0" class="dTable" id="inpatient-datatable">
<thead>
    <tr>
	<th width="3%"></th>
	<th width="9%"><?php echo $lang['Transaction No']; ?></th>
	<th width="22%"><?php echo $lang['Patient Name']; ?></th>
	<th width="12%"><?php echo $lang['Room']; ?></th>
	<th width="10%"><?php echo $lang['Room Type']; ?></th>
	<th width="14%"><?php echo $lang['Account Status']; ?></th>
	<th width="8%"><?php echo $lang['Days']; ?></th>
	<th width="24%"><?php echo $lang['Action']; ?></th>
    </tr>	
</thead>
<tbody>

</tbody>
</table>
</div>

	    
	    
        </div>
	
    </div>
    <!-- Main content ends -->
    
</div>
<!-- Content ends -->  
             
</body>
</html>
