<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo e($site_title); ?>">
    <meta name="keywords" content="">
    <meta name="author" content="">

    <title><?php echo e($site_title); ?> - <?php echo e($page_title); ?></title>
    <!-- Swiper Slider CSS -->
    <link href="<?php echo e(asset('css/swiper.css')); ?>" rel="stylesheet">
    <!-- Custom Main StyleSheet CSS -->
    <link href="<?php echo e(asset('style.css')); ?>" rel="stylesheet">
    <!-- Color CSS -->
    <link href="<?php echo e(asset('css/color.css')); ?>" rel="stylesheet">
    <!-- Responsive CSS -->
    <link href="<?php echo e(asset('css/responsive.css')); ?>" rel="stylesheet">
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    <?php echo $__env->yieldContent('style'); ?>

</head>

<body>

<!--gt Wrapper Start-->
<div class="gt_wrapper">


    <!--Header Wrap Start-->
    <header>
        <div class="gt_top3_wrap default_width">
            <div class="container">
                <div class="gt_top3_scl_icon">
                    <ul class="gt_hdr3_scl_icon">
                        <li><a href="<?php echo e($general->facebook); ?>"><i class="fa fa-facebook"></i></a></li>
                        <li><a href="<?php echo e($general->twitter); ?>"><i class="fa fa-twitter"></i></a></li>
                        <li><a href="<?php echo e($general->google_plus); ?>"><i class="fa fa-google-plus"></i></a></li>
                        <li><a href="<?php echo e($general->linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
                        <li><a href="<?php echo e($general->youtube); ?>"><i class="fa fa-youtube"></i></a></li>
                    </ul>
                </div>
                <div class="gt_hdr_3_ui_element">
                    <ul>
                        <li><i class="fa fa-phone"></i><?php echo e($general->number); ?></li>
                        <li><i class="fa fa-envelope-o"></i><?php echo e($general->email); ?></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="gt_top3_menu default_width">
            <div class="container">
                <div class="gt-logo">
                    <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('images/logo.png')); ?>" alt=""></a>
                </div>
                <nav class="gt_hdr3_navigation">
                    <!-- Responsive Buttun -->
                    <a class="navbar-btn collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </a>
                    <!-- Responsive Buttun -->
                    <ul class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                        <li class="<?php echo e(Request::is('/') ? "active" : ""); ?>"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <?php foreach($menu as $m): ?>
                            <li class="hidden-sm">
                                <a href="<?php echo e(url('menu/')); ?>/<?php echo e($m->id); ?>/<?php echo e(urlencode(strtolower($m->name))); ?>">
                                    <?php echo e($m->name); ?>

                                </a>
                            </li>
                        <?php endforeach; ?>
                        <li class="<?php echo e(Request::is('contact-us') ? "active" : ""); ?>"><a href="<?php echo e(route('contact-us')); ?>">Contact Us</a></li>
                        <?php if(Auth::guard('member')->check()): ?>
                            <li><a href="#">
                                    <div><i class="fa fa-user" style="margin-top: 5px;"></i> <?php echo e(Auth::guard('member')->user()->fname); ?> <?php echo e(Auth::guard('member')->user()->lname); ?> <i style="padding-top: 2px;" class="fa fa-sort-down"></i></div>
                                </a>
                                <ul>

                                    <?php  $id = Auth::guard('member')->user()->id  ?>
                                    <li><a href="<?php echo e(route('user-dashboard')); ?>">
                                            <div><i class="fa fa-dashboard"></i> Dashboard</div></a>
                                    </li>
                                    <li><a href="#">
                                            <div><i class="fa fa-money"></i> Total Balance - <?php echo e(Auth::guard('member')->user()->balance); ?> USD</div></a>
                                    </li>
                                    <li><a href="<?php echo e(route('user-logout')); ?>"><div><i class="fa fa-sign-out"></i> Log Out</div></a></li>
                                </ul>
                            </li>
                        <?php else: ?>
                            <li><a href="<?php echo e(route('user-login')); ?>">
                                    <div><i class="fa fa-sign-in" style="margin-top: 5px;"></i> LOGIN</div>
                                </a></li>
                            <li><a href="<?php echo e(route('user-registration')); ?>">
                                    <div><i class="fa fa-edit" style="margin-top: 5px;"></i> REGISTER</div>
                                </a></li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </header>
<!--Header Wrap End-->

    <!--Main Content Wrap Start-->
<?php echo $__env->yieldContent('content'); ?>
<!--Main Content Wrap End-->

    <!--Footer Wrap Start-->
    <footer>


        <!--Footer Wrap Start-->
        <div class="gt_footer_bg default_width">
            <div class="container">
                <div class="row">
                    <div class="col-md-9">
                        <div class="gt_office_wrap default_width" style="margin-top: 30px; overflow: hidden">
                            <div class="gt_foo_about widget">
                                <h5 class="text-center">About <?php echo e($site_title); ?></h5>
                                <p><?php echo substr($footer_text,0,300); ?>...</p>
                                <ul>
                                    <li><a href="<?php echo e($general->facebook); ?>"><i class="fa fa-facebook"></i></a></li>
                                    <li><a href="<?php echo e($general->twitter); ?>"><i class="fa fa-twitter"></i></a></li>
                                    <li><a href="<?php echo e($general->google_pluse); ?>"><i class="fa fa-google-plus"></i></a></li>
                                    <li><a href="<?php echo e($general->linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
                                    <li><a href="<?php echo e($general->youtube); ?>"><i class="fa fa-youtube"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="foo_col_outer_wrap default_width">
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <div class="widget">
                                        <h5>Our Address</h5>
                                        <ul class="gt_team1_contact_info">
                                            <li><i class="fa fa-map-marker"></i><?php echo e($general->address); ?></li>
                                            <li><i class="fa fa-phone"></i><?php echo e($general->number); ?></li>
                                            <li><i class="fa fa-envelope"></i><?php echo e($general->email); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!--Footer Wrap End-->

        <!--Copyright Wrap Start-->
        <div class="copyright_bg default_width">
            <div class="container">
                <div class="text-center default_width">
                    <p><?php echo $footer_bottom_text; ?></p>
                </div>
            </div>
        </div>
        <!--Copyright Wrap End-->
    </footer>
    <!--Footer Wrap End-->
    <!--Back to Top Wrap Start-->
    <div class="back-to-top">
        <a href="#home"><i class="fa fa-angle-up"></i></a>
    </div>
    <!--Back to Top Wrap Start-->

</div>
<!--gt Wrapper End-->


<!--Jquery Library-->
<script src="<?php echo e(asset('js/jquery.js')); ?>"></script>
<!--Bootstrap core JavaScript-->
<script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
<!--Swiper JavaScript-->
<script src="<?php echo e(asset('js/swiper.jquery.min.js')); ?>"></script>
<!--Count Down JavaScript-->
<script src="<?php echo e(asset('js/jquery.downCount.js')); ?>"></script>
<!--Pretty Photo JavaScript-->
<!--Number Count (Waypoint) JavaScript-->
<script src="<?php echo e(asset('js/waypoints-min.js')); ?>"></script>
<!--WOW JavaScript-->
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>

<?php echo $__env->yieldContent('scripts'); ?>
</body>

<!-- index.html  2016 00:24:52  -->
</html>
