@extends('layouts.member')
@section('content')




    <div class="row">
        <div class="col-md-12">


            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark"><strong>Deposit Method</strong>
                    </div>
                    <div class="tools"> </div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                        <div class="col-md-4 col-sm-12 text-center">

                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h3 style="font-size: 28px;"><b>
                                                @if($fund->payment_type == 1)
                                                    Paypal
                                                @elseif($fund->payment_type == 2)
                                                    Perfect Money
                                                @elseif($fund->payment_type == 3)
                                                    BTC - ( BlockChain )
                                                @else
                                                    Credit Card
                                                @endif
                                            </b></h3>
                                    </div>
                                    <div style="font-size: 18px;padding: 18px;" class="panel-body text-center">
                                        @if($fund->payment_type == 1)
                                            @php $img = $paypal->image @endphp
                                        @elseif($fund->payment_type == 2)
                                            @php $img = $perfect->image @endphp
                                        @elseif($fund->payment_type == 3)
                                            @php $img = $btc->image @endphp
                                        @else
                                            @php $img = $stripe->image @endphp
                                        @endif
                                        <img width="100%" class="image-responsive" src="{{ asset('images') }}/{{ $img }}" alt="">
                                    </div>
                                    <div class="panel-footer">
                                        <a href="" class="btn btn-info btn-block btn-icon icon-left"><i
                                                    class="fa fa-arrow-left"></i> Back to Payment Method Page</a>
                                    </div>
                                </div>
                        </div>
                        <div class="col-md-8 col-sm-12">
                            <div class="panel panel-info panel-shadow" data-collapsed="0"><!-- to apply shadow add class "panel-shadow" -->

                                <!-- panel head -->
                                <div class="panel-heading">
                                    <div class="panel-title"><i class="fa fa-money"></i> <strong>{{ $page_title }}</strong></div>
                                </div>
                                <!-- panel body -->
                                <div class="panel-body">
                                    <div class="text-center">
                                        <h3>Current Balance : <strong>{{ Auth::guard('member')->user()->balance }} - {{ $site_currency }}</strong></h3>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="form-group">
                                            <label style="margin-top: 5px;font-size: 14px;" class="col-sm-4 col-sm-offset-1 text-right control-label">Amount : </label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <input type="text" value="{{ $fund->amount }}" readonly name="amount" id="amount" class="form-control" placeholder="Enter Deposit Amount" required>
                                                    <span class="input-group-addon red">&nbsp;<strong> {{ $site_currency }} </strong></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="form-group">
                                            <label style="margin-top: 5px;font-size: 14px;" class="col-sm-4 col-sm-offset-1 text-right control-label">After Deposit Balance  : </label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <input type="text" value="{{ $fund->amount + Auth::guard('member')->user()->balance }}" readonly name="amount" id="amount" class="form-control" placeholder="Enter Deposit Amount" required>
                                                    <span class="input-group-addon red">&nbsp;<strong> {{ $site_currency }} </strong></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    @if($fund->payment_type == 1)
                                        <div class="row">
                                            <form action="https://secure.paypal.com/uk/cgi-bin/webscr" method="post" name="paypal" id="paypal">
                                                <input type="hidden" name="cmd" value="_xclick" />
                                                <input type="hidden" name="business" value="{{ $paypal->val1 }}" />
                                                <input type="hidden" name="cbt" value="{{ $site_title }}" />
                                                <input type="hidden" name="currency_code" value="USD" />
                                                <input type="hidden" name="quantity" value="1" />
                                                <input type="hidden" name="item_name" value="Add Fund to {{ $site_title }}" />

                                                <!-- Custom value you want to send and process back in the IPN -->
                                                <input type="hidden" name="custom" value="{{ $fund->custom }}" />

                                                <input name="amount" type="hidden" value="{{ $fund->amount  }}">
                                                <input type="hidden" name="return" value="{{ route('deposit-fund') }}"/>
                                                <input type="hidden" name="cancel_return" value="{{ route('deposit-fund') }}" />
                                                <!-- Where to send the PayPal IPN to. -->
                                                <input type="hidden" name="notify_url" value="{{ route('paypal-ipn') }}" />

                                                <div class="form-group">
                                                    <div class="col-sm-6 col-sm-offset-3">
                                                        <button class="btn btn-danger btn-block btn-icon icon-left"><i
                                                                    class="fa fa-send"></i> Add Fund Now</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    @elseif($fund->payment_type == 2)
                                        <div class="row">
                                            <form action="https://perfectmoney.is/api/step1.asp" method="POST" id="myform">
                                                <input type="hidden" name="PAYEE_ACCOUNT" value="{{ $perfect->val1 }}">
                                                <input type="hidden" name="PAYEE_NAME" value="{{ $site_title }}">
                                                <input type='hidden' name='PAYMENT_ID' value='{{ $fund->custom }}'>
                                                <input type="hidden" name="PAYMENT_AMOUNT"  value="{{ round(($fund->amount),2)  }}">
                                                <input type="hidden" name="PAYMENT_UNITS" value="USD">
                                                <input type="hidden" name="STATUS_URL" value="{{ route('perfect-ipn') }}">
                                                <input type="hidden" name="PAYMENT_URL" value="{{ route('deposit-fund') }}">
                                                <input type="hidden" name="PAYMENT_URL_METHOD" value="GET">
                                                <input type="hidden" name="NOPAYMENT_URL" value="{{ route('deposit-fund') }}">
                                                <input type="hidden" name="NOPAYMENT_URL_METHOD" value="GET">
                                                <input type="hidden" name="SUGGESTED_MEMO" value="{{ $site_title }}">
                                                <input type="hidden" name="BAGGAGE_FIELDS" value="IDENT"><br>

                                                <div class="form-group">
                                                    <div class="col-sm-6 col-sm-offset-3">
                                                        <button class="btn btn-danger btn-block btn-icon icon-left"><i
                                                                    class="fa fa-send"></i>Add Fund Now</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    @elseif($fund->payment_type == 3)

                                        <div class="row">
                                            {!! Form::open(['route'=>'btc-preview']) !!}
                                            <input type="hidden" name="amount" value="{{ round(($fund->amount),3)  }}">
                                            <input type="hidden" name="fund_id" value="{{ $fund->id }}">
                                            <input type="hidden" name="custom" value="{{ $fund->custom }}">
                                            <div class="form-group">
                                                <div class="col-sm-6 col-sm-offset-3">
                                                    <button class="btn btn-danger btn-block btn-icon icon-left"><i
                                                                class="fa fa-send"></i>Add Fund Now</button>
                                                </div>
                                            </div>
                                            {{ Form::close() }}
                                        </div>
                                    @elseif($fund->payment_type == 4)
                                        <div class="row">
                                            {!! Form::open(['route'=>'stripe-preview']) !!}
                                            <input type="hidden" name="amount" value="{{ round(($fund->amount),2)  }}">
                                            <input type="hidden" name="fund_id" value="{{ $fund->id }}">
                                            <input type="hidden" name="custom" value="{{ $fund->custom }}">
                                            <div class="form-group">
                                                <div class="col-sm-6 col-sm-offset-3">
                                                    <button class="btn btn-danger btn-block btn-icon icon-left"><i
                                                                class="fa fa-send"></i>Add Fund Now</button>
                                                </div>
                                            </div>
                                            {{ Form::close() }}
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div><!-- ROW-->


@endsection
