@extends('layouts.member')
@section('content')


    @if(count($deposit))

        <div class="row">
            <div class="col-md-12">


                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                        </div>
                        <div class="tools"> </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_1">

                            <thead>
                            <tr>
                                <th>ID#</th>
                                <th>Deposit Date</th>
                                <th>Deposit Method</th>
                                <th>Deposit Balance</th>
                                <th>Deposit Status</th>
                            </tr>
                            </thead>

                            <tbody>
                            @php $i=0;@endphp
                            @foreach($deposit as $p)
                                @php $i++;@endphp
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>{{ date('d-F-Y h:i A',strtotime($p->created_at))  }}</td>
                                    <td>
                                        @if($p->payment_type == 1)
                                            <span class="label label-primary"><i class="fa fa-paypal"></i> Paypal</span>
                                        @elseif($p->payment_type == 2)
                                            <span class="label label-primary"><i class="fa fa-money"></i> Perfect Money</span>
                                        @elseif($p->payment_type == 3)
                                            <span class="label label-primary"><i class="fa fa-btc"></i> BTC - BlockChain</span>
                                        @elseif($p->payment_type == 4)
                                            <span class="label label-primary"><i class="fa fa-credit-card"></i> Credit Card</span>
                                        @endif
                                    </td>
                                    <td>{{ $p->amount }} - {{ $site_currency }}</td>
                                    <td>
                                        <span class="label label-primary"><i class="fa fa-check"></i> Completed</span>
                                    </td>

                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div><!-- ROW-->

    @else

        <div class="text-center">
            <h3>No Deposit History Available</h3>
        </div>
    @endif


@endsection
