@extends('layouts.member')
@section('content')


    @if(count($advert))

        <div class="row">
            <div class="col-md-12">


                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                        </div>
                        <div class="tools"> </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_1">

                            <thead>
                            <tr>
                                <th>ID#</th>
                                <th>Date</th>
                                <th>Title</th>
                                <th>Link</th>
                                <th>Hit</th>
                                <th>Limit</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tbody>
                            @php $i=0;@endphp
                            @foreach($advert as $p)
                                @php $i++;@endphp
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>{{ date('d-F-Y',strtotime($p->created_at))  }}</td>
                                    <td>{{ $p->title }}</td>
                                    <td>{{ $p->link }}</td>
                                    <td>{{ $p->hit }}</td>
                                    <td>{{ $p->limit }}</td>
                                    <td>
                                        @if($p->status == 0)
                                            <span class="label label-primary"><i class="fa fa-spinner"></i> Running</span>
                                        @elseif($p->status == 1)
                                            <span class="label label-primary"><i class="fa fa-check"></i> Completed</span>
                                        @else
                                            <span class="label label-primary"><i class="fa fa-times"></i> Refunded</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($p->p_status == 0)
                                            <span class="label label-primary"><i class="fa fa-spinner"></i> Pending</span>
                                        @elseif($p->p_status == 1)
                                            <span class="label label-primary"><i class="fa fa-check"></i> Accept</span>
                                        @else
                                            <span class="label label-danger"><i class="fa fa-times"></i> Rejected</span>
                                        @endif
                                    </td>

                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div><!-- ROW-->

    @else

        <div class="text-center">
            <h3>No Data Available</h3>
        </div>
    @endif


@endsection
