@extends('layouts.home2')

@section('content')

    <!--Banner Wrap Start-->
    <div class="gt_banner default_width">
        <div class="swiper-container" id="swiper-container">
            <ul class="swiper-wrapper">
                @foreach($sliders as $slider)
                    <li class="swiper-slide">
                        <img src="{{ asset('images') }}/{{ $slider->image }}" alt="">
                        <div class="gt_banner_text gt_slide_1">
                            <h3>{{ $slider->small_text }}</h3>
                            <h2>{{ $slider->bold_text }}</h2>
                        </div>
                    </li>
                @endforeach

            </ul>
        </div>
        <div class="swiper-button-next"><i class="fa fa-angle-right"></i></div>
        <div class="swiper-button-prev"><i class="fa fa-angle-left"></i></div>
    </div>
    <!--Banner Wrap End-->

    <div class="gt_main_content_wrap">

        <!--Offer Wrap start-->
        <section class="gt_wht_offer_bg">
            <div class="container">
                <div class="gt_hdg_1">
                    <h3>WHAT WE SERVICES YOU</h3>
                    <span><img src="{{ asset('images/hdg-01.png') }}" alt=""></span>
                </div>
                <!--What We Offer 2 Wrap Start-->
                <div class="row">
                    <div class="col-md-12 col-sm-12">
                        <div class="gt_wht_offer_wrap mb">
                            <div class="gt_wht_offer_des">
                                <p class="lead text-center" style="font-size: 18px">{!! $top_text  !!} </p>
                            </div>
                        </div>
                    </div>
                </div>
                <!--What We Offer 2 Wrap End-->
            </div>
        </section>
        <!--offer Wrap End-->

        <!--Facts and Figure Wrap End-->
        <section style="background-image: url('{{ asset('images') }}/{{ $general->bg_image }}')" class="fact_figure_bg">
            <div class="container">
                <div class="gt_hdg_1 white_hdg">
                    <h3>Our Company History</h3>
                    <span><img src="{{ asset('images/hdg-01.png') }}" alt=""></span>
                </div>
                <div class="row">
                    <div class="col-md-4 col-sm-6">
                        <div class="gt_facts_wrap">
                            <h2 class="counter">{{ $total_ad }}</h2>
                            <span>Total Advertisement</span>
                        </div>
                        <span class="facts_border bg_1"></span>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="gt_facts_wrap">
                            <h2 class="counter">{{ $total_ad_view->total }}</h2>
                            <span>Advertisement View</span>
                        </div>
                        <span class="facts_border bg_2"></span>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="gt_facts_wrap">
                            <h2 class="counter">{{ $total_user }}</h2>
                            <span>Total User</span>
                        </div>
                        <span class="facts_border bg_3"></span>
                    </div>

                </div>
            </div>
        </section>
        <!--Facts and Figure Wrap End-->

    </div>


@endsection