@extends('layouts.dashboard')
@section('content')


    @if(count($withdraw))

        <div class="row">
            <div class="col-md-12">


                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                        </div>
                        <div class="tools"> </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_1">

                            <thead>
                            <tr>
                                <th>ID#</th>
                                <th>Withdraw Date</th>
                                <th>Withdraw Method</th>
                                <th>Withdraw Balance</th>
                                <th>Details</th>
                                <th>Withdraw Status</th>
                            </tr>
                            </thead>

                            <tbody>
                            @php $i=0;@endphp
                            @foreach($withdraw as $p)
                                @php $i++;@endphp
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>{{ date('d-F-Y',strtotime($p->created_at))  }}</td>
                                    <td>{{ $p->method->name }}</td>
                                    <td>{{ $p->balance }} - {{ $site_currency }}</td>
                                    <td>{{ $p->details }}</td>
                                    <td>
                                        @if($p->status == 0)
                                        <div class="row">

                                            {!! Form::open(['method'=>'post','class'=>'form-inline']) !!}



                                                <div class="form-group">
                                                    <select name="status" id="" class="form-control" required>
                                                        @if($p->status == 0)
                                                            <option value="0" selected>Processing</option>
                                                            <option value="1">Completed</option>
                                                            <option value="2">Refund</option>
                                                        @endif
                                                    </select>
                                                </div>
                                                <input type="hidden" name="withdraw_id" value="{{ $p->id }}">
                                                <button type="submit" class="btn btn-primary"><i class="fa fa-send"></i> Update</button>
                                            {!! Form::close() !!}

                                        </div>
                                        @elseif($p->status == 1)
                                            <span class="label label-primary"><i class="fa fa-check"></i> Completed</span>
                                        @else
                                            <span class="label label-danger"><i class="fa fa-times"></i> Refund</span>
                                        @endif
                                    </td>

                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div><!-- ROW-->

    @else

        <div class="text-center">
            <h3>No Data available</h3>
        </div>
    @endif


@endsection
