@extends('layouts.dashboard')

@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default panel-shadow" data-collapsed="0"><!-- to apply shadow add class "panel-shadow" -->

                <!-- panel head -->
                <div class="panel-heading">
                    <div class="panel-title">{{ $page_title }}</div>

                </div>
                <!-- panel body -->
                <div class="panel-body">

                    @foreach($plan as $p)

                        <div class="col-sm-4 text-center">
                            <div class="panel panel-success panel-pricing">
                                <div class="panel-heading">
                                    <h3 style="font-size: 28px;"><b>{{ $p->name }}</b></h3>
                                </div>
                                <div style="font-size: 18px;padding: 18px;" class="panel-body text-center">
                                    <p><strong>{{ $site_currency }} - {{ $p->price }}</strong></p>
                                </div>
                                <ul style='font-size: 15px;' class="list-group text-center bold">
                                    <li style="border-top: 1px solid #eee;" class="list-group-item"> {{ $p->click }} - Clicks</li>
                                    <li class="list-group-item"><span class="aaaa">{{ $p->status == 1 ? "Active" : 'DeActive' }}</span></li>
                                </ul>
                                <div class="panel-footer" style="overflow: hidden">
                                    <div class="col-sm-12">
                                        <a class="btn btn-block btn-success" href="{{ route('plan-edit',$p->id) }}"><i class="fa fa-edit"></i> Edit Plan</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

@endsection


