@extends('layouts.dashboard')
@section('content')


    @if(count($advert))

        <div class="row">
            <div class="col-md-12">


                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                        </div>
                        <div class="tools"> </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="sample_1">

                            <thead>
                            <tr>
                                <th>ID#</th>
                                <th>Date</th>
                                <th>Title</th>
                                <th>Link</th>
                                <th>Limit</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tbody>
                            @php $i=0;@endphp
                            @foreach($advert as $p)
                                @php $i++;@endphp
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>{{ date('d-F-Y',strtotime($p->created_at))  }}</td>
                                    <td>{{ $p->title }}</td>
                                    <td>{{ $p->link }}</td>
                                    <td>{{ $p->limit }}</td>
                                    <td>
                                        <a href="{{ $p->link }}" target="_blank" class="btn btn-success btn-sm"><i class="fa fa-eye"></i> View</a>
                                        <button type="button" class="btn btn-primary btn-sm delete_button"
                                                data-toggle="modal" data-target="#DelModal"
                                                data-id="{{ $p->id }}">
                                            <i class='fa fa-check'></i> Accept
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm delete_button1"
                                                data-toggle="modal" data-target="#DelModal1"
                                                data-id="{{ $p->id }}">
                                            <i class='fa fa-times'></i> Rejected
                                        </button>
                                    </td>

                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div><!-- ROW-->

    @else

        <div class="text-center">
            <h3>No Data Available</h3>
        </div>
    @endif
    <div class="modal fade" id="DelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"> <i class='fa fa-check'></i> Accept !</h4>
                </div>
                <form method="post" action="{{ route('ptc-accept') }}" class="form-horizontal">
                <div class="modal-body">
                    <strong>Are you sure you want to Accept ?</strong>
                    <br>
                    <br>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label class="col-sm-4 control-label"><b>Per Click : </b></label>

                                <div class="col-sm-8">
                                    <div class="input-group">
                                        <input name="price" value="" class="form-control input-lg" type="text" required placeholder="Per click ">
                                        <span class="input-group-addon"><strong>{{ $site_currency }}</strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer">

                        {!! csrf_field() !!}
                        <input type="hidden" name="id" class="abir_id" value="0">

                        <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-danger"><i class="fa fa-check"></i> Yes. Sure.</button>

                </div>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade" id="DelModal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"> <i class='fa fa-times'></i> Reject !</h4>
                </div>

                <div class="modal-body">
                    <strong>Are you sure you want to Reject ?</strong>
                </div>

                <div class="modal-footer">
                    <form method="post" action="{{ route('ptc-reject') }}" class="form-inline">
                        {!! csrf_field() !!}
                        <input type="hidden" name="id" class="abir_id" value="0">

                        <button type="button" class="btn btn-default" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-danger"><i class="fa fa-check"></i> Yes. Sure.</button>
                    </form>
                </div>

            </div>
        </div>
    </div>


@endsection

@section('scripts')

    <script>
        $(document).ready(function () {

            $(document).on("click", '.delete_button', function (e) {
                var id = $(this).data('id');
                $(".abir_id").val(id);

            });

        });
    </script>
    <script>
        $(document).ready(function () {

            $(document).on("click", '.delete_button1', function (e) {
                var id = $(this).data('id');
                $(".abir_id").val(id);

            });

        });
    </script>

@endsection
